/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.xml.lexer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.xml.lexer.DTDTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class DTDLexer
implements Lexer<DTDTokenId> {
    private static final int ISI_INIT = 0;
    private static final int ISI_TEXT = 1;
    private static final int ISI_PROCESSING_INSTR = 2;
    private static final int ISI_DECLARATION = 3;
    private static final int ISI_ENTITY = 4;
    private static final int ISI_ELEMENT = 5;
    private static final int ISI_ATTLIST = 6;
    private static final int ISI_NOTATION = 7;
    private static final int ISI_COMMENT = 8;
    private static final int SUB_PROCESSING_TARGET = 0;
    private static final int SUB_PROCESSING_CONTENT = 1;
    private static final int SUB_PROCESSING_XML = 2;
    private static final int SUB_DECLARATION_NAME = 0;
    private static final int SUB_DECLARATION_DEF = 1;
    private static final int SUB_VALUE_QUOTE = 5;
    private static final int SUB_VALUE_DOUBLE = 6;
    private LexerInput input;
    private int state;
    private int substate;
    private int intrSubstate;
    private TokenFactory<DTDTokenId> tokenFactory;
    private static final Map<String, Integer> DECLARATION_KEYWORDS = new HashMap<String, Integer>();
    private static final Set<String> ELEMENT_KEYWORDS;
    private static final Set<String> ATTLIST_KEYWORDS;
    private static final Set<String> NOTATION_KEYWORDS;

    private Token<DTDTokenId> unterminatedFoundOpen() {
        int ch = this.input.read();
        switch (ch) {
            case 63: {
                this.setState(2, 0);
                return this.error();
            }
            case 33: {
                ch = this.input.read();
                if (Character.isAlphabetic(ch)) {
                    this.setState(3);
                    return this.error();
                }
                if (ch == 45 && (ch = this.input.read()) == 45) {
                    this.setState(8);
                    return this.error();
                }
                this.input.backup(1);
                return this.error();
            }
        }
        this.input.backup(1);
        return this.error();
    }

    public Token<DTDTokenId> nextTokenInit() {
        int ch = this.input.read();
        Token<DTDTokenId> tukac = null;
        switch (ch) {
            case 60: {
                ch = this.input.read();
                switch (ch) {
                    case 63: {
                        this.setState(2, 0);
                        return this.tokenFactory.createToken((TokenId)DTDTokenId.SYMBOL);
                    }
                    case 33: {
                        ch = this.input.read();
                        if (Character.isAlphabetic(ch)) {
                            this.setState(3);
                            this.input.backup(1);
                            return this.tokenFactory.createToken((TokenId)DTDTokenId.SYMBOL);
                        }
                        if (ch == 45 && (ch = this.input.read()) == 45) {
                            return this.skipComment();
                        }
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
                    }
                }
            }
            case 38: {
                tukac = this.processEntityOrCharacterRef();
                return tukac == null ? this.error() : tukac;
            }
            case 37: {
                tukac = this.processParsedEntity();
                return tukac == null ? this.error() : tukac;
            }
        }
        if (tukac != null) {
            return tukac;
        }
        return this.nextTokenContent();
    }

    private Token<DTDTokenId> processCharacterReference() {
        boolean hex;
        int ch = this.input.read();
        boolean bl = hex = ch == 120;
        if (hex) {
            ch = this.input.read();
        }
        boolean first = true;
        while (ch != 59) {
            if (!(ch >= 48 && ch <= 57 || hex && (ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102))) {
                return null;
            }
            first = false;
            ch = this.input.read();
            if (ch != -1) continue;
        }
        return this.createReferenceToken(first ? DTDTokenId.ERROR : DTDTokenId.CHARACTER);
    }

    private Token<DTDTokenId> createReferenceToken(DTDTokenId id) {
        Token t = this.intrSubstate != 0 ? this.tokenFactory.createToken((TokenId)id, this.input.readLength(), PartType.MIDDLE) : this.tokenFactory.createToken((TokenId)id);
        return t;
    }

    private Token<DTDTokenId> processEntityOrCharacterRef() {
        int ch;
        boolean first = true;
        Token<DTDTokenId> t = null;
        while ((ch = this.input.read()) != -1) {
            if (ch == 59) {
                return first ? this.error() : this.createReferenceToken(DTDTokenId.REFERENCE);
            }
            if (first && ch == 35) {
                int r = this.input.readLength();
                t = this.processCharacterReference();
                if (t != null) {
                    return t;
                }
                this.input.backup(this.input.readLength() - r);
                return this.error();
            }
            if (!(first && Character.isLetter(ch) || !first && (ch == 45 || ch == 46 || Character.isLetterOrDigit(ch)))) {
                this.input.backup(1);
                break;
            }
            first = false;
        }
        return this.error();
    }

    private Token<DTDTokenId> skipComment() {
        int ch;
        boolean minus = false;
        this.setState(8);
        while ((ch = this.input.read()) != -1) {
            if (ch == 45) {
                if (minus) {
                    ch = this.input.read();
                    if (ch == 62) {
                        this.setState(0);
                        return this.tokenFactory.createToken((TokenId)DTDTokenId.COMMENT);
                    }
                    this.intrSubstate = 0;
                    if (this.input.readLength() > 2) {
                        this.setState(0);
                        this.input.backup(2);
                        return this.tokenFactory.createToken((TokenId)DTDTokenId.COMMENT);
                    }
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
                }
                minus = true;
                continue;
            }
            minus = false;
            if (ch != 38) continue;
            if (this.input.readLength() > 1) {
                this.input.backup(1);
                return this.tokenFactory.createToken((TokenId)DTDTokenId.COMMENT);
            }
            this.intrSubstate = this.saveState();
            return this.processEntityOrCharacterRef();
        }
        this.intrSubstate = 0;
        this.setState(0);
        if (this.input.readLength() > 0) {
            this.input.backup(1);
            return this.tokenFactory.createToken((TokenId)DTDTokenId.COMMENT);
        }
        return this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
    }

    private void setState(int state) {
        this.setState(state, 0);
    }

    private void setState(int state, int subState) {
        this.state = state;
        this.substate = subState;
        this.intrSubstate = 0;
    }

    private Token<DTDTokenId> nextTokenContent() {
        int ch;
        while ((ch = this.input.read()) != -1) {
            switch (ch) {
                case 60: {
                    this.input.backup(1);
                    this.setState(0);
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.PLAIN);
                }
                case 38: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        this.setState(0);
                        return this.tokenFactory.createToken((TokenId)DTDTokenId.PLAIN);
                    }
                    return this.processEntityOrCharacterRef();
                }
                case 37: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        this.setState(0);
                        return this.tokenFactory.createToken((TokenId)DTDTokenId.PLAIN);
                    }
                    Token<DTDTokenId> id = this.processParsedEntity();
                    if (id == null) break;
                    this.setState(0);
                    return id;
                }
            }
        }
        this.setState(0);
        if (this.input.readLength() == 0) {
            return null;
        }
        return this.tokenFactory.createToken((TokenId)DTDTokenId.PLAIN);
    }

    private Token<DTDTokenId> processParsedEntity() {
        int ch;
        boolean first = true;
        while ((ch = this.input.read()) != -1) {
            if (ch == 59) {
                return first ? null : this.tokenFactory.createToken((TokenId)DTDTokenId.REFERENCE);
            }
            if ((!first || !Character.isLetter(ch)) && (first || ch != 45 && ch != 46 && !Character.isLetterOrDigit(ch))) break;
            first = false;
        }
        return null;
    }

    public Token<DTDTokenId> nextToken() {
        switch (this.state) {
            case 0: {
                return this.nextTokenInit();
            }
            case 8: {
                return this.skipComment();
            }
            case 2: {
                return this.nextProcessingInstr();
            }
            case 3: {
                return this.nextDeclaration();
            }
            case 5: 
            case 6: {
                return this.processElementOrAttlist();
            }
        }
        int ch = this.input.read();
        if (ch != -1) {
            return this.error();
        }
        return null;
    }

    private Token<DTDTokenId> processElementOrAttlist() {
        switch (this.substate) {
            case 6: {
                this.restoreState();
                return this.stringvalue(34);
            }
            case 5: {
                this.restoreState();
                return this.stringvalue(39);
            }
        }
        Token<DTDTokenId> wh = this.skipWhitespace();
        if (wh != null) {
            return wh;
        }
        int ch = this.input.read();
        if (ch == -1) {
            return null;
        }
        if (ch == 62) {
            this.setState(0);
            return this.tokenFactory.createToken((TokenId)DTDTokenId.SYMBOL);
        }
        if (ch == 38 || ch == 37) {
            return this.processEntityOrCharacterRef();
        }
        switch (this.substate) {
            case 0: {
                this.input.backup(1);
                return this.processDeclarationName();
            }
            case 1: {
                this.input.backup(1);
                return this.processDeclarationDef();
            }
        }
        return this.error();
    }

    private Token<DTDTokenId> nextDeclaration() {
        String name;
        Integer nState;
        int ch = this.input.read();
        switch (ch) {
            case 62: {
                this.setState(0);
                return this.tokenFactory.createToken((TokenId)DTDTokenId.SYMBOL);
            }
            case 60: {
                return this.unterminatedFoundOpen();
            }
        }
        if (!Character.isLetter(ch)) {
            return this.error();
        }
        while ((ch = this.input.read()) != -1) {
            if (Character.isLetterOrDigit(ch)) continue;
            if (this.input.readLength() == 1) {
                this.setState(0);
                return this.error();
            }
            this.input.backup(1);
            break;
        }
        if ((nState = DECLARATION_KEYWORDS.get(name = this.input.readText().toString())) == null) {
            this.setState(0);
            return this.error();
        }
        this.setState(nState);
        return this.tokenFactory.createToken((TokenId)DTDTokenId.DECLARATION);
    }

    private Token<DTDTokenId> processDeclarationName() {
        int ch;
        boolean first = true;
        while ((ch = this.input.read()) != -1) {
            if (first && ch == 37 && this.state == 4) {
                int n = this.input.read();
                if (Character.isWhitespace(n)) {
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.OPERATOR);
                }
                this.input.backup(1);
            }
            if (ch == 37 || ch == 38) {
                Token<DTDTokenId> t = this.processEntityOrCharacterRef();
                this.substate = 1;
                if (t != null) {
                    return t;
                }
                return this.error();
            }
            if (!this.isNametokenChar(ch, first)) {
                if (first) {
                    this.substate = 1;
                    return this.error();
                }
                this.input.backup(1);
                break;
            }
            first = false;
        }
        this.substate = 1;
        return this.tokenFactory.createToken((TokenId)DTDTokenId.NAME);
    }

    private Token<DTDTokenId> processDeclarationDef() {
        Token<DTDTokenId> wh = this.skipWhitespace();
        if (wh != null) {
            return wh;
        }
        int ch = this.input.read();
        switch (ch) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 63: 
            case 124: {
                return this.tokenFactory.createToken((TokenId)DTDTokenId.OPERATOR);
            }
            case 37: 
            case 38: {
                return this.processEntityOrCharacterRef();
            }
            case 34: 
            case 39: {
                return this.stringvalue(ch);
            }
        }
        if (ch == 35 || Character.isLetter(ch)) {
            Set<String> check;
            while ((ch = this.input.read()) != -1 && Character.isLetterOrDigit(ch)) {
            }
            this.input.backup(1);
            String t = this.input.readText().toString();
            switch (this.state) {
                case 6: {
                    check = ATTLIST_KEYWORDS;
                    break;
                }
                case 5: {
                    check = ELEMENT_KEYWORDS;
                    break;
                }
                case 4: 
                case 7: {
                    check = NOTATION_KEYWORDS;
                    break;
                }
                default: {
                    check = Collections.emptySet();
                }
            }
            if (check.contains(t)) {
                return this.tokenFactory.createToken((TokenId)DTDTokenId.KEYWORD);
            }
            return this.tokenFactory.createToken((TokenId)DTDTokenId.NAME);
        }
        return this.error();
    }

    private Token<DTDTokenId> nextProcessingInstr() {
        switch (this.substate) {
            case 6: {
                this.restoreState();
                return this.stringvalue(34);
            }
            case 5: {
                this.restoreState();
                return this.stringvalue(39);
            }
        }
        Token<DTDTokenId> wh = this.skipWhitespace();
        if (wh != null) {
            return wh;
        }
        int ch = this.input.read();
        if (ch == -1) {
            return null;
        }
        switch (ch) {
            case 63: {
                return this.endProcessingInstruction();
            }
            case 62: {
                this.setState(0);
                return this.error();
            }
            case 60: {
                return this.unterminatedFoundOpen();
            }
        }
        switch (this.substate) {
            case 0: {
                this.input.backup(1);
                return this.nextProcessingTarget();
            }
            case 1: {
                this.input.backup(1);
                return this.nextProcessingContent();
            }
            case 2: {
                if (ch == 61) {
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.OPERATOR);
                }
                if (ch == 34 || ch == 39) {
                    return this.stringvalue(ch);
                }
                if (Character.isLetter(ch)) {
                    this.input.backup(1);
                    return this.processName();
                }
                this.error();
            }
        }
        return this.error();
    }

    private Token<DTDTokenId> stringvalue(int delimiter) {
        int ch;
        while ((ch = this.input.read()) != -1) {
            if (ch == delimiter) {
                this.restoreState();
                return this.tokenFactory.createToken((TokenId)DTDTokenId.STRING);
            }
            if (ch == 38) {
                this.intrSubstate = this.saveState();
                this.substate = delimiter == 34 ? 6 : 5;
                return this.valueEntityReference();
            }
            if (ch != 60) continue;
            this.input.backup(1);
            break;
        }
        if (this.input.readLength() > 0) {
            return this.tokenFactory.createToken((TokenId)DTDTokenId.STRING);
        }
        this.setState(0);
        return this.error();
    }

    private Token<DTDTokenId> valueEntityReference() {
        if (this.input.readLength() > 1) {
            this.input.backup(1);
            return this.tokenFactory.createToken((TokenId)DTDTokenId.STRING);
        }
        return this.processEntityOrCharacterRef();
    }

    private Token<DTDTokenId> skipWhitespace() {
        int ch;
        int start = this.input.readLength();
        while ((ch = this.input.read()) != -1) {
            if (Character.isWhitespace(ch)) continue;
            this.input.backup(1);
            if (this.input.readLength() - start <= 0) break;
            return this.tokenFactory.createToken((TokenId)DTDTokenId.WS, this.input.readLength() - start);
        }
        if (this.input.readLength() - start > 0) {
            return this.tokenFactory.createToken((TokenId)DTDTokenId.WS, this.input.readLength() - start);
        }
        return null;
    }

    private boolean isNametokenChar(int c, boolean first) {
        if (first) {
            return c == 58 || c == 95 || Character.isLetter(c);
        }
        switch (c) {
            case 45: 
            case 46: 
            case 58: 
            case 95: {
                return true;
            }
        }
        return Character.isLetterOrDigit(c);
    }

    private Token<DTDTokenId> error() {
        Token t = this.intrSubstate != 0 ? this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR, this.input.readLength(), PartType.MIDDLE) : this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
        return t;
    }

    private Token<DTDTokenId> processName() {
        int ch;
        boolean first = true;
        while ((ch = this.input.read()) != -1) {
            if (this.isNametokenChar(ch, first)) {
                first = false;
                continue;
            }
            this.input.backup(1);
            break;
        }
        if (this.input.readLength() > 0) {
            return this.tokenFactory.createToken((TokenId)DTDTokenId.NAME);
        }
        if (ch == 63) {
            return this.endProcessingInstruction();
        }
        return this.error();
    }

    private Token<DTDTokenId> endProcessingInstruction() {
        int ch = this.input.read();
        this.setState(0);
        if (ch == 62) {
            return this.tokenFactory.createToken((TokenId)DTDTokenId.SYMBOL);
        }
        return this.error();
    }

    private Token<DTDTokenId> nextProcessingTarget() {
        int ch;
        boolean first = true;
        while ((ch = this.input.read()) != -1) {
            if (ch == 63) {
                if (first) {
                    return this.nextProcessingContent();
                }
                this.substate = 1;
                this.input.backup(1);
                break;
            }
            if (Character.isWhitespace(ch)) {
                if (first) {
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
                }
                this.substate = 1;
                this.input.backup(1);
                break;
            }
            if (!(first & Character.isLetter(ch) || !first && Character.isLetterOrDigit(ch))) {
                return this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
            }
            first = false;
        }
        if ("xml".equalsIgnoreCase(this.input.readText().toString())) {
            this.substate = 2;
        }
        return this.tokenFactory.createToken((TokenId)DTDTokenId.TARGET);
    }

    private Token<DTDTokenId> nextProcessingContent() {
        int ch;
        boolean white = false;
        int whiteStart = -1;
        while ((ch = this.input.read()) != -1) {
            if (ch == 63) {
                if (whiteStart > 0) {
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.PI_CONTENT, whiteStart);
                }
                if (this.input.readLength() > 1) {
                    this.input.backup(1);
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.PI_CONTENT);
                }
                ch = this.input.read();
                if (ch == 62) {
                    return this.tokenFactory.createToken((TokenId)DTDTokenId.SYMBOL);
                }
                this.setState(0);
                return this.tokenFactory.createToken((TokenId)DTDTokenId.ERROR);
            }
            if (Character.isWhitespace(ch)) {
                if (whiteStart == -1) {
                    whiteStart = this.input.readLength();
                }
                if (this.input.readLength() != 1) continue;
                white = true;
                continue;
            }
            if (!white) continue;
            return this.tokenFactory.createToken((TokenId)DTDTokenId.WS);
        }
        return this.tokenFactory.createToken((TokenId)DTDTokenId.PI_CONTENT);
    }

    public Object state() {
        return this.state & 0xF | (this.substate & 0xF) << 4 | (this.intrSubstate & 0xFF) << 16;
    }

    private int saveState() {
        return this.state & 0xF | (this.substate & 0xF) << 4;
    }

    private void restoreState() {
        if (this.intrSubstate == 0) {
            return;
        }
        int s = this.intrSubstate;
        this.state = s & 0xF;
        this.substate = s >> 4 & 0xF;
        this.intrSubstate = 0;
    }

    public void release() {
    }

    public DTDLexer(LexerRestartInfo<DTDTokenId> info) {
        this.input = info.input();
        if (info.state() == null) {
            this.state = 0;
            this.substate = 0;
        } else {
            int s = (Integer)info.state();
            this.state = s & 0xF;
            this.substate = s >> 4 & 0xF;
            this.intrSubstate = s >> 16 & 0xFF;
        }
        this.tokenFactory = info.tokenFactory();
    }

    static {
        DECLARATION_KEYWORDS.put("ELEMENT", 5);
        DECLARATION_KEYWORDS.put("ATTLIST", 6);
        DECLARATION_KEYWORDS.put("ENTITY", 4);
        DECLARATION_KEYWORDS.put("NOTATION", 7);
        ELEMENT_KEYWORDS = new HashSet<String>();
        ELEMENT_KEYWORDS.add("#PCDATA");
        ELEMENT_KEYWORDS.add("EMPTY");
        ELEMENT_KEYWORDS.add("ANY");
        ATTLIST_KEYWORDS = new HashSet<String>();
        NOTATION_KEYWORDS = new HashSet<String>();
        ATTLIST_KEYWORDS.add("#PCDATA");
        ATTLIST_KEYWORDS.add("#REQUIRED");
        ATTLIST_KEYWORDS.add("CDATA");
        ATTLIST_KEYWORDS.add("ID");
        ATTLIST_KEYWORDS.add("IDREF");
        ATTLIST_KEYWORDS.add("IDREFS");
        ATTLIST_KEYWORDS.add("ENTITY");
        ATTLIST_KEYWORDS.add("NMTOKEN");
        ATTLIST_KEYWORDS.add("NMTOKENS");
        ATTLIST_KEYWORDS.add("NOTATION");
        ATTLIST_KEYWORDS.add("#REQUIRED");
        ATTLIST_KEYWORDS.add("#IMPLIED");
        ATTLIST_KEYWORDS.add("#FIXED");
        NOTATION_KEYWORDS.add("SYSTEM");
        NOTATION_KEYWORDS.add("PUBLIC");
        NOTATION_KEYWORDS.add("NDATA");
    }
}

