/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.textmate.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.textmate.lexer.TextmateLexer;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public enum TextmateTokenId implements TokenId
{
    TEXTMATE,
    UNTOKENIZED;


    public String primaryCategory() {
        return "textmate";
    }

    public static final class MimeDataProviderImpl
    implements MimeDataProvider {
        private static final Logger LOG = Logger.getLogger(MimeDataProviderImpl.class.getName());
        private static final Map<String, Reference<LookupPlaceholder>> placeholders = new HashMap<String, Reference<LookupPlaceholder>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup getLookup(MimePath arg0) {
            Class<LanguageHierarchyImpl> clazz = LanguageHierarchyImpl.class;
            synchronized (LanguageHierarchyImpl.class) {
                LookupPlaceholder placeholder;
                String path = arg0.getPath();
                Reference<LookupPlaceholder> placeholderRef = placeholders.get(path);
                LookupPlaceholder lookupPlaceholder = placeholder = placeholderRef != null ? placeholderRef.get() : null;
                if (placeholder == null) {
                    placeholder = new LookupPlaceholder();
                    placeholders.put(path, new WeakReference<LookupPlaceholder>(placeholder));
                }
                placeholder.setDelegate(MimeDataProviderImpl.updateMimeType(path));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return placeholder;
            }
        }

        private static Lookup updateMimeType(String path) {
            String scope = (String)LanguageHierarchyImpl.mimeType2Scope.get(path);
            Lookup nested = Lookup.EMPTY;
            if (scope != null) {
                try {
                    nested = Lookups.singleton((Object)new LanguageHierarchyImpl(path, scope).language());
                }
                catch (Exception ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            return nested;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateAllMimeTypes() {
            Class<LanguageHierarchyImpl> clazz = LanguageHierarchyImpl.class;
            synchronized (LanguageHierarchyImpl.class) {
                for (Map.Entry<String, Reference<LookupPlaceholder>> e : placeholders.entrySet()) {
                    LookupPlaceholder lp = e.getValue().get();
                    if (lp == null) continue;
                    lp.setDelegate(MimeDataProviderImpl.updateMimeType(e.getKey()));
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static class LookupPlaceholder
        extends ProxyLookup {
            private void setDelegate(Lookup nested) {
                this.setLookups(new Lookup[]{nested});
            }
        }
    }

    public static class LanguageHierarchyImpl
    extends LanguageHierarchy<TextmateTokenId> {
        public static final String GRAMMAR_MARK = "textmate-grammar";
        public static final String INJECTION_MARK = "inject-to";
        private static final RequestProcessor.Task REFRESH = new RequestProcessor(TextmateTokenId.class.getName(), 1, false, false).create(() -> LanguageHierarchyImpl.refreshGrammars());
        private static final int REFRESH_DELAY = 500;
        private static Map<String, FileObject> scope2File;
        private static Map<String, Collection<String>> scope2Injections;
        private static Map<String, String> mimeType2Scope;
        private final String mimeType;
        private final IGrammar grammar;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void refreshGrammars() {
            HashMap<String, FileObject> scope2File = new HashMap<String, FileObject>();
            HashMap<String, Collection<String>> scope2Injections = new HashMap<String, Collection<String>>();
            HashMap<String, String> mimeType2Scope = new HashMap<String, String>();
            FileObject editors = FileUtil.getSystemConfigRoot().getFileObject("Editors");
            if (editors != null) {
                Enumeration en = editors.getChildren(true);
                while (en.hasMoreElements()) {
                    FileObject candidate = (FileObject)en.nextElement();
                    Object attr = candidate.getAttribute(GRAMMAR_MARK);
                    if (!(attr instanceof String)) continue;
                    String scope = (String)attr;
                    scope2File.put(scope, candidate);
                    attr = candidate.getAttribute(INJECTION_MARK);
                    if (attr instanceof String) {
                        for (String s : ((String)attr).split(",")) {
                            scope2Injections.computeIfAbsent(s, str -> new ArrayList()).add(scope);
                        }
                        continue;
                    }
                    mimeType2Scope.put(FileUtil.getRelativePath((FileObject)editors, (FileObject)candidate.getParent()), scope);
                }
            }
            Class<LanguageHierarchyImpl> clazz = LanguageHierarchyImpl.class;
            synchronized (LanguageHierarchyImpl.class) {
                if (!(Objects.equals(LanguageHierarchyImpl.scope2File, scope2File) && Objects.equals(LanguageHierarchyImpl.scope2Injections, scope2Injections) && Objects.equals(LanguageHierarchyImpl.mimeType2Scope, mimeType2Scope))) {
                    LanguageHierarchyImpl.scope2File = scope2File;
                    LanguageHierarchyImpl.scope2Injections = scope2Injections;
                    LanguageHierarchyImpl.mimeType2Scope = mimeType2Scope;
                    MimeDataProviderImpl.updateAllMimeTypes();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        public LanguageHierarchyImpl(String mimeType, String scope) throws Exception {
            this.mimeType = mimeType;
            IRegistryOptions opts = new IRegistryOptions(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String getFilePath(String scopeName) {
                    Class<LanguageHierarchyImpl> clazz = LanguageHierarchyImpl.class;
                    synchronized (LanguageHierarchyImpl.class) {
                        FileObject file = (FileObject)scope2File.get(scopeName);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return file != null ? file.getNameExt() : null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public InputStream getInputStream(String scopeName) throws IOException {
                    Class<LanguageHierarchyImpl> clazz = LanguageHierarchyImpl.class;
                    synchronized (LanguageHierarchyImpl.class) {
                        FileObject file = (FileObject)scope2File.get(scopeName);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return file != null ? file.getInputStream() : null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Collection<String> getInjections(String scopeName) {
                    Class<LanguageHierarchyImpl> clazz = LanguageHierarchyImpl.class;
                    synchronized (LanguageHierarchyImpl.class) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return (Collection)scope2Injections.get(scopeName);
                    }
                }
            };
            this.grammar = new Registry(opts).loadGrammar(scope);
        }

        protected Collection<TextmateTokenId> createTokenIds() {
            return Arrays.asList(TextmateTokenId.values());
        }

        protected Lexer<TextmateTokenId> createLexer(LexerRestartInfo<TextmateTokenId> lri) {
            return new TextmateLexer(lri.input(), lri.state(), (TokenFactory<TextmateTokenId>)lri.tokenFactory(), this.grammar);
        }

        protected String mimeType() {
            return this.mimeType;
        }

        static {
            final FileObject editors = FileUtil.getSystemConfigRoot().getFileObject("Editors");
            if (editors != null) {
                editors.addRecursiveListener(new FileChangeListener(){

                    public void fileFolderCreated(FileEvent fe) {
                        if (fe.getFile().getParent() == editors || fe.getFile().getParent().getParent() == editors) {
                            REFRESH.schedule(500);
                        }
                    }

                    public void fileDataCreated(FileEvent fe) {
                        if (fe.getFile().getAttribute(LanguageHierarchyImpl.GRAMMAR_MARK) != null) {
                            REFRESH.schedule(500);
                        }
                    }

                    public void fileChanged(FileEvent fe) {
                        if (fe.getFile().getAttribute(LanguageHierarchyImpl.GRAMMAR_MARK) != null) {
                            REFRESH.schedule(500);
                        }
                    }

                    public void fileDeleted(FileEvent fe) {
                    }

                    public void fileRenamed(FileRenameEvent fe) {
                    }

                    public void fileAttributeChanged(FileAttributeEvent fe) {
                    }
                });
            }
            LanguageHierarchyImpl.refreshGrammars();
        }
    }
}

