/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.project.uiapi.ProjectTemplateAttributesLegacy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;

public final class ProjectTemplateAttributesProvider
implements CreateFromTemplateAttributes {
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_LICENSE = "license";
    private static final String ATTR_LICENSE_PATH = "licensePath";
    private static final String ATTR_ENCODING = "encoding";

    public Map<String, ?> attributesFor(CreateDescriptor desc) {
        FileObject templateF = desc.getTemplate();
        FileObject targetF = desc.getTarget();
        String name = desc.getProposedName();
        Project prj = FileOwnerQuery.getOwner((FileObject)targetF);
        HashMap<String, Object> all = new HashMap<String, Object>();
        boolean needFill = true;
        if (prj != null) {
            Collection oldProvs;
            boolean bl = needFill = desc.getValue(ProjectTemplateAttributesLegacy.class.getName()) == null;
            if (needFill && !(oldProvs = prj.getLookup().lookupAll(CreateFromTemplateAttributesProvider.class)).isEmpty()) {
                try {
                    DataObject t = DataObject.find((FileObject)targetF);
                    if (t instanceof DataFolder) {
                        DataFolder target = (DataFolder)t;
                        DataObject template = DataObject.find((FileObject)templateF);
                        for (CreateFromTemplateAttributesProvider attrs : oldProvs) {
                            Map m = attrs.attributesFor(template, target, name);
                            if (m == null) continue;
                            all.putAll(m);
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            FileBuilder bld = FileBuilder.fromDescriptor((CreateDescriptor)desc);
            for (CreateFromTemplateAttributes attrs : prj.getLookup().lookupAll(CreateFromTemplateAttributes.class)) {
                CreateDescriptor childDesc;
                Map m = attrs.attributesFor(childDesc = bld.withParameters(all).createDescriptor(false));
                if (m == null) continue;
                if (m.containsKey(ATTR_PROJECT)) {
                    needFill = true;
                }
                all.putAll(m);
            }
        }
        if (needFill) {
            HashMap<String, Object> check = new HashMap<String, Object>(desc.getParameters());
            check.putAll(all);
            return ProjectTemplateAttributesProvider.checkProjectAttrs(check, all, targetF);
        }
        return all;
    }

    static Map<String, ? extends Object> checkProjectAttrs(Map<String, Object> check, Map<String, Object> m, FileObject parent) {
        Object prjAttrObj;
        Object object = prjAttrObj = check != null ? check.get(ATTR_PROJECT) : null;
        if (prjAttrObj instanceof Map) {
            Map prjAttrs = NbCollections.checkedMapByFilter((Map)((Map)prjAttrObj), String.class, Object.class, (boolean)false);
            HashMap<String, Object> newPrjAttrs = new HashMap<String, Object>(prjAttrs);
            m.put(ATTR_PROJECT, newPrjAttrs);
            ProjectTemplateAttributesProvider.ensureProjectAttrs(newPrjAttrs, parent);
            return m;
        }
        if (prjAttrObj != null) {
            return m;
        }
        HashMap<String, Object> projectMap = new HashMap<String, Object>();
        ProjectTemplateAttributesProvider.ensureProjectAttrs(projectMap, parent);
        if (m != null) {
            m.put(ATTR_PROJECT, projectMap);
            return m;
        }
        return Collections.singletonMap(ATTR_PROJECT, projectMap);
    }

    private static void ensureProjectAttrs(Map<String, Object> map, FileObject parent) {
        String url;
        if (map.get(ATTR_LICENSE) == null) {
            map.put(ATTR_LICENSE, "default");
        }
        if (map.get(ATTR_LICENSE_PATH) == null) {
            map.put(ATTR_LICENSE_PATH, "Templates/Licenses/license-" + map.get(ATTR_LICENSE).toString() + ".txt");
        }
        if (FileUtil.getConfigFile((String)(url = map.get(ATTR_LICENSE_PATH).toString())) == null) {
            try {
                URI uri = URI.create(url);
                map.put(ATTR_LICENSE_PATH, new URI("file", "", uri.getPath(), null).toString());
            }
            catch (Exception uri) {}
        } else {
            map.put(ATTR_LICENSE_PATH, "/" + url);
        }
        if (map.get(ATTR_ENCODING) == null) {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)parent);
            String encoding = charset != null ? charset.name() : "UTF-8";
            map.put(ATTR_ENCODING, encoding);
        }
    }
}

