/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.fish.payara.micro.project.ActionType;
import org.netbeans.modules.fish.payara.micro.project.MicroApplicationContent;
import org.netbeans.modules.maven.api.NbMavenProject;

public class MicroApplication {
    private final Project project;
    private final MavenProject mavenProject;
    private ActionType buildActionType;
    private boolean buildAction;
    private ActionType runActionType;
    private final AtomicInteger runActionCount = new AtomicInteger();
    private boolean reloadAction;
    private static final String SINGLE = ".single.deploy";

    public MicroApplication(Project project) {
        this.project = project;
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        this.mavenProject = nbMavenProject.getMavenProject();
    }

    public Project getProject() {
        return this.project;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setBuilding(boolean buildAction, String actionType) {
        this.buildActionType = ActionType.toAction(actionType.replace("-", "_"));
        this.setBuilding(buildAction);
    }

    public void setBuilding(boolean buildAction) {
        this.buildAction = buildAction;
        NbMavenProject.fireMavenProjectReload((Project)this.project);
    }

    public ActionType getBuildActionType() {
        return this.buildActionType;
    }

    public boolean isBuilding() {
        return this.buildAction;
    }

    public void setRunning(boolean running, String actionType) {
        this.runActionType = ActionType.toAction(actionType.replace(SINGLE, ""));
        this.setRunning(running);
    }

    public void setRunning(boolean running) {
        if (running) {
            this.runActionCount.incrementAndGet();
        } else if (this.isRunning()) {
            this.runActionCount.decrementAndGet();
        }
        NbMavenProject.fireMavenProjectReload((Project)this.project);
    }

    public boolean isRunning() {
        return this.runActionCount.get() > 0;
    }

    private int calcRunningInstanceCount() {
        ArrayList<String> processIds = new ArrayList<String>();
        String executorFilter = "gav=" + this.mavenProject.getGroupId() + ":" + this.mavenProject.getArtifactId() + ":" + this.mavenProject.getVersion();
        Runtime re = Runtime.getRuntime();
        try {
            String line;
            Process jpsProcess = re.exec("jps -v");
            InputStream inputStream = jpsProcess.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = in.readLine()) != null) {
                if (!line.contains(executorFilter)) continue;
                String[] split = line.split(" ");
                processIds.add(split[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return processIds.size();
    }

    public int getRunningInstanceCount() {
        return this.runActionCount.get();
    }

    public ActionType getRunActionType() {
        return this.runActionType;
    }

    public void setLoading(boolean loading) {
        this.reloadAction = loading;
        NbMavenProject.fireMavenProjectReload((Project)this.project);
    }

    public boolean isLoading() {
        return this.reloadAction;
    }

    public static MicroApplication getInstance(Project project) {
        MicroApplicationContent content;
        MicroApplication microApplication = null;
        if (project != null && (content = (MicroApplicationContent)project.getLookup().lookup(MicroApplicationContent.class)) != null) {
            microApplication = content.getMicroApplication();
        }
        return microApplication;
    }

    public static MicroApplication registerInstance(Project project) {
        MicroApplicationContent content;
        MicroApplication microApplication = null;
        if (project != null && (content = (MicroApplicationContent)project.getLookup().lookup(MicroApplicationContent.class)) != null) {
            microApplication = new MicroApplication(project);
            content.setMicroApplication(microApplication);
        }
        return microApplication;
    }

    public static boolean isPayaraMicroProject(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        return mavenProject.getPluginArtifactMap().get("fish.payara.maven.plugins:payara-micro-maven-plugin") != null;
    }
}

