/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.impl.ParserEventForward;
import org.netbeans.modules.parsing.impl.SchedulerAccessor;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.implspi.SchedulerControl;
import org.netbeans.modules.parsing.implspi.SourceControl;
import org.netbeans.modules.parsing.implspi.SourceEnvironment;
import org.netbeans.modules.parsing.implspi.SourceFactory;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class Source
implements Lookup.Provider {
    private static final Logger LOG = Logger.getLogger(Source.class.getName());
    private static final ThreadLocal<Boolean> suppressListening = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<Boolean> preferFile = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Lookup context;
    private final String mimeType;
    private final FileObject fileObject;
    private final Document document;
    private final Set<SourceFlags> flags = Collections.synchronizedSet(EnumSet.noneOf(SourceFlags.class));
    private int taskCount;
    private volatile Parser cachedParser;
    private final AtomicReference<ExtendableSourceModificationEvent> sourceModificationEvent = new AtomicReference();
    private final ASourceModificationEvent unspecifiedSourceModificationEvent = new ASourceModificationEvent(this, true, -1, -1);
    private Map<Class<? extends Scheduler>, SchedulerEvent> schedulerEvents;
    private SourceCache cache;
    private volatile long eventId;
    private volatile boolean listeningOnChanges;
    private final SourceControl ctrl = new SourceControl(this);
    private final SourceEnvironment sourceEnv;
    private final ParserEventForward peFwd;

    public static Source create(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (!fileObject.isValid() || !fileObject.isData()) {
            return null;
        }
        return Source._get(fileObject.getMIMEType(), fileObject, Lookup.getDefault());
    }

    public static Source create(FileObject fileObject, Lookup lkp) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        if (!fileObject.isValid() || !fileObject.isData()) {
            return null;
        }
        return Source._get(fileObject.getMIMEType(), fileObject, lkp);
    }

    public static Source create(Document document) {
        return Source.create(document, Lookup.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Source create(Document document, Lookup lkp) {
        Parameters.notNull((CharSequence)"document", (Object)document);
        String mimeType = DocumentUtilities.getMimeType((Document)document);
        if (mimeType == null) {
            throw new NullPointerException("Netbeans documents must have 'mimeType' property: " + document.getClass() + "@" + Integer.toHexString(System.identityHashCode(document)));
        }
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            Source source;
            Reference sourceRef = (Reference)document.getProperty(Source.class);
            Source source2 = source = sourceRef == null ? null : (Source)sourceRef.get();
            if (source != null && source.getFileObject() != null && !source.getFileObject().isValid()) {
                source = null;
            }
            if (source == null) {
                FileObject fileObject = Utilities.getFileObject(document);
                if (fileObject != null) {
                    source = Source._get(mimeType, fileObject, lkp);
                } else {
                    if ("text/x-dialog-binding".equals(mimeType)) {
                        LanguagePath path;
                        InputAttributes attributes = (InputAttributes)document.getProperty(InputAttributes.class);
                        Document doc = (Document)attributes.getValue(path = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)mimeType).lookup(Language.class))), (Object)"dialogBinding.document");
                        fileObject = doc != null ? Utilities.getFileObject(doc) : (FileObject)attributes.getValue(path, (Object)"dialogBinding.fileObject");
                    }
                    source = new Source(mimeType, document, fileObject, lkp);
                }
                document.putProperty(Source.class, new WeakReference<Source>(source));
            }
            assert (source != null) : "No Source for " + document;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return source;
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Document getDocument(boolean forceOpen) {
        if (preferFile.get().booleanValue()) {
            if (!forceOpen) {
                return null;
            }
            boolean ae = false;
            if (!$assertionsDisabled) {
                ae = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (ae) {
                LOG.log(Level.INFO, "Calling Source.getDocument(forceOpen=true) for Source preferring files -> possible performance problem {0}", Arrays.asList(Thread.currentThread().getStackTrace()));
            }
        }
        if (this.document != null) {
            return this.document;
        }
        assert (this.fileObject != null);
        try {
            return this.sourceEnv.readDocument(this.fileObject, forceOpen);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return null;
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot createSnapshot() {
        int[][] lineStartOffsets;
        CharSequence[] text;
        block23: {
            text = new CharSequence[]{""};
            lineStartOffsets = new int[][]{{0}};
            Document doc = this.getDocument(false);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, null, new Throwable("Creating snapshot: doc=" + doc + ", file=" + this.fileObject));
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Creating snapshot: doc={0}, file={1}", new Object[]{doc, this.fileObject});
            }
            try {
                if (doc == null) {
                    try {
                        if (!this.fileObject.isValid()) break block23;
                        if (this.fileObject.getSize() <= (long)Utilities.getMaxFileSize()) {
                            InputStream is = this.fileObject.getInputStream();
                            assert (is != null) : "FileObject.getInputStream() returned null for FileObject: " + FileUtil.getFileDisplayName((FileObject)this.fileObject);
                            try (InputStreamReader reader = new InputStreamReader(is, FileEncodingQuery.getEncoding((FileObject)this.fileObject));){
                                StringBuilder output = new StringBuilder(Math.max(16, (int)this.fileObject.getSize()));
                                LinkedList<Integer> lso = new LinkedList<Integer>();
                                boolean lastCharCR = false;
                                char[] buffer = new char[65536];
                                int size = -1;
                                int LF = 10;
                                int CR = 13;
                                int LS = 8232;
                                int PS = 8233;
                                lso.add(0);
                                while (-1 != (size = reader.read(buffer, 0, buffer.length))) {
                                    for (int i = 0; i < size; ++i) {
                                        char ch = buffer[i];
                                        if (lastCharCR && ch == '\n') continue;
                                        if (ch == '\r') {
                                            output.append('\n');
                                            lso.add(output.length());
                                            lastCharCR = true;
                                            continue;
                                        }
                                        if (ch == '\u2028' || ch == '\u2029') {
                                            output.append('\n');
                                            lso.add(output.length());
                                            lastCharCR = false;
                                            continue;
                                        }
                                        lastCharCR = false;
                                        output.append(ch);
                                    }
                                }
                                int[] lsoArr = new int[lso.size()];
                                int idx = 0;
                                for (Integer offset : lso) {
                                    lsoArr[idx++] = offset;
                                }
                                text[0] = output;
                                lineStartOffsets[0] = lsoArr;
                                break block23;
                            }
                            finally {
                                is.close();
                            }
                        }
                        LOG.log(Level.WARNING, "Source {0} of size: {1} has been ignored due to large size. Files large then {2} bytes are ignored, you can increase the size by parse.max.file.size property.", new Object[]{FileUtil.getFileDisplayName((FileObject)this.fileObject), this.fileObject.getSize(), Utilities.getMaxFileSize()});
                    }
                    catch (FileNotFoundException is) {
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.WARNING, null, ioe);
                    }
                    break block23;
                }
                final Document d = doc;
                d.render(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int length = d.getLength();
                            if (length < 0) {
                                text[0] = "";
                                lineStartOffsets[0] = new int[]{0};
                            } else {
                                Element root = DocumentUtilities.getParagraphRootElement((Document)d);
                                int[] lso = new int[root.getElementCount()];
                                for (int i = 0; i < lso.length; ++i) {
                                    lso[i] = root.getElement(i).getStartOffset();
                                }
                                text[0] = d.getText(0, length);
                                lineStartOffsets[0] = lso;
                            }
                        }
                        catch (BadLocationException ble) {
                            LOG.log(Level.WARNING, null, ble);
                        }
                    }
                });
            }
            catch (OutOfMemoryError oome) {
                text[0] = "";
                lineStartOffsets[0] = new int[]{0};
                LOG.log(Level.INFO, null, oome);
                if (doc != null) {
                    LOG.warning("Can't create snapshot of " + doc + ", size=" + doc.getLength() + ", mimeType=" + this.mimeType);
                }
                LOG.warning("Can't create snapshot of " + this.fileObject + ", size=" + this.fileObject.getSize() + ", mimeType=" + this.mimeType);
            }
        }
        return Snapshot.create(text[0], lineStartOffsets[0], this, MimePath.get((String)this.mimeType), new int[][]{{0, 0}}, new int[][]{{0, 0}});
    }

    public String toString() {
        return super.toString() + "[mimeType=" + this.mimeType + ", fileObject=" + this.fileObject + ", document=" + this.document;
    }

    private Source(String mimeType, Document document, FileObject fileObject, Lookup context) {
        this.mimeType = mimeType;
        this.document = document;
        this.fileObject = fileObject;
        this.context = context;
        this.peFwd = new ParserEventForward();
        this.sourceEnv = Utilities.createEnvironment(this, this.ctrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static Source _get(@NonNull String mimeType, @NonNull FileObject fileObject, @NonNull Lookup context) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            Source source = SourceFactory.getDefault().createSource(fileObject, mimeType, context);
            assert (source.context == context);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return source;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignListeners() {
        boolean listen;
        boolean bl = listen = suppressListening.get() == false;
        if (listen) {
            if (this.listeningOnChanges) {
                return;
            }
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (this.listeningOnChanges) {
                    return;
                }
                try {
                    this.sourceEnv.activate();
                }
                finally {
                    this.listeningOnChanges = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlags(Set<SourceFlags> flags) {
        Set<SourceFlags> set = flags;
        synchronized (set) {
            this.flags.addAll(flags);
            ++this.eventId;
        }
    }

    private void setSourceModification(boolean sourceChanged, int startOffset, int endOffset) {
        ExtendableSourceModificationEvent newSourceModificationEvent;
        ExtendableSourceModificationEvent oldSourceModificationEvent;
        while (!this.sourceModificationEvent.compareAndSet(oldSourceModificationEvent, newSourceModificationEvent = (oldSourceModificationEvent = this.sourceModificationEvent.get()) == null ? new ASourceModificationEvent(this, sourceChanged, startOffset, endOffset) : oldSourceModificationEvent.add(sourceChanged, startOffset, endOffset))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceCache getCache() {
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new SourceCache(this, null);
            }
            return this.cache;
        }
    }

    public Lookup getLookup() {
        return this.context;
    }

    static {
        SourceAccessor.setINSTANCE(new MySourceAccessor());
    }

    private static class AComposite
    extends SourceModificationEvent.Composite
    implements ExtendableSourceModificationEvent {
        private final int startOffset;
        private final int endOffset;

        AComposite(@NonNull ASourceModificationEvent read, @NonNull ASourceModificationEvent write) {
            super(read, write);
            this.startOffset = Math.min(read.getAffectedStartOffset(), write.getAffectedStartOffset());
            this.endOffset = Math.max(read.getAffectedEndOffset(), write.getAffectedEndOffset());
        }

        @Override
        public int getAffectedStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getAffectedEndOffset() {
            return this.endOffset;
        }

        @Override
        public String toString() {
            return "SourceModificationEvent " + this.startOffset + ":" + this.endOffset;
        }

        @Override
        public ASourceModificationEvent getWriteEvent() {
            return (ASourceModificationEvent)super.getWriteEvent();
        }

        @Override
        public ASourceModificationEvent getReadEvent() {
            return (ASourceModificationEvent)super.getReadEvent();
        }

        @Override
        @NonNull
        public ExtendableSourceModificationEvent add(boolean changed, int start, int end) {
            if (changed) {
                return new AComposite(this.getReadEvent(), (ASourceModificationEvent)this.getWriteEvent().add(changed, start, end));
            }
            return new AComposite((ASourceModificationEvent)this.getReadEvent().add(changed, start, end), this.getWriteEvent());
        }
    }

    private static class ASourceModificationEvent
    extends SourceModificationEvent
    implements ExtendableSourceModificationEvent {
        private final int startOffset;
        private final int endOffset;

        ASourceModificationEvent(Object source, boolean sourceChanged, int _startOffset, int _endOffset) {
            super(source, sourceChanged);
            this.startOffset = _startOffset;
            this.endOffset = _endOffset;
        }

        @Override
        public int getAffectedStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getAffectedEndOffset() {
            return this.endOffset;
        }

        @Override
        public String toString() {
            return "SourceModificationEvent " + this.startOffset + ":" + this.endOffset;
        }

        @Override
        @NonNull
        public ExtendableSourceModificationEvent add(boolean changed, int start, int end) {
            boolean oldChanged = this.sourceChanged();
            if (oldChanged == changed) {
                start = Math.min(start, this.startOffset);
                end = Math.min(end, this.endOffset);
                return new ASourceModificationEvent(this.getSource(), oldChanged, start, end);
            }
            ASourceModificationEvent other = new ASourceModificationEvent(this.getSource(), changed, start, end);
            return oldChanged ? new AComposite(other, this) : new AComposite(this, other);
        }
    }

    private static interface ExtendableSourceModificationEvent {
        public ExtendableSourceModificationEvent add(boolean var1, int var2, int var3);
    }

    private static class MySourceAccessor
    extends SourceAccessor {
        private MySourceAccessor() {
        }

        @Override
        public void setFlags(Source source, Set<SourceFlags> flags) {
            assert (source != null);
            assert (flags != null);
            source.setFlags(flags);
        }

        @Override
        public boolean testFlag(Source source, SourceFlags flag) {
            assert (source != null);
            assert (flag != null);
            return source.flags.contains((Object)flag);
        }

        @Override
        public boolean cleanFlag(Source source, SourceFlags flag) {
            assert (source != null);
            assert (flag != null);
            return source.flags.remove((Object)flag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean testAndCleanFlags(Source source, SourceFlags test, Set<SourceFlags> clean) {
            assert (source != null);
            assert (test != null);
            assert (clean != null);
            Set set = source.flags;
            synchronized (set) {
                boolean res = source.flags.contains((Object)test);
                source.flags.removeAll(clean);
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate(Source source, boolean force) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                boolean invalid = source.flags.remove((Object)SourceFlags.INVALID);
                if (force || invalid) {
                    SourceCache cache = this.getCache(source);
                    assert (cache != null);
                    cache.invalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean invalidate(Source source, long id, Snapshot snapshot) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (snapshot == null) {
                    return !source.flags.contains((Object)SourceFlags.INVALID);
                }
                long eventId = source.eventId;
                if (id != eventId) {
                    return false;
                }
                source.flags.remove((Object)SourceFlags.INVALID);
                SourceCache cache = this.getCache(source);
                assert (cache != null);
                cache.invalidate();
                return true;
            }
        }

        @Override
        public void attachScheduler(Source src, SchedulerControl sched, boolean attach) {
            src.sourceEnv.attachScheduler(sched, attach);
        }

        @Override
        public Parser getParser(Source source) {
            assert (source != null);
            return source.cachedParser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setParser(Source source, Parser parser) throws IllegalStateException {
            assert (source != null);
            assert (parser != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (source.cachedParser != null) {
                    throw new IllegalStateException();
                }
                source.cachedParser = parser;
            }
        }

        @Override
        public void assignListeners(@NonNull Source source) {
            assert (source != null);
            source.assignListeners();
        }

        @Override
        public SourceControl getEnvControl(Source source) {
            assert (source != null);
            return source.ctrl;
        }

        @Override
        public SourceEnvironment getEnv(Source source) {
            assert (source != null);
            return source.sourceEnv;
        }

        @Override
        public long getLastEventId(Source source) {
            assert (source != null);
            return source.eventId;
        }

        @Override
        public void setSourceModification(Source source, boolean sourceChanged, int startOffset, int endOffset) {
            assert (source != null);
            source.setSourceModification(sourceChanged, startOffset, endOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void mimeTypeMayChanged(@NonNull Source source) {
            assert (source != null);
            FileObject file = source.getFileObject();
            if (file == null || Objects.equals(source.getMimeType(), file.getMIMEType())) return;
            Class<Source> clazz = Source.class;
            synchronized (Source.class) {
                SourceFactory.getDefault().removeSource(file);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void parsed(Source source) {
            source.sourceModificationEvent.set(null);
        }

        @Override
        public SourceModificationEvent getSourceModificationEvent(Source source) {
            assert (source != null);
            SourceModificationEvent event = (SourceModificationEvent)source.sourceModificationEvent.get();
            if (event == null) {
                event = source.unspecifiedSourceModificationEvent;
            }
            return event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<Class<? extends Scheduler>, SchedulerEvent> createSchedulerEvents(@NonNull Source source, @NonNull Iterable<? extends Scheduler> schedulers, @NonNull SourceModificationEvent sourceModificationEvent) {
            Parameters.notNull((CharSequence)"source", (Object)source);
            Parameters.notNull((CharSequence)"schedulers", schedulers);
            Parameters.notNull((CharSequence)"sourceModificationEvent", (Object)sourceModificationEvent);
            HashMap result = new HashMap();
            for (Scheduler scheduler : schedulers) {
                SchedulerEvent schedulerEvent = SchedulerAccessor.get().createSchedulerEvent(scheduler, sourceModificationEvent);
                if (schedulerEvent == null) continue;
                result.put(scheduler.getClass(), schedulerEvent);
            }
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                source.schedulerEvents = result;
            }
            return Collections.unmodifiableMap(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSchedulerEvent(@NonNull Source source, @NonNull Scheduler scheduler, @NonNull SchedulerEvent event) {
            Parameters.notNull((CharSequence)"source", (Object)source);
            Parameters.notNull((CharSequence)"scheduler", (Object)scheduler);
            Parameters.notNull((CharSequence)"event", (Object)event);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (source.schedulerEvents == null) {
                    source.schedulerEvents = new HashMap();
                }
                source.schedulerEvents.put(scheduler.getClass(), event);
            }
        }

        @Override
        public SchedulerEvent getSchedulerEvent(Source source, Class<? extends Scheduler> schedulerType) {
            if (schedulerType == null) {
                return null;
            }
            if (source.schedulerEvents == null) {
                return null;
            }
            return (SchedulerEvent)source.schedulerEvents.get(schedulerType);
        }

        @Override
        public SourceCache getCache(Source source) {
            assert (source != null);
            return source.getCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int taskAdded(Source source) {
            int ret;
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                ret = source.taskCount++;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int taskRemoved(Source source) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                return --source.taskCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Source get(FileObject file) {
            Class<Source> clazz = Source.class;
            synchronized (Source.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return SourceFactory.getDefault().getSource(file);
            }
        }

        @Override
        public void suppressListening(boolean suppress, boolean prefer) {
            suppressListening.set(suppress);
            preferFile.set(prefer);
        }

        @Override
        public int getLineStartOffset(Snapshot snapshot, int lineIdx) {
            assert (snapshot != null);
            assert (snapshot.lineStartOffsets != null) : "Line offsets can only be obtained for a top-level snapshot";
            assert (lineIdx >= 0 && lineIdx <= snapshot.lineStartOffsets.length) : "Invalid lineIdx=" + lineIdx + ", lineStartOffsets.length=" + snapshot.lineStartOffsets.length;
            if (lineIdx < snapshot.lineStartOffsets.length) {
                return snapshot.lineStartOffsets[lineIdx];
            }
            return snapshot.getText().length();
        }

        @Override
        public Snapshot createSnapshot(CharSequence text, int[] lineStartOffsets, Source source, MimePath mimePath, int[][] currentToOriginal, int[][] originalToCurrent) {
            return Snapshot.create(text, lineStartOffsets, source, mimePath, currentToOriginal, originalToCurrent);
        }

        @Override
        public SourceCache getAndSetCache(Source source, SourceCache sourceCache) {
            SourceCache origCache = source.cache;
            source.cache = sourceCache;
            return origCache;
        }

        @Override
        @NonNull
        public ParserEventForward getParserEventForward(@NonNull Source source) {
            return source.peFwd;
        }

        @Override
        public Source create(@NonNull FileObject file, @NonNull String mimeType, @NonNull Lookup context) {
            return new Source(mimeType, null, file, context);
        }
    }
}

