/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolOptions;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.actions.Openable;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class BreadcrumbsImpl
implements LSPBindings.BackgroundTask {
    private static final RequestProcessor WORKER = new RequestProcessor(BreadcrumbsImpl.class.getName(), 1, false, false);
    private final JTextComponent comp;
    private final Document doc;
    private volatile RootBreadcrumbsElementImpl rootElement;

    public BreadcrumbsImpl(JTextComponent comp) {
        this.comp = comp;
        this.doc = comp.getDocument();
        this.comp.addCaretListener(evt -> this.update());
    }

    @Override
    public void run(List<LSPBindings> servers, FileObject file) {
        ArrayList<Pair<LSPBindings, List<DocumentSymbol>>> allSymbols = new ArrayList<Pair<LSPBindings, List<DocumentSymbol>>>();
        Utils.handleBindings(servers, capa -> Utils.isEnabled(capa.getDocumentSymbolProvider()), () -> new DocumentSymbolParams(new TextDocumentIdentifier(Utils.toURI(file))), (server, params) -> server.getTextDocumentService().documentSymbol(params), (server, result) -> allSymbols.add(Pair.of((Object)server, result.stream().map(this::toDocumentSymbol).toList())));
        this.rootElement = new RootBreadcrumbsElementImpl(file, this.doc, allSymbols);
        SwingUtilities.invokeLater(() -> this.update());
    }

    private DocumentSymbol toDocumentSymbol(Either<SymbolInformation, DocumentSymbol> variants) {
        if (variants.isRight()) {
            return (DocumentSymbol)variants.getRight();
        }
        SymbolInformation left = (SymbolInformation)variants.getLeft();
        return new DocumentSymbol(left.getName(), left.getKind(), left.getLocation().getRange(), left.getLocation().getRange(), null, Collections.emptyList());
    }

    private void update() {
        RootBreadcrumbsElementImpl element = this.rootElement;
        if (element == null) {
            return;
        }
        Caret caret = this.comp.getCaret();
        if (caret != null && !element.getChildren().isEmpty()) {
            element = (BreadcrumbsElement)element.getChildren().get(0);
            int caretPos = caret.getDot();
            block0: while (true) {
                for (BreadcrumbsElement child : element.getChildren()) {
                    BreadcrumbsElementImpl impl = (BreadcrumbsElementImpl)child;
                    if (impl.startPos.getOffset() > caretPos || caretPos > impl.endPos.getOffset()) continue;
                    element = child;
                    continue block0;
                }
                break;
            }
            BreadcrumbsController.setBreadcrumbs((Document)this.doc, (BreadcrumbsElement)element);
        }
    }

    static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
        }
        return null;
    }

    public static SideBarFactory createSideBarFactory() {
        final SideBarFactory delegate = BreadcrumbsController.createSideBarFactory();
        return new SideBarFactory(){

            public JComponent createSideBar(JTextComponent target) {
                return new LSPBreadcrumbPanel(delegate, target);
            }
        };
    }

    private static final class RootBreadcrumbsElementImpl
    implements BreadcrumbsElement {
        private final List<BreadcrumbsElement> children;

        public RootBreadcrumbsElementImpl(FileObject file, Document doc, List<Pair<LSPBindings, List<DocumentSymbol>>> allSymbols) {
            this.children = Collections.singletonList(new FileBreadcrumbsElementImpl(file, doc, this, allSymbols));
        }

        public String getHtmlDisplayName() {
            return "";
        }

        public Image getIcon(int type) {
            return BreadcrumbsController.NO_ICON;
        }

        public Image getOpenedIcon(int type) {
            return BreadcrumbsController.NO_ICON;
        }

        public List<BreadcrumbsElement> getChildren() {
            return this.children;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public BreadcrumbsElement getParent() {
            return null;
        }
    }

    private static final class BreadcrumbsElementImpl
    implements BreadcrumbsElement {
        private final BreadcrumbsElement parent;
        private final DocumentSymbol symbol;
        private final Position startPos;
        private final Position endPos;
        private final List<BreadcrumbsElement> children;
        private final Lookup lookup;

        public BreadcrumbsElementImpl(BreadcrumbsElement parent, final FileObject file, Document doc, final DocumentSymbol symbol) throws BadLocationException {
            this.parent = parent;
            this.symbol = symbol;
            this.startPos = doc.createPosition(Utils.getOffset(doc, symbol.getRange().getStart()));
            this.endPos = doc.createPosition(Utils.getOffset(doc, symbol.getRange().getEnd()));
            this.children = BreadcrumbsElementImpl.create((BreadcrumbsElement)this, symbol.getChildren(), file, doc);
            this.lookup = Lookups.fixed((Object[])new Object[]{new Openable(){

                public void open() {
                    Utils.open(Utils.toURI(file), symbol.getRange());
                }
            }});
        }

        public String getHtmlDisplayName() {
            return BreadcrumbsImpl.escape(this.symbol.getName());
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Icons.getSymbolIconBase(this.symbol.getKind()));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public List<BreadcrumbsElement> getChildren() {
            return this.children;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public BreadcrumbsElement getParent() {
            return this.parent;
        }

        public static List<BreadcrumbsElement> create(BreadcrumbsElement parent, List<DocumentSymbol> symbols, FileObject file, Document doc) {
            if (symbols == null) {
                return Collections.emptyList();
            }
            return symbols.stream().map(c -> BreadcrumbsElementImpl.create(parent, file, doc, c)).filter(e -> e != null).sorted((be1, be2) -> ((BreadcrumbsElementImpl)be1).startPos.getOffset() - ((BreadcrumbsElementImpl)be2).endPos.getOffset()).collect(Collectors.toList());
        }

        private static BreadcrumbsElement create(BreadcrumbsElement parent, FileObject file, Document doc, DocumentSymbol symbol) {
            try {
                return new BreadcrumbsElementImpl(parent, file, doc, symbol);
            }
            catch (BadLocationException ex) {
                return null;
            }
        }
    }

    private static class LSPBreadcrumbPanel
    extends JPanel
    implements PropertyChangeListener,
    ChangeListener {
        private final JTextComponent component;
        private final JComponent sidebar;

        public LSPBreadcrumbPanel(SideBarFactory delegate, JTextComponent component) {
            this.component = component;
            this.sidebar = delegate.createSideBar(component);
            this.setLayout(new BorderLayout());
            this.add((Component)this.sidebar, "Center");
            this.sidebar.addPropertyChangeListener(this);
            LSPBindings.addChangeListener(this);
            this.update();
        }

        private void update() {
            WORKER.post(() -> {
                FileObject file = NbEditorUtilities.getFileObject((Document)this.component.getDocument());
                List<Object> allBindings = file != null ? LSPBindings.getBindings(file) : List.of();
                List<LSPBindings> filterBindings = allBindings.stream().filter(bindings -> Utils.isEnabled(bindings.getInitResult().getCapabilities().getDocumentSymbolProvider())).toList();
                Runnable r = filterBindings.isEmpty() ? () -> {
                    this.setPreferredSize(new Dimension(0, 0));
                    this.setMaximumSize(new Dimension(0, 0));
                    this.revalidate();
                } : () -> {
                    this.setPreferredSize(this.sidebar.getPreferredSize());
                    this.setMaximumSize(this.sidebar.getMaximumSize());
                    this.revalidate();
                };
                SwingUtilities.invokeLater(r);
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == null || "preferredSize".equals(propertyName) || "maximumSize".equals(propertyName)) {
                this.update();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update();
        }
    }

    private static final class ProviderBreadcrumbsElementImpl
    implements BreadcrumbsElement {
        private final LSPBindings bindings;
        private final String displayName;
        private final BreadcrumbsElement root;
        private final List<BreadcrumbsElement> children;

        public ProviderBreadcrumbsElementImpl(FileObject file, LSPBindings bindings, Document doc, BreadcrumbsElement root, List<DocumentSymbol> symbols) {
            DocumentSymbolOptions docSymOpts;
            this.bindings = bindings;
            this.root = root;
            this.children = BreadcrumbsElementImpl.create((BreadcrumbsElement)this, symbols, file, doc);
            String displayName = bindings.getInitResult().getServerInfo().getName();
            ServerCapabilities capa = bindings.getInitResult().getCapabilities();
            Either docSymProvider = capa != null ? capa.getDocumentSymbolProvider() : null;
            DocumentSymbolOptions documentSymbolOptions = docSymOpts = docSymProvider != null && docSymProvider.isRight() ? (DocumentSymbolOptions)docSymProvider.getRight() : null;
            if (docSymOpts != null && docSymOpts.getLabel() != null) {
                displayName = docSymOpts.getLabel();
            }
            this.displayName = displayName;
        }

        public String getHtmlDisplayName() {
            return BreadcrumbsImpl.escape(this.displayName);
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)Icons.getSymbolIconBase(SymbolKind.Namespace));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public List<BreadcrumbsElement> getChildren() {
            return this.children;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public BreadcrumbsElement getParent() {
            return this.root;
        }
    }

    private static final class FileBreadcrumbsElementImpl
    implements BreadcrumbsElement {
        private final FileObject file;
        private final BreadcrumbsElement root;
        private final List<BreadcrumbsElement> children;

        public FileBreadcrumbsElementImpl(FileObject file, Document doc, BreadcrumbsElement root, List<Pair<LSPBindings, List<DocumentSymbol>>> allSymbols) {
            this.file = file;
            this.root = root;
            this.children = allSymbols.size() == 1 ? BreadcrumbsElementImpl.create((BreadcrumbsElement)this, (List)allSymbols.get(0).second(), file, doc) : allSymbols.stream().map(p -> new ProviderBreadcrumbsElementImpl(file, (LSPBindings)p.first(), doc, root, (List)p.second())).toList();
        }

        public String getHtmlDisplayName() {
            return BreadcrumbsImpl.escape(this.file.getNameExt());
        }

        public Image getIcon(int type) {
            try {
                return DataObject.find((FileObject)this.file).getNodeDelegate().getIcon(type);
            }
            catch (DataObjectNotFoundException ex) {
                return BreadcrumbsController.NO_ICON;
            }
        }

        public Image getOpenedIcon(int type) {
            try {
                return DataObject.find((FileObject)this.file).getNodeDelegate().getOpenedIcon(type);
            }
            catch (DataObjectNotFoundException ex) {
                return BreadcrumbsController.NO_ICON;
            }
        }

        public List<BreadcrumbsElement> getChildren() {
            return this.children;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public BreadcrumbsElement getParent() {
            return this.root;
        }
    }
}

