/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.options;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.lsp.client.options.Bundle;
import org.netbeans.modules.lsp.client.options.LanguageStorage;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LanguageDescriptionPanel
extends JPanel {
    private final String id;
    private JCheckBox debugger;
    private JTextField extensions;
    private JTextField icon;
    private JTextField name;
    private JTextField server;
    private JTextField syntax;

    public LanguageDescriptionPanel(LanguageStorage.LanguageDescription desc, Set<String> usedIds) {
        this.initComponents();
        if (desc == null) {
            char c;
            String base = "";
            block0: while (true) {
                for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    if (usedIds.add(base + c)) break block0;
                }
                base = "a";
            }
            String id = base + c;
            this.id = id;
        } else {
            this.id = desc.id;
            this.extensions.setText(desc.extensions);
            this.syntax.setText(desc.syntaxGrammar);
            this.server.setText(desc.languageServer);
            this.name.setText(desc.name);
            this.icon.setText(desc.icon);
            this.debugger.setSelected(desc.debugger);
        }
    }

    public LanguageStorage.LanguageDescription getDescription() {
        return new LanguageStorage.LanguageDescription(this.id, this.extensions.getText(), this.syntax.getText(), this.server.getText(), this.name.getText(), this.icon.getText(), this.debugger.isSelected());
    }

    private void initComponents() {
        JLabel nameLabel = new JLabel();
        JLabel extensionsLabel = new JLabel();
        JLabel grammarLabel = new JLabel();
        JLabel serverLabel = new JLabel();
        this.name = new JTextField();
        this.extensions = new JTextField();
        this.syntax = new JTextField();
        this.server = new JTextField();
        JButton browseGrammar = new JButton();
        JButton browseServer = new JButton();
        JSeparator extraOptionsSeparator = new JSeparator();
        JLabel optionalParams = new JLabel();
        JLabel iconLabel = new JLabel();
        this.icon = new JTextField();
        JButton browseIcon = new JButton();
        this.debugger = new JCheckBox();
        nameLabel.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)nameLabel, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.nameLabel.text"));
        extensionsLabel.setLabelFor(this.extensions);
        Mnemonics.setLocalizedText((JLabel)extensionsLabel, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.extensionsLabel.text"));
        grammarLabel.setLabelFor(this.syntax);
        Mnemonics.setLocalizedText((JLabel)grammarLabel, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.grammarLabel.text"));
        serverLabel.setLabelFor(this.server);
        Mnemonics.setLocalizedText((JLabel)serverLabel, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.serverLabel.text"));
        this.name.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.name.text"));
        this.extensions.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.extensions.text"));
        this.syntax.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.syntax.text"));
        this.server.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.server.text"));
        Mnemonics.setLocalizedText((AbstractButton)browseGrammar, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.browseGrammar.text"));
        browseGrammar.addActionListener(this::browseGrammarActionPerformed);
        Mnemonics.setLocalizedText((AbstractButton)browseServer, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.browseServer.text"));
        browseServer.addActionListener(this::browseServerActionPerformed);
        Mnemonics.setLocalizedText((JLabel)optionalParams, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.optionalParams.text"));
        iconLabel.setLabelFor(this.icon);
        Mnemonics.setLocalizedText((JLabel)iconLabel, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.iconLabel.text"));
        this.icon.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.icon.text"));
        Mnemonics.setLocalizedText((AbstractButton)browseIcon, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.browseIcon.text"));
        browseIcon.addActionListener(this::browseIconActionPerformed);
        Mnemonics.setLocalizedText((AbstractButton)this.debugger, (String)NbBundle.getMessage(LanguageDescriptionPanel.class, (String)"LanguageDescriptionPanel.debugger.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(optionalParams).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(extraOptionsSeparator)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(nameLabel).addComponent(iconLabel)).addGap(68, 68, 68).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.icon, -1, 273, Short.MAX_VALUE).addComponent(this.name)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(browseIcon)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(grammarLabel).addComponent(serverLabel).addComponent(extensionsLabel, -2, 101, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.extensions).addComponent(this.server).addComponent(this.syntax)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(browseGrammar, GroupLayout.Alignment.TRAILING).addComponent(browseServer, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addComponent(this.debugger).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(extensionsLabel).addComponent(this.extensions, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(grammarLabel).addComponent(this.syntax, -2, -1, -2).addComponent(browseGrammar)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.server, -2, -1, -2).addComponent(serverLabel).addComponent(browseServer)).addGap(18, 18, 18).addComponent(this.debugger).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(optionalParams).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(extraOptionsSeparator, -2, 11, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.name, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.icon, -2, -1, -2).addComponent(iconLabel).addComponent(browseIcon)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseGrammarActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".json") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".tmlanguage");
            }

            @Override
            public String getDescription() {
                return Bundle.DESC_JSONFilter();
            }
        });
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setSelectedFile(new File(this.syntax.getText()));
        if (chooser.showDialog(null, Bundle.BTN_Select()) == 0) {
            this.syntax.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void browseIconActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".png") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jpg") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".gif");
            }

            @Override
            public String getDescription() {
                return Bundle.DESC_IconFilter();
            }
        });
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setSelectedFile(new File(this.icon.getText()));
        if (chooser.showDialog(null, Bundle.BTN_Select()) == 0) {
            this.icon.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void browseServerActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setSelectedFile(new File(this.server.getText()));
        if (chooser.showDialog(null, Bundle.BTN_Select()) == 0) {
            this.server.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }
}

