/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.lsp4j.debug.StackFrame;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPThread;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;

public final class DAPFrame
implements DebuggingView.DVFrame {
    private static final Logger LOGGER = Logger.getLogger(DAPFrame.class.getName());
    private final DAPDebugger.URIPathConvertor fileConvertor;
    private final DAPThread thread;
    private final StackFrame frame;

    public DAPFrame(DAPDebugger.URIPathConvertor fileConvertor, DAPThread thread, StackFrame frame) {
        this.fileConvertor = fileConvertor;
        this.thread = thread;
        this.frame = frame;
    }

    public String getName() {
        Object name = this.frame.getName();
        if (((String)name).length() > 100) {
            name = ((String)name).substring(0, 100) + "...";
        }
        return name;
    }

    public DebuggingView.DVThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        this.thread.setCurrentFrame(this);
    }

    public URI getSourceURI() {
        if (this.frame.getSource() == null || this.frame.getSource().getPath() == null) {
            return null;
        }
        return this.fileConvertor.toURI(this.frame.getSource().getPath());
    }

    public int getLine() {
        return this.frame.getLine();
    }

    public int getColumn() {
        return -1;
    }

    @CheckForNull
    public Line location() {
        FileObject file;
        if (this.frame.getLine() == 0) {
            return null;
        }
        URI sourceURI = this.getSourceURI();
        if (sourceURI == null) {
            return null;
        }
        try {
            if (!sourceURI.isAbsolute()) {
                return null;
            }
            file = URLMapper.findFileObject((URL)sourceURI.toURL());
        }
        catch (MalformedURLException ex) {
            return null;
        }
        if (file == null) {
            return null;
        }
        LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
        return lc.getLineSet().getOriginal(this.frame.getLine() - 1);
    }

    public int getId() {
        return this.frame.getId();
    }

    public String getDescription() {
        return this.getName();
    }
}

