/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bridge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.lsp.ErrorProvider;
import org.netbeans.spi.lsp.StructureProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class BridgingLanguageServer
implements LanguageServer,
LanguageClientAware {
    private static final int DIAGNOSTIC_DELAY = 500;
    private static final RequestProcessor WORKER = new RequestProcessor(BridgingLanguageServer.class.getName() + "-worker", 1, false, false);
    private static final RequestProcessor BACKGROUND = new RequestProcessor(BridgingLanguageServer.class.getName() + "-background", 1, false, false);
    private final Map<FileObject, RequestProcessor.Task> runDiagnostics = new WeakHashMap<FileObject, RequestProcessor.Task>();
    private LanguageClient client;

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        ServerCapabilities serverCaps = new ServerCapabilities();
        serverCaps.setTextDocumentSync(TextDocumentSyncKind.Incremental);
        ServerInfo serverInfo = new ServerInfo();
        InitializeResult initResult = new InitializeResult(serverCaps, serverInfo);
        CompletableFuture<InitializeResult> result = new CompletableFuture<InitializeResult>();
        result.complete(initResult);
        return result;
    }

    public CompletableFuture<Object> shutdown() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void exit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void reRunDiagnostics(FileObject file) {
        this.runDiagnostics.computeIfAbsent(file, x -> BACKGROUND.create(() -> {
            try {
                if (this.client == null) {
                    return;
                }
                EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                StyledDocument doc = ec.openDocument();
                ArrayList<org.eclipse.lsp4j.Diagnostic> diagnostics = new ArrayList<org.eclipse.lsp4j.Diagnostic>();
                for (ErrorProvider.Kind kind : ErrorProvider.Kind.values()) {
                    ErrorProvider.Context ctx = new ErrorProvider.Context(file, kind);
                    for (ErrorProvider provider : MimeLookup.getLookup((String)file.getMIMEType()).lookupAll(ErrorProvider.class)) {
                        for (Diagnostic diag : provider.computeErrors(ctx)) {
                            if (diag.getSeverity() == null) {
                                System.err.println("!!!!");
                            }
                            DiagnosticSeverity severity = diag.getSeverity() != null ? DiagnosticSeverity.valueOf((String)diag.getSeverity().name()) : null;
                            diagnostics.add(new org.eclipse.lsp4j.Diagnostic(new Range(Utils.createPosition(doc, diag.getStartPosition().getOffset()), Utils.createPosition(doc, diag.getEndPosition().getOffset())), diag.getDescription(), severity, null, diag.getCode()));
                        }
                    }
                }
                this.client.publishDiagnostics(new PublishDiagnosticsParams(Utils.toURI(file), diagnostics));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        })).schedule(500);
    }

    public TextDocumentService getTextDocumentService() {
        return new TextDocumentService(){

            public void didOpen(DidOpenTextDocumentParams params) {
                FileObject file = Utils.fromURI(params.getTextDocument().getUri());
                BridgingLanguageServer.this.reRunDiagnostics(file);
            }

            public void didChange(DidChangeTextDocumentParams params) {
                FileObject file = Utils.fromURI(params.getTextDocument().getUri());
                BridgingLanguageServer.this.reRunDiagnostics(file);
            }

            public void didClose(DidCloseTextDocumentParams params) {
            }

            public void didSave(DidSaveTextDocumentParams params) {
            }

            public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
                CompletableFuture<Either<List<CompletionItem>, CompletionList>> result = new CompletableFuture<Either<List<CompletionItem>, CompletionList>>();
                try {
                    boolean complete;
                    FileObject file = Utils.fromURI(position.getTextDocument().getUri());
                    EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                    StyledDocument doc = ec.openDocument();
                    ArrayList items = new ArrayList();
                    Completion.TriggerKind triggerKind = Completion.TriggerKind.Invoked;
                    Character triggerCharacter = null;
                    if (position.getContext() != null) {
                        triggerKind = Completion.TriggerKind.valueOf((String)position.getContext().getTriggerKind().name());
                        triggerCharacter = position.getContext().getTriggerKind() == CompletionTriggerKind.TriggerCharacter ? Character.valueOf(position.getContext().getTriggerCharacter().charAt(0)) : null;
                    }
                    CompletionList resultValue = new CompletionList(!(complete = Completion.collect((Document)doc, (int)Utils.getOffset(doc, position.getPosition()), (Completion.Context)new Completion.Context(triggerKind, triggerCharacter), completion -> {
                        CompletionItem item = BridgingLanguageServer.this.convertCompletionItem(doc, (Completion)completion);
                        items.add(item);
                    })), items);
                    result.complete((Either<List<CompletionItem>, CompletionList>)Either.forRight((Object)resultValue));
                }
                catch (IOException ex) {
                    result.completeExceptionally(ex);
                }
                return result;
            }

            public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
                CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>();
                CompletionResolutionData completionData = (CompletionResolutionData)unresolved.getData();
                if (completionData != null) {
                    Completion completion = completionData.completion();
                    Document doc = completionData.doc();
                    WORKER.post(() -> {
                        if (completion.getDetail() != null) {
                            try {
                                String detail = (String)completion.getDetail().get();
                                if (detail != null) {
                                    unresolved.setDetail(detail);
                                }
                            }
                            catch (Exception detail) {
                                // empty catch block
                            }
                        }
                        if (completion.getAdditionalTextEdits() != null) {
                            try {
                                List additionalTextEdits = (List)completion.getAdditionalTextEdits().get();
                                if (additionalTextEdits != null && !additionalTextEdits.isEmpty()) {
                                    unresolved.setAdditionalTextEdits(additionalTextEdits.stream().map(ed -> new org.eclipse.lsp4j.TextEdit(new Range(BridgingLanguageServer.createPosition(doc, ed.getStartOffset()), BridgingLanguageServer.createPosition(doc, ed.getEndOffset())), ed.getNewText())).collect(Collectors.toList()));
                                }
                            }
                            catch (Exception additionalTextEdits) {
                                // empty catch block
                            }
                        }
                        if (completion.getDocumentation() != null) {
                            try {
                                String documentation = completion.getDocumentation().getNow(null);
                                if (documentation != null) {
                                    MarkupContent markup = new MarkupContent();
                                    markup.setKind("html");
                                    markup.setValue(documentation);
                                    unresolved.setDocumentation(markup);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        result.complete(unresolved);
                    });
                } else {
                    result.complete(unresolved);
                }
                return result;
            }

            public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
                CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> result = new CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>>();
                try {
                    FileObject file = Utils.fromURI(params.getTextDocument().getUri());
                    EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
                    StyledDocument doc = ec.openDocument();
                    ArrayList items = new ArrayList();
                    ArrayList<Either> symbols = new ArrayList<Either>();
                    for (StructureProvider structure : MimeLookup.getLookup((String)file.getMIMEType()).lookupAll(StructureProvider.class)) {
                        for (StructureElement el : structure.getStructure((Document)doc)) {
                            symbols.add(Either.forRight((Object)BridgingLanguageServer.structureElement2DocumentSymbol(doc, el)));
                        }
                    }
                    result.complete(symbols);
                }
                catch (IOException | BadLocationException ex) {
                    result.completeExceptionally(ex);
                }
                return result;
            }
        };
    }

    private CompletionItem convertCompletionItem(Document doc, Completion completion) {
        List additionalTextEdits;
        org.netbeans.api.lsp.Command command;
        TextEdit edit;
        String documentation;
        CompletionItem item = new CompletionItem(completion.getLabel());
        if (completion.getLabelDetail() != null || completion.getLabelDescription() != null) {
            CompletionItemLabelDetails labelDetails = new CompletionItemLabelDetails();
            labelDetails.setDetail(completion.getLabelDetail());
            labelDetails.setDescription(completion.getLabelDescription());
            item.setLabelDetails(labelDetails);
        }
        if (completion.getKind() != null) {
            item.setKind(CompletionItemKind.valueOf((String)completion.getKind().name()));
        }
        if (completion.getTags() != null) {
            item.setTags(completion.getTags().stream().map(tag -> CompletionItemTag.valueOf((String)tag.name())).collect(Collectors.toList()));
        }
        if (completion.getDetail() != null && completion.getDetail().isDone()) {
            item.setDetail((String)completion.getDetail().getNow(null));
        }
        if (completion.getDocumentation() != null && completion.getDocumentation().isDone() && (documentation = (String)completion.getDocumentation().getNow(null)) != null) {
            MarkupContent markup = new MarkupContent();
            markup.setKind("html");
            markup.setValue(documentation);
            item.setDocumentation(markup);
        }
        if (completion.isPreselect()) {
            item.setPreselect(Boolean.valueOf(true));
        }
        item.setSortText(completion.getSortText());
        item.setFilterText(completion.getFilterText());
        item.setInsertText(completion.getInsertText());
        if (completion.getInsertTextFormat() != null) {
            item.setInsertTextFormat(InsertTextFormat.valueOf((String)completion.getInsertTextFormat().name()));
        }
        if ((edit = completion.getTextEdit()) != null) {
            item.setTextEdit(Either.forLeft((Object)new org.eclipse.lsp4j.TextEdit(new Range(BridgingLanguageServer.createPosition(doc, edit.getStartOffset()), BridgingLanguageServer.createPosition(doc, edit.getEndOffset())), edit.getNewText())));
        }
        if ((command = completion.getCommand()) != null) {
            item.setCommand(new Command(command.getTitle(), command.getCommand(), command.getArguments()));
        }
        if (completion.getAdditionalTextEdits() != null && completion.getAdditionalTextEdits().isDone() && (additionalTextEdits = (List)completion.getAdditionalTextEdits().getNow(null)) != null && !additionalTextEdits.isEmpty()) {
            item.setAdditionalTextEdits(additionalTextEdits.stream().map(ed -> new org.eclipse.lsp4j.TextEdit(new Range(BridgingLanguageServer.createPosition(doc, ed.getStartOffset()), BridgingLanguageServer.createPosition(doc, ed.getEndOffset())), ed.getNewText())).collect(Collectors.toList()));
        }
        if (completion.getCommitCharacters() != null) {
            item.setCommitCharacters(completion.getCommitCharacters().stream().map(ch -> ch.toString()).collect(Collectors.toList()));
        }
        item.setData((Object)new CompletionResolutionData(doc, completion));
        return item;
    }

    private static DocumentSymbol structureElement2DocumentSymbol(Document doc, StructureElement el) throws BadLocationException {
        Position selectionStartPos = Utils.createPosition(doc, el.getSelectionStartOffset());
        Position selectionEndPos = Utils.createPosition(doc, el.getSelectionEndOffset());
        Range selectionRange = new Range(selectionStartPos, selectionEndPos);
        Position enclosedStartPos = Utils.createPosition(doc, el.getExpandedStartOffset());
        Position enclosedEndPos = Utils.createPosition(doc, el.getExpandedEndOffset());
        Range expandedRange = new Range(enclosedStartPos, enclosedEndPos);
        if (el.getChildren() != null && !el.getChildren().isEmpty()) {
            DocumentSymbol ds;
            ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
            for (StructureElement child : el.getChildren()) {
                ds = BridgingLanguageServer.structureElement2DocumentSymbol(doc, child);
                if (ds == null) continue;
                children.add(ds);
            }
            ds = new DocumentSymbol(el.getName(), BridgingLanguageServer.structureElementKind2SymbolKind(el.getKind()), expandedRange, selectionRange, el.getDetail(), children);
            ds.setTags(BridgingLanguageServer.elementTags2SymbolTags(el.getTags()));
            return ds;
        }
        DocumentSymbol ds = new DocumentSymbol(el.getName(), BridgingLanguageServer.structureElementKind2SymbolKind(el.getKind()), expandedRange, selectionRange, el.getDetail());
        ds.setTags(BridgingLanguageServer.elementTags2SymbolTags(el.getTags()));
        return ds;
    }

    private static SymbolKind structureElementKind2SymbolKind(StructureElement.Kind kind) {
        switch (kind) {
            case Array: {
                return SymbolKind.Array;
            }
            case Boolean: {
                return SymbolKind.Boolean;
            }
            case Class: {
                return SymbolKind.Class;
            }
            case Constant: {
                return SymbolKind.Constant;
            }
            case Constructor: {
                return SymbolKind.Constructor;
            }
            case Enum: {
                return SymbolKind.Enum;
            }
            case EnumMember: {
                return SymbolKind.EnumMember;
            }
            case Event: {
                return SymbolKind.Event;
            }
            case Field: {
                return SymbolKind.Field;
            }
            case File: {
                return SymbolKind.File;
            }
            case Function: {
                return SymbolKind.Function;
            }
            case Interface: {
                return SymbolKind.Interface;
            }
            case Key: {
                return SymbolKind.Key;
            }
            case Method: {
                return SymbolKind.Method;
            }
            case Module: {
                return SymbolKind.Module;
            }
            case Namespace: {
                return SymbolKind.Namespace;
            }
            case Null: {
                return SymbolKind.Null;
            }
            case Number: {
                return SymbolKind.Number;
            }
            case Object: {
                return SymbolKind.Object;
            }
            case Operator: {
                return SymbolKind.Operator;
            }
            case Package: {
                return SymbolKind.Package;
            }
            case Property: {
                return SymbolKind.Property;
            }
            case String: {
                return SymbolKind.String;
            }
            case Struct: {
                return SymbolKind.Struct;
            }
            case TypeParameter: {
                return SymbolKind.TypeParameter;
            }
            case Variable: {
                return SymbolKind.Variable;
            }
        }
        return SymbolKind.Object;
    }

    private static List<SymbolTag> elementTags2SymbolTags(Set<StructureElement.Tag> tags) {
        if (tags != null) {
            return Collections.singletonList(SymbolTag.Deprecated);
        }
        return null;
    }

    public WorkspaceService getWorkspaceService() {
        return new WorkspaceService(){

            public void didChangeConfiguration(DidChangeConfigurationParams params) {
            }

            public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
            }
        };
    }

    public static Position createPosition(Document doc, int offset) {
        try {
            return new Position(LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)offset), offset - LineDocumentUtils.getLineStart((LineDocument)((LineDocument)doc), (int)offset));
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    record CompletionResolutionData(Document doc, Completion completion) {
    }
}

