/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class SemanticHighlight
implements LSPBindings.BackgroundTask {
    private static final Logger LOG = Logger.getLogger(SemanticHighlight.class.getName());
    private final Document doc;
    private final Map<Integer, Map<Integer, AttributeSet>> tokenId2Highlight = new HashMap<Integer, Map<Integer, AttributeSet>>();
    private static final AttributeSet EMPTY = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[0]);

    public SemanticHighlight(JTextComponent c) {
        this.doc = c.getDocument();
    }

    @Override
    public void run(LSPBindings bindings, FileObject file) {
        try {
            SemanticTokensWithRegistrationOptions options = bindings.getInitResult().getCapabilities().getSemanticTokensProvider();
            if (options == null) {
                return;
            }
            OffsetsBag target = new OffsetsBag(this.doc);
            SemanticTokensParams params = new SemanticTokensParams(new TextDocumentIdentifier(Utils.toURI(file)));
            SemanticTokens tokens = (SemanticTokens)bindings.getTextDocumentService().semanticTokensFull(params).get();
            List data = tokens.getData();
            String mimeType = FileUtil.getMIMEType((FileObject)file);
            FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
            if (fcs == null) {
                fcs = (FontColorSettings)MimeLookup.getLookup((String)"text/textmate").lookup(FontColorSettings.class);
            }
            int lastLine = 0;
            int lastColumn = 0;
            int offset = 0;
            for (int i = 0; i < data.size(); i += 5) {
                int deltaLine = (Integer)data.get(i);
                int deltaColumn = (Integer)data.get(i + 1);
                if (deltaLine == 0) {
                    lastColumn += deltaColumn;
                    offset += deltaColumn;
                } else {
                    lastColumn = deltaColumn;
                    offset = Utils.getOffset(this.doc, new Position(lastLine += deltaLine, lastColumn));
                }
                if ((Integer)data.get(i + 2) <= 0) continue;
                AttributeSet tokenHighlight = fcs == null ? EMPTY : this.tokenHighlight(bindings, fcs, (Integer)data.get(i + 3), (Integer)data.get(i + 4));
                target.addHighlight(offset, offset + (Integer)data.get(i + 2), tokenHighlight);
            }
            SemanticHighlight.getBag(this.doc).setHighlights(target);
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private AttributeSet tokenHighlight(LSPBindings bindings, FontColorSettings fcs, int tokenId, int modifiers) {
        assert (fcs != null);
        return this.tokenId2Highlight.computeIfAbsent(tokenId, s -> new HashMap()).computeIfAbsent(modifiers, mods -> {
            AttributeSet statik;
            SemanticTokensLegend legend = bindings.getInitResult().getCapabilities().getSemanticTokensProvider().getLegend();
            List tokenTypes = legend.getTokenTypes();
            if (tokenId >= tokenTypes.size()) {
                return EMPTY;
            }
            String tokenName = tokenId >= 0 ? (String)tokenTypes.get(tokenId) : null;
            boolean isStatic = false;
            boolean isDeclaration = false;
            while (mods != 0) {
                int mod = Integer.highestOneBit(mods);
                switch ((String)legend.getTokenModifiers().get(Integer.numberOfTrailingZeros(mod))) {
                    case "static": {
                        isStatic = true;
                        break;
                    }
                    case "definition": 
                    case "declaration": {
                        isDeclaration = true;
                    }
                }
                mods = mods & ~mod;
            }
            String colorSet = "mod" + (String)(tokenName != null ? "-" + tokenName : "") + (isDeclaration ? "-declaration" : "");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "LSP Semantic coloring. token kind: {0}", colorSet);
            }
            AttributeSet colors = fcs.getTokenFontColors(colorSet);
            AttributeSet attributeSet = statik = isStatic ? fcs.getTokenFontColors("mod-static") : null;
            if (colors != null && statik != null) {
                return AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{SemanticHighlight.adjustAttributes(colors), SemanticHighlight.adjustAttributes(statik)});
            }
            if (colors != null) {
                return colors;
            }
            if (statik != null) {
                return statik;
            }
            return EMPTY;
        });
    }

    private static OffsetsBag getBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(SemanticHighlight.class);
        if (bag == null) {
            bag = new OffsetsBag(doc);
            doc.putProperty(SemanticHighlight.class, bag);
        }
        return bag;
    }

    private static AttributeSet adjustAttributes(AttributeSet as) {
        LinkedList<Object> attrs = new LinkedList<Object>();
        Enumeration<?> e = as.getAttributeNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = as.getAttribute(key);
            if (value == Boolean.FALSE) continue;
            attrs.add(key);
            attrs.add(value);
        }
        return AttributesUtilities.createImmutable((Object[])attrs.toArray());
    }

    public static final class HighlightsLayerFactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)SemanticHighlight.class.getName(), (ZOrder)ZOrder.SYNTAX_RACK.forPosition(1000), (boolean)true, (HighlightsContainer)SemanticHighlight.getBag(context.getDocument()))};
        }
    }
}

