/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client;

import com.google.gson.InstanceCreator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.PublishDiagnosticsCapabilities;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensCapabilities;
import org.eclipse.lsp4j.SemanticTokensClientCapabilitiesRequests;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolKindCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.lsp4j.util.Preconditions;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.lsp.client.Bundle;
import org.netbeans.modules.lsp.client.LanguageServerProviderAccessor;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.LanguageClientImpl;
import org.netbeans.modules.lsp.client.bindings.TextDocumentSyncServerCapabilityHandler;
import org.netbeans.modules.lsp.client.options.MimeTypeInfo;
import org.netbeans.modules.lsp.client.spi.LanguageServerProvider;
import org.netbeans.modules.lsp.client.spi.MultiMimeLanguageServerProvider;
import org.netbeans.modules.lsp.client.spi.ServerRestarter;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class LSPBindings {
    private static final Logger LOG = Logger.getLogger(LSPBindings.class.getName());
    private static final int DELAY = 500;
    private static final int LSP_KEEP_ALIVE_MINUTES = 10;
    private static final int INVALID_START_TIME = 60000;
    private static final int INVALID_START_MAX_COUNT = 5;
    private static final RequestProcessor WORKER = new RequestProcessor(LanguageClientImpl.class.getName(), 1, false, false);
    private static final ChangeSupport cs = new ChangeSupport(LSPBindings.class);
    private static final Map<LSPBindings, Long> lspKeepAlive = new IdentityHashMap<LSPBindings, Long>();
    private static final Map<URI, Map<String, ServerDescription>> project2MimeType2Server = new HashMap<URI, Map<String, ServerDescription>>();
    private static final Map<FileObject, Map<String, LSPBindings>> workspace2Extension2Server = new HashMap<FileObject, Map<String, LSPBindings>>();
    private static final Map<FileObject, Map<BackgroundTask, RequestProcessor.Task>> backgroundTasks;
    private final Set<FileObject> openedFiles = new HashSet<FileObject>();
    private static final List<String> KNOWN_TOKEN_TYPES;
    private static final List<String> KNOWN_TOKEN_MODIFIERS;
    private final LanguageServer server;
    private final InitializeResult initResult;
    private final Process process;

    public static synchronized LSPBindings getBindings(FileObject file) {
        for (Map.Entry<FileObject, Map<String, LSPBindings>> e : workspace2Extension2Server.entrySet()) {
            if (!FileUtil.isParentOf((FileObject)e.getKey(), (FileObject)file)) continue;
            LSPBindings bindings = e.getValue().get(file.getExt());
            if (bindings == null) break;
            return bindings;
        }
        String mimeType = FileUtil.getMIMEType((FileObject)file);
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (mimeType == null) {
            return null;
        }
        return LSPBindings.getBindingsImpl(prj, file, mimeType);
    }

    public static void ensureServerRunning(Project prj, String mimeType) {
        LSPBindings.getBindingsImpl(prj, prj.getProjectDirectory(), mimeType);
    }

    public static synchronized LSPBindings getBindingsImpl(Project prj, FileObject file, String mimeType) {
        FileObject dir;
        if (prj == null) {
            dir = file.getParent();
            File dirFile = FileUtil.toFile((FileObject)dir);
            if (dirFile != null && dirFile.getName().startsWith("vcs-") && dirFile.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) {
                return null;
            }
        } else {
            dir = prj.getProjectDirectory();
        }
        URI uri = dir.toURI();
        LSPBindings bindings = null;
        ServerDescription description = project2MimeType2Server.computeIfAbsent(uri, p -> new HashMap()).computeIfAbsent(mimeType, m -> new ServerDescription());
        if (description.bindings != null) {
            bindings = description.bindings.get();
        }
        if (bindings != null && bindings.process != null && !bindings.process.isAlive()) {
            LSPBindings.startFailed(description, mimeType);
            bindings = null;
        }
        if (description.failedCount >= 5) {
            return null;
        }
        if (bindings == null && (bindings = LSPBindings.buildBindings(description, prj, mimeType, dir, uri)) != null) {
            description.bindings = new WeakReference<LSPBindings>(bindings);
            description.lastStartTimeStamp = System.currentTimeMillis();
            Map<String, ServerDescription> mimeType2Server = project2MimeType2Server.get(uri);
            for (String mt : description.mimeTypes) {
                mimeType2Server.put(mt, description);
            }
            TextDocumentSyncServerCapabilityHandler.refreshOpenedFilesInServers();
            WORKER.post(() -> cs.fireChange());
        }
        if (bindings != null) {
            lspKeepAlive.put(bindings, System.currentTimeMillis());
        }
        return bindings != null ? bindings : null;
    }

    private static void startFailed(ServerDescription description, String mimeType) {
        long timeStamp = System.currentTimeMillis();
        if (timeStamp - description.lastStartTimeStamp < 60000L) {
            ++description.failedCount;
            if (description.failedCount == 5) {
                NotificationDisplayer.getDefault().notify(Bundle.TITLE_FailedToStart(mimeType), (Icon)ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/lsp/client/resources/error_16.png", (boolean)false), Bundle.DETAIL_FailedToStart(), null);
            }
        } else {
            description.failedCount = 0;
        }
        description.lastStartTimeStamp = timeStamp;
    }

    private static LSPBindings buildBindings(ServerDescription inDescription, Project prj, String mt, FileObject dir, URI baseUri) {
        MimeTypeInfo mimeTypeInfo = new MimeTypeInfo(mt);
        ServerRestarter restarter = () -> {
            Class<LSPBindings> clazz = LSPBindings.class;
            synchronized (LSPBindings.class) {
                LSPBindings b;
                ServerDescription description = (ServerDescription)project2MimeType2Server.getOrDefault(baseUri, Collections.emptyMap()).remove(mt);
                if (description != null) {
                    for (String anotherMT : description.mimeTypes) {
                        project2MimeType2Server.get(baseUri).remove(anotherMT);
                    }
                }
                Reference<LSPBindings> bRef = description != null ? description.bindings : null;
                LSPBindings lSPBindings = b = bRef != null ? bRef.get() : null;
                if (b != null) {
                    lspKeepAlive.remove(b);
                    try {
                        b.server.shutdown().get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                    if (b.process != null) {
                        b.process.destroy();
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
        boolean foundServer = false;
        for (LanguageServerProvider provider : MimeLookup.getLookup((String)mt).lookupAll(LanguageServerProvider.class)) {
            LanguageServerProvider.LanguageServerDescription desc;
            Lookup lkp = prj != null ? Lookups.fixed((Object[])new Object[]{prj, mimeTypeInfo, restarter}) : Lookups.fixed((Object[])new Object[]{mimeTypeInfo, restarter});
            inDescription.mimeTypes = Collections.singleton(mt);
            if (provider instanceof MultiMimeLanguageServerProvider) {
                inDescription.mimeTypes = new HashSet<String>(((MultiMimeLanguageServerProvider)provider).getMimeTypes());
            }
            if ((desc = provider.startServer(lkp)) == null) continue;
            LSPBindings b = LanguageServerProviderAccessor.getINSTANCE().getBindings(desc);
            if (b != null) {
                return b;
            }
            foundServer = true;
            try {
                Process process;
                LanguageClientImpl lci = new LanguageClientImpl();
                LanguageServer server = LanguageServerProviderAccessor.getINSTANCE().getServer(desc);
                if (server == null) {
                    InputStream in = LanguageServerProviderAccessor.getINSTANCE().getInputStream(desc);
                    OutputStream out = LanguageServerProviderAccessor.getINSTANCE().getOutputStream(desc);
                    process = LanguageServerProviderAccessor.getINSTANCE().getProcess(desc);
                    Launcher.Builder launcherBuilder = new LSPLauncher.Builder().setLocalService((Object)lci).setRemoteInterface(LanguageServer.class).setInput(in).setOutput(out).configureGson(gson -> {
                        gson.registerTypeAdapter(SemanticTokensLegend.class, (Object)new InstanceCreator<SemanticTokensLegend>(){

                            public SemanticTokensLegend createInstance(Type type) {
                                return new SemanticTokensLegend(Collections.emptyList(), Collections.emptyList());
                            }
                        });
                        gson.registerTypeAdapter(SemanticTokens.class, (Object)new InstanceCreator<SemanticTokens>(){

                            public SemanticTokens createInstance(Type type) {
                                return new SemanticTokens(Collections.emptyList());
                            }
                        });
                    });
                    if (LOG.isLoggable(Level.FINER)) {
                        PrintWriter pw = new PrintWriter(new Writer(){
                            StringBuffer sb = new StringBuffer();

                            @Override
                            public void write(char[] cbuf, int off, int len) throws IOException {
                                this.sb.append(cbuf, off, len);
                            }

                            @Override
                            public void flush() throws IOException {
                                LOG.finer(this.sb.toString());
                            }

                            @Override
                            public void close() throws IOException {
                                this.sb.setLength(0);
                                this.sb.trimToSize();
                            }
                        });
                        launcherBuilder.traceMessages(pw);
                    }
                    Launcher launcher = launcherBuilder.create();
                    launcher.startListening();
                    server = (LanguageServer)launcher.getRemoteProxy();
                } else {
                    process = null;
                    if (server instanceof LanguageClientAware) {
                        LanguageClientAware aware = (LanguageClientAware)server;
                        aware.connect((LanguageClient)lci);
                    }
                }
                InitializeResult result = LSPBindings.initServer(process, server, dir);
                server.initialized(new InitializedParams());
                b = new LSPBindings(server, result, LanguageServerProviderAccessor.getINSTANCE().getProcess(desc));
                new LSPReference(b, Utilities.activeReferenceQueue());
                lci.setBindings(b);
                LanguageServerProviderAccessor.getINSTANCE().setBindings(desc, b);
                return b;
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        if (foundServer) {
            LSPBindings.startFailed(inDescription, mt);
        }
        return null;
    }

    public static void addBindings(FileObject root, int port, String ... extensions) {
        BaseProgressUtils.showProgressDialogAndRun(() -> {
            try {
                Socket s = new Socket(InetAddress.getLocalHost(), port);
                LanguageClientImpl lc = new LanguageClientImpl();
                InputStream in = s.getInputStream();
                final OutputStream out = s.getOutputStream();
                Launcher launcher = LSPLauncher.createClientLauncher((LanguageClient)lc, (InputStream)in, (OutputStream)new OutputStream(){

                    @Override
                    public void write(int w) throws IOException {
                        out.write(w);
                        if (w == 10) {
                            out.flush();
                        }
                    }
                });
                launcher.startListening();
                LanguageServer server = (LanguageServer)launcher.getRemoteProxy();
                InitializeResult result = LSPBindings.initServer(null, server, root);
                server.initialized(new InitializedParams());
                LSPBindings bindings = new LSPBindings(server, result, null);
                lc.setBindings(bindings);
                Class<LSPBindings> clazz = LSPBindings.class;
                synchronized (LSPBindings.class) {
                    workspace2Extension2Server.put(root, Arrays.stream(extensions).collect(Collectors.toMap(k -> k, v -> bindings)));
                    // ** MonitorExit[var11_12] (shouldn't be in output)
                    WORKER.post(() -> cs.fireChange());
                }
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, (String)Bundle.LBL_Connecting());
    }

    private static InitializeResult initServer(Process p, LanguageServer server, FileObject root) throws InterruptedException, ExecutionException {
        InitializeParams initParams = new InitializeParams();
        initParams.setRootUri(Utils.toURI(root));
        File rootFile = FileUtil.toFile((FileObject)root);
        if (rootFile != null) {
            initParams.setRootPath(rootFile.getAbsolutePath());
        }
        initParams.setProcessId(Integer.valueOf(0));
        TextDocumentClientCapabilities tdcc = new TextDocumentClientCapabilities();
        DocumentSymbolCapabilities dsc = new DocumentSymbolCapabilities();
        dsc.setHierarchicalDocumentSymbolSupport(Boolean.valueOf(true));
        dsc.setSymbolKind(new SymbolKindCapabilities(Arrays.asList(SymbolKind.values())));
        tdcc.setDocumentSymbol(dsc);
        tdcc.setSemanticTokens(new SemanticTokensCapabilities(new SemanticTokensClientCapabilitiesRequests(Boolean.valueOf(true)), KNOWN_TOKEN_TYPES, KNOWN_TOKEN_MODIFIERS, Arrays.asList(new String[0])));
        WorkspaceClientCapabilities wcc = new WorkspaceClientCapabilities();
        wcc.setWorkspaceEdit(new WorkspaceEditCapabilities());
        wcc.getWorkspaceEdit().setDocumentChanges(Boolean.valueOf(true));
        wcc.getWorkspaceEdit().setResourceOperations(Arrays.asList("create", "delete", "rename"));
        SymbolCapabilities sc = new SymbolCapabilities(new SymbolKindCapabilities(Arrays.asList(SymbolKind.values())));
        wcc.setSymbol(sc);
        PublishDiagnosticsCapabilities publishDiagnostics = new PublishDiagnosticsCapabilities();
        tdcc.setPublishDiagnostics(publishDiagnostics);
        initParams.setCapabilities(new ClientCapabilities(wcc, tdcc, null));
        CompletableFuture initResult = server.initialize(initParams);
        while (true) {
            try {
                return (InitializeResult)initResult.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                if (p == null || p.isAlive()) continue;
                InitializeResult emptyResult = new InitializeResult();
                emptyResult.setCapabilities(new ServerCapabilities());
                return emptyResult;
            }
            break;
        }
    }

    public static synchronized Set<LSPBindings> getAllBindings() {
        Set<LSPBindings> allBindings = Collections.newSetFromMap(new IdentityHashMap());
        project2MimeType2Server.values().stream().flatMap(n -> n.values().stream()).map(description -> description.bindings != null ? description.bindings.get() : null).filter(binding -> binding != null).forEach(allBindings::add);
        workspace2Extension2Server.values().stream().flatMap(n -> n.values().stream()).forEach(allBindings::add);
        return allBindings;
    }

    private LSPBindings(LanguageServer server, InitializeResult initResult, Process process) {
        this.server = server;
        this.initResult = initResult;
        this.process = process;
    }

    public TextDocumentService getTextDocumentService() {
        return this.server.getTextDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        return this.server.getWorkspaceService();
    }

    public InitializeResult getInitResult() {
        return this.initResult;
    }

    public static synchronized void addBackgroundTask(FileObject file, BackgroundTask task) {
        RequestProcessor.Task req = WORKER.create(() -> {
            LSPBindings bindings = LSPBindings.getBindings(file);
            if (bindings == null) {
                return;
            }
            task.run(bindings, file);
        });
        backgroundTasks.computeIfAbsent(file, f -> new LinkedHashMap()).put(task, req);
        LSPBindings.scheduleBackgroundTask(req);
    }

    public static synchronized void removeBackgroundTask(FileObject file, BackgroundTask task) {
        RequestProcessor.Task req = LSPBindings.backgroundTasksMapFor(file).remove(task);
        if (req != null) {
            req.cancel();
        }
    }

    public static void addChangeListener(ChangeListener l) {
        cs.addChangeListener(WeakListeners.change((ChangeListener)l, (Object)cs));
    }

    public void runOnBackground(Runnable r) {
        WORKER.post(r);
    }

    private static void scheduleBackgroundTask(RequestProcessor.Task req) {
        req.schedule(500);
    }

    public static synchronized void rescheduleBackgroundTask(FileObject file, BackgroundTask task) {
        RequestProcessor.Task req = LSPBindings.backgroundTasksMapFor(file).get(task);
        if (req != null) {
            LSPBindings.scheduleBackgroundTask(req);
        }
    }

    public static synchronized void scheduleBackgroundTasks(FileObject file) {
        LSPBindings.backgroundTasksMapFor(file).values().stream().forEach(LSPBindings::scheduleBackgroundTask);
    }

    private static Map<BackgroundTask, RequestProcessor.Task> backgroundTasksMapFor(FileObject file) {
        return backgroundTasks.computeIfAbsent(file, f -> new IdentityHashMap());
    }

    public Set<FileObject> getOpenedFiles() {
        return this.openedFiles;
    }

    static {
        Preconditions.enableNullChecks((boolean)false);
        WORKER.scheduleAtFixedRate(() -> {
            Class<LSPBindings> clazz = LSPBindings.class;
            synchronized (LSPBindings.class) {
                long tooOld = System.currentTimeMillis() - 600000L;
                Iterator<Map.Entry<LSPBindings, Long>> iterator = lspKeepAlive.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<LSPBindings, Long> entry = iterator.next();
                    if (entry.getValue() >= tooOld) continue;
                    iterator.remove();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }, (long)Math.max(5, 1), (long)Math.max(5, 1), TimeUnit.MINUTES);
        backgroundTasks = new WeakHashMap<FileObject, Map<BackgroundTask, RequestProcessor.Task>>();
        KNOWN_TOKEN_TYPES = Collections.unmodifiableList(Arrays.asList("namespace", "package", "function", "method", "macro", "parameter", "variable", "struct", "enum", "class", "typeAlias", "typeParameter", "field", "enumMember", "keyword"));
        KNOWN_TOKEN_MODIFIERS = Collections.unmodifiableList(Arrays.asList("static", "definition", "declaration"));
    }

    private static class ServerDescription {
        public long lastStartTimeStamp;
        public int failedCount;
        public Reference<LSPBindings> bindings;
        public Set<String> mimeTypes;

        private ServerDescription() {
        }
    }

    private static class LSPReference
    extends WeakReference<LSPBindings>
    implements Runnable {
        private final LanguageServer server;
        private final Process process;

        public LSPReference(LSPBindings t, ReferenceQueue<? super LSPBindings> rq) {
            super(t, rq);
            this.server = t.server;
            this.process = t.process;
        }

        @Override
        public void run() {
            if (!this.process.isAlive()) {
                return;
            }
            CompletableFuture shutdownResult = this.server.shutdown();
            for (int i = 0; i < 300; --i) {
                try {
                    shutdownResult.get(100L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                catch (InterruptedException | ExecutionException ex) {
                    break;
                }
            }
            this.server.exit();
            try {
                if (!this.process.waitFor(30L, TimeUnit.SECONDS)) {
                    this.process.destroy();
                }
            }
            catch (InterruptedException ex) {
                this.process.destroy();
            }
        }
    }

    public static interface BackgroundTask {
        public void run(LSPBindings var1, FileObject var2);
    }

    public static class Cleanup
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<LSPBindings> clazz = LSPBindings.class;
            synchronized (LSPBindings.class) {
                for (Map<String, ServerDescription> map : project2MimeType2Server.values()) {
                    for (ServerDescription serverDescription : map.values()) {
                        LSPBindings b = serverDescription.bindings != null ? serverDescription.bindings.get() : null;
                        if (b == null || b.process == null) continue;
                        b.process.destroy();
                    }
                }
                for (Map<String, Object> map : workspace2Extension2Server.values()) {
                    for (LSPBindings lSPBindings : map.values()) {
                        if (lSPBindings == null || lSPBindings.process == null) continue;
                        lSPBindings.process.destroy();
                    }
                }
                // ** MonitorExit[clazz] (shouldn't be in output)
                return;
            }
        }
    }
}

