/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class MarkOccurrences
implements LSPBindings.BackgroundTask,
CaretListener,
PropertyChangeListener {
    private static final RequestProcessor WORKER = new RequestProcessor(MarkOccurrences.class.getName(), 1, false, false);
    private final JTextComponent component;
    private Document doc;
    private int caretPos;

    public MarkOccurrences(JTextComponent component) {
        this.component = component;
        component.addCaretListener(this);
        component.addPropertyChangeListener(this);
        this.doc = component.getDocument();
        this.caretPos = component.getCaretPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(LSPBindings bindings, FileObject file) {
        int caretPos;
        Document doc;
        MarkOccurrences markOccurrences = this;
        synchronized (markOccurrences) {
            doc = this.doc;
            caretPos = this.caretPos;
        }
        MarkOccurrences.getHighlightsBag(doc).setHighlights(this.computeHighlights(doc, caretPos));
    }

    private OffsetsBag computeHighlights(Document doc, int caretPos) {
        AttributeSet attr = this.getColoring(doc);
        OffsetsBag result = new OffsetsBag(doc);
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return result;
        }
        LSPBindings server = LSPBindings.getBindings(file);
        if (server == null) {
            return result;
        }
        Boolean hasDocumentHighlight = server.getInitResult().getCapabilities().getDocumentHighlightProvider();
        if (hasDocumentHighlight == null || !hasDocumentHighlight.booleanValue()) {
            return result;
        }
        String uri = Utils.toURI(file);
        try {
            List highlights = (List)server.getTextDocumentService().documentHighlight(new DocumentHighlightParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, caretPos))).get();
            for (DocumentHighlight h : highlights) {
                result.addHighlight(Utils.getOffset(doc, h.getRange().getStart()), Utils.getOffset(doc, h.getRange().getEnd()), attr);
            }
            return result;
        }
        catch (InterruptedException | ExecutionException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return result;
        }
    }

    private AttributeSet getColoring(Document doc) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)NbEditorUtilities.getMimeType((Document)doc)).lookup(FontColorSettings.class);
        if (fcs == null) {
            return AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[0]);
        }
        assert (fcs != null);
        return fcs.getTokenFontColors("mark-occurrences");
    }

    @Override
    public synchronized void caretUpdate(CaretEvent e) {
        this.caretPos = e.getDot();
        WORKER.post(() -> {
            FileObject file = NbEditorUtilities.getFileObject((Document)this.doc);
            if (file != null) {
                LSPBindings.rescheduleBackgroundTask(file, this);
            }
        });
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "document".equals(evt.getPropertyName())) {
            this.doc = this.component.getDocument();
        }
    }

    static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MarkOccurrences.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, false);
            doc.putProperty(MarkOccurrences.class, bag);
            Object stream = doc.getProperty("stream");
            final OffsetsBag bagFin = bag;
            DocumentListener l = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(l);
            if (stream instanceof DataObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "LSP Client MarkOccurrences Highlights Bag", new Object[]{((DataObject)stream).getPrimaryFile(), bag});
                Logger.getLogger("TIMER").log(Level.FINE, "LSP Client MarkOccurrences Highlights Bag Listener", new Object[]{((DataObject)stream).getPrimaryFile(), l});
            }
        }
        return bag;
    }

    public static class HighlightsLayerFactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)MarkOccurrences.class.getName(), (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(20), (boolean)true, (HighlightsContainer)MarkOccurrences.getHighlightsBag(context.getDocument()))};
        }
    }
}

