/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class HyperlinkProviderImpl
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        if (doc.getProperty(HyperlinkProviderImpl.class) != Boolean.TRUE) {
            return null;
        }
        try {
            return Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)doc), (int)offset);
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        if (file == null) {
            return;
        }
        LSPBindings server = LSPBindings.getBindings(file);
        if (server == null) {
            return;
        }
        String uri = Utils.toURI(file);
        try {
            TextDocumentPositionParams params = new TextDocumentPositionParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, offset));
            CompletableFuture def = server.getTextDocumentService().definition(params);
            ((CompletableFuture)def.handleAsync((locations, exception) -> {
                Range targetRange;
                String targetUri;
                if (exception != null) {
                    exception.printStackTrace();
                }
                if (locations == null) {
                    return null;
                }
                if (locations.isLeft() && ((List)locations.getLeft()).size() == 1) {
                    targetUri = ((Location)((List)locations.getLeft()).get(0)).getUri();
                    targetRange = ((Location)((List)locations.getLeft()).get(0)).getRange();
                } else if (locations.isRight() && ((List)locations.getRight()).size() == 1) {
                    targetUri = ((LocationLink)((List)locations.getRight()).get(0)).getTargetUri();
                    targetRange = ((LocationLink)((List)locations.getRight()).get(0)).getTargetRange();
                } else {
                    return null;
                }
                try {
                    URI target = URI.create(targetUri);
                    FileObject targetFile = URLMapper.findFileObject((URL)target.toURL());
                    if (targetFile != null) {
                        LineCookie lc = (LineCookie)targetFile.getLookup().lookup(LineCookie.class);
                        Line line = lc.getLineSet().getCurrent(targetRange.getStart().getLine());
                        SwingUtilities.invokeLater(() -> line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, targetRange.getStart().getCharacter()));
                    }
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return null;
            })).get();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return null;
    }
}

