/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;

public class DatabaseContext
extends DatabaseItem {
    private DatabaseContext parent;
    private String type;
    private List<DatabaseUsage> usages;
    private List<DatabaseContext> contexts;
    private List<DatabaseDefinition> definitions;
    private boolean usagesSorted = false;
    private boolean contextsSorted = false;
    private boolean definitionsSorted = false;
    private DatabaseDefinition enclosingDefinition;
    private List<DatabaseDefinition> definitionsCache;

    public DatabaseContext(DatabaseContext parent, String type, int offset, int endOffset) {
        super(offset, endOffset);
        this.parent = parent;
        this.type = type;
    }

    protected void setParent(DatabaseContext parent) {
        this.parent = parent;
    }

    public DatabaseContext getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public void setEnclosingDefinition(DatabaseDefinition enclosingDefinition) {
        this.enclosingDefinition = enclosingDefinition;
    }

    public DatabaseDefinition getEnclosingDefinition() {
        if (this.enclosingDefinition != null) {
            return this.enclosingDefinition;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingDefinition();
        }
        return null;
    }

    public void addDefinition(DatabaseDefinition definition) {
        this.definitionsCache = null;
        if (this.definitions == null) {
            this.definitions = new ArrayList<DatabaseDefinition>();
        }
        this.definitions.add(definition);
        this.definitionsSorted = false;
    }

    public void addUsage(DatabaseUsage usage) {
        if (this.usages == null) {
            this.usages = new ArrayList<DatabaseUsage>();
        }
        this.usages.add(usage);
        this.usagesSorted = false;
    }

    public void addUsage(ASTToken item, DatabaseDefinition definition) {
        DatabaseUsage usage = new DatabaseUsage("", item.getOffset(), item.getEndOffset());
        definition.addUsage(usage);
        usage.setDatabaseDefinition(definition);
        this.addUsage(usage);
    }

    public void addContext(ASTItem item, DatabaseContext context) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<DatabaseContext>();
        }
        this.contexts.add(context);
        this.contextsSorted = false;
    }

    private void addItem(DatabaseItem databaseItem) {
        if (databaseItem instanceof DatabaseUsage) {
            this.addUsage((DatabaseUsage)databaseItem);
        } else if (databaseItem instanceof DatabaseDefinition) {
            this.addDefinition((DatabaseDefinition)databaseItem);
        } else if (databaseItem instanceof DatabaseContext) {
            this.addContext(null, (DatabaseContext)databaseItem);
        }
    }

    public List<DatabaseDefinition> getDefinitions() {
        if (this.definitionsCache == null) {
            if (this.definitions == null) {
                this.definitionsCache = Collections.emptyList();
            } else {
                this.definitionsCache = new ArrayList<DatabaseDefinition>();
                Iterator<DatabaseDefinition> it = this.definitions.iterator();
                while (it.hasNext()) {
                    this.definitionsCache.add(it.next());
                }
            }
        }
        return this.definitionsCache;
    }

    public List<DatabaseDefinition> getAllVisibleDefinitions(int offset) {
        HashMap<String, DatabaseDefinition> map = new HashMap<String, DatabaseDefinition>();
        this.addDefinitions(map, offset);
        return new ArrayList<DatabaseDefinition>(map.values());
    }

    private void addDefinitions(Map<String, DatabaseDefinition> map, int offset) {
        if (this.definitions != null) {
            for (DatabaseDefinition definition : this.definitions) {
                map.put(definition.getName(), definition);
            }
        }
        if (this.contexts != null) {
            for (DatabaseContext context : this.contexts) {
                if (context.getOffset() > offset || offset >= context.getEndOffset()) continue;
                context.addDefinitions(map, offset);
            }
        }
    }

    public DatabaseItem getDatabaseItem(int offset) {
        DatabaseItem middle;
        int mid;
        int high;
        int low;
        if (this.definitions != null) {
            if (!this.definitionsSorted) {
                Collections.sort(this.definitions, new ItemsComparator());
                this.definitionsSorted = true;
            }
            low = 0;
            high = this.definitions.size() - 1;
            while (low <= high) {
                mid = low + high >> 1;
                middle = this.definitions.get(mid);
                if (offset < middle.getOffset()) {
                    high = mid - 1;
                    continue;
                }
                if (offset >= middle.getEndOffset()) {
                    low = mid + 1;
                    continue;
                }
                return middle;
            }
        }
        if (this.usages != null) {
            if (!this.usagesSorted) {
                Collections.sort(this.usages, new ItemsComparator());
                this.usagesSorted = true;
            }
            low = 0;
            high = this.usages.size() - 1;
            while (low <= high) {
                mid = low + high >> 1;
                middle = this.usages.get(mid);
                if (offset < middle.getOffset()) {
                    high = mid - 1;
                    continue;
                }
                if (offset >= middle.getEndOffset()) {
                    low = mid + 1;
                    continue;
                }
                return middle;
            }
        }
        if (this.contexts != null) {
            if (!this.contextsSorted) {
                Collections.sort(this.contexts, new ItemsComparator());
                this.contextsSorted = true;
            }
            low = 0;
            high = this.contexts.size() - 1;
            while (low <= high) {
                mid = low + high >> 1;
                middle = this.contexts.get(mid);
                if (offset < middle.getOffset()) {
                    high = mid - 1;
                    continue;
                }
                if (offset >= middle.getEndOffset()) {
                    low = mid + 1;
                    continue;
                }
                return ((DatabaseContext)middle).getDatabaseItem(offset);
            }
        }
        return null;
    }

    public DatabaseContext getDatabaseContext(int offset) {
        if (this.contexts == null || this.contexts.isEmpty()) {
            return this;
        }
        if (!this.contextsSorted) {
            Collections.sort(this.contexts, new ItemsComparator());
        }
        this.contextsSorted = true;
        int low = 0;
        int high = this.contexts.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            DatabaseContext middle = this.contexts.get(mid);
            if (offset < middle.getOffset()) {
                high = mid - 1;
                continue;
            }
            if (offset >= middle.getEndOffset()) {
                low = mid + 1;
                continue;
            }
            DatabaseContext context = middle.getDatabaseContext(offset);
            if (context == null) {
                return middle;
            }
            return context;
        }
        return this;
    }

    public DatabaseDefinition getDefinition(String name, int offset) {
        if (this.definitions != null) {
            if (!this.definitionsSorted) {
                Collections.sort(this.definitions, new ItemsComparator());
            }
            this.definitionsSorted = true;
            for (DatabaseDefinition definition : this.definitions) {
                if (!definition.getName().equals(name)) continue;
                return definition;
            }
        }
        if (this.parent != null) {
            return this.parent.getDefinition(name, offset);
        }
        return null;
    }

    public List<DatabaseContext> getContexts() {
        if (this.contexts == null) {
            return Collections.emptyList();
        }
        return this.contexts;
    }

    public void addContext(DatabaseContext context) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<DatabaseContext>();
        }
        context.setParent(this);
        this.contexts.add(context);
    }

    public DatabaseContext getClosestContext(int offset) {
        DatabaseContext result = null;
        if (this.contexts != null) {
            for (DatabaseContext child : this.contexts) {
                if (!child.contains(offset)) continue;
                result = child.getClosestContext(offset);
                break;
            }
        }
        if (result != null) {
            return result;
        }
        if (this.contains(offset)) {
            return this;
        }
        return null;
    }

    private boolean contains(int offset) {
        return offset >= this.getOffset() && offset < this.getEndOffset();
    }

    public <T extends DatabaseDefinition> T getFirstDefinition(Class<T> clazz) {
        if (this.definitions == null) {
            return null;
        }
        for (DatabaseDefinition dfn : this.definitions) {
            if (!clazz.isInstance(dfn)) continue;
            return (T)dfn;
        }
        return null;
    }

    public <T extends DatabaseDefinition> Collection<T> getDefinitions(Class<T> clazz) {
        if (this.definitions == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseDefinition> result = new ArrayList<DatabaseDefinition>();
        for (DatabaseDefinition dfn : this.definitions) {
            if (!clazz.isInstance(dfn)) continue;
            result.add(dfn);
        }
        return result;
    }

    public void collectDefinitionsInScope(Collection<DatabaseDefinition> scopeDefinitions) {
        if (this.definitions != null) {
            scopeDefinitions.addAll(this.definitions);
        }
        if (this.parent != null) {
            this.parent.collectDefinitionsInScope(scopeDefinitions);
        }
    }

    public <T extends DatabaseDefinition> T getDefinitionInScopeByName(Class<T> clazz, String name) {
        DatabaseDefinition result = null;
        if (this.definitions != null) {
            for (DatabaseDefinition dfn : this.definitions) {
                if (!clazz.isInstance(dfn) || !name.equals(dfn.getName())) continue;
                result = dfn;
                break;
            }
        }
        if (result != null) {
            return (T)result;
        }
        if (this.parent != null) {
            return this.parent.getDefinitionInScopeByName(clazz, name);
        }
        return null;
    }

    public <T extends DatabaseDefinition> T getEnclosingDefinition(Class<T> clazz, int offset) {
        DatabaseContext context = this.getClosestContext(offset);
        return context.getEnclosingDefinitionRecursively(clazz);
    }

    public <T extends DatabaseDefinition> T getEnclosingDefinition(Class<T> clazz) {
        return this.getEnclosingDefinitionRecursively(clazz);
    }

    private <T extends DatabaseDefinition> T getEnclosingDefinitionRecursively(Class<T> clazz) {
        DatabaseDefinition result = this.getEnclosingDefinition();
        if (result != null && clazz.isInstance(result)) {
            return (T)result;
        }
        DatabaseContext parentCtx = this.getParent();
        if (parentCtx != null) {
            return parentCtx.getEnclosingDefinition(clazz);
        }
        return null;
    }

    public String toString() {
        return "Context " + this.getOffset() + "-" + this.getEndOffset();
    }

    private static class ItemsComparator
    implements Comparator<DatabaseItem> {
        private ItemsComparator() {
        }

        @Override
        public int compare(DatabaseItem o1, DatabaseItem o2) {
            return o1.getOffset() < o2.getOffset() ? -1 : 1;
        }
    }
}

