/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.io.IOException;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.dataobject.LanguagesDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public class LanguagesDataLoader
extends MultiFileLoader {
    private static final long serialVersionUID = 1L;

    public LanguagesDataLoader() {
        super("org.netbeans.modules.languages.dataobject.LanguagesDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(LanguagesDataLoader.class, (String)"LBL_mf_loader_name");
    }

    protected String actionsContext() {
        return "Loaders/Languages/Actions";
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        String mimeType = fo.getMIMEType();
        if (LanguagesManager.getDefault().createDataObjectFor(mimeType)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        String mimeType = primaryFile.getMIMEType();
        if (LanguagesManager.getDefault().createDataObjectFor(mimeType)) {
            return new LanguagesDataObject(primaryFile, this);
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new FileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new FileEntry(obj, secondaryFile);
    }

    public int getNBSFiles() {
        return 1;
    }
}

