/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class GoToDeclarationAction
extends BaseAction {
    public GoToDeclarationAction() {
        super(NbBundle.getBundle(GoToDeclarationAction.class).getString("LBL_GoToDeclaration"));
    }

    public void actionPerformed(ActionEvent e, JTextComponent component) {
        JTextComponent comp = this.getTextComponent(null);
        if (comp == null) {
            return;
        }
        ASTNode node = this.getASTNode(comp);
        if (node == null) {
            return;
        }
        NbEditorDocument doc = (NbEditorDocument)comp.getDocument();
        int position = comp.getCaretPosition();
        ASTPath path = node.findPath(position);
        DatabaseContext root = DatabaseManager.getRoot((ASTNode)path.getRoot());
        if (root == null) {
            return;
        }
        DatabaseItem item = root.getDatabaseItem(path.getLeaf().getOffset());
        if (item == null) {
            return;
        }
        if (item instanceof DatabaseUsage) {
            item = ((DatabaseUsage)item).getDefinition();
        }
        int offset = item.getOffset();
        DataObject dobj = null;
        Object docToGo = null;
        URL url = ((DatabaseDefinition)item).getSourceFileUrl();
        if (url == null) {
            dobj = NbEditorUtilities.getDataObject((Document)doc);
            docToGo = doc;
        } else {
            File file = null;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
            if (file != null && file.exists()) {
                file = FileUtil.normalizeFile((File)file);
                FileObject fobj = FileUtil.toFileObject((File)file);
                try {
                    dobj = DataObject.find((FileObject)fobj);
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
                if (dobj != null) {
                    Node nodeOfDobj = dobj.getNodeDelegate();
                    EditorCookie ec = (EditorCookie)nodeOfDobj.getCookie(EditorCookie.class);
                    try {
                        docToGo = ec.openDocument();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (dobj == null) {
            return;
        }
        LineCookie lc = (LineCookie)dobj.getCookie(LineCookie.class);
        Line.Set lineSet = lc.getLineSet();
        Line line = lineSet.getCurrent(NbDocument.findLineNumber((StyledDocument)docToGo, (int)offset));
        int column = NbDocument.findLineColumn((StyledDocument)docToGo, (int)offset);
        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
    }

    public boolean isEnabled() {
        JTextComponent comp = this.getTextComponent(null);
        if (comp == null) {
            return false;
        }
        ASTNode node = this.getASTNode(comp);
        if (node == null) {
            return false;
        }
        int position = comp.getCaretPosition();
        ASTPath path = node.findPath(position);
        if (path == null) {
            return false;
        }
        DatabaseContext root = DatabaseManager.getRoot((ASTNode)path.getRoot());
        if (root == null) {
            return false;
        }
        DatabaseItem item = root.getDatabaseItem(path.getLeaf().getOffset());
        return item != null;
    }

    private ASTNode getASTNode(JTextComponent comp) {
        return ParserManagerImpl.getImpl((Document)((NbEditorDocument)comp.getDocument())).getAST();
    }
}

