/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages.database;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;

public class DatabaseDefinition
extends DatabaseItem {
    private String name;
    private String type;
    private List<DatabaseUsage> usages;
    private URL sourceFileUrl;

    public DatabaseDefinition(String name, String type, int offset, int endOffset) {
        super(offset, endOffset);
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void addUsage(DatabaseUsage usage) {
        if (this.usages == null) {
            this.usages = new ArrayList<DatabaseUsage>();
        }
        this.usages.add(usage);
    }

    public List<DatabaseUsage> getUsages() {
        if (this.usages == null) {
            return Collections.emptyList();
        }
        return this.usages;
    }

    public void setSourceFileUrl(URL url) {
        this.sourceFileUrl = url;
    }

    public URL getSourceFileUrl() {
        return this.sourceFileUrl;
    }

    public String toString() {
        return "Definition " + this.getName() + " (" + this.getType() + ")";
    }

    public static DatabaseDefinition load(DataInputStream is) throws IOException {
        return new DatabaseDefinition(is.readUTF(), is.readUTF(), is.readInt(), is.readInt());
    }

    public void save(DataOutputStream os) throws IOException {
        os.writeUTF(this.name);
        os.writeUTF(this.type);
        os.writeInt(this.getOffset());
        os.writeInt(this.getEndOffset());
    }
}

