/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.Iterator;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class ToolTipAnnotation
extends Annotation {
    static final String TOOLTIP = "TOOLTIP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getShortDescription() {
        try {
            SyntaxError syntaxError;
            ASTItem item;
            Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
            if (lp == null) {
                return null;
            }
            Line line = lp.getLine();
            DataObject dob = DataEditorSupport.findDataObject((Line)line);
            EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
            NbEditorDocument document = (NbEditorDocument)ec.getDocument();
            String mimeType = (String)document.getProperty((Object)"mimeType");
            int offset = NbDocument.findLineOffset((StyledDocument)ec.getDocument(), (int)lp.getLine().getLineNumber()) + lp.getColumn();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            if (tokenHierarchy == null) {
                return null;
            }
            Language l = LanguagesManager.getDefault().getLanguage(mimeType);
            document.readLock();
            try {
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                if (tokenSequence == null) {
                    String string = null;
                    return string;
                }
                tokenSequence.move(offset);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    String string = null;
                    return string;
                }
                Token token = tokenSequence.token();
                Feature tooltip = l.getFeatureList().getFeature(TOOLTIP, token.id().name());
                if (tooltip != null) {
                    String s;
                    String string = s = ToolTipAnnotation.c((String)tooltip.getValue(Context.create((Document)document, offset)));
                    return string;
                }
            }
            finally {
                document.readUnlock();
            }
            ASTNode ast = null;
            ParserManagerImpl parserManager = ParserManagerImpl.getImpl((Document)document);
            if (parserManager == null) {
                return null;
            }
            ast = parserManager.getAST();
            if (ast == null) {
                return null;
            }
            ASTPath path = ast.findPath(offset);
            if (path == null) {
                return null;
            }
            int k = path.size();
            for (int i = 0; i < k; ++i) {
                ASTPath p = path.subPath(i);
                Feature tooltip = l.getFeatureList().getFeature(TOOLTIP, p);
                if (tooltip == null) continue;
                return ToolTipAnnotation.c((String)tooltip.getValue(SyntaxContext.create((Document)document, p)));
            }
            Iterator<SyntaxError> it = parserManager.getSyntaxErrors().iterator();
            do {
                if (!it.hasNext()) return null;
                syntaxError = it.next();
                item = syntaxError.getItem();
                if (item.getOffset() == ast.getEndOffset()) {
                    item = ast.findPath(item.getOffset() - 1).getLeaf();
                }
                if (item.getOffset() <= offset) continue;
                return null;
            } while (item.getEndOffset() <= offset);
            return syntaxError.getMessage();
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public String getAnnotationType() {
        return null;
    }

    private static String c(String s) {
        if (s == null) {
            return null;
        }
        s = s.replace("\\n", "\n");
        s = s.replace("\\r", "\r");
        s = s.replace("\\t", "\t");
        return s;
    }
}

