/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.ComputeDiff;
import org.netbeans.modules.java.source.save.Difference;

class DiffFacility {
    private final Collection<CasualDiff.Diff> gdiff;

    public DiffFacility(Collection<CasualDiff.Diff> diff) {
        this.gdiff = diff;
    }

    private static List<Line> getLines(String text) {
        char[] chars = text.toCharArray();
        ArrayList<Line> list = new ArrayList<Line>();
        int pointer = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            list.add(new Line(new String(chars, pointer, i - pointer + 1), pointer, i + 1));
            pointer = i + 1;
        }
        if (pointer < chars.length) {
            list.add(new Line(new String(chars, pointer, chars.length - pointer), pointer, chars.length));
        }
        return list;
    }

    public List<CasualDiff.Diff> makeListMatch(String text1, String text2, int offset) {
        List<Line> list1 = DiffFacility.getLines(text1);
        List<Line> list2 = DiffFacility.getLines(text2);
        Line[] lines1 = list1.toArray(new Line[list1.size()]);
        Line[] lines2 = list2.toArray(new Line[list2.size()]);
        List<Difference> diffs = new ComputeDiff<Line>(lines1, lines2).diff();
        for (Difference diff : diffs) {
            String match2;
            int i;
            StringBuilder builder;
            int type;
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            int n = delEnd != -1 && addEnd != -1 ? 99 : (type = delEnd == -1 ? 97 : 100);
            if (type == 97) {
                builder = new StringBuilder();
                for (i = addStart; i <= addEnd; ++i) {
                    builder.append(lines2[i].data);
                }
                this.gdiff.add(CasualDiff.Diff.insert(delEnd == -1 ? (delStart < lines1.length ? lines1[delStart].start + offset : (lines1.length != 0 ? lines1[lines1.length - 1].end + offset : offset)) : lines1[delEnd].end + offset, builder.toString()));
                continue;
            }
            if (type == 100) {
                this.gdiff.add(CasualDiff.Diff.delete(lines1[delStart].start + offset, lines1[delEnd].end + offset));
                continue;
            }
            if (addEnd - addStart > delEnd - delStart) {
                builder = new StringBuilder();
                for (i = delStart; i <= delEnd; ++i) {
                    builder.append(lines1[i].data);
                }
                String match1 = builder.toString();
                builder = new StringBuilder();
                for (int i2 = addStart; i2 <= addStart + delEnd - delStart; ++i2) {
                    builder.append(lines2[i2].data);
                }
                match2 = builder.toString();
                this.makeTokenListMatch(match1, match2, lines1[delStart].start + offset);
                builder = new StringBuilder();
                for (int i3 = addStart + delEnd - delStart + 1; i3 <= addEnd; ++i3) {
                    builder.append(lines2[i3].data);
                }
                String s = builder.toString();
                if ("".equals(s)) continue;
                this.gdiff.add(CasualDiff.Diff.insert(lines1[delEnd].end + offset, s));
                continue;
            }
            builder = new StringBuilder();
            for (i = delStart; i <= delEnd; ++i) {
                builder.append(lines1[i].data);
            }
            String match1 = builder.toString();
            builder = new StringBuilder();
            for (int i4 = addStart; i4 <= addEnd; ++i4) {
                builder.append(lines2[i4].data);
            }
            match2 = builder.toString();
            this.makeTokenListMatch(match1, match2, lines1[delStart].start + offset);
        }
        return null;
    }

    public List<CasualDiff.Diff> makeTokenListMatch(String text1, String text2, int currentPos) {
        TokenSequence seq1 = TokenHierarchy.create((CharSequence)text1, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        TokenSequence seq2 = TokenHierarchy.create((CharSequence)text2, (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
        ArrayList<Line> list1 = new ArrayList<Line>();
        ArrayList<Line> list2 = new ArrayList<Line>();
        JavaTokenId lastId1 = null;
        while (seq1.moveNext()) {
            String data = ((Object)seq1.token().text()).toString();
            lastId1 = (JavaTokenId)seq1.token().id();
            list1.add(new Line(data, seq1.offset(), seq1.offset() + data.length()));
        }
        JavaTokenId lastId2 = null;
        while (seq2.moveNext()) {
            String data = ((Object)seq2.token().text()).toString();
            lastId2 = (JavaTokenId)seq2.token().id();
            list2.add(new Line(data, seq2.offset(), seq2.offset() + data.length()));
        }
        if (lastId1 != null && lastId1 == lastId2 && (lastId1 == JavaTokenId.LINE_COMMENT || lastId1 == JavaTokenId.WHITESPACE && !(((Line)list1.get((int)(list1.size() - 1))).data.endsWith("\n") ^ ((Line)list2.get((int)(list2.size() - 1))).data.endsWith("\n")))) {
            list1.remove(list1.size() - 1);
            list2.remove(list2.size() - 1);
        }
        Line[] lines1 = list1.toArray(new Line[list1.size()]);
        Line[] lines2 = list2.toArray(new Line[list2.size()]);
        List<Difference> diffs = new ComputeDiff<Line>(lines1, lines2).diff();
        for (Difference diff : diffs) {
            int i;
            StringBuilder builder;
            int type;
            int delStart = diff.getDeletedStart();
            int delEnd = diff.getDeletedEnd();
            int addStart = diff.getAddedStart();
            int addEnd = diff.getAddedEnd();
            int n = delEnd != -1 && addEnd != -1 ? 99 : (type = delEnd == -1 ? 97 : 100);
            if (type == 97) {
                builder = new StringBuilder();
                for (i = addStart; i <= addEnd; ++i) {
                    builder.append(lines2[i].data);
                }
                this.gdiff.add(CasualDiff.Diff.insert(currentPos + (delEnd == -1 ? (delStart < lines1.length ? lines1[delStart].start : (lines1.length > 0 ? lines1[lines1.length - 1].end : 0)) : lines1[delEnd].end), builder.toString()));
                continue;
            }
            if (type == 100) {
                this.gdiff.add(CasualDiff.Diff.delete(currentPos + lines1[delStart].start, currentPos + lines1[delEnd].end));
                continue;
            }
            builder = new StringBuilder();
            this.gdiff.add(CasualDiff.Diff.delete(currentPos + lines1[delStart].start, currentPos + lines1[delEnd].end));
            for (i = addStart; i <= addEnd; ++i) {
                builder.append(lines2[i].data);
            }
            this.gdiff.add(CasualDiff.Diff.insert(currentPos + (delEnd == -1 ? lines1[delStart].start : lines1[delEnd].end), builder.toString()));
        }
        return null;
    }

    private static class Line {
        String data;
        int end;
        int start;

        Line(String data, int start, int end) {
            this.start = start;
            this.end = end;
            this.data = data;
        }

        public String toString() {
            return this.data.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Line) {
                return this.data.equals(((Line)o).data);
            }
            return false;
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

