/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchive;
import org.netbeans.modules.java.source.parsing.FileObjectArchive;
import org.netbeans.modules.java.source.parsing.FolderArchive;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class CachingArchiveProvider {
    private static CachingArchiveProvider instance;
    HashMap<URL, Archive> archives = new HashMap();

    public static synchronized CachingArchiveProvider getDefault() {
        if (instance == null) {
            instance = new CachingArchiveProvider();
        }
        return instance;
    }

    CachingArchiveProvider() {
    }

    public synchronized Archive getArchive(URL root, boolean cacheFile) {
        Archive archive = this.archives.get(root);
        if (archive == null && (archive = CachingArchiveProvider.create(root, cacheFile)) != null) {
            this.archives.put(root, archive);
        }
        return archive;
    }

    public synchronized Iterable<Archive> getArchives(URL[] roots, boolean cacheFile) {
        ArrayList<Archive> archives = new ArrayList<Archive>(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            Archive a = this.getArchive(roots[i], cacheFile);
            if (a == null) continue;
            archives.add(a);
        }
        return archives;
    }

    public synchronized Iterable<Archive> getArchives(ClassPath cp, boolean cacheFile) {
        List entries = cp.entries();
        ArrayList<Archive> archives = new ArrayList<Archive>(entries.size());
        for (ClassPath.Entry entry : entries) {
            Archive a = this.getArchive(entry.getURL(), cacheFile);
            if (a == null) continue;
            archives.add(a);
        }
        return archives;
    }

    public synchronized void removeArchive(URL root) {
        Archive archive = this.archives.remove(root);
        if (archive != null) {
            archive.clear();
        }
    }

    public synchronized void clearArchive(URL root) {
        Archive archive = this.archives.get(root);
        if (archive != null) {
            archive.clear();
        }
    }

    private static Archive create(URL root, boolean cacheFile) {
        URL inner;
        String protocol = root.getProtocol();
        if ("file".equals(protocol)) {
            File f = Utilities.toFile((URI)URI.create(root.toExternalForm()));
            if (f.isDirectory()) {
                return new FolderArchive(f);
            }
            return null;
        }
        if ("jar".equals(protocol) && "file".equals(protocol = (inner = FileUtil.getArchiveFile((URL)root)).getProtocol())) {
            File f = Utilities.toFile((URI)URI.create(inner.toExternalForm()));
            if (f.isFile()) {
                return new CachingArchive(f, cacheFile);
            }
            return null;
        }
        FileObject fo = URLMapper.findFileObject((URL)root);
        if (fo != null) {
            return new FileObjectArchive(fo);
        }
        return null;
    }

    void clear() {
        this.archives.clear();
    }
}

