/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.spi.java.loaders.RenameHandler;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class JavaNode
extends DataNode
implements ChangeListener {
    private static final String EXECUTABLE_BADGE_URL = "org/netbeans/modules/java/resources/executable-badge.png";
    private static final String NEEDS_COMPILE_BADGE_URL = "org/netbeans/modules/java/resources/needs-compile.png";
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String JAVA_ICON_BASE = "org/netbeans/modules/java/resources/class.png";
    private static final String CLASS_ICON_BASE = "org/netbeans/modules/java/resources/clazz.gif";
    private static final Image NEEDS_COMPILE;
    private static final Image IS_EXECUTABLE_CLASS;
    private static final Logger LOG;
    private FileBuiltQuery.Status status;
    private final AtomicBoolean isCompiled;
    private ChangeListener executableListener;
    private final AtomicBoolean isExecutable;
    private Node.PropertySet[] propertySets;
    private static final RequestProcessor WORKER;

    public JavaNode(final DataObject jdo, boolean isJavaSource) {
        super(jdo, Children.LEAF);
        this.setIconBaseWithExtension(isJavaSource ? JAVA_ICON_BASE : CLASS_ICON_BASE);
        Logger.getLogger("TIMER").log(Level.FINE, "JavaNode", new Object[]{jdo.getPrimaryFile(), this});
        if (isJavaSource) {
            this.isCompiled = new AtomicBoolean(true);
            WORKER.post((Runnable)new BuildStatusTask(this));
            this.isExecutable = new AtomicBoolean(false);
            WORKER.post((Runnable)new ExecutableTask(this));
            jdo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("primaryFile".equals(evt.getPropertyName())) {
                        Logger.getLogger("TIMER").log(Level.FINE, "JavaNode", new Object[]{jdo.getPrimaryFile(), this});
                        WORKER.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                JavaNode javaNode = JavaNode.this;
                                synchronized (javaNode) {
                                    JavaNode.this.status = null;
                                    JavaNode.this.executableListener = null;
                                    WORKER.post((Runnable)new BuildStatusTask(JavaNode.this));
                                    WORKER.post((Runnable)new ExecutableTask(JavaNode.this));
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.isCompiled = null;
            this.isExecutable = null;
        }
    }

    public void setName(String name) {
        RenameHandler handler = JavaNode.getRenameHandler();
        if (handler == null) {
            super.setName(name);
        } else {
            try {
                handler.handleRename((Node)this, name);
            }
            catch (IllegalArgumentException ioe) {
                super.setName(name);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Collection handlers = Lookup.getDefault().lookupAll(RenameHandler.class);
        if (handlers.size() == 0) {
            return null;
        }
        if (handlers.size() > 1) {
            LOG.warning("Multiple instances of RenameHandler found in Lookup; only using first one: " + handlers);
        }
        return (RenameHandler)handlers.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node.PropertySet[] getPropertySets() {
        this.getSheet();
        JavaNode javaNode = this;
        synchronized (javaNode) {
            return Arrays.copyOf(this.propertySets, this.propertySets.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set ps = new Sheet.Set();
        ps.setName("classpaths");
        ps.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        ps.setShortDescription(NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        ps.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(ps);
        Node.PropertySet[] propertySets = sheet.toArray();
        JavaNode javaNode = this;
        synchronized (javaNode) {
            this.propertySets = propertySets;
        }
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite<String> p = new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(DataObject.class, (String)"PROP_name"), NbBundle.getMessage(DataObject.class, (String)"HINT_name")){

            public String getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String key) {
                if ("suppressCustomEditor".equals(key)) {
                    return Boolean.TRUE;
                }
                return super.getValue(key);
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                JavaNode.this.setName(val);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return p;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        WORKER.post((Runnable)new BuildStatusTask(this));
    }

    public Image getIcon(int type) {
        Image i = super.getIcon(type);
        return this.enhanceIcon(i);
    }

    public Image getOpenedIcon(int type) {
        Image i = super.getOpenedIcon(type);
        return this.enhanceIcon(i);
    }

    private Image enhanceIcon(Image i) {
        if (this.isCompiled != null && !this.isCompiled.get()) {
            i = ImageUtilities.mergeImages((Image)i, (Image)NEEDS_COMPILE, (int)16, (int)0);
        }
        if (this.isExecutable != null && this.isExecutable.get()) {
            i = ImageUtilities.mergeImages((Image)i, (Image)IS_EXECUTABLE_CLASS, (int)10, (int)6);
        }
        return i;
    }

    static {
        LOG = Logger.getLogger(JavaNode.class.getName());
        URL needsCompileIconURL = JavaNode.class.getClassLoader().getResource(NEEDS_COMPILE_BADGE_URL);
        String needsCompileTP = "<img src=\"" + needsCompileIconURL + "\">&nbsp;" + NbBundle.getMessage(JavaNode.class, (String)"TP_NeedsCompileBadge");
        NEEDS_COMPILE = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)NEEDS_COMPILE_BADGE_URL), (String)needsCompileTP);
        URL executableIconURL = JavaNode.class.getClassLoader().getResource(EXECUTABLE_BADGE_URL);
        String executableTP = "<img src=\"" + executableIconURL + "\">&nbsp;" + NbBundle.getMessage(JavaNode.class, (String)"TP_ExecutableBadge");
        IS_EXECUTABLE_CLASS = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)EXECUTABLE_BADGE_URL), (String)executableTP);
        WORKER = new RequestProcessor("Java Node Badge Processor", 1);
    }

    private static class ExecutableTask
    implements Runnable {
        private final JavaNode node;

        public ExecutableTask(JavaNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassPath cp;
            FileObject root;
            ChangeListener _executableListener;
            JavaNode javaNode = this.node;
            synchronized (javaNode) {
                _executableListener = this.node.executableListener;
            }
            FileObject file = this.node.getDataObject().getPrimaryFile();
            if (_executableListener == null) {
                _executableListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        WORKER.post((Runnable)new ExecutableTask(ExecutableTask.this.node));
                    }
                };
                try {
                    ExecutableFilesIndex.DEFAULT.addChangeListener(file.getURL(), _executableListener);
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                JavaNode ex = this.node;
                synchronized (ex) {
                    if (this.node.executableListener == null) {
                        this.node.executableListener = _executableListener;
                    }
                }
            }
            FileObject fileObject = root = (cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source")) != null ? cp.findOwnerRoot(file) : null;
            if (root != null) {
                try {
                    boolean newIsExecutable = ExecutableFilesIndex.DEFAULT.isMainClass(root.getURL(), file.getURL());
                    boolean oldIsExecutable = this.node.isExecutable.getAndSet(newIsExecutable);
                    if (newIsExecutable != oldIsExecutable) {
                        this.node.fireIconChange();
                        this.node.fireOpenedIconChange();
                    }
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class BuildStatusTask
    implements Runnable {
        private JavaNode node;

        public BuildStatusTask(JavaNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean oldIsCompiled;
            FileBuiltQuery.Status _status = null;
            JavaNode javaNode = this.node;
            synchronized (javaNode) {
                _status = this.node.status;
            }
            if (_status == null) {
                FileObject jf = this.node.getDataObject().getPrimaryFile();
                _status = FileBuiltQuery.getStatus((FileObject)jf);
                JavaNode javaNode2 = this.node;
                synchronized (javaNode2) {
                    if (_status != null && this.node.status == null) {
                        this.node.status = _status;
                        this.node.status.addChangeListener(WeakListeners.change((ChangeListener)this.node, (Object)this.node.status));
                    }
                }
            }
            boolean isPackageInfo = "package-info.java".equals(this.node.getDataObject().getPrimaryFile().getNameExt());
            boolean newIsCompiled = _status != null && !isPackageInfo ? _status.isBuilt() : true;
            if (newIsCompiled != (oldIsCompiled = this.node.isCompiled.getAndSet(newIsCompiled))) {
                this.node.fireIconChange();
                this.node.fireOpenedIconChange();
            }
        }
    }

    private final class ClasspathProperty
    extends PropertySupport.ReadOnly<String> {
        private final String id;

        public ClasspathProperty(String id, String displayName, String shortDescription) {
            super(id, String.class, displayName, shortDescription);
            this.id = id;
            this.setValue("oneline", false);
        }

        public String getValue() {
            ClassPath cp = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (cp != null) {
                StringBuffer sb = new StringBuffer();
                for (ClassPath.Entry entry : cp.entries()) {
                    URL u = entry.getURL();
                    String item = u.toExternalForm();
                    if (u.getProtocol().equals("file")) {
                        item = Utilities.toFile((URI)URI.create(item)).getAbsolutePath();
                    } else if (u.getProtocol().equals("jar") && item.endsWith("!/")) {
                        URL embedded = FileUtil.getArchiveFile((URL)u);
                        assert (embedded != null) : u;
                        if (embedded.getProtocol().equals("file")) {
                            item = Utilities.toFile((URI)URI.create(embedded.toExternalForm())).getAbsolutePath();
                        }
                    }
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(item);
                }
                return sb.toString();
            }
            return NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_classpath_unknown");
        }
    }
}

