/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.HiddenTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.pretty.CharBuffer;
import org.netbeans.modules.java.source.pretty.DanglingElseChecker;
import org.netbeans.modules.java.source.pretty.TrimBufferObserver;
import org.netbeans.modules.java.source.pretty.WidthEstimator;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.save.Reformatter;
import org.netbeans.modules.java.source.transform.FieldGroupTree;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;

public final class VeryPretty
extends JCTree.Visitor
implements DocTreeVisitor<Void, Void>,
TrimBufferObserver {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    private static final String REPLACEMENT = "%[a-z]*%";
    private static final String ERROR = "<error>";
    private final CodeStyle cs;
    public final CharBuffer out;
    private final Names names;
    private final CommentHandler commentHandler;
    private final Operators operators;
    private final WidthEstimator widthEstimator;
    private final DanglingElseChecker danglingElseChecker;
    public boolean suppressVariableType;
    public JCTree.JCClassDecl enclClass;
    private int indentSize;
    private int prec;
    private boolean printingMethodParams;
    private DiffContext diffContext;
    private CommentHandlerService comments;
    private int fromOffset = -1;
    private int toOffset = -1;
    private boolean insideAnnotation = false;
    private final Map<Tree, ?> tree2Tag;
    private final Map<Tree, DocCommentTree> tree2Doc;
    private final Map<Object, int[]> tag2Span;
    private final String origText;
    private int initialOffset = 0;
    private Map<JCTree, Integer> overrideStartPositions;
    public Set<Tree> oldTrees = Collections.emptySet();
    public SortedSet<int[]> reindentRegions = new TreeSet<int[]>(new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            return o1[0] - o2[0];
        }
    });
    private boolean commentsEnabled;
    private final Set<Tree> trailingCommentsHandled = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Tree> innerCommentsHandled = Collections.newSetFromMap(new IdentityHashMap());
    private static final Logger LOG = Logger.getLogger(CasualDiff.class.getName());
    public static final String ANNOTATIONS = "%annotations%";
    public static final String NAME = "%name%";
    public static final String TYPE = "%type%";
    public static final String THROWS = "%throws%";
    public static final String IMPLEMENTS = "%implements%";
    public static final String EXTENDS = "%extends%";
    public static final String TYPEPARAMETERS = "%typeparameters%";
    public static final String FLAGS = "%flags%";
    public static final String PARAMETERS = "%parameters%";
    private static final String[] typeTagNames = new String[TypeTag.values().length];
    private boolean reallyPrintAnnotations;
    private static final String[] flagLowerCaseNames;
    public int conditionStartHack = -1;
    private Set<Tree> precedingCommentsHandled = new HashSet<Tree>();

    public VeryPretty(DiffContext diffContext) {
        this(diffContext, diffContext.style, null, null, null, null);
    }

    public VeryPretty(DiffContext diffContext, CodeStyle cs) {
        this(diffContext, cs, null, null, null, null);
    }

    public VeryPretty(DiffContext diffContext, CodeStyle cs, Map<Tree, ?> tree2Tag, Map<Tree, DocCommentTree> tree2Doc, Map<?, int[]> tag2Span, String origText) {
        this(diffContext.context, cs, tree2Tag, tree2Doc, tag2Span, origText);
        this.diffContext = diffContext;
    }

    public VeryPretty(DiffContext diffContext, CodeStyle cs, Map<Tree, ?> tree2Tag, Map<Tree, DocCommentTree> tree2Doc, Map<?, int[]> tag2Span, String origText, int initialOffset) {
        this(diffContext, cs, tree2Tag, tree2Doc, tag2Span, origText);
        this.initialOffset = initialOffset;
    }

    private VeryPretty(Context context, CodeStyle cs, Map<Tree, ?> tree2Tag, Map<Tree, DocCommentTree> tree2Doc, Map<?, int[]> tag2Span, String origText) {
        this.names = Names.instance(context);
        this.enclClass = null;
        this.commentHandler = CommentHandlerService.instance(context);
        this.operators = Operators.instance(context);
        this.widthEstimator = new WidthEstimator(context);
        this.danglingElseChecker = new DanglingElseChecker();
        this.prec = -1;
        this.cs = cs;
        this.out = new CharBuffer(cs.getRightMargin(), cs.getTabSize(), cs.expandTabToSpaces());
        this.out.addTrimObserver(this);
        this.indentSize = cs.getIndentSize();
        this.tree2Tag = tree2Tag;
        this.tree2Doc = tree2Doc == null ? Collections.emptyMap() : tree2Doc;
        this.tag2Span = tag2Span;
        this.origText = origText;
        this.comments = CommentHandlerService.instance(context);
    }

    public void setInitialOffset(int offset) {
        this.initialOffset = offset < 0 ? 0 : offset;
    }

    public int getInitialOffset() {
        return this.initialOffset;
    }

    public String toString() {
        return this.out.toString();
    }

    public void toLeftMargin() {
        this.out.toLeftMargin();
    }

    public void reset(int margin, int col) {
        this.out.setLength(0);
        this.out.leftMargin = margin;
        this.out.col = col;
    }

    public int getIndent() {
        return this.out.leftMargin;
    }

    public void setIndent(int indent) {
        this.out.leftMargin = indent;
    }

    public int indent() {
        int old = this.out.leftMargin;
        this.out.leftMargin = old + this.indentSize;
        return old;
    }

    public void undent(int old) {
        this.out.leftMargin = old;
    }

    public void newline() {
        this.out.nlTerm();
    }

    private void newLineNoTrim() {
        this.out.nlTermNoTrim();
    }

    public void blankline() {
        this.out.blanklines(1);
    }

    public int setPrec(int prec) {
        int old = this.prec;
        this.prec = prec;
        return old;
    }

    public final void print(String s) {
        if (s == null) {
            return;
        }
        this.out.append(s);
    }

    public final void print(Name n) {
        if (n == null) {
            return;
        }
        this.out.appendUtf8(n.getByteArray(), n.getByteOffset(), n.getByteLength());
    }

    private void print(javax.lang.model.element.Name n) {
        if (n == null) {
            return;
        }
        this.print(n.toString());
    }

    public void print(JCTree t) {
        if (t == null) {
            return;
        }
        this.blankLines(t, true);
        this.toLeftMargin();
        this.doAccept(t, true);
        this.blankLines(t, false);
    }

    public void print(DCTree t) {
        this.print(t, false);
    }

    public void print(DCTree t, boolean noMarginAfter) {
        if (t == null) {
            return;
        }
        this.blankLines(t, true, false);
        this.toLeftMargin();
        this.doAccept(t);
        this.blankLines(t, false, noMarginAfter);
    }

    private int getOldPos(JCTree oldT) {
        Integer i;
        if (this.overrideStartPositions != null && (i = this.overrideStartPositions.get(oldT)) != null) {
            return i;
        }
        return TreeInfo.getStartPos(oldT);
    }

    public int endPos(JCTree t) {
        return TreeInfo.getEndPos(t, this.diffContext.origUnit.endPositions);
    }

    private java.util.List<? extends StatementTree> getStatements(Tree tree) {
        switch (tree.getKind()) {
            case BLOCK: {
                return ((BlockTree)tree).getStatements();
            }
            case CASE: {
                return ((CaseTree)tree).getStatements();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private java.util.List<JCTree.JCVariableDecl> printOriginalPartOfFieldGroup(FieldGroupTree fgt) {
        Tree t;
        void var11_14;
        TreePath parent;
        java.util.List<JCTree.JCVariableDecl> variables = fgt.getVariables();
        TreePath tp = TreePath.getPath(this.diffContext.origUnit, (Tree)variables.get(0));
        TreePath treePath = parent = tp != null ? tp.getParentPath() : null;
        if (parent == null) {
            return variables;
        }
        java.util.List<? extends StatementTree> statements = this.getStatements(parent.getLeaf());
        if (statements == null) {
            return variables;
        }
        JCTree.JCVariableDecl firstDecl = fgt.getVariables().get(0);
        int startIndex = statements.indexOf(firstDecl);
        if (startIndex < 0) {
            return variables;
        }
        int origCount = 0;
        int s = statements.size();
        for (JCTree jCTree : variables) {
            if (startIndex >= s || statements.get(startIndex++) != jCTree) break;
            ++origCount;
        }
        if (origCount < 2) {
            return variables;
        }
        int firstPos = this.getOldPos(firstDecl);
        int n = startIndex;
        while (var11_14 > 0 && (t = (Tree)statements.get((int)(var11_14 - true))) instanceof JCTree.JCVariableDecl && this.getOldPos((JCTree.JCVariableDecl)t) == firstPos) {
            --var11_14;
        }
        int firstIdentStart = ((JCTree)((Object)statements.get((int)var11_14))).pos;
        if (var11_14 < startIndex) {
            this.copyToIndented(firstPos, firstIdentStart);
            IdentityHashMap<JCTree, Integer> m = new IdentityHashMap<JCTree, Integer>(origCount);
            for (int i = 0; i < origCount; ++i) {
                m.put(variables.get(i), variables.get((int)i).pos);
            }
            this.overrideStartPositions = m;
        }
        this.doPrintOriginalTree(variables.subList(0, origCount), true);
        this.overrideStartPositions = null;
        return variables.subList(origCount, variables.size());
    }

    private void doAccept(JCTree t, boolean printComments) {
        if (!this.handlePossibleOldTrees(Collections.singletonList(t), printComments)) {
            Object tag;
            if (printComments) {
                this.printPrecedingComments(t, true);
            }
            int start = this.out.length();
            if (t instanceof FieldGroupTree) {
                FieldGroupTree fgt = (FieldGroupTree)t;
                if (fgt.isEnum()) {
                    this.printEnumConstants(List.from(fgt.getVariables().toArray(new JCTree[0])), !fgt.isEnum() || fgt.moreElementsFollowEnum(), printComments);
                } else {
                    java.util.List<JCTree.JCVariableDecl> remainder = this.printOriginalPartOfFieldGroup(fgt);
                    boolean firstMember = remainder.size() == fgt.getVariables().size();
                    for (JCTree.JCVariableDecl var : remainder) {
                        this.oldTrees.remove(var);
                        assert (!VeryPretty.isEnumerator(var));
                        assert (!this.isSynthetic(var));
                        this.printStat(var, true, firstMember, true, true, printComments);
                        firstMember = false;
                    }
                }
            } else {
                boolean saveComments = this.commentsEnabled;
                this.commentsEnabled = printComments;
                t.accept(this);
                this.commentsEnabled = saveComments;
            }
            int end = this.out.length();
            Object k = tag = this.tree2Tag != null ? (Object)this.tree2Tag.get(t) : null;
            if (tag != null) {
                this.tag2Span.put(tag, new int[]{start + this.initialOffset, end + this.initialOffset});
            }
            if (printComments) {
                this.printInnerCommentsAsTrailing(t, true);
                this.printTrailingComments(t, true);
            }
        }
    }

    private void doAccept(DCTree t) {
        t.accept(this, null);
    }

    public boolean handlePossibleOldTrees(java.util.List<? extends JCTree> toPrint, boolean includeComments) {
        for (JCTree jCTree : toPrint) {
            if (!this.oldTrees.contains(jCTree)) {
                return false;
            }
            if (jCTree.getKind() == Tree.Kind.ARRAY_TYPE) {
                return false;
            }
            CommentSet cs = this.commentHandler.getComments(jCTree);
            if (!cs.hasChanges()) continue;
            return false;
        }
        if (toPrint.size() > 1) {
            TreePath tp = TreePath.getPath(this.diffContext.mainUnit, (Tree)toPrint.get(0));
            TreePath treePath = tp.getParentPath();
            if (treePath == null) {
                return false;
            }
            java.util.List<? extends StatementTree> statements = this.getStatements(treePath.getLeaf());
            if (statements == null) {
                return false;
            }
            int startIndex = statements.indexOf(toPrint.get(0));
            if (startIndex < 0) {
                return false;
            }
            for (JCTree jCTree : toPrint) {
                if (statements.get(startIndex++) == jCTree) continue;
                return false;
            }
        }
        this.doPrintOriginalTree(toPrint, includeComments);
        return true;
    }

    private void doPrintOriginalTree(java.util.List<? extends JCTree> toPrint, final boolean includeComments) {
        if (this.out.isWhitespaceLine()) {
            this.toLeftMargin();
        }
        JCTree firstTree = toPrint.get(0);
        JCTree lastTree = toPrint.get(toPrint.size() - 1);
        CommentSet old = this.commentHandler.getComments(firstTree);
        final int realStart = includeComments ? Math.min(this.getOldPos(firstTree), CasualDiff.commentStart(this.diffContext, old, CommentSet.RelativePosition.PRECEDING, this.getOldPos(firstTree))) : this.getOldPos(firstTree);
        final int newStart = this.out.length() + this.initialOffset;
        final int[] realEnd = new int[]{this.endPos(lastTree)};
        new ErrorAwareTreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null) {
                    Object tag;
                    CommentSetImpl old = VeryPretty.this.comments.getComments(node);
                    if (includeComments) {
                        realEnd[0] = Math.max(realEnd[0], Math.max(CasualDiff.commentEnd(old, CommentSet.RelativePosition.INLINE), CasualDiff.commentEnd(old, CommentSet.RelativePosition.TRAILING)));
                        VeryPretty.this.trailingCommentsHandled.add(node);
                    }
                    Object k = tag = VeryPretty.this.tree2Tag != null ? (Object)VeryPretty.this.tree2Tag.get(node) : null;
                    if (tag != null) {
                        int s = VeryPretty.this.getOldPos((JCTree)node);
                        int e = VeryPretty.this.endPos((JCTree)node);
                        VeryPretty.this.tag2Span.put(tag, new int[]{s - realStart + newStart, e - realStart + newStart});
                    }
                }
                return (Void)super.scan(node, p);
            }
        }.scan((Tree)lastTree, (Void)null);
        this.copyToIndented(realStart, realEnd[0]);
    }

    private void copyToIndented(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to || from < 0 || to < 0) {
            LOG.log(Level.INFO, "-----\n" + this.origText + "-----\n");
            LOG.log(Level.INFO, "Illegal values: from = " + from + "; to = " + to + ".Please, attach your messages.log to new issue!");
            if (to >= 0) {
                this.eatChars(from - to);
            }
            return;
        }
        if (to > this.origText.length()) {
            LOG.severe("-----\n" + this.origText + "-----\n");
            throw new IllegalArgumentException("Copying to " + to + " is greater then its size (" + this.origText.length() + ").");
        }
        String text = this.origText.substring(from, to);
        int newLine = text.indexOf("\n") + 1;
        boolean wasWhitespaceLine = this.out.isWhitespaceLine();
        if (newLine == 0 && !wasWhitespaceLine) {
            this.print(text);
        } else {
            int start = this.out.length();
            this.print(text);
            int end = start + text.length();
            this.reindentRegions.add(new int[]{this.initialOffset + start + (wasWhitespaceLine ? 0 : newLine), this.initialOffset + end});
        }
    }

    @Override
    public void trimmed(int limit) {
        int[] reg;
        SortedSet<int[]> s = this.reindentRegions;
        while (!s.isEmpty() && (reg = s.last())[1] > this.initialOffset + limit) {
            if (reg[0] >= this.initialOffset + limit) {
                s.remove(reg);
                continue;
            }
            reg[1] = this.initialOffset + limit;
            break;
        }
    }

    public void printPackage(JCTree.JCExpression pid) {
        if (pid != null) {
            this.blankLines(this.cs.getBlankLinesBeforePackage());
            this.print("package ");
            this.printExpr(pid);
            this.print(';');
            this.blankLines(this.cs.getBlankLinesAfterPackage());
        }
    }

    public String getMethodHeader(MethodTree t, String s) {
        JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, ANNOTATIONS);
        this.printFlags(tree.mods.flags);
        s = this.replace(s, FLAGS);
        if (tree.name == this.names.init) {
            this.print(this.enclClass.name);
            s = this.replace(s, NAME);
        } else {
            if (tree.typarams != null) {
                this.printTypeParameters(tree.typarams);
                this.needSpace();
                s = this.replace(s, TYPEPARAMETERS);
            }
            this.print(tree.restype);
            s = this.replace(s, TYPE);
            this.out.clear();
            this.print(tree.name);
            s = this.replace(s, NAME);
        }
        this.print('(');
        this.wrapTrees(tree.params, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
        this.print(')');
        s = this.replace(s, PARAMETERS);
        if (tree.thrown.nonEmpty()) {
            this.print(" throws ");
            this.wrapTrees(tree.thrown, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
            s = this.replace(s, THROWS);
        }
        return s.replaceAll(REPLACEMENT, "");
    }

    public String getClassHeader(ClassTree t, String s) {
        JCTree.JCClassDecl tree = (JCTree.JCClassDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, ANNOTATIONS);
        long flags = tree.mods.flags;
        if ((flags & 0x4000L) != 0L) {
            this.printFlags(flags & 0xFFFFFFFFFFFFFDEFL);
        } else {
            this.printFlags(flags & 0xFFFFFFFFFFFFF9FFL);
        }
        s = this.replace(s, FLAGS);
        if ((flags & 0x200L) != 0L) {
            this.print("interface ");
            this.print(tree.name);
            s = this.replace(s, NAME);
            this.printTypeParameters(tree.typarams);
            s = this.replace(s, TYPEPARAMETERS);
            if (tree.implementing.nonEmpty()) {
                this.print(" extends ");
                this.wrapTrees(tree.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                s = this.replace(s, EXTENDS);
            }
        } else {
            if ((flags & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((flags & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(tree.name);
            s = this.replace(s, NAME);
            this.printTypeParameters(tree.typarams);
            s = this.replace(s, TYPEPARAMETERS);
            if (tree.extending != null) {
                this.print(" extends ");
                this.print(tree.extending);
                s = this.replace(s, EXTENDS);
            }
            if (tree.implementing.nonEmpty()) {
                this.print(" implements ");
                this.wrapTrees(tree.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                s = this.replace(s, IMPLEMENTS);
            }
        }
        return s.replaceAll(REPLACEMENT, "");
    }

    public String getVariableHeader(VariableTree t, String s) {
        JCTree.JCVariableDecl tree = (JCTree.JCVariableDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, ANNOTATIONS);
        this.printFlags(tree.mods.flags);
        s = this.replace(s, FLAGS);
        this.print(tree.vartype);
        s = this.replace(s, TYPE);
        this.needSpace();
        this.print(tree.name);
        s = this.replace(s, NAME);
        return s.replaceAll(REPLACEMENT, "");
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        List<JCTree> l = tree.defs;
        if (((JCTree)l.head).hasTag(JCTree.Tag.PACKAGEDEF)) {
            this.print((JCTree)l.head);
            l = l.tail;
        }
        ArrayList<JCTree.JCImport> imports = new ArrayList<JCTree.JCImport>();
        while (l.nonEmpty() && ((JCTree)l.head).getTag() == JCTree.Tag.IMPORT) {
            imports.add((JCTree.JCImport)l.head);
            l = l.tail;
        }
        this.printImportsBlock(imports, !l.isEmpty());
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head, true, false, false, true, false);
            l = l.tail;
        }
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl tree) {
        int old;
        this.toLeftMargin();
        this.printAnnotations(tree.mods.annotations);
        if (tree.getModuleType() == ModuleTree.ModuleKind.OPEN) {
            this.print("open ");
        }
        this.print("module ");
        this.print(this.fullName(tree.qualId));
        int bcol = old = this.cs.indentTopLevelClassMembers() ? this.indent() : this.out.leftMargin;
        switch (this.cs.getModuleDeclBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(old);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                bcol = this.out.leftMargin;
                this.toColExactly(bcol);
            }
        }
        if (this.cs.spaceBeforeModuleDeclLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        this.printInnerCommentsAsTrailing(tree, true);
        if (!tree.directives.isEmpty()) {
            this.blankLines(this.cs.getBlankLinesAfterModuleHeader());
            boolean firstDirective = true;
            for (JCTree jCTree : tree.directives) {
                this.printStat(jCTree, true, firstDirective, true, true, false);
                firstDirective = false;
            }
            this.blankLines(this.cs.getBlankLinesBeforeModuleClosingBrace());
        } else {
            this.printEmptyBlockComments(tree, false);
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
    }

    @Override
    public void visitExports(JCTree.JCExports tree) {
        this.print("exports ");
        this.print(this.fullName(tree.qualid));
        if (tree.moduleNames.nonEmpty()) {
            this.wrap("to ", this.cs.wrapExportsToKeyword());
            this.wrapTrees(tree.moduleNames, this.cs.wrapExportsToList(), this.cs.alignMultilineExports() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        }
        this.print(';');
    }

    @Override
    public void visitOpens(JCTree.JCOpens tree) {
        this.print("opens ");
        this.print(this.fullName(tree.qualid));
        if (tree.moduleNames.nonEmpty()) {
            this.wrap("to ", this.cs.wrapOpensToKeyword());
            this.wrapTrees(tree.moduleNames, this.cs.wrapOpensToList(), this.cs.alignMultilineOpens() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        }
        this.print(';');
    }

    @Override
    public void visitRequires(JCTree.JCRequires tree) {
        this.print("requires ");
        if (tree.isStaticPhase) {
            this.print("static ");
        }
        if (tree.isTransitive) {
            this.print("transitive ");
        }
        this.print(this.fullName(tree.moduleName));
        this.print(';');
    }

    @Override
    public void visitProvides(JCTree.JCProvides tree) {
        this.print("provides ");
        this.print(this.fullName(tree.serviceName));
        if (tree.implNames.nonEmpty()) {
            this.wrap("with ", this.cs.wrapProvidesWithKeyword());
            this.wrapTrees(tree.implNames, this.cs.wrapProvidesWithList(), this.cs.alignMultilineProvides() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        }
        this.print(';');
    }

    @Override
    public void visitUses(JCTree.JCUses tree) {
        this.print("uses ");
        this.print(this.fullName(tree.qualid));
        this.print(';');
    }

    @Override
    public void visitPackageDef(JCTree.JCPackageDecl tree) {
        if (tree != null) {
            this.printAnnotations((List<JCTree.JCAnnotation>)tree.getAnnotations());
            this.printPackage(tree.pid);
        }
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        this.print("import ");
        if (tree.staticImport) {
            this.print("static ");
        }
        this.print(this.fullName(tree.qualid));
        this.print(';');
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        int old;
        JCTree.JCClassDecl enclClassPrev = this.enclClass;
        this.enclClass = tree;
        this.toLeftMargin();
        this.printAnnotations(tree.mods.annotations);
        long flags = tree.mods.flags;
        if ((flags & 0x4000L) != 0L) {
            this.printFlags(flags & 0xFFFFFFFFFFFFFDEFL);
        } else {
            this.printFlags(flags & 0xFFFFFFFFFFFFF9FFL);
        }
        if ((flags & 0x200L) != 0L || (flags & 0x2000L) != 0L) {
            if ((flags & 0x2000L) != 0L) {
                this.print('@');
            }
            this.print("interface ");
            this.print(tree.name);
            this.printTypeParameters(tree.typarams);
            if (tree.implementing.nonEmpty()) {
                this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                this.wrapTrees(tree.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            }
        } else {
            if ((flags & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((flags & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(tree.name);
            this.printTypeParameters(tree.typarams);
            if (tree.extending != null) {
                this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                this.print(tree.extending);
            }
            if (tree.implementing.nonEmpty()) {
                this.wrap("implements ", this.cs.wrapExtendsImplementsKeyword());
                this.wrapTrees(tree.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            }
        }
        int bcol = old = this.cs.indentTopLevelClassMembers() ? this.indent() : this.out.leftMargin;
        switch (this.cs.getClassDeclBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(old);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                bcol = this.out.leftMargin;
                this.toColExactly(bcol);
            }
        }
        if (this.cs.spaceBeforeClassDeclLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        this.printInnerCommentsAsTrailing(tree, true);
        java.util.List<JCTree> members = CasualDiff.filterHidden(this.diffContext, tree.defs);
        if (!members.isEmpty()) {
            this.blankLines(this.enclClass.name.isEmpty() ? this.cs.getBlankLinesAfterAnonymousClassHeader() : ((flags & 0x4000L) != 0L ? this.cs.getBlankLinesAfterEnumHeader() : this.cs.getBlankLinesAfterClassHeader()));
            boolean firstMember = true;
            for (JCTree t : members) {
                this.printStat(t, true, firstMember, true, true, false);
                firstMember = false;
            }
            this.blankLines(this.enclClass.name.isEmpty() ? this.cs.getBlankLinesBeforeAnonymousClassClosingBrace() : ((flags & 0x4000L) != 0L ? this.cs.getBlankLinesBeforeEnumClosingBrace() : this.cs.getBlankLinesBeforeClassClosingBrace()));
        } else {
            this.printEmptyBlockComments(tree, false);
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
        this.enclClass = enclClassPrev;
    }

    private void printEnumConstants(java.util.List<? extends JCTree> defs, boolean forceSemicolon, boolean printComments) {
        boolean first = true;
        boolean hasNonEnumerator = false;
        for (JCTree jCTree : defs) {
            if (VeryPretty.isEnumerator(jCTree)) {
                boolean col = false;
                if (first) {
                    col = true;
                    first = false;
                } else {
                    this.print(this.cs.spaceBeforeComma() ? " ," : ",");
                    switch (this.cs.wrapEnumConstants()) {
                        case WRAP_IF_LONG: {
                            int rm = this.cs.getRightMargin();
                            if (this.widthEstimator.estimateWidth(jCTree, rm - this.out.col) + this.out.col + 1 <= rm) {
                                if (!this.cs.spaceAfterComma()) break;
                                this.print(' ');
                                break;
                            }
                        }
                        case WRAP_ALWAYS: {
                            this.newline();
                            col = true;
                            break;
                        }
                        case WRAP_NEVER: {
                            if (!this.cs.spaceAfterComma()) break;
                            this.print(' ');
                        }
                    }
                }
                this.printStat(jCTree, true, false, col, false, printComments);
                continue;
            }
            if (this.isSynthetic(jCTree)) continue;
            hasNonEnumerator = true;
        }
        if (hasNonEnumerator || forceSemicolon) {
            this.print(";");
            this.newline();
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if ((tree.mods.flags & 0x1000L) == 0L && tree.name != this.names.init || this.enclClass != null) {
            JCTree.JCClassDecl enclClassPrev = this.enclClass;
            this.enclClass = null;
            this.printAnnotations(tree.mods.annotations);
            this.printFlags(tree.mods.flags);
            if (tree.typarams != null) {
                this.printTypeParameters(tree.typarams);
                this.needSpace();
            }
            if (tree.name == this.names.init || tree.name.contentEquals(enclClassPrev.name)) {
                this.print(enclClassPrev.name);
            } else {
                this.print(tree.restype);
                this.needSpace();
                this.print(tree.name);
            }
            this.print(this.cs.spaceBeforeMethodDeclParen() ? " (" : "(");
            if (this.cs.spaceWithinMethodDeclParens() && tree.params.nonEmpty()) {
                this.print(' ');
            }
            boolean oldPrintingMethodParams = this.printingMethodParams;
            this.printingMethodParams = true;
            this.wrapTrees(tree.params, this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize(), true);
            this.printingMethodParams = oldPrintingMethodParams;
            if (this.cs.spaceWithinMethodDeclParens() && tree.params.nonEmpty()) {
                this.needSpace();
            }
            this.print(')');
            if (tree.thrown.nonEmpty()) {
                this.wrap("throws ", this.cs.wrapThrowsKeyword());
                this.wrapTrees(tree.thrown, this.cs.wrapThrowsList(), this.cs.alignMultilineThrows() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize(), true);
            }
            if (tree.body != null) {
                this.printBlock(tree.body, tree.body.stats, this.cs.getMethodDeclBracePlacement(), this.cs.spaceBeforeMethodDeclLeftBrace(), true);
            } else {
                if (tree.defaultValue != null) {
                    this.print(" default ");
                    this.printExpr(tree.defaultValue);
                }
                this.print(';');
            }
            this.enclClass = enclClassPrev;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        boolean notEnumConst = (tree.mods.flags & 0x4000L) == 0L;
        this.printAnnotations(tree.mods.annotations);
        if (notEnumConst) {
            this.printFlags(tree.mods.flags);
            if (!this.suppressVariableType) {
                if ((tree.mods.flags & 0x400000000L) != 0L) {
                    if (Tree.Kind.ARRAY_TYPE == tree.vartype.getKind()) {
                        this.printExpr(((JCTree.JCArrayTypeTree)tree.vartype).elemtype);
                    } else {
                        this.printExpr(tree.vartype);
                    }
                    this.print("...");
                } else {
                    this.print(tree.vartype);
                }
            }
        }
        if (tree.vartype != null && !this.suppressVariableType) {
            this.needSpace();
        }
        if (!ERROR.contentEquals(tree.name)) {
            this.print(tree.name);
        }
        if (tree.init != null) {
            if (notEnumConst) {
                this.printVarInit(tree);
            } else {
                JCTree.JCNewClass newClsTree = (JCTree.JCNewClass)tree.init;
                if (newClsTree.args.nonEmpty()) {
                    this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
                    if (this.cs.spaceWithinMethodCallParens()) {
                        this.print(' ');
                    }
                    this.wrapTrees(newClsTree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    this.print(this.cs.spaceWithinMethodCallParens() ? " )" : ")");
                }
                if (newClsTree.def != null) {
                    JCTree.JCClassDecl enclClassPrev = this.enclClass;
                    this.enclClass = newClsTree.def;
                    this.printBlock(null, newClsTree.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace(), true);
                    this.enclClass = enclClassPrev;
                }
            }
        }
        if (this.prec == -1 && notEnumConst) {
            this.print(';');
        }
    }

    public void printVarInit(final JCTree.JCVariableDecl tree) {
        int col = this.out.col;
        if (!ERROR.contentEquals(tree.name)) {
            col -= tree.name.getByteLength();
        }
        this.wrapAssignOpTree("=", col, new Runnable(){

            @Override
            public void run() {
                VeryPretty.this.printNoParenExpr(tree.init);
            }
        });
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
        this.print(';');
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.printFlags(tree.flags, false);
        this.printBlock(tree, tree.stats, this.cs.getOtherBracePlacement(), (tree.flags & 8L) != 0L ? this.cs.spaceBeforeStaticInitLeftBrace() : false, false);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        boolean prevblock;
        this.print("do");
        if (this.cs.spaceBeforeDoLeftBrace()) {
            this.print(' ');
        }
        this.printIndentedStat(tree.body, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
        boolean bl = prevblock = tree.body.getKind() == Tree.Kind.BLOCK || this.cs.redundantDoWhileBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (this.cs.placeWhileOnNewLine() || !prevblock) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeWhile()) {
            this.needSpace();
        }
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " );" : ");");
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " )" : ")");
        this.printIndentedStat(tree.body, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        int col = this.out.col;
        if (tree.init.nonEmpty()) {
            if (((JCTree.JCStatement)tree.init.head).getTag() == JCTree.Tag.VARDEF) {
                this.printNoParenExpr((JCTree)tree.init.head);
                List l = tree.init.tail;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl vdef = (JCTree.JCVariableDecl)l.head;
                    this.print(", " + vdef.name + " = ");
                    this.printNoParenExpr(vdef.init);
                    l = l.tail;
                }
            } else {
                this.printExprs(tree.init);
            }
        }
        String sep = this.cs.spaceBeforeSemi() ? " ;" : ";";
        this.print(sep);
        if (tree.cond != null) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.cond, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.cs.alignMultilineFor() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printNoParenExpr(tree.cond);
        }
        this.print(sep);
        if (tree.step.nonEmpty()) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.step, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.cs.alignMultilineFor() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printExprs(tree.step);
        }
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(tree.body, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        this.toColExactly(this.cs.absoluteLabelIndent() ? 0 : this.out.leftMargin);
        this.print(tree.label);
        this.print(':');
        int old = this.out.leftMargin;
        this.out.leftMargin += this.cs.getLabelIndent();
        this.toColExactly(this.out.leftMargin);
        this.printStat(tree.body);
        this.undent(old);
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        boolean useParens;
        boolean bl = useParens = this.cs.parensAroundSingularLambdaParam() || tree.params.size() != 1 || tree.paramKind != JCTree.JCLambda.ParameterKind.IMPLICIT;
        if (useParens) {
            this.print(this.cs.spaceWithinLambdaParens() && tree.params.nonEmpty() ? "( " : "(");
        }
        boolean oldPrintingMethodParams = this.printingMethodParams;
        this.printingMethodParams = true;
        this.suppressVariableType = tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT;
        this.wrapTrees(tree.params, this.cs.wrapLambdaParams(), this.cs.alignMultilineLambdaParams() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize(), true);
        this.suppressVariableType = false;
        this.printingMethodParams = oldPrintingMethodParams;
        if (useParens) {
            if (this.cs.spaceWithinLambdaParens() && tree.params.nonEmpty()) {
                this.needSpace();
            }
            this.print(')');
        }
        this.print(this.cs.spaceAroundLambdaArrow() ? " ->" : "->");
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT) {
            this.printBlock(tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceAroundLambdaArrow());
        } else {
            int rm = this.cs.getRightMargin();
            switch (this.cs.wrapBinaryOps()) {
                case WRAP_IF_LONG: {
                    if (this.widthEstimator.estimateWidth(tree.body, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                        if (!this.cs.spaceAroundLambdaArrow()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAroundLambdaArrow()) break;
                    this.print(' ');
                }
            }
            this.printExpr(tree.body, -1);
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.print("switch");
        this.print(this.cs.spaceBeforeSwitchParen() ? " (" : "(");
        if (this.cs.spaceWithinSwitchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.selector);
        this.print(this.cs.spaceWithinSwitchParens() ? " )" : ")");
        int bcol = this.out.leftMargin;
        switch (this.cs.getOtherBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(bcol);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize);
            }
        }
        if (this.cs.spaceBeforeSwitchLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        if (tree.cases.nonEmpty()) {
            this.newline();
            this.printStats(tree.cases);
            this.toColExactly(bcol);
        }
        this.print('}');
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        this.print("switch");
        this.print(this.cs.spaceBeforeSwitchParen() ? " (" : "(");
        if (this.cs.spaceWithinSwitchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.selector);
        this.print(this.cs.spaceWithinSwitchParens() ? " )" : ")");
        int bcol = this.out.leftMargin;
        switch (this.cs.getOtherBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(bcol);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize);
            }
        }
        if (this.cs.spaceBeforeSwitchLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        if (!((List)tree.getCases()).isEmpty()) {
            this.newline();
            ListBuffer<JCTree.JCCase> newTcases = new ListBuffer<JCTree.JCCase>();
            for (CaseTree t : tree.getCases()) {
                newTcases.append((JCTree.JCCase)t);
            }
            this.printStats(newTcases.toList());
            this.toColExactly(bcol);
        }
        this.print('}');
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        int old = this.cs.indentCasesFromSwitch() ? this.indent() : this.out.leftMargin;
        this.toLeftMargin();
        List<JCTree.JCCaseLabel> labels = tree.labels;
        if (labels.size() == 1 && ((JCTree.JCCaseLabel)labels.get(0)).hasTag(JCTree.Tag.DEFAULTCASELABEL)) {
            this.print("default");
        } else {
            this.print("case ");
            String sep = "";
            for (JCTree jCTree : labels) {
                this.print(sep);
                this.printNoParenExpr(jCTree);
                sep = ", ";
            }
        }
        CaseTree.CaseKind caseKind = tree.getCaseKind();
        if (caseKind == null || !String.valueOf((Object)caseKind).equals("RULE")) {
            this.print(':');
            this.newline();
            this.indent();
            this.printStats(tree.stats);
            this.undent(old);
        } else {
            this.print(" -> ");
            this.printStat((JCTree)tree.stats.head);
            this.undent(old);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.print("synchronized");
        this.print(this.cs.spaceBeforeSynchronizedParen() ? " (" : "(");
        if (this.cs.spaceWithinSynchronizedParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.lock);
        this.print(this.cs.spaceWithinSynchronizedParens() ? " )" : ")");
        this.printBlock((JCTree)tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeSynchronizedLeftBrace());
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        this.print("try");
        if (!((List)tree.getResources()).isEmpty()) {
            this.print(" (");
            Iterator it = ((List)tree.getResources()).iterator();
            while (it.hasNext()) {
                JCTree r = (JCTree)it.next();
                this.oldTrees.remove(r);
                this.printPrecedingComments(r, false);
                this.printExpr(r, 0);
                this.printTrailingComments(r, false);
                if (!it.hasNext()) continue;
                this.print(";");
            }
            this.print(") ");
        }
        this.printBlock((JCTree)tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeTryLeftBrace());
        List<JCTree.JCCatch> l = tree.catchers;
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head);
            l = l.tail;
        }
        if (tree.finalizer != null) {
            this.printFinallyBlock(tree.finalizer);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        if (this.cs.placeCatchOnNewLine()) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeCatch()) {
            this.needSpace();
        }
        this.print("catch");
        this.print(this.cs.spaceBeforeCatchParen() ? " (" : "(");
        if (this.cs.spaceWithinCatchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.param);
        this.print(this.cs.spaceWithinCatchParens() ? " )" : ")");
        this.printBlock((JCTree)tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeCatchLeftBrace());
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        int rm;
        this.printExpr(tree.cond, 2);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                rm = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(tree.truepart, rm - this.out.col) + this.out.col + 1 <= rm) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? "? " : "?");
        this.printExpr(tree.truepart, 3);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                rm = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(tree.falsepart, rm - this.out.col) + this.out.col + 1 <= rm) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? ": " : ":");
        this.printExpr(tree.falsepart, 3);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        boolean prevblock;
        this.print("if");
        this.print(this.cs.spaceBeforeIfParen() ? " (" : "(");
        if (this.cs.spaceWithinIfParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinIfParens() ? " )" : ")");
        boolean bl = prevblock = tree.thenpart.getKind() == Tree.Kind.BLOCK && this.cs.redundantIfBraces() != CodeStyle.BracesGenerationStyle.ELIMINATE || this.cs.redundantIfBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (tree.elsepart != null && this.danglingElseChecker.hasDanglingElse(tree.thenpart)) {
            this.printBlock((JCTree)tree.thenpart, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeIfLeftBrace());
            prevblock = true;
        } else {
            this.printIndentedStat(tree.thenpart, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
        }
        if (tree.elsepart != null) {
            this.printElse(tree, prevblock);
        }
    }

    public void printElse(JCTree.JCIf tree, boolean prevblock) {
        if (this.cs.placeElseOnNewLine() || !prevblock) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeElse()) {
            this.needSpace();
        }
        this.print("else");
        if (tree.elsepart.getKind() == Tree.Kind.IF && this.cs.specialElseIf()) {
            this.needSpace();
            this.printStat(tree.elsepart);
        } else {
            this.printIndentedStat(tree.elsepart, this.cs.redundantIfBraces(), this.cs.spaceBeforeElseLeftBrace(), this.cs.wrapIfStatement());
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.printNoParenExpr(tree.expr);
        if (this.prec == -1) {
            this.print(';');
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        this.print("break");
        if (tree.getLabel() != null) {
            this.needSpace();
            this.print(tree.getLabel());
        }
        this.print(';');
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        this.print("yield");
        JCTree.JCExpression expr = tree.getValue();
        if (expr != null) {
            this.needSpace();
            this.print(expr);
        }
        this.print(';');
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        this.print("continue");
        if (tree.label != null) {
            this.needSpace();
            this.print(tree.label);
        }
        this.print(';');
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.print("return");
        if (tree.expr != null) {
            this.needSpace();
            this.printNoParenExpr(tree.expr);
        }
        this.print(';');
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.print("throw ");
        this.printNoParenExpr(tree.expr);
        this.print(';');
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        this.print("assert ");
        this.printExpr(tree.cond);
        if (tree.detail != null) {
            this.print(this.cs.spaceBeforeColon() ? " :" : ":");
            switch (this.cs.wrapAssert()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.detail, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterColon()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterColon()) break;
                    this.print(' ');
                }
            }
            this.printExpr(tree.detail);
        }
        this.print(';');
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        int prevPrec = this.prec;
        this.prec = 15;
        this.printMethodSelect(tree);
        this.prec = prevPrec;
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty()) {
            this.print(' ');
        }
        this.wrapTrees(tree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty() ? " )" : ")");
    }

    public void printMethodSelect(JCTree.JCMethodInvocation tree) {
        if (tree.meth.getTag() == JCTree.Tag.SELECT) {
            JCTree.JCFieldAccess left = (JCTree.JCFieldAccess)tree.meth;
            this.printExpr(left.selected);
            boolean wrapAfterDot = this.cs.wrapAfterDotInChainedMethodCalls();
            if (wrapAfterDot) {
                this.print('.');
            }
            if (left.selected.getTag() == JCTree.Tag.APPLY) {
                switch (this.cs.wrapChainedMethodCalls()) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        int estWidth = left.name.length();
                        if (tree.typeargs.nonEmpty()) {
                            estWidth += this.widthEstimator.estimateWidth(tree.typeargs, rm - this.out.col - estWidth) + 2;
                        }
                        if ((estWidth += this.widthEstimator.estimateWidth(tree.args, rm - this.out.col - estWidth) + 2) + this.out.col <= rm) break;
                    }
                    case WRAP_ALWAYS: {
                        this.newline();
                        this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                }
            }
            if (!wrapAfterDot) {
                this.print('.');
            }
            if (tree.typeargs.nonEmpty()) {
                this.printTypeArguments(tree.typeargs);
            }
            this.print(left.name);
        } else {
            if (tree.typeargs.nonEmpty()) {
                this.printTypeArguments(tree.typeargs);
            }
            this.printExpr(tree.meth);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            this.printExpr(tree.encl);
            this.print('.');
        }
        this.print("new ");
        if (tree.typeargs.nonEmpty()) {
            this.print("<");
            this.printExprs(tree.typeargs);
            this.print(">");
        }
        if (tree.encl == null) {
            this.print(tree.clazz);
        } else if (tree.clazz.type != null) {
            this.print(tree.clazz.type.tsym.name);
        } else {
            this.print(tree.clazz);
        }
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty()) {
            this.print(' ');
        }
        this.wrapTrees(tree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty() ? " )" : ")");
        if (tree.def != null) {
            this.printNewClassBody(tree);
        }
    }

    public void printNewClassBody(JCTree.JCNewClass tree) {
        JCTree.JCClassDecl enclClassPrev = this.enclClass;
        this.enclClass = tree.def;
        this.printBlock(null, tree.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace(), true, true);
        this.enclClass = enclClassPrev;
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        if (tree.elemtype != null) {
            this.print("new ");
            int n = tree.elems != null ? 1 : 0;
            JCTree.JCExpression elemtype = tree.elemtype;
            while (elemtype.getTag() == JCTree.Tag.TYPEARRAY) {
                ++n;
                elemtype = ((JCTree.JCArrayTypeTree)elemtype).elemtype;
            }
            this.printExpr(elemtype);
            List<JCTree.JCExpression> l = tree.dims;
            while (l.nonEmpty()) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ " : "[");
                this.printNoParenExpr((JCTree)l.head);
                this.print(this.cs.spaceWithinArrayInitBrackets() ? " ]" : "]");
                l = l.tail;
            }
            while (--n >= 0) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ ]" : "[]");
            }
        }
        if (tree.elems != null) {
            if (this.cs.spaceBeforeArrayInitLeftBrace()) {
                this.needSpace();
            }
            this.print('{');
            if (this.cs.spaceWithinBraces()) {
                this.print(' ');
            }
            this.wrapTrees(tree.elems, this.cs.wrapArrayInit(), this.cs.alignMultilineArrayInit() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            this.print(this.cs.spaceWithinBraces() ? " }" : "}");
        }
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        this.print('(');
        if (this.cs.spaceWithinParens()) {
            this.print(' ');
        }
        this.printExpr(tree.expr);
        this.print(this.cs.spaceWithinParens() ? " )" : ")");
    }

    @Override
    public void visitAssign(final JCTree.JCAssign tree) {
        int col = this.out.col;
        this.printExpr(tree.lhs, 2);
        this.wrapAssignOpTree("=", col, new Runnable(){

            @Override
            public void run() {
                VeryPretty.this.printExpr(tree.rhs, 1);
            }
        });
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        int col = this.out.col;
        this.printExpr(tree.lhs, 3);
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print(this.operators.operatorName(tree.getTag().noAssignOp()));
        this.print('=');
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, 2);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        Name opname;
        int ownprec = TreeInfo.opPrec(tree.getTag());
        switch (tree.getTag()) {
            case POS: {
                opname = this.names.fromString("+");
                break;
            }
            case NEG: {
                opname = this.names.fromString("-");
                break;
            }
            default: {
                opname = this.operators.operatorName(tree.getTag());
            }
        }
        if (tree.getTag().ordinal() <= JCTree.Tag.PREDEC.ordinal()) {
            if (this.cs.spaceAroundUnaryOps()) {
                this.needSpace();
                this.print(opname);
                this.print(' ');
            } else {
                this.print(opname);
                if (tree.getTag() == JCTree.Tag.POS && (tree.arg.getTag() == JCTree.Tag.POS || tree.arg.getTag() == JCTree.Tag.PREINC) || tree.getTag() == JCTree.Tag.NEG && (tree.arg.getTag() == JCTree.Tag.NEG || tree.arg.getTag() == JCTree.Tag.PREDEC)) {
                    this.print(' ');
                }
            }
            this.printExpr(tree.arg, ownprec);
        } else {
            this.printExpr(tree.arg, ownprec);
            if (this.cs.spaceAroundUnaryOps()) {
                this.print(' ');
                this.print(opname);
                this.print(' ');
            } else {
                this.print(opname);
            }
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        int ownprec = TreeInfo.opPrec(tree.getTag());
        Name opname = this.operators.operatorName(tree.getTag());
        int col = this.out.col;
        this.printExpr(tree.lhs, ownprec);
        if (this.cs.spaceAroundBinaryOps()) {
            this.print(' ');
        }
        this.print(opname);
        boolean needsSpace = this.cs.spaceAroundBinaryOps() || tree.getTag() == JCTree.Tag.PLUS && (tree.rhs.getTag() == JCTree.Tag.POS || tree.rhs.getTag() == JCTree.Tag.PREINC) || tree.getTag() == JCTree.Tag.MINUS && (tree.rhs.getTag() == JCTree.Tag.NEG || tree.rhs.getTag() == JCTree.Tag.PREDEC);
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapBinaryOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!needsSpace) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.cs.alignMultilineBinaryOp() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!needsSpace) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, ownprec + 1);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.print(this.cs.spaceWithinTypeCastParens() ? "( " : "(");
        this.print(tree.clazz);
        this.print(this.cs.spaceWithinTypeCastParens() ? " )" : ")");
        if (this.cs.spaceAfterTypeCast()) {
            this.needSpace();
        }
        if (this.diffContext.origUnit != null && TreePath.getPath(this.diffContext.origUnit, (Tree)tree.expr) != null) {
            int a = TreeInfo.getStartPos(tree.expr);
            int b = TreeInfo.getEndPos(tree.expr, this.diffContext.origUnit.endPositions);
            this.print(this.diffContext.origText.substring(a, b));
            return;
        }
        this.printExpr(tree.expr, 14);
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion that) {
        boolean sep = this.cs.spaceAroundBinaryOps();
        this.wrapTrees((List)that.getTypeAlternatives(), this.cs.wrapDisjunctiveCatchTypes(), this.cs.alignMultilineDisjunctiveCatchTypes() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize(), false, sep, sep, "|");
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
        this.printExprs(tree.bounds, " & ");
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.printExpr(tree.expr, 10);
        this.print(" instanceof ");
        this.print(CasualDiff.getPattern(tree));
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.printExpr(tree.indexed, 15);
        this.print('[');
        this.printExpr(tree.index);
        this.print(']');
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.printExpr(tree.selected, 15);
        this.print('.');
        this.print(tree.name);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        this.print(tree.name);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        long end;
        long start;
        if (this.diffContext != null && this.diffContext.origUnit != null && (start = this.diffContext.trees.getSourcePositions().getStartPosition(this.diffContext.origUnit, tree)) >= 0L && (end = this.diffContext.trees.getSourcePositions().getEndPosition(this.diffContext.origUnit, tree)) >= 0L && this.origText != null) {
            this.print(this.origText.substring((int)start, (int)end));
            return;
        }
        if (this.diffContext != null && this.diffContext.mainUnit != null && (start = this.diffContext.trees.getSourcePositions().getStartPosition(this.diffContext.mainUnit, tree)) >= 0L && (end = this.diffContext.trees.getSourcePositions().getEndPosition(this.diffContext.mainUnit, tree)) >= 0L && this.diffContext.mainCode != null) {
            this.print(this.diffContext.mainCode.substring((int)start, (int)end));
            return;
        }
        switch (tree.typetag) {
            case INT: {
                this.print(tree.value.toString());
                break;
            }
            case LONG: {
                this.print(tree.value.toString() + "L");
                break;
            }
            case FLOAT: {
                this.print(tree.value.toString() + "F");
                break;
            }
            case DOUBLE: {
                this.print(tree.value.toString());
                break;
            }
            case CHAR: {
                this.print("'" + VeryPretty.quote(String.valueOf((char)((Number)tree.value).intValue()), '\"') + "'");
                break;
            }
            case CLASS: {
                if (tree.value instanceof String) {
                    this.print("\"" + VeryPretty.quote((String)tree.value, '\'') + "\"");
                    break;
                }
                if (tree.value instanceof String[]) {
                    int indent = this.out.col;
                    this.print("\"\"\"");
                    this.newline();
                    String[] lines = (String[])tree.value;
                    for (int i = 0; i < lines.length; ++i) {
                        this.out.toCol(indent);
                        String line = lines[i];
                        for (int c = 0; c < line.length(); ++c) {
                            if (line.startsWith("\"\"\"", c)) {
                                this.print('\\');
                                this.print('\"');
                                continue;
                            }
                            if (line.charAt(c) != '\'' && line.charAt(c) != '\"') {
                                this.print(Convert.quote(line.charAt(c)));
                                continue;
                            }
                            this.print(line.charAt(c));
                        }
                        if (i + 1 >= lines.length) continue;
                        this.newLineNoTrim();
                    }
                    this.print("\"\"\"");
                    break;
                }
                throw new IllegalStateException("Incorrect literal value.");
            }
            case BOOLEAN: {
                this.print(tree.getValue().toString());
                break;
            }
            case BOT: {
                this.print("null");
                break;
            }
            default: {
                this.print(tree.value.toString());
            }
        }
    }

    private static String quote(String val, char keep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c != keep) {
                sb.append(Convert.quote(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String typeTagName(TypeTag tt) {
        return typeTagNames[tt.ordinal()];
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        this.print(VeryPretty.typeTagName(tree.typetag));
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        this.printExpr(tree.elemtype);
        this.print("[]");
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        this.printExpr(tree.clazz);
        this.print('<');
        this.printExprs(tree.arguments);
        this.print('>');
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        this.printExprs(tree.annotations);
        this.print(' ');
        this.printExpr(tree.underlyingType);
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        this.print(tree.name);
        if (tree.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(tree.bounds, " & ");
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        this.print(String.valueOf(tree.kind));
        if (tree.kind.kind != BoundKind.UNBOUND) {
            this.printExpr(tree.inner);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
        this.printAnnotations(tree.annotations);
        this.printFlags(tree.flags);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        boolean oldInsideAnnotation = this.insideAnnotation;
        this.insideAnnotation = true;
        if (!this.printAnnotationsFormatted(List.of(tree))) {
            this.print("@");
            this.printExpr(tree.annotationType);
            if (tree.args.nonEmpty()) {
                this.print(this.cs.spaceBeforeAnnotationParen() ? " (" : "(");
                if (this.cs.spaceWithinAnnotationParens()) {
                    this.print(' ');
                }
                this.printExprs(tree.args);
                this.print(this.cs.spaceWithinAnnotationParens() ? " )" : ")");
            }
        }
        this.insideAnnotation = oldInsideAnnotation;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        this.printExpr(tree.getVariable());
        String sep = this.cs.spaceBeforeColon() ? " :" : ":";
        this.print(this.cs.spaceAfterColon() ? sep + " " : sep);
        this.printExpr(tree.getExpression());
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(tree.getStatement(), this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        this.printExpr(tree.expr);
        this.print(this.cs.spaceAroundMethodReferenceDoubleColon() ? " :: " : "::");
        if (tree.typeargs != null && !tree.typeargs.isEmpty()) {
            this.print("<");
            this.printExprs(tree.typeargs);
            this.print(">");
        }
        if (tree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE) {
            this.print(tree.name);
        } else {
            this.print("new");
        }
    }

    @Override
    public void visitBindingPattern(JCTree.JCBindingPattern tree) {
        this.print(tree.var.vartype);
        this.print(' ');
        this.print(tree.var.name);
    }

    @Override
    public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel tree) {
        this.print("default");
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
        this.printExpr(tree.expr);
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
        this.print(tree.pat);
        if (tree.guard != null) {
            this.print(" when ");
            this.printExpr(tree.guard);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.print("(let " + tree.defs + " in " + tree.expr + ")");
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        this.print("(ERROR)");
    }

    @Override
    public void visitTree(JCTree tree) {
        this.print("(UNKNOWN: " + tree + ")");
        this.newline();
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern tree) {
        this.print(tree.deconstructor);
        this.print("(");
        Iterator<JCTree.JCPattern> it = tree.nested.iterator();
        while (it.hasNext()) {
            JCTree.JCPattern pattern = it.next();
            this.doAccept(pattern, true);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(")");
    }

    private void print(char c) {
        this.out.append(c);
    }

    private void needSpace() {
        this.out.needSpace();
    }

    private void blankLines(int n) {
        this.out.blanklines(n);
    }

    private void blankLines(JCTree tree, boolean before) {
        if (tree == null) {
            return;
        }
        int n = 0;
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                int n2 = n = before ? this.cs.getBlankLinesBeforeClass() : this.cs.getBlankLinesAfterClass();
                if (((JCTree.JCClassDecl)tree).defs.nonEmpty() && !before) {
                    n = 0;
                } else {
                    this.out.blanklines(n);
                    this.toLeftMargin();
                }
                return;
            }
            case METHOD: {
                if ((((JCTree.JCMethodDecl)tree).mods.flags & 0x1000L) == 0L && ((JCTree.JCMethodDecl)tree).name != this.names.init || this.enclClass != null) {
                    n = before ? (this.isFirst(tree, this.enclClass.defs) ? (this.enclClass.name == this.names.empty ? this.cs.getBlankLinesAfterAnonymousClassHeader() : this.cs.getBlankLinesAfterClassHeader()) : this.cs.getBlankLinesBeforeMethods()) : (this.isLast(tree, this.enclClass.defs) ? (this.enclClass.name == this.names.empty ? this.cs.getBlankLinesBeforeAnonymousClassClosingBrace() : this.cs.getBlankLinesBeforeClassClosingBrace()) : this.cs.getBlankLinesAfterMethods());
                    this.out.blanklines(n);
                    this.toLeftMargin();
                }
                return;
            }
            case VARIABLE: {
                if (this.enclClass != null && this.enclClass.name != this.names.empty && (((JCTree.JCVariableDecl)tree).mods.flags & 0x4000L) == 0L) {
                    n = before ? (this.isFirst(tree, this.enclClass.defs) ? (this.enclClass.name == this.names.empty ? this.cs.getBlankLinesAfterAnonymousClassHeader() : this.cs.getBlankLinesAfterClassHeader()) : this.cs.getBlankLinesBeforeFields()) : (this.isLast(tree, this.enclClass.defs) ? (this.enclClass.name == this.names.empty ? this.cs.getBlankLinesBeforeAnonymousClassClosingBrace() : this.cs.getBlankLinesBeforeClassClosingBrace()) : this.cs.getBlankLinesAfterFields());
                    this.out.blanklines(n);
                    if (before) {
                        this.toLeftMargin();
                    }
                }
                return;
            }
        }
    }

    private boolean isFirst(JCTree tree, List<? extends JCTree> list) {
        for (JCTree jCTree : list) {
            if (this.isSynthetic(jCTree)) continue;
            return jCTree == tree;
        }
        return false;
    }

    private boolean isLast(JCTree tree, List<? extends JCTree> list) {
        boolean b = false;
        for (JCTree jCTree : list) {
            if (this.isSynthetic(jCTree)) continue;
            b = jCTree == tree;
        }
        return b;
    }

    private void blankLines(DCTree tree, boolean before, boolean suppressMarginAfter) {
        if (tree == null) {
            return;
        }
        switch (tree.getKind()) {
            case AUTHOR: 
            case DEPRECATED: 
            case EXCEPTION: 
            case PARAM: 
            case RETURN: 
            case SEE: 
            case SERIAL: 
            case SERIAL_DATA: 
            case SERIAL_FIELD: 
            case SINCE: 
            case THROWS: 
            case UNKNOWN_BLOCK_TAG: 
            case VERSION: {
                if (!before) break;
                this.newline();
                this.toLeftMargin();
                this.print(" * ");
                break;
            }
            case DOC_COMMENT: {
                if (before) {
                    this.blankline();
                } else {
                    this.newline();
                }
                if (suppressMarginAfter) break;
                this.toLeftMargin();
                break;
            }
        }
    }

    private void toColExactly(int n) {
        if (n < this.out.col) {
            this.newline();
        }
        this.out.toCol(n);
    }

    protected void printTagName(DocTree node) {
        this.out.append("@");
        this.out.append(node.getKind().tagName);
    }

    @Override
    public Void visitAttribute(AttributeTree node, Void p) {
        String quote;
        this.print(node.getName());
        switch (node.getValueKind()) {
            case EMPTY: {
                return null;
            }
            case UNQUOTED: {
                quote = "";
                break;
            }
            case SINGLE: {
                quote = "'";
                break;
            }
            case DOUBLE: {
                quote = "\"";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.print("=");
        this.print(quote);
        for (DocTree docTree : node.getValue()) {
            this.doAccept((DCTree)docTree);
        }
        this.print(quote);
        return null;
    }

    @Override
    public Void visitAuthor(AuthorTree node, Void p) {
        this.printTagName(node);
        this.print(" ");
        for (DocTree docTree : node.getName()) {
            this.doAccept((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitComment(CommentTree node, Void p) {
        this.print(node.getBody());
        return null;
    }

    @Override
    public Void visitDeprecated(DeprecatedTree node, Void p) {
        this.printTagName(node);
        if (!node.getBody().isEmpty()) {
            this.needSpace();
            for (DocTree docTree : node.getBody()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitDocComment(DocCommentTree node, Void p) {
        this.print("/**");
        this.newline();
        this.toLeftMargin();
        this.print(" * ");
        for (DocTree docTree : node.getFirstSentence()) {
            this.doAccept((DCTree)docTree);
        }
        for (DocTree docTree : node.getBody()) {
            this.doAccept((DCTree)docTree);
        }
        for (DocTree docTree : node.getBlockTags()) {
            this.newline();
            this.toLeftMargin();
            this.print(" * ");
            this.doAccept((DCTree)docTree);
        }
        this.newline();
        this.toLeftMargin();
        this.print(" */");
        return null;
    }

    @Override
    public Void visitDocRoot(DocRootTree node, Void p) {
        this.print("{");
        this.printTagName(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visitStartElement(StartElementTree node, Void p) {
        this.print("<");
        this.print(node.getName());
        java.util.List<? extends DocTree> attrs = node.getAttributes();
        if (!attrs.isEmpty()) {
            this.print(" ");
            for (DocTree docTree : attrs) {
                this.doAccept((DCTree)docTree);
            }
            DocTree last = attrs.get(attrs.size() - 1);
            if (node.isSelfClosing() && last instanceof AttributeTree && ((AttributeTree)last).getValueKind() == AttributeTree.ValueKind.UNQUOTED) {
                this.print(" ");
            }
        }
        if (node.isSelfClosing()) {
            this.print("/");
        }
        this.print(">");
        return null;
    }

    @Override
    public Void visitEndElement(EndElementTree node, Void p) {
        this.print("</");
        this.print(node.getName());
        this.print(">");
        return null;
    }

    @Override
    public Void visitEntity(EntityTree node, Void p) {
        this.print("&");
        this.print(node.getName());
        this.print(";");
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree node, Void p) {
        this.print(node.getBody());
        return null;
    }

    @Override
    public Void visitHidden(HiddenTree node, Void p) {
        this.printTagName(node);
        if (!node.getBody().isEmpty()) {
            this.print(" ");
            for (DocTree docTree : node.getBody()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        this.print(node.getName());
        return null;
    }

    @Override
    public Void visitIndex(IndexTree node, Void p) {
        this.print("{");
        this.printTagName(node);
        this.print(" ");
        this.doAccept((DCTree)node.getSearchTerm());
        if (!node.getDescription().isEmpty()) {
            this.print(" ");
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        this.print("}");
        return null;
    }

    @Override
    public Void visitInheritDoc(InheritDocTree node, Void p) {
        this.print("{");
        this.printTagName(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visitLink(LinkTree node, Void p) {
        this.print("{");
        this.printTagName(node);
        this.print(" ");
        this.doAccept((DCTree)((Object)node.getReference()));
        if (!node.getLabel().isEmpty()) {
            this.print(" ");
            for (DocTree docTree : node.getLabel()) {
                this.doAccept((DCTree)docTree);
            }
        }
        this.print("}");
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree node, Void p) {
        this.print("{");
        this.printTagName(node);
        this.print(" ");
        this.doAccept((DCTree)((Object)node.getBody()));
        this.print("}");
        return null;
    }

    @Override
    public Void visitParam(ParamTree node, Void p) {
        this.printTagName(node);
        this.needSpace();
        if (node.isTypeParameter()) {
            this.print('<');
        }
        this.doAccept((DCTree)((Object)node.getName()));
        if (node.isTypeParameter()) {
            this.print('>');
        }
        if (!node.getDescription().isEmpty()) {
            this.needSpace();
        }
        for (DocTree docTree : node.getDescription()) {
            this.doAccept((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitProvides(ProvidesTree node, Void p) {
        this.printTagName(node);
        this.needSpace();
        this.doAccept((DCTree)((Object)node.getServiceType()));
        if (!node.getDescription().isEmpty()) {
            this.needSpace();
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitReference(ReferenceTree node, Void p) {
        DCTree.DCReference refNode = (DCTree.DCReference)node;
        if (refNode.qualifierExpression != null) {
            this.print(refNode.qualifierExpression);
        }
        if (refNode.memberName != null) {
            this.print("#");
            this.print(refNode.memberName);
        }
        if (refNode.paramTypes != null) {
            this.print("(");
            boolean first = true;
            for (Tree tree : refNode.paramTypes) {
                if (!first) {
                    this.print(", ");
                }
                this.print(tree.toString());
                first = false;
            }
            this.print(")");
        }
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        this.printTagName(node);
        this.print(" ");
        for (DocTree docTree : node.getDescription()) {
            this.doAccept((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitSee(SeeTree node, Void p) {
        this.printTagName(node);
        boolean first = true;
        boolean needSep = true;
        for (DocTree docTree : node.getReference()) {
            if (needSep) {
                this.print(" ");
            }
            needSep = first && docTree instanceof ReferenceTree;
            first = false;
            this.print((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitSerial(SerialTree node, Void p) {
        this.printTagName(node);
        if (!node.getDescription().isEmpty()) {
            this.print(" ");
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitSerialData(SerialDataTree node, Void p) {
        this.printTagName(node);
        if (!node.getDescription().isEmpty()) {
            this.print(" ");
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitSerialField(SerialFieldTree node, Void p) {
        this.printTagName(node);
        this.print(" ");
        this.print((DCTree)((Object)node.getName()));
        this.print(" ");
        this.print((DCTree)((Object)node.getType()));
        if (!node.getDescription().isEmpty()) {
            this.print(" ");
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitSince(SinceTree node, Void p) {
        this.printTagName(node);
        this.print(" ");
        for (DocTree docTree : node.getBody()) {
            this.doAccept((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitText(TextTree node, Void p) {
        this.print(node.getBody());
        return null;
    }

    @Override
    public Void visitThrows(ThrowsTree node, Void p) {
        this.printTagName(node);
        this.needSpace();
        this.doAccept((DCTree)((Object)node.getExceptionName()));
        if (!node.getDescription().isEmpty()) {
            this.needSpace();
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
        this.print("@");
        this.print(node.getTagName());
        this.print(" ");
        for (DocTree docTree : node.getContent()) {
            this.doAccept((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree node, Void p) {
        this.print("{");
        this.print("@");
        this.print(node.getTagName());
        this.print(" ");
        for (DocTree docTree : node.getContent()) {
            this.doAccept((DCTree)docTree);
        }
        this.print("}");
        return null;
    }

    @Override
    public Void visitUses(UsesTree node, Void p) {
        this.printTagName(node);
        this.needSpace();
        this.doAccept((DCTree)((Object)node.getServiceType()));
        if (!node.getDescription().isEmpty()) {
            this.needSpace();
            for (DocTree docTree : node.getDescription()) {
                this.doAccept((DCTree)docTree);
            }
        }
        return null;
    }

    @Override
    public Void visitValue(ValueTree node, Void p) {
        this.print("{");
        this.printTagName(node);
        if (node.getReference() != null) {
            this.print(" ");
            this.print((DCTree)((Object)node.getReference()));
        }
        this.print("}");
        return null;
    }

    @Override
    public Void visitVersion(VersionTree node, Void p) {
        this.printTagName(node);
        this.print(" ");
        for (DocTree docTree : node.getBody()) {
            this.doAccept((DCTree)docTree);
        }
        return null;
    }

    @Override
    public Void visitOther(DocTree node, Void p) {
        this.print("(UNKNOWN: " + node + ")");
        this.newline();
        return null;
    }

    private void adjustSpans(Iterable<? extends Tree> original, String code) {
        if (this.tree2Tag == null) {
            return;
        }
        LinkedList linearized = new LinkedList();
        if ((Boolean)new Linearize().scan(original, linearized) == false != Boolean.TRUE) {
            return;
        }
        ClassPath empty = ClassPathSupport.createClassPath((URL[])new URL[0]);
        ClasspathInfo cpInfo = ClasspathInfo.create(JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries(), empty, empty);
        JavacTaskImpl javacTask = JavacParser.createJavacTask(cpInfo, null, null, null, null, null, null, null, Arrays.asList(FileObjects.memoryFileObject("", "Scratch.java", code)));
        Context ctx = javacTask.getContext();
        JavaCompiler.instance((Context)ctx).genEndPos = true;
        CompilationUnitTree tree = javacTask.parse().iterator().next();
        DocSourcePositions sp = JavacTrees.instance(ctx).getSourcePositions();
        ClassTree clazz = (ClassTree)tree.getTypeDecls().get(0);
        new CopyTags(tree, sp).scan(clazz.getModifiers().getAnnotations(), linearized);
    }

    private static String whitespace(int num) {
        StringBuilder res = new StringBuilder(num);
        while (num-- > 0) {
            res.append(' ');
        }
        return res.toString();
    }

    private boolean printAnnotationsFormatted(List<JCTree.JCAnnotation> annotations) {
        if (this.reallyPrintAnnotations) {
            return false;
        }
        VeryPretty del = new VeryPretty(this.diffContext, this.cs, new HashMap(), this.tree2Doc, new HashMap(), this.origText, 0);
        del.reallyPrintAnnotations = true;
        del.printingMethodParams = this.printingMethodParams;
        del.printAnnotations(annotations);
        String str = del.out.toString();
        int col = this.printingMethodParams ? this.out.leftMargin + this.cs.getContinuationIndentSize() : this.out.col;
        str = Reformatter.reformat(str + " class A{}", this.cs, this.cs.getRightMargin() - col);
        str = str.trim().replace("\n", "\n" + VeryPretty.whitespace(col));
        try {
            this.adjustSpans(annotations, str);
        }
        catch (Exception e) {
            return false;
        }
        str = str.substring(0, str.lastIndexOf("class")).trim();
        this.print(str);
        return true;
    }

    private void printAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        if (this.printAnnotationsFormatted(annotations)) {
            if (!this.printingMethodParams) {
                this.toColExactly(this.out.leftMargin);
            } else {
                this.out.needSpace();
            }
            return;
        }
        while (annotations.nonEmpty()) {
            this.printNoParenExpr((JCTree)annotations.head);
            if (annotations.tail != null && annotations.tail.nonEmpty()) {
                switch (this.cs.wrapAnnotations()) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)annotations.tail.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.newline();
                        this.toColExactly(this.out.leftMargin);
                        break;
                    }
                    case WRAP_NEVER: {
                        this.print(' ');
                    }
                }
            } else if (!this.printingMethodParams) {
                this.toColExactly(this.out.leftMargin);
            }
            annotations = annotations.tail;
        }
    }

    public void printFlags(long flags) {
        this.printFlags(flags, true);
    }

    public void printFinallyBlock(JCTree.JCBlock finalizer) {
        if (this.cs.placeFinallyOnNewLine()) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeFinally()) {
            this.needSpace();
        }
        this.print("finally");
        this.printBlock((JCTree)finalizer, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeFinallyLeftBrace());
    }

    public void printFlags(long flags, boolean addSpace) {
        this.print(VeryPretty.flagNames(flags & 0xFFFFFFFFFFFFFDFFL & 0xFFFFFFFFFFFFDFFFL & 0xFFFFFFFFFFFFBFFFL));
        if ((flags & 0xFFFL) != 0L) {
            if (this.cs.placeNewLineAfterModifiers()) {
                this.toColExactly(this.out.leftMargin);
            } else if (addSpace) {
                this.needSpace();
            }
        }
    }

    public static String flagNames(long flags) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (Flags.Flag flag : Flags.asFlagSet(flags &= 0xC000080000000FFFL)) {
            buf.append(sep);
            String fname = flagLowerCaseNames[flag.ordinal()];
            buf.append(fname);
            sep = " ";
        }
        return buf.toString().trim();
    }

    public void printBlock(JCTree oldT, JCTree newT, Tree.Kind parentKind) {
        switch (parentKind) {
            case ENHANCED_FOR_LOOP: 
            case FOR_LOOP: {
                this.printIndentedStat(newT, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
                break;
            }
            case WHILE_LOOP: {
                this.printIndentedStat(newT, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
                break;
            }
            case IF: {
                this.printIndentedStat(newT, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
                break;
            }
            case DO_WHILE_LOOP: {
                this.printIndentedStat(newT, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
                if (this.cs.placeWhileOnNewLine()) {
                    this.newline();
                    this.toLeftMargin();
                    break;
                }
                if (!this.cs.spaceBeforeWhile()) break;
                this.needSpace();
            }
        }
    }

    public void printImportsBlock(java.util.List<? extends JCTree> imports, boolean maybeAppendNewLine) {
        boolean hasImports = !imports.isEmpty();
        CodeStyle.ImportGroups importGroups = null;
        if (hasImports) {
            this.blankLines(Math.max(this.cs.getBlankLinesBeforeImports(), this.diffContext.origUnit.getPackageName() != null ? this.cs.getBlankLinesAfterPackage() : 0));
            if (this.cs.separateImportGroups()) {
                importGroups = this.cs.getImportGroups();
            }
        }
        int lastGroup = -1;
        for (JCTree jCTree : imports) {
            if (importGroups != null) {
                int group;
                Name name = this.fullName(((JCTree.JCImport)jCTree).qualid);
                int n = group = name != null ? importGroups.getGroupId(name.toString(), ((JCTree.JCImport)jCTree).staticImport) : -1;
                if (lastGroup >= 0 && lastGroup != group) {
                    this.blankline();
                }
                lastGroup = group;
            }
            this.printStat(jCTree);
            this.newline();
        }
        if (hasImports && maybeAppendNewLine) {
            this.blankLines(this.cs.getBlankLinesAfterImports());
        }
    }

    public void eatChars(int count) {
        this.out.eatAwayChars(count);
    }

    private void printExpr(JCTree tree) {
        this.printExpr(tree, 0);
    }

    private void printNoParenExpr(JCTree tree) {
        while (tree instanceof JCTree.JCParens) {
            tree = ((JCTree.JCParens)tree).expr;
        }
        this.printExpr(tree, 0);
    }

    private void printExpr(JCTree tree, int prec) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            int prevPrec = this.prec;
            this.prec = prec;
            this.doAccept(tree, this.commentsEnabled);
            this.prec = prevPrec;
        }
    }

    private <T extends JCTree> void printExprs(List<T> trees) {
        String sep = this.cs.spaceBeforeComma() ? " ," : ",";
        this.printExprs(trees, this.cs.spaceAfterComma() ? sep + " " : sep);
    }

    private <T extends JCTree> void printExprs(List<T> trees, String sep) {
        if (trees.nonEmpty()) {
            this.printNoParenExpr((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printNoParenExpr((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    private void printStat(JCTree tree) {
        this.printStat(tree, false, false);
    }

    private void printStat(JCTree tree, boolean member, boolean first) {
        this.printStat(tree, member, first, false, false, false);
    }

    private void printStat(JCTree tree, boolean member, boolean first, boolean col, boolean nl, boolean printComments) {
        if (tree == null) {
            if (col) {
                this.toColExactly(this.out.leftMargin);
            }
            this.print(';');
            if (nl) {
                this.newline();
            }
        } else {
            if (!first) {
                this.blankLines(tree, true);
            }
            if (col) {
                this.toColExactly(this.out.leftMargin);
            }
            if (printComments) {
                this.printPrecedingComments(tree, !member);
            }
            this.printInnerCommentsAsTrailing(tree, !member);
            this.printExpr(tree, -1);
            int tag = tree.getTag().ordinal();
            if (JCTree.Tag.APPLY.ordinal() <= tag && tag <= JCTree.Tag.MOD_ASG.ordinal()) {
                this.print(';');
            }
            this.printTrailingComments(tree, !member);
            this.blankLines(tree, false);
            if (nl) {
                this.newline();
            }
        }
    }

    private void printIndentedStat(JCTree tree, CodeStyle.BracesGenerationStyle redundantBraces, boolean spaceBeforeLeftBrace, CodeStyle.WrapStyle wrapStat) {
        if (this.fromOffset >= 0 && this.toOffset >= 0 && (TreeInfo.getStartPos(tree) < this.fromOffset || TreeInfo.getEndPos(tree, this.diffContext.origUnit.endPositions) > this.toOffset)) {
            redundantBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
        }
        switch (redundantBraces) {
            case GENERATE: {
                this.printBlock(tree, this.cs.getOtherBracePlacement(), spaceBeforeLeftBrace);
                return;
            }
            case ELIMINATE: {
                List<JCTree.JCStatement> t;
                while (tree instanceof JCTree.JCBlock && !(t = ((JCTree.JCBlock)tree).stats).isEmpty() && !t.tail.nonEmpty() && !(t.head instanceof JCTree.JCVariableDecl)) {
                    this.printPrecedingComments(tree, true);
                    tree = (JCTree)t.head;
                }
            }
            case LEAVE_ALONE: {
                if (tree instanceof JCTree.JCBlock) {
                    this.printBlock(tree, this.cs.getOtherBracePlacement(), spaceBeforeLeftBrace);
                    return;
                }
                final int old = this.indent();
                final JCTree toPrint = tree;
                this.wrapTree(wrapStat, spaceBeforeLeftBrace, this.out.leftMargin, new Runnable(){

                    @Override
                    public void run() {
                        VeryPretty.this.printStat(toPrint);
                        VeryPretty.this.undent(old);
                    }
                });
            }
        }
    }

    private void printStats(List<? extends JCTree> trees) {
        this.printStats(trees, false);
    }

    private void printStats(List<? extends JCTree> trees, boolean members) {
        java.util.List<JCTree> filtered = CasualDiff.filterHidden(this.diffContext, trees);
        if (!filtered.isEmpty() && this.handlePossibleOldTrees(filtered, true)) {
            return;
        }
        boolean first = true;
        for (JCTree t : filtered) {
            this.printStat(t, members, first, true, false, false);
            first = false;
        }
    }

    private void printBlock(JCTree t, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace) {
        List<JCTree> stats;
        JCTree block;
        if (t instanceof JCTree.JCBlock) {
            block = t;
            stats = ((JCTree.JCBlock)t).stats;
        } else {
            block = null;
            stats = List.of(t);
        }
        this.printBlock(block, stats, bracePlacement, spaceBeforeLeftBrace, true);
    }

    private void printBlock(JCTree tree, List<? extends JCTree> stats, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace, boolean printComments) {
        this.printBlock(tree, stats, bracePlacement, spaceBeforeLeftBrace, false, printComments);
    }

    private void printBlock(JCTree tree, List<? extends JCTree> stats, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace, boolean members, boolean printComments) {
        int old;
        if (printComments) {
            this.printPrecedingComments(tree, true);
        }
        int bcol = old = this.indent();
        switch (bracePlacement) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(old);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                bcol = this.out.leftMargin;
                this.toColExactly(bcol);
            }
        }
        String trailing = null;
        if (this.conditionStartHack != -1) {
            boolean found;
            TokenSequence ts = TokenHierarchy.create((CharSequence)this.toString().substring(this.conditionStartHack), (Language)JavaTokenId.language()).tokenSequence(JavaTokenId.language());
            ts.moveEnd();
            while ((found = ts.movePrevious()) && PositionEstimator.nonRelevant.contains(ts.token().id())) {
            }
            if (found) {
                String content = this.toString();
                trailing = content.substring(this.conditionStartHack + ts.offset() + ts.token().text().length());
                this.out.used -= trailing.length();
                this.out.col -= trailing.length();
            }
        }
        if (spaceBeforeLeftBrace) {
            this.needSpace();
        }
        this.print('{');
        if (trailing != null) {
            this.print(trailing);
        }
        boolean emptyBlock = true;
        List<JCTree> l = stats;
        while (l.nonEmpty()) {
            if (!this.isSynthetic((JCTree)l.head)) {
                emptyBlock = false;
                break;
            }
            l = l.tail;
        }
        if (emptyBlock) {
            this.printEmptyBlockComments(tree, members);
        } else {
            if (this.innerCommentsHandled.add(tree)) {
                java.util.List<Comment> comments = this.commentHandler.getComments(tree).getComments(CommentSet.RelativePosition.INNER);
                for (Comment c : comments) {
                    this.printComment(c, false, members);
                }
            }
            if (members) {
                this.blankLines(this.cs.getBlankLinesAfterAnonymousClassHeader());
            } else {
                this.newline();
            }
            this.printStats(stats, members);
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
        if (printComments) {
            this.printTrailingComments(tree, true);
        }
    }

    private void printTypeParameters(List<JCTree.JCTypeParameter> trees) {
        if (trees.nonEmpty()) {
            this.print('<');
            this.printExprs(trees);
            this.print('>');
        }
    }

    private void printTypeArguments(List<? extends JCTree.JCExpression> typeargs) {
        if (typeargs.nonEmpty()) {
            this.print('<');
            this.printExprs(typeargs);
            this.print('>');
        }
    }

    private void printPrecedingComments(JCTree tree, boolean printWhitespace) {
        if (!this.precedingCommentsHandled.add(tree)) {
            return;
        }
        CommentSet commentSet = this.commentHandler.getComments(tree);
        java.util.List<Comment> pc = commentSet.getComments(CommentSet.RelativePosition.PRECEDING);
        DocCommentTree doc = this.tree2Doc.get(tree);
        if (!pc.isEmpty()) {
            Comment javadoc = null;
            for (Comment comment : pc) {
                if (comment.style() != Comment.Style.JAVADOC) continue;
                javadoc = comment;
            }
            for (Comment c : pc) {
                if (doc != null && c == javadoc) {
                    this.print((DCTree)((Object)doc));
                    doc = null;
                    continue;
                }
                this.printComment(c, true, printWhitespace);
            }
        }
        if (doc != null) {
            this.print((DCTree)((Object)doc));
        }
    }

    private void printInnerCommentsAsTrailing(JCTree tree, boolean printWhitespace) {
        if (this.innerCommentsHandled.contains(tree)) {
            return;
        }
        CommentSet commentSet = this.commentHandler.getComments(tree);
        java.util.List<Comment> cl = commentSet.getComments(CommentSet.RelativePosition.INNER);
        this.innerCommentsHandled.add(tree);
        for (Comment comment : cl) {
            this.printComment(comment, true, printWhitespace);
        }
    }

    private void printTrailingComments(JCTree tree, boolean printWhitespace) {
        if (this.trailingCommentsHandled.contains(tree)) {
            return;
        }
        CommentSet commentSet = this.commentHandler.getComments(tree);
        java.util.List<Comment> cl = commentSet.getComments(CommentSet.RelativePosition.INLINE);
        for (Comment comment : cl) {
            this.trailingCommentsHandled.add(tree);
            this.printComment(comment, true, printWhitespace);
        }
        java.util.List<Comment> tc = commentSet.getComments(CommentSet.RelativePosition.TRAILING);
        if (!tc.isEmpty()) {
            this.trailingCommentsHandled.add(tree);
            for (Comment c : tc) {
                this.printComment(c, false, printWhitespace);
            }
        }
    }

    private void printEmptyBlockComments(JCTree tree, boolean printWhitespace) {
        if (!this.innerCommentsHandled.add(tree)) {
            return;
        }
        java.util.List<Comment> comments = this.commentHandler.getComments(tree).getComments(CommentSet.RelativePosition.INNER);
        for (Comment c : comments) {
            this.printComment(c, false, printWhitespace);
        }
    }

    public void printComment(Comment comment, boolean preceding, boolean printWhitespace) {
        this.printComment(comment, preceding, printWhitespace, false);
    }

    public void printComment(Comment comment, boolean preceding, boolean printWhitespace, boolean preventClosingWhitespace) {
        boolean onlyWhitespaces = this.out.isWhitespaceLine();
        if (Comment.Style.WHITESPACE == comment.style()) {
            return;
        }
        String body = comment.getText();
        boolean rawBody = body.length() == 0 || body.charAt(0) != '/';
        LinkedList<CommentLine> lines = new LinkedList<CommentLine>();
        int stpos = -1;
        int limit = body.length();
        for (int i = 0; i < limit; ++i) {
            char c = body.charAt(i);
            if (c == '\n') {
                lines.add(new CommentLine(stpos, stpos < 0 ? 0 : i - stpos, body));
                stpos = -1;
                continue;
            }
            if (c <= ' ' || stpos >= 0) continue;
            stpos = i;
        }
        if (stpos >= 0 && stpos < limit) {
            lines.add(new CommentLine(stpos, limit - stpos, body));
        }
        if (comment.pos() > 0 && comment.endPos() < this.diffContext.origText.length() && this.diffContext.origText.substring(comment.pos() - 1, comment.endPos()).contentEquals("\n" + comment.getText())) {
            if (this.out.lastBlankLines == 0 && !preceding) {
                this.newline();
            }
            this.out.toLineStart();
        } else if (comment.indent() == 0) {
            if (!preceding && this.out.lastBlankLines == 0 && comment.style() != Comment.Style.LINE) {
                this.newline();
            }
            this.out.toLineStart();
        } else if (comment.indent() > 0 && !preceding) {
            if (this.out.lastBlankLines == 0 && comment.style() != Comment.Style.LINE) {
                this.newline();
            }
            this.toLeftMargin();
        } else if (comment.indent() < 0 && !preceding) {
            if (this.out.lastBlankLines == 0) {
                this.newline();
            }
            this.toLeftMargin();
        } else {
            this.needSpace();
        }
        if (rawBody) {
            switch (comment.style()) {
                case LINE: {
                    this.print("// ");
                    break;
                }
                case BLOCK: {
                    this.print("/* ");
                    break;
                }
                case JAVADOC: {
                    if (!onlyWhitespaces) {
                        this.newline();
                    }
                    this.toLeftMargin();
                    this.print("/**");
                    this.newline();
                    this.toLeftMargin();
                    this.print(" * ");
                }
            }
        }
        if (!lines.isEmpty()) {
            ((CommentLine)lines.removeFirst()).print(this.out.col);
        }
        while (!lines.isEmpty()) {
            this.newline();
            this.toLeftMargin();
            CommentLine line = (CommentLine)lines.removeFirst();
            if (rawBody) {
                this.print(" * ");
            } else if (line.body.charAt(line.startPos) == '*') {
                this.print(' ');
            }
            line.print(this.out.col);
        }
        if (rawBody) {
            switch (comment.style()) {
                case BLOCK: {
                    this.print(" */");
                    break;
                }
                case JAVADOC: {
                    this.newline();
                    this.toLeftMargin();
                    this.print(" */");
                    this.newline();
                    this.toLeftMargin();
                }
            }
        }
        if (onlyWhitespaces && !preventClosingWhitespace || comment.style() == Comment.Style.LINE) {
            this.newline();
            if (!preventClosingWhitespace) {
                this.toLeftMargin();
            }
        } else if (!preventClosingWhitespace) {
            this.needSpace();
        }
    }

    private void wrap(String s, CodeStyle.WrapStyle wrapStyle) {
        switch (wrapStyle) {
            case WRAP_IF_LONG: {
                if (s.length() + this.out.col <= this.cs.getRightMargin()) {
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                this.print(' ');
            }
        }
        this.print(s);
    }

    private <T extends JCTree> void wrapTrees(List<T> trees, CodeStyle.WrapStyle wrapStyle, int wrapIndent) {
        this.wrapTrees(trees, wrapStyle, wrapIndent, false);
    }

    private <T extends JCTree> void wrapTrees(List<T> trees, CodeStyle.WrapStyle wrapStyle, int wrapIndent, boolean wrapFirst) {
        this.wrapTrees(trees, wrapStyle, wrapIndent, wrapFirst, this.cs.spaceBeforeComma(), this.cs.spaceAfterComma(), ",");
    }

    private <T extends JCTree> void wrapTrees(List<T> trees, CodeStyle.WrapStyle wrapStyle, int wrapIndent, boolean wrapFirst, boolean spaceBeforeSeparator, boolean spaceAfterSeparator, String separator) {
        boolean first = true;
        List<Object> l = trees;
        while (l.nonEmpty()) {
            if (!first) {
                if (spaceBeforeSeparator) {
                    this.print(' ');
                }
                this.print(separator);
            }
            if (!first || wrapFirst) {
                switch (first && wrapStyle != CodeStyle.WrapStyle.WRAP_NEVER ? CodeStyle.WrapStyle.WRAP_IF_LONG : wrapStyle) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        boolean space = spaceAfterSeparator && !first;
                        if (this.widthEstimator.estimateWidth((JCTree)l.head, rm - this.out.col) + this.out.col + (space ? 1 : 0) <= rm) {
                            if (!space) break;
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.newline();
                        this.toColExactly(wrapIndent);
                        break;
                    }
                    case WRAP_NEVER: {
                        if (!spaceAfterSeparator || first) break;
                        this.print(' ');
                    }
                }
            }
            this.printNoParenExpr((JCTree)l.head);
            first = false;
            l = l.tail;
        }
    }

    private void wrapAssignOpTree(final String operator, int col, final Runnable print) {
        final boolean spaceAroundAssignOps = this.cs.spaceAroundAssignOps();
        if (this.cs.wrapAfterAssignOps()) {
            if (spaceAroundAssignOps) {
                this.print(' ');
            }
            this.print(operator);
        }
        this.wrapTree(this.cs.wrapAssignOps(), spaceAroundAssignOps, this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize(), new Runnable(){

            @Override
            public void run() {
                if (!VeryPretty.this.cs.wrapAfterAssignOps()) {
                    VeryPretty.this.print(operator);
                    if (spaceAroundAssignOps) {
                        VeryPretty.this.print(' ');
                    }
                }
                print.run();
            }
        });
    }

    private void wrapTree(CodeStyle.WrapStyle wrapStyle, boolean needsSpaceBefore, int colAfterWrap, Runnable print) {
        switch (wrapStyle) {
            case WRAP_NEVER: {
                if (needsSpaceBefore) {
                    this.needSpace();
                }
                print.run();
                return;
            }
            case WRAP_IF_LONG: {
                int oldhm = this.out.harden();
                int oldc = this.out.col;
                int oldu = this.out.used;
                int oldm = this.out.leftMargin;
                int oldPrec = this.prec;
                try {
                    if (needsSpaceBefore) {
                        this.needSpace();
                    }
                    print.run();
                    this.out.restore(oldhm);
                    return;
                }
                catch (Throwable t) {
                    this.out.restore(oldhm);
                    this.out.col = oldc;
                    this.out.used = oldu;
                    this.out.leftMargin = oldm;
                    this.prec = oldPrec;
                }
            }
            case WRAP_ALWAYS: {
                if (this.out.col > 0) {
                    this.newline();
                }
                this.toColExactly(colAfterWrap);
                print.run();
            }
        }
    }

    public Name fullName(JCTree tree) {
        switch (tree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)tree).name;
            }
            case SELECT: {
                JCTree.JCFieldAccess sel = (JCTree.JCFieldAccess)tree;
                Name sname = this.fullName(sel.selected);
                return sname != null && sname.getByteLength() > 0 ? sname.append('.', sel.name) : sel.name;
            }
        }
        return null;
    }

    private boolean isSynthetic(JCTree tree) {
        if (tree.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L;
        }
        if (tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && this.diffContext.origUnit != null) {
            JCTree.JCExpressionStatement est = (JCTree.JCExpressionStatement)tree;
            if (est.expr.getKind() == Tree.Kind.METHOD_INVOCATION) {
                JCTree.JCMethodInvocation mit = (JCTree.JCMethodInvocation)est.getExpression();
                if (mit.meth.getKind() == Tree.Kind.IDENTIFIER) {
                    JCTree.JCIdent it = (JCTree.JCIdent)mit.getMethodSelect();
                    return it.name == this.names._super && this.diffContext.syntheticTrees.contains(tree);
                }
            }
        }
        return false;
    }

    private static boolean isEnumerator(JCTree tree) {
        return tree.getTag() == JCTree.Tag.VARDEF && (((JCTree.JCVariableDecl)tree).mods.flags & 0x4000L) != 0L;
    }

    private String replace(String a, String b) {
        a = a.replace(b, this.out.toString());
        this.out.clear();
        return a;
    }

    static {
        for (TypeTag typeTag : TypeTag.values()) {
            VeryPretty.typeTagNames[typeTag.ordinal()] = typeTag.name().toLowerCase(Locale.ENGLISH);
        }
        flagLowerCaseNames = new String[Flags.Flag.values().length];
        for (Enum enum_ : Flags.Flag.values()) {
            VeryPretty.flagLowerCaseNames[enum_.ordinal()] = enum_.name().toLowerCase(Locale.ENGLISH);
        }
    }

    private class CommentLine {
        private int startPos;
        private int length;
        private String body;

        CommentLine(int sp, int l, String b) {
            this.length = l;
            this.startPos = this.length == 0 ? 0 : sp;
            this.body = b;
        }

        public void print(int col) {
            if (this.length > 0) {
                int limit = this.startPos + this.length;
                for (int i = this.startPos; i < limit; ++i) {
                    VeryPretty.this.out.append(this.body.charAt(i));
                }
            }
        }
    }

    private final class CopyTags
    extends ErrorAwareTreeScanner<Void, java.util.List<Tree>> {
        private final CompilationUnitTree fake;
        private final SourcePositions sp;

        public CopyTags(CompilationUnitTree fake, SourcePositions sp) {
            this.fake = fake;
            this.sp = sp;
        }

        @Override
        public Void scan(Tree node, java.util.List<Tree> p) {
            if (p.isEmpty()) {
                return null;
            }
            Object tag = VeryPretty.this.tree2Tag.get(p.remove(0));
            if (tag != null) {
                VeryPretty.this.tag2Span.put(tag, new int[]{VeryPretty.this.out.length() + VeryPretty.this.initialOffset + (int)this.sp.getStartPosition(this.fake, node), VeryPretty.this.out.length() + VeryPretty.this.initialOffset + (int)this.sp.getEndPosition(this.fake, node)});
            }
            return (Void)super.scan(node, p);
        }
    }

    private final class Linearize
    extends ErrorAwareTreeScanner<Boolean, java.util.List<Tree>> {
        private Linearize() {
        }

        @Override
        public Boolean scan(Tree node, java.util.List<Tree> p) {
            p.add(node);
            super.scan(node, p);
            return VeryPretty.this.tree2Tag.containsKey(node);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
        }
    }
}

