/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CheckSums {
    private static final String CHECK_SUMS_FILE = "checksums.properties";
    private static final String DEPRECATED = "DEPRECATED";
    private final Context context;
    private final Properties props = new Properties();
    private final MessageDigest md;

    public static CheckSums forContext(Context context) throws IOException, NoSuchAlgorithmException {
        return new CheckSums(context);
    }

    private CheckSums(Context context) throws IOException, NoSuchAlgorithmException {
        assert (context != null);
        this.context = context;
        this.md = MessageDigest.getInstance("MD5");
        this.load();
    }

    public boolean checkAndSet(URL file, Iterable<? extends TypeElement> topLevelElements, Elements elements) {
        String sum;
        String fileId = file.toExternalForm();
        String value = (String)this.props.setProperty(fileId, sum = CheckSums.computeCheckSum(this.md, topLevelElements, elements));
        return value == null || value.equals(sum);
    }

    public void remove(URL file) {
        String fileId = file.toExternalForm();
        this.props.remove(fileId);
    }

    public void store() throws IOException {
        File indexDir = FileUtil.toFile((FileObject)this.context.getIndexFolder());
        File f = new File(indexDir, CHECK_SUMS_FILE);
        try (FileOutputStream out = new FileOutputStream(f);){
            this.props.store(out, "");
        }
    }

    private void load() throws IOException {
        File indexDir = FileUtil.toFile((FileObject)this.context.getIndexFolder());
        File f = new File(indexDir, CHECK_SUMS_FILE);
        if (f.canRead()) {
            try (FileInputStream in = new FileInputStream(f);){
                this.props.load(in);
            }
            catch (IllegalArgumentException iae) {
                this.props.clear();
            }
        }
    }

    static String computeCheckSum(MessageDigest md, Iterable<? extends TypeElement> topLevelElements, Elements elements) {
        LinkedList<TypeElement> toHandle = new LinkedList<TypeElement>();
        for (TypeElement typeElement : topLevelElements) {
            toHandle.offer(typeElement);
        }
        ArrayList<String> sigs = new ArrayList<String>();
        while (!toHandle.isEmpty()) {
            Element element = (Element)toHandle.poll();
            if (element == null) continue;
            sigs.add(String.valueOf(element.asType()) + CheckSums.getExtendedModifiers(elements, element));
            for (Element element2 : element.getEnclosedElements()) {
                switch (element2.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        if (element2.getModifiers().contains((Object)Modifier.PRIVATE)) break;
                        toHandle.offer((TypeElement)element2);
                        break;
                    }
                    case CONSTRUCTOR: 
                    case METHOD: 
                    case FIELD: 
                    case ENUM_CONSTANT: {
                        if (element2.getModifiers().contains((Object)Modifier.PRIVATE)) break;
                        StringBuilder sb = new StringBuilder();
                        sb.append(element2.getSimpleName());
                        sb.append(String.valueOf(element2.asType()));
                        sb.append(CheckSums.getExtendedModifiers(elements, element2));
                        sigs.add(sb.toString());
                    }
                }
            }
        }
        Collections.sort(sigs);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : sigs) {
            stringBuilder.append(string);
        }
        byte[] bytes = md.digest(stringBuilder.toString().getBytes());
        return new String(bytes);
    }

    private static String getExtendedModifiers(Elements elements, Element el) {
        Object v;
        StringBuilder sb = new StringBuilder();
        for (Modifier m : el.getModifiers()) {
            sb.append(m.name());
        }
        if (elements.isDeprecated(el)) {
            sb.append(DEPRECATED);
        }
        if (el.getKind() == ElementKind.FIELD && (v = ((VariableElement)el).getConstantValue()) != null) {
            sb.append(v.getClass().getName());
            sb.append(String.valueOf(v));
        }
        return sb.toString();
    }
}

