/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.java.lsp.server.progress.LspInternalHandle;
import org.netbeans.modules.java.lsp.server.progress.LspProgressUIWorker;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEnvironment;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class AbstractProgressEnvironment
implements ProgressEnvironment {
    private static final String[] MASK_CANCELLABLES = new String[]{"org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater$"};
    private static final Controller NO_CONTEXT_CONTROLLER = new Controller(null);
    private final Lookup env;
    private Pattern patternMaskingCancellables;

    protected AbstractProgressEnvironment() {
        this(Lookups.proxy(() -> Lookup.getDefault()));
    }

    protected AbstractProgressEnvironment(Lookup env) {
        this.env = env;
    }

    Pattern maskCancellablesPattern() {
        if (this.patternMaskingCancellables == null) {
            StringBuilder re = new StringBuilder();
            for (String pref : MASK_CANCELLABLES) {
                if (re.length() > 0) {
                    re.append("|");
                }
                re.append(Pattern.quote(pref) + ".*");
            }
            this.patternMaskingCancellables = Pattern.compile(re.toString());
        }
        return this.patternMaskingCancellables;
    }

    public ProgressHandle createHandle(String displayname, Cancellable c, boolean userInit) {
        NbCodeLanguageClient client = (NbCodeLanguageClient)this.env.lookup(NbCodeLanguageClient.class);
        OperationContext ctx = OperationContext.find(this.env);
        if (client == null) {
            if (ctx == null) {
                return new NoContextHandle(displayname, c, userInit).createProgressHandle();
            }
            client = ctx.getClient();
        }
        if (c != null && this.maskCancellablesPattern().matcher(c.getClass().getName()).matches()) {
            c = null;
        }
        return new LspInternalHandle(ctx, client, this::findController, displayname, c, userInit).createProgressHandle();
    }

    public Controller findController(InternalHandle h) {
        if (!(h instanceof LspInternalHandle)) {
            return this.getController();
        }
        OperationContext ctx = ((LspInternalHandle)h).getContext();
        NbCodeLanguageClient client = ctx.getClient();
        if (client == null) {
            return this.getController();
        }
        return new Controller((ProgressUIWorker)new LspProgressUIWorker());
    }

    public Controller getController() {
        NbCodeLanguageClient client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class);
        if (client == null) {
            return NO_CONTEXT_CONTROLLER;
        }
        return new Controller((ProgressUIWorker)new LspProgressUIWorker());
    }

    static class NoContextHandle
    extends InternalHandle {
        public NoContextHandle(String displayName, Cancellable cancel, boolean userInitiated) {
            super(displayName, cancel, userInitiated);
        }

        public synchronized void start(String message, int workunits, long estimate) {
            try {
                this.setController(NO_CONTEXT_CONTROLLER);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            super.start(message, workunits, estimate);
        }
    }
}

