/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

public final class IntroduceCodeActions
extends CodeActionsProvider {
    private static final Set<String> SUPPORTED_CODE_ACTION_KINDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("refactor.extract")));

    @Override
    public Set<String> getSupportedCodeActionKinds() {
        return SUPPORTED_CODE_ACTION_KINDS;
    }

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        Range range = params.getRange();
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        if (client.getNbCodeCapabilities().wantsJavaSupport() && !range.getStart().equals((Object)range.getEnd())) {
            CompilationController cc;
            CompilationController compilationController = cc = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
            if (cc != null) {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                StyledDocument doc = (StyledDocument)cc.getDocument();
                int startOffset = Utils.getOffset(doc, range.getStart());
                int endOffset = Utils.getOffset(doc, range.getEnd());
                for (ErrorDescription err : IntroduceHint.computeError((CompilationInfo)cc, (int)startOffset, (int)endOffset, new EnumMap(IntroduceKind.class), new EnumMap(IntroduceKind.class), (AtomicBoolean)new AtomicBoolean())) {
                    for (Fix fix : err.getFixes().getFixes()) {
                        if (!(fix instanceof IntroduceFixBase)) continue;
                        try {
                            ModificationResult changes = ((IntroduceFixBase)fix).getModificationResult();
                            if (changes == null) continue;
                            ArrayList<Either> documentChanges = new ArrayList<Either>();
                            Set fos = changes.getModifiedFileObjects();
                            if (fos.size() != 1) continue;
                            FileObject fileObject = (FileObject)fos.iterator().next();
                            List diffs = changes.getDifferences(fileObject);
                            if (diffs != null) {
                                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                                for (ModificationResult.Difference diff : diffs) {
                                    String newText = diff.getNewText();
                                    edits.add(new TextEdit(new Range(Utils.createPosition(fileObject, diff.getStartPosition().getOffset()), Utils.createPosition(fileObject, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                                }
                                documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(fileObject), Integer.valueOf(-1)), edits)));
                            }
                            CodeAction codeAction = new CodeAction(fix.getText());
                            codeAction.setKind("refactor.extract");
                            codeAction.setEdit(new WorkspaceEdit(documentChanges));
                            int renameOffset = ((IntroduceFixBase)fix).getNameOffset(changes);
                            if (renameOffset >= 0) {
                                codeAction.setCommand(new Command("Rename", client.getNbCodeCapabilities().getCommandPrefix() + ".rename.element.at", Collections.singletonList(renameOffset)));
                            }
                            result.add(codeAction);
                        }
                        catch (GeneratorUtils.DuplicateMemberException duplicateMemberException) {}
                    }
                }
            }
        }
        return result;
    }
}

