/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.commands;

import com.google.gson.JsonPrimitive;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.gototest.TestOppositesLocator;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.filesystems.FileObject;

public class TestOppositesCommandProvider
implements CommandProvider {
    private static final String NBLS_GO_TO_TEST = "nbls.go.to.test";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("nbls.go.to.test"));

    public Set<String> getCommands() {
        return COMMANDS;
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        switch (command) {
            case "nbls.go.to.test": {
                try {
                    String source = ((JsonPrimitive)arguments.get(0)).getAsString();
                    FileObject file = Utils.fromUri(source);
                    return TestOppositesLocator.getDefault().findOpposites(file, -1).thenApply(locations -> locations);
                }
                catch (MalformedURLException ex) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
            }
        }
        throw new UnsupportedOperationException("Command not supported: " + command);
    }
}

