/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TelemetryEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class LspServerTelemetryManager {
    public final String SCAN_START_EVT = "SCAN_START_EVT";
    public final String SCAN_END_EVT = "SCAN_END_EVT";
    public final String WORKSPACE_INFO_EVT = "WORKSPACE_INFO_EVT";
    private final String ENABLE_PREVIEW = "--enable-preview";
    private final String STANDALONE_PRJ = "Standalone";
    private final WeakHashMap<LanguageClient, Future<Void>> clients = new WeakHashMap();
    private long lspServerIntiailizationTime;

    public synchronized void connect(LanguageClient client, Future<Void> future) {
        this.clients.put(client, future);
        this.lspServerIntiailizationTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendTelemetry(TelemetryEvent event) {
        HashSet<LanguageClient> toRemove = new HashSet<LanguageClient>();
        ArrayList<LanguageClient> toSendTelemetry = new ArrayList<LanguageClient>();
        WeakHashMap<LanguageClient, Future<Void>> weakHashMap = this.clients;
        synchronized (weakHashMap) {
            for (Map.Entry<LanguageClient, Future<Void>> entry : this.clients.entrySet()) {
                if (entry.getValue().isDone()) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                toSendTelemetry.add(entry.getKey());
            }
            this.clients.keySet().removeAll(toRemove);
        }
        for (LanguageClient client : toSendTelemetry) {
            client.telemetryEvent((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTelemetry(LanguageClient client, TelemetryEvent event) {
        boolean shouldSendTelemetry = false;
        WeakHashMap<LanguageClient, Future<Void>> weakHashMap = this.clients;
        synchronized (weakHashMap) {
            if (this.clients.containsKey(client)) {
                if (this.clients.get(client).isDone()) {
                    this.clients.remove(client);
                } else {
                    shouldSendTelemetry = true;
                }
            }
        }
        if (shouldSendTelemetry) {
            client.telemetryEvent((Object)event);
        }
    }

    public void sendWorkspaceInfo(LanguageClient client, List<FileObject> workspaceClientFolders, Collection<Project> prjs, long timeToOpenPrjs) {
        JsonObject properties = new JsonObject();
        JsonArray prjProps = new JsonArray();
        Map<String, Project> mp = prjs.stream().collect(Collectors.toMap(project -> project.getProjectDirectory().getPath(), project -> project));
        for (FileObject workspaceFolder : workspaceClientFolders) {
            try {
                JsonObject obj = new JsonObject();
                String prjPath = workspaceFolder.getPath();
                String prjId = this.getPrjId(prjPath);
                obj.addProperty("id", prjId);
                obj.addProperty("javaVersion", System.getProperty("java.version"));
                if (mp.containsKey(prjPath)) {
                    Project prj = mp.get(prjPath);
                    ProjectManager.Result r = ProjectManager.getDefault().isProject2(prj.getProjectDirectory());
                    String projectType = r.getProjectType();
                    obj.addProperty("buildTool", projectType.contains("maven") ? "MavenProject" : "GradleProject");
                    obj.addProperty("openedWithProblems", Boolean.valueOf(ProjectProblems.isBroken((Project)prj)));
                    boolean isPreviewFlagEnabled = this.isEnablePreivew(prj.getProjectDirectory(), projectType);
                    obj.addProperty("enablePreview", Boolean.valueOf(isPreviewFlagEnabled));
                } else {
                    obj.addProperty("buildTool", this.STANDALONE_PRJ);
                    obj.addProperty("javaVersion", System.getProperty("java.version"));
                    obj.addProperty("openedWithProblems", Boolean.valueOf(false));
                    boolean isPreviewFlagEnabled = this.isEnablePreivew(workspaceFolder, this.STANDALONE_PRJ);
                    obj.addProperty("enablePreview", Boolean.valueOf(isPreviewFlagEnabled));
                }
                prjProps.add((JsonElement)obj);
            }
            catch (NoSuchAlgorithmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        properties.add("prjsInfo", (JsonElement)prjProps);
        properties.addProperty("timeToOpenPrjs", (Number)timeToOpenPrjs);
        properties.addProperty("numOfPrjsOpened", (Number)workspaceClientFolders.size());
        properties.addProperty("lspServerInitializationTime", (Number)(System.currentTimeMillis() - this.lspServerIntiailizationTime));
        this.sendTelemetry(client, new TelemetryEvent(MessageType.Info.toString(), this.WORKSPACE_INFO_EVT, properties));
    }

    private boolean isEnablePreivew(FileObject source, String prjType) {
        if (prjType.equals(this.STANDALONE_PRJ)) {
            NbCodeLanguageClient client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class);
            if (client == null) {
                return false;
            }
            AtomicBoolean isEnablePreviewSet = new AtomicBoolean(false);
            ConfigurationItem conf = new ConfigurationItem();
            conf.setSection(client.getNbCodeCapabilities().getAltConfigurationPrefix() + "runConfig.vmOptions");
            client.configuration(new ConfigurationParams(Collections.singletonList(conf))).thenAccept(c -> {
                String config = ((JsonPrimitive)c.get(0)).getAsString();
                isEnablePreviewSet.set(config.contains(this.ENABLE_PREVIEW));
            });
            return isEnablePreviewSet.get();
        }
        CompilerOptionsQuery.Result result = CompilerOptionsQuery.getOptions((FileObject)source);
        return result.getArguments().contains(this.ENABLE_PREVIEW);
    }

    private String getPrjId(String prjPath) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(prjPath.getBytes(StandardCharsets.UTF_8));
        BigInteger number = new BigInteger(1, hash);
        StringBuilder hexString = new StringBuilder(number.toString(16));
        while (hexString.length() < 64) {
            hexString.insert(0, '0');
        }
        return hexString.toString();
    }
}

