/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;

public class DBConnectionProvider
extends CodeActionsProvider {
    private static final Logger LOG = Logger.getLogger(DBConnectionProvider.class.getName());
    private static final String GET_DB_CONNECTION = "nbls.db.connection";
    private static final boolean POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    private static final EnumSet<PosixFilePermission> readWritePosix = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
    private static final EnumSet<AclEntryPermission> readOnlyAcl = EnumSet.of(AclEntryPermission.READ_ACL, new AclEntryPermission[]{AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.DELETE, AclEntryPermission.SYNCHRONIZE});
    private static final Path tmpdir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);

    public DBConnectionProvider() {
        try {
            DBConnectionProvider.deleteOldFiles(DBConnectionProvider.generateDirPath());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "deleteOldFiles", ex);
        }
    }

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        HashMap<String, String> result = new HashMap<String, String>();
        CompletableFuture<Object> ret = new CompletableFuture<Object>();
        Properties dbProps = new Properties();
        DatabaseConnection conn = ConnectionManager.getDefault().getPreferredConnection(true);
        if (conn != null) {
            Path temp = null;
            Path dir = DBConnectionProvider.generateDirPath();
            try {
                if (!Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                if (POSIX) {
                    FileAttribute<Set<PosixFilePermission>> readWriteAttribs = PosixFilePermissions.asFileAttribute(readWritePosix);
                    temp = Files.createTempFile(dir, "db-", ".properties", readWriteAttribs);
                } else {
                    temp = Files.createTempFile(dir, "db-", ".properties", new FileAttribute[0]);
                    AclFileAttributeView acl = Files.getFileAttributeView(temp, AclFileAttributeView.class, new LinkOption[0]);
                    AclEntry ownerEntry = null;
                    for (AclEntry e : acl.getAcl()) {
                        if (!e.principal().equals(acl.getOwner())) continue;
                        ownerEntry = e;
                        break;
                    }
                    if (ownerEntry == null) {
                        DBConnectionProvider.deleteTempFile(temp);
                        ret.completeExceptionally(new IOException("Owner missing, file:" + temp.toString()));
                        return ret;
                    }
                    acl.setAcl(Collections.singletonList(ownerEntry));
                }
            }
            catch (IOException ex) {
                DBConnectionProvider.deleteTempFile(temp);
                ret.completeExceptionally(ex);
                return ret;
            }
            try (FileWriter writer = new FileWriter(temp.toFile(), Charset.defaultCharset());){
                BasicFileAttributeView attribs;
                dbProps.put("datasources.default.url", conn.getDatabaseURL());
                dbProps.put("datasources.default.username", conn.getUser());
                dbProps.put("datasources.default.password", conn.getPassword());
                dbProps.put("datasources.default.driverClassName", conn.getDriverClass());
                String ocid = (String)conn.getConnectionProperties().get("OCID");
                if (ocid != null && !ocid.isEmpty()) {
                    dbProps.put("datasources.default.ocid", ocid);
                }
                dbProps.store(writer, "");
                if (POSIX) {
                    attribs = Files.getFileAttributeView(temp, PosixFileAttributeView.class, new LinkOption[0]);
                    attribs.setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ));
                } else {
                    attribs = Files.getFileAttributeView(temp, DosFileAttributeView.class, new LinkOption[0]);
                    attribs.setReadOnly(true);
                    AclFileAttributeView acl = Files.getFileAttributeView(temp, AclFileAttributeView.class, new LinkOption[0]);
                    AclEntry ownerEntry = null;
                    if (acl.getAcl().size() != 1) {
                        DBConnectionProvider.deleteTempFile(temp);
                        ret.completeExceptionally(new IOException("Too many Acls, file:" + temp.toString()));
                        CompletableFuture<Object> completableFuture = ret;
                        return completableFuture;
                    }
                    for (AclEntry e : acl.getAcl()) {
                        if (!e.principal().equals(acl.getOwner())) continue;
                        ownerEntry = e;
                        break;
                    }
                    if (ownerEntry == null) {
                        DBConnectionProvider.deleteTempFile(temp);
                        ret.completeExceptionally(new IOException("Owner missing, file:" + temp.toString()));
                        CompletableFuture<Object> completableFuture = ret;
                        return completableFuture;
                    }
                    AclEntry readOnly = AclEntry.newBuilder(ownerEntry).setPermissions(readOnlyAcl).build();
                    acl.setAcl(Collections.singletonList(readOnly));
                }
                temp.toFile().deleteOnExit();
                result.put("MICRONAUT_CONFIG_FILES", temp.toAbsolutePath().toString());
            }
            catch (IOException ex) {
                DBConnectionProvider.deleteTempFile(temp);
                ret.completeExceptionally(ex);
                return ret;
            }
        }
        ret.complete(result);
        return ret;
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(GET_DB_CONNECTION);
    }

    private static Path generateDirPath() {
        String s = "nbls.db.connection_" + System.getProperty("user.name");
        Path name = tmpdir.getFileSystem().getPath(s, new String[0]);
        return tmpdir.resolve(name);
    }

    private static void deleteOldFiles(Path dir) throws IOException {
        if (Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path f : stream) {
                    DBConnectionProvider.deleteTempFile(f);
                }
            }
        }
    }

    private static void deleteTempFile(Path temp) {
        if (temp != null && Files.isRegularFile(temp, LinkOption.NOFOLLOW_LINKS)) {
            try {
                if (POSIX) {
                    PosixFileAttributeView attribs = Files.getFileAttributeView(temp, PosixFileAttributeView.class, new LinkOption[0]);
                    attribs.setPermissions(readWritePosix);
                } else {
                    DosFileAttributeView attribs = Files.getFileAttributeView(temp, DosFileAttributeView.class, new LinkOption[0]);
                    attribs.setReadOnly(false);
                }
                Files.delete(temp);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "deleteTempFile", ex);
            }
        }
    }
}

