/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.lsp4j.CallHierarchyRegistrationOptions;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FoldingRangeProviderOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.SemanticTokensCapabilities;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkDoneProgressCancelParams;
import org.eclipse.lsp4j.WorkDoneProgressParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.WorkspaceSymbolOptions;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.LspGsonSetup;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.explorer.LspTreeViewServiceImpl;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangedParams;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeViewService;
import org.netbeans.modules.java.lsp.server.files.OpenedDocuments;
import org.netbeans.modules.java.lsp.server.input.InputService;
import org.netbeans.modules.java.lsp.server.input.LspInputServiceImpl;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.DecorationRenderOptions;
import org.netbeans.modules.java.lsp.server.protocol.HtmlPageParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientCapabilities;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientWrapper;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.NbLanguageServer;
import org.netbeans.modules.java.lsp.server.protocol.NbLspServer;
import org.netbeans.modules.java.lsp.server.protocol.SetTextEditorDecorationParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowStatusMessageParams;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.java.lsp.server.protocol.UpdateConfigParams;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceIOContext;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceServiceImpl;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceUIContext;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Server {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    static final ThreadLocal<NbCodeLanguageClient> DISPATCHERS = new ThreadLocal();
    public static final String NBLS_BUILD_WORKSPACE = "nbls.build.workspace";
    public static final String NBLS_CLEAN_WORKSPACE = "nbls.clean.workspace";
    public static final String JAVA_NEW_FROM_TEMPLATE = "java.new.from.template";
    public static final String JAVA_NEW_PROJECT = "java.new.project";
    public static final String JAVA_GET_PROJECT_SOURCE_ROOTS = "java.get.project.source.roots";
    public static final String JAVA_GET_PROJECT_CLASSPATH = "java.get.project.classpath";
    public static final String JAVA_GET_PROJECT_PACKAGES = "java.get.project.packages";
    public static final String JAVA_LOAD_WORKSPACE_TESTS = "java.load.workspace.tests";
    public static final String JAVA_RESOLVE_STACKTRACE_LOCATION = "java.resolve.stacktrace.location";
    public static final String JAVA_SUPER_IMPLEMENTATION = "java.super.implementation";
    public static final String GRAALVM_PAUSE_SCRIPT = "graalvm.pause.script";
    public static final String JAVA_RUN_PROJECT_ACTION = "java.project.run.action";
    public static final String JAVA_FIND_PROJECT_CONFIGURATIONS = "java.project.configurations";
    public static final String JAVA_FIND_DEBUG_ATTACH_CONFIGURATIONS = "java.attachDebugger.configurations";
    public static final String JAVA_FIND_DEBUG_PROCESS_TO_ATTACH = "java.attachDebugger.pickProcess";
    public static final String NATIVE_IMAGE_FIND_DEBUG_PROCESS_TO_ATTACH = "nativeImage.attachDebugger.pickProcess";
    public static final String JAVA_PROJECT_CONFIGURATION_COMPLETION = "java.project.configuration.completion";
    public static final String JAVA_PROJECT_RESOLVE_PROJECT_PROBLEMS = "java.project.resolveProjectProblems";
    public static final String JAVA_CLEAR_PROJECT_CACHES = "java.clear.project.caches";
    public static final String JAVA_PROJECT_INFO = "nbls.project.info";
    public static final String JAVA_ENABLE_PREVIEW = "java.project.enable.preview";
    static final String INDEXING_COMPLETED = "Indexing completed.";
    static final String NO_JAVA_SUPPORT = "Cannot initialize Java support on JDK ";
    static final NbCodeLanguageClient STUB_CLIENT = new NbCodeLanguageClient(){
        private final NbCodeClientCapabilities caps = new NbCodeClientCapabilities();

        private void logWarning(Object ... args) {
            LOG.log(Level.WARNING, "LSP Client called without proper context with param(s): {0}", Arrays.asList(args));
        }

        @Override
        public void showStatusBarMessage(ShowStatusMessageParams params) {
            this.logWarning(new Object[]{params});
        }

        @Override
        public CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(params.getCanPickMany() || params.getItems().isEmpty() ? params.getItems() : Collections.singletonList(params.getItems().get(0)));
        }

        @Override
        public CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(params.getValue());
        }

        @Override
        public CompletableFuture<Map<String, Either<List<QuickPickItem>, String>>> showMultiStepInput(ShowMutliStepInputParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void notifyTestProgress(TestProgressParams params) {
            this.logWarning(params);
        }

        @Override
        public NbCodeClientCapabilities getNbCodeCapabilities() {
            this.logWarning(new Object[0]);
            return this.caps;
        }

        public void telemetryEvent(Object object) {
            this.logWarning(object);
        }

        public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
            this.logWarning(diagnostics);
        }

        public void showMessage(MessageParams messageParams) {
            this.logWarning(messageParams);
        }

        public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
            this.logWarning(requestParams);
            CompletableFuture<MessageActionItem> x = new CompletableFuture<MessageActionItem>();
            x.complete(null);
            return x;
        }

        @Override
        public CompletableFuture<String> createTextEditorDecoration(DecorationRenderOptions params) {
            this.logWarning(params);
            CompletableFuture<String> x = new CompletableFuture<String>();
            x.complete(null);
            return x;
        }

        @Override
        public void setTextEditorDecoration(SetTextEditorDecorationParams params) {
            this.logWarning(params);
        }

        @Override
        public void disposeTextEditorDecoration(String params) {
            this.logWarning(params);
        }

        public void logMessage(MessageParams message) {
            this.logWarning(message);
        }

        @Override
        public void notifyNodeChange(NodeChangedParams params) {
            this.logWarning(params);
        }

        @Override
        public CompletableFuture<String> showHtmlPage(HtmlPageParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<String> execInHtmlPage(HtmlPageParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> configurationUpdate(UpdateConfigParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(null);
        }
    };
    private static boolean groovyClassWarningLogged;
    private static boolean antClassWarningLogged;

    private Server() {
    }

    public static NbCodeLanguageClient getStubClient() {
        return STUB_CLIENT;
    }

    public static boolean isClientResponseThread(NbCodeLanguageClient client) {
        return client != null ? DISPATCHERS.get() == client : DISPATCHERS.get() != null;
    }

    public static NbLspServer launchServer(Pair<InputStream, OutputStream> io, LspSession session) {
        LanguageServerImpl server = new LanguageServerImpl(session);
        ConsumeWithLookup msgProcessor = new ConsumeWithLookup(server.getSessionLookup());
        Launcher<NbCodeLanguageClient> serverLauncher = Server.createLauncher(server, io, msgProcessor::attachLookup);
        NbCodeLanguageClient remote = (NbCodeLanguageClient)serverLauncher.getRemoteProxy();
        server.connect(remote);
        msgProcessor.attachClient(server.client);
        Future runningServer = serverLauncher.startListening();
        LSPServerTelemetryFactory.getDefault().connect(server.client, runningServer);
        return new NbLspServer(server, runningServer);
    }

    private static Launcher<NbCodeLanguageClient> createLauncher(LanguageServerImpl server, Pair<InputStream, OutputStream> io, Function<MessageConsumer, MessageConsumer> processor) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(NbCodeLanguageClient.class).setInput((InputStream)io.first()).setOutput((OutputStream)io.second()).wrapMessages(processor).configureGson(gb -> {
            Lookup.getDefault().lookupAll(LspGsonSetup.class).forEach(s -> s.configureBuilder((GsonBuilder)gb));
            gb.registerTypeAdapter(SemanticTokensCapabilities.class, (Object)new InstanceCreator<SemanticTokensCapabilities>(){

                public SemanticTokensCapabilities createInstance(Type type) {
                    return new SemanticTokensCapabilities(null);
                }
            });
            gb.registerTypeAdapter(SemanticTokensParams.class, (Object)new InstanceCreator<SemanticTokensParams>(){

                public SemanticTokensParams createInstance(Type type) {
                    return new SemanticTokensParams(new TextDocumentIdentifier(""));
                }
            });
        }).setExceptionHandler(t -> {
            LOG.log(Level.WARNING, "Error occurred during LSP message dispatch", (Throwable)t);
            if (t instanceof CompletionException) {
                if (t.getCause() instanceof ResponseErrorException) {
                    return ((ResponseErrorException)t).getResponseError();
                }
                Throwable cause = t.getCause();
                ResponseError error = new ResponseError();
                error.setMessage(cause.getMessage());
                error.setCode(ResponseErrorCode.InternalError);
                error.setData((Object)cause);
                return error;
            }
            return (ResponseError)RemoteEndpoint.DEFAULT_EXCEPTION_HANDLER.apply(t);
        }).create();
    }

    public static Iterable<Project> projectPath(final @NonNull Project project, final boolean excludeSelf) {
        return new Iterable<Project>(){

            @Override
            public Iterator<Project> iterator() {
                return new Iterator<Project>(){
                    Project next;
                    {
                        this.next = excludeSelf ? project : ProjectUtils.parentOf((Project)project);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Project next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Project r = this.next;
                        this.next = ProjectUtils.parentOf((Project)r);
                        return r;
                    }
                };
            }
        };
    }

    private static void hackConfigureGroovySupport(NbCodeClientCapabilities caps) {
        block4: {
            boolean b = caps != null && caps.wantsGroovySupport();
            try {
                Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.modules.groovy.editor.api.GroovyIndexer");
                Method m = clazz.getDeclaredMethod("setIndexingEnabled", Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(null, b);
            }
            catch (ClassNotFoundException ex) {
                if (b && !groovyClassWarningLogged) {
                    groovyClassWarningLogged = true;
                    LOG.log(Level.WARNING, "Unable to configure Groovy indexing: Groovy support is not enabled");
                }
            }
            catch (ReflectiveOperationException ex) {
                if (groovyClassWarningLogged) break block4;
                groovyClassWarningLogged = true;
                LOG.log(Level.WARNING, "Unable to configure Groovy support", ex);
            }
        }
    }

    private static void hackNoReuseOfOutputsForAntProjects() {
        block2: {
            String PROP_AUTO_CLOSE_TABS = "autoCloseTabs";
            try {
                Class<?> antSettings = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.apache.tools.ant.module.AntSettings");
                Preferences prefs = NbPreferences.forModule(antSettings);
                prefs.putBoolean("autoCloseTabs", false);
            }
            catch (ReflectiveOperationException ex) {
                if (antClassWarningLogged) break block2;
                antClassWarningLogged = true;
                LOG.log(Level.WARNING, "Unable to configure Ant support", ex);
            }
        }
    }

    public static class LSPServerTelemetryFactory
    extends CustomIndexerFactory {
        private static LSPServerTelemetryFactory INSTANCE;
        private final WeakHashMap<LanguageClient, Future<Void>> clients = new WeakHashMap();
        private final CustomIndexer noOp = new CustomIndexer(){

            protected void index(Iterable<? extends Indexable> files, Context context) {
            }
        };

        public static LSPServerTelemetryFactory getDefault() {
            if (INSTANCE == null) {
                INSTANCE = new LSPServerTelemetryFactory();
            }
            return INSTANCE;
        }

        private LSPServerTelemetryFactory() {
        }

        public synchronized void connect(LanguageClient client, Future<Void> future) {
            this.clients.put(client, future);
        }

        public synchronized boolean scanStarted(Context context) {
            HashSet<LanguageClient> toRemove = new HashSet<LanguageClient>();
            for (Map.Entry<LanguageClient, Future<Void>> entry : this.clients.entrySet()) {
                if (entry.getValue().isDone()) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                entry.getKey().telemetryEvent((Object)"nbls.scanStarted");
            }
            for (LanguageClient lc : toRemove) {
                this.clients.remove(lc);
            }
            return true;
        }

        public synchronized void scanFinished(Context context) {
            HashSet<LanguageClient> toRemove = new HashSet<LanguageClient>();
            for (Map.Entry<LanguageClient, Future<Void>> entry : this.clients.entrySet()) {
                if (entry.getValue().isDone()) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                entry.getKey().telemetryEvent((Object)"nbls.scanFinished");
            }
            for (LanguageClient lc : toRemove) {
                this.clients.remove(lc);
            }
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return "LSPServerTelemetry";
        }

        public int getIndexVersion() {
            return 1;
        }

        public CustomIndexer createIndexer() {
            return this.noOp;
        }

        public boolean supportsEmbeddedIndexers() {
            return false;
        }
    }

    public static class LanguageServerImpl
    implements LanguageServer,
    LanguageClientAware,
    LspServerState,
    NbLanguageServer {
        private static final String NETBEANS_FORMAT = "netbeans.format";
        private static final String NETBEANS_JAVA_IMPORTS = "netbeans.java.imports";
        private static final RequestProcessor SERVER_INIT_RP = new RequestProcessor(LanguageServerImpl.class.getName());
        private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class.getName());
        private NbCodeClientWrapper client;
        private final TextDocumentServiceImpl textDocumentService = new TextDocumentServiceImpl(this);
        private final WorkspaceServiceImpl workspaceService = new WorkspaceServiceImpl(this);
        private final InstanceContent sessionServices = new InstanceContent();
        private final AbstractLookup sessionOnly = new AbstractLookup((AbstractLookup.Content)this.sessionServices);
        private final Lookup sessionLookup = new ProxyLookup(new Lookup[]{this.sessionOnly, Lookup.getDefault()});
        private final LspTreeViewServiceImpl treeService = new LspTreeViewServiceImpl(this.sessionLookup);
        private final LspInputServiceImpl inputService = new LspInputServiceImpl();
        private final Map<Project, CompletableFuture<Void>> beingOpened = new HashMap<Project, CompletableFuture<Void>>();
        private final Map<Project, CompletableFuture<Project>> openingFileOwners = new HashMap<Project, CompletableFuture<Project>>();
        private volatile CompletableFuture<Project[]> workspaceProjects = new CompletableFuture();
        private volatile Collection<Project> openedProjects = Collections.emptyList();
        private final List<FileObject> acceptedWorkspaceFolders = new ArrayList<FileObject>();
        private final OpenedDocuments openedDocuments = new OpenedDocuments();
        private final LspSession lspSession;
        private AtomicInteger openRequestId = new AtomicInteger(1);

        LanguageServerImpl(LspSession session) {
            this.lspSession = session;
        }

        private Lookup getSessionLookup() {
            return this.lspSession.getLookup();
        }

        Lookup getSessionOnlyLookup() {
            return this.sessionOnly;
        }

        @Override
        public CompletableFuture<Project[]> asyncOpenSelectedProjects(List<FileObject> projectCandidates, boolean addWorkspace) {
            if (projectCandidates == null || projectCandidates.isEmpty()) {
                return CompletableFuture.completedFuture(new Project[0]);
            }
            CompletableFuture<Project[]> f = new CompletableFuture<Project[]>();
            LOG.log(Level.FINER, "Asked to open project(s): {0}", Arrays.asList(projectCandidates));
            LOG.log(Level.FINER, "Caller:", new Throwable());
            SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(f, projectCandidates, addWorkspace, false));
            return f;
        }

        @Override
        public CompletableFuture<Project> asyncOpenFileOwner(FileObject file) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            if (prj == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.workspaceProjects.thenCompose(wprj -> {
                CompletableFuture f = new CompletableFuture();
                CompletionStage g = f.thenApply(arr -> ((Project[])arr).length > 0 ? arr[0] : null);
                List<Project> prjs = Arrays.asList(wprj);
                boolean openImmediately = false;
                LanguageServerImpl languageServerImpl = this;
                synchronized (languageServerImpl) {
                    if (this.openedProjects.contains(prj)) {
                        return CompletableFuture.completedFuture(prj);
                    }
                    CompletableFuture<Void> h = this.beingOpened.get(prj);
                    if (h != null) {
                        return h.thenApply(unused -> prj);
                    }
                    CompletableFuture<Project> p = this.openingFileOwners.putIfAbsent(prj, (CompletableFuture<Project>)g);
                    if (p != null) {
                        return p;
                    }
                    for (Project check : Server.projectPath(prj, false)) {
                        if (!prjs.contains(check)) continue;
                        openImmediately = true;
                        break;
                    }
                    if (!openImmediately) {
                        FileObject pdir = prj.getProjectDirectory();
                        for (FileObject wf : this.acceptedWorkspaceFolders) {
                            if (!wf.equals(pdir) && !FileUtil.isParentOf((FileObject)wf, (FileObject)pdir)) continue;
                            openImmediately = true;
                        }
                    }
                }
                if (openImmediately) {
                    SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(f, Collections.singletonList(file), false, false));
                } else {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)prj);
                    String dispName = pi != null ? pi.getDisplayName() : Bundle.PROMPT_AskOpenProjectForFile_Unnamed();
                    MessageActionItem yes = new MessageActionItem(Bundle.PROMPT_AskOpenProjectForFile_Yes());
                    ShowMessageRequestParams smrp = new ShowMessageRequestParams(Arrays.asList(yes, new MessageActionItem(Bundle.PROMPT_AskOpenProjectForFile_No())));
                    if (prj.getProjectDirectory() == file) {
                        smrp.setMessage(Bundle.PROMPT_AskOpenProject(dispName));
                    } else {
                        smrp.setMessage(Bundle.PROMPT_AskOpenProjectForFile(file.getNameExt(), dispName));
                    }
                    smrp.setType(MessageType.Info);
                    this.client.showMessageRequest(smrp).thenAccept(ai -> {
                        if (!yes.equals(ai)) {
                            f.completeExceptionally(new CancellationException());
                            return;
                        }
                        SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(f, Collections.singletonList(file), false, false));
                    });
                }
                return f.thenApply(arr -> ((Project[])arr).length > 0 ? arr[0] : null);
            });
        }

        @Override
        public List<FileObject> getAcceptedWorkspaceFolders() {
            return this.acceptedWorkspaceFolders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void asyncOpenSelectedProjects0(CompletableFuture<Project[]> f, List<FileObject> projectCandidates, boolean asWorkspaceProjects, boolean validParents) {
            ArrayList<Project> projects = new ArrayList<Project>();
            ArrayList<FileObject> nonProjects = new ArrayList<FileObject>();
            ArrayList<FileObject> haveProjects = new ArrayList<FileObject>();
            try {
                Project[] previouslyOpened;
                if (projectCandidates != null) {
                    for (FileObject candidate : projectCandidates) {
                        Project prj = FileOwnerQuery.getOwner((FileObject)candidate);
                        if (prj != null) {
                            projects.add(prj);
                            haveProjects.add(prj.getProjectDirectory());
                            continue;
                        }
                        if (!validParents || !candidate.isFolder()) continue;
                        nonProjects.add(candidate);
                    }
                    LanguageServerImpl languageServerImpl = this;
                    synchronized (languageServerImpl) {
                        boolean nwp = asWorkspaceProjects;
                        for (FileObject pd : haveProjects) {
                            for (FileObject wf : new ArrayList<FileObject>(this.acceptedWorkspaceFolders)) {
                                if (!wf.equals(pd) && !FileUtil.isParentOf((FileObject)pd, (FileObject)wf)) continue;
                                LOG.log(Level.FINE, "Nonproject workspace folder turned to project: {0}", projectCandidates.get(0));
                                this.acceptedWorkspaceFolders.remove(wf);
                                if (projectCandidates.size() != 1) continue;
                                nwp = true;
                            }
                        }
                        block10: for (FileObject np : nonProjects) {
                            for (FileObject c : this.acceptedWorkspaceFolders) {
                                if (!c.equals(np) && !FileUtil.isParentOf((FileObject)c, (FileObject)np)) continue;
                                continue block10;
                            }
                            LOG.log(Level.FINE, "Not recognized as a project, but accepting as workspace : {0}", np);
                            this.acceptedWorkspaceFolders.add(np);
                        }
                        asWorkspaceProjects = nwp;
                    }
                }
                try {
                    previouslyOpened = (Project[])OpenProjects.getDefault().openProjects().get();
                    if (previouslyOpened.length > 0) {
                        Level level = Level.FINEST;
                        assert ((level = Level.CONFIG) != null);
                        for (Project p : previouslyOpened) {
                            LOG.log(level, "Previously opened project at {0}", p.getProjectDirectory());
                        }
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
                this.asyncOpenSelectedProjects1(f, previouslyOpened, projects, asWorkspaceProjects);
            }
            catch (RuntimeException ex) {
                f.completeExceptionally(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void asyncOpenSelectedProjects1(CompletableFuture<Project[]> f, Project[] previouslyOpened, List<Project> projects, boolean addToWorkspace) {
            final int id = this.openRequestId.getAndIncrement();
            ArrayList primingBuilds = new ArrayList();
            ArrayList<Project> toOpen = new ArrayList<Project>();
            HashMap local = new HashMap();
            LanguageServerImpl languageServerImpl = this;
            synchronized (languageServerImpl) {
                LOG.log(Level.FINER, "{0}: Opening project(s): {1}", new Object[]{id, Arrays.asList(projects)});
                for (Project p : projects) {
                    CompletableFuture<Void> pending = this.beingOpened.get(p);
                    if (pending != null) {
                        primingBuilds.add(pending);
                        continue;
                    }
                    toOpen.add(p);
                    local.put(p, new CompletableFuture());
                }
                this.beingOpened.putAll(local);
            }
            long t = System.currentTimeMillis();
            LOG.log(Level.FINER, id + ": Opening projects: {0}", Arrays.asList(toOpen));
            for (final Project p : toOpen) {
                ActionProvider pap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
                if (pap == null) {
                    LOG.log(Level.FINER, "{0}: No action provider at all !", id);
                    continue;
                }
                if (!Arrays.asList(pap.getSupportedActions()).contains("prime")) {
                    LOG.log(Level.FINER, "{0}: No action provider gives PRIME", id);
                    continue;
                }
                LOG.log(Level.FINER, "{0}: Found Priming action: {1}", new Object[]{id, p});
                if (!pap.isActionEnabled("prime", Lookup.EMPTY)) continue;
                final CompletableFuture primeF = new CompletableFuture();
                LOG.log(Level.FINER, "{0}: Found enabled Priming build for: {1}", new Object[]{id, p});
                ActionProgress progress = new ActionProgress(){

                    protected void started() {
                    }

                    public void finished(boolean success) {
                        LOG.log(Level.FINER, id + ": Priming build completed for project " + p);
                        primeF.complete(null);
                    }
                };
                primingBuilds.add(primeF);
                pap.invokeAction("prime", Lookups.fixed((Object[])new Object[]{progress}));
            }
            ((CompletableFuture)CompletableFuture.allOf(primingBuilds.toArray(new CompletableFuture[primingBuilds.size()])).thenRun(() -> {
                OpenProjects.getDefault().open(projects.toArray(new Project[0]), false);
                try {
                    LOG.log(Level.FINER, "{0}: Calling openProjects() for : {1}", new Object[]{id, Arrays.asList(projects)});
                    OpenProjects.getDefault().openProjects().get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
                for (Project prj : projects) {
                    ProjectUtils.getSources((Project)prj).getSourceGroups("generic");
                    CompletableFuture prjF = (CompletableFuture)local.get(prj);
                    if (prjF == null) continue;
                    prjF.complete(null);
                }
                HashSet<Project> projectSet = new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects()));
                projectSet.retainAll(this.openedProjects);
                projectSet.addAll(projects);
                Project[] prjsRequested = projects.toArray(new Project[projects.size()]);
                Project[] prjs = projects.toArray(new Project[projects.size()]);
                LOG.log(Level.FINER, "{0}: Finished opening projects: {1}", new Object[]{id, Arrays.asList(projects)});
                LanguageServerImpl languageServerImpl = this;
                synchronized (languageServerImpl) {
                    this.openedProjects = projectSet;
                    if (addToWorkspace) {
                        HashSet<Project> ns = new HashSet<Project>(projects);
                        List<Project> current = Arrays.asList(this.workspaceProjects.getNow(new Project[0]));
                        int s = current.size();
                        ns.addAll(current);
                        if (s != ns.size()) {
                            prjs = ns.toArray(new Project[ns.size()]);
                            this.workspaceProjects = CompletableFuture.completedFuture(prjs);
                        }
                    }
                    for (Project p : prjs) {
                        this.openingFileOwners.put(p, (CompletableFuture<Project>)f.thenApply(unused -> p));
                    }
                }
                f.complete(prjsRequested);
                LOG.log(Level.INFO, "{0} projects opened in {1}ms", new Object[]{prjsRequested.length, System.currentTimeMillis() - t});
            })).exceptionally(e -> {
                f.completeExceptionally((Throwable)e);
                return null;
            });
        }

        private JavaSource checkJavaSupport() {
            ClasspathInfo info = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
            JavaSource source = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
            if (source == null) {
                SERVER_INIT_RP.post(() -> {
                    String msg = Server.NO_JAVA_SUPPORT + System.getProperty("java.version");
                    this.showStatusBarMessage(MessageType.Error, msg, 5000);
                });
            }
            return source;
        }

        @Override
        public CompletableFuture<Project[]> openedProjects() {
            return this.workspaceProjects;
        }

        @Override
        public OpenedDocuments getOpenedDocuments() {
            return this.openedDocuments;
        }

        private JavaSource showIndexingCompleted(Project[] opened) {
            try {
                JavaSource source = this.checkJavaSupport();
                if (source != null) {
                    source.runWhenScanFinished(cc -> this.showStatusBarMessage(MessageType.Info, Server.INDEXING_COMPLETED, 0), true);
                }
                return source;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void showStatusBarMessage(MessageType type, String msg, int timeout) {
            if (this.client.getNbCodeCapabilities().hasStatusBarMessageSupport()) {
                this.client.showStatusBarMessage(new ShowStatusMessageParams(type, msg, timeout));
            } else {
                this.client.showMessage(new ShowStatusMessageParams(type, msg, timeout));
            }
        }

        private InitializeResult constructInitResponse(InitializeParams init, JavaSource src) {
            ServerCapabilities capabilities = new ServerCapabilities();
            if (src != null) {
                TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
                textDocumentSyncOptions.setChange(TextDocumentSyncKind.Incremental);
                textDocumentSyncOptions.setOpenClose(Boolean.valueOf(true));
                textDocumentSyncOptions.setWillSaveWaitUntil(Boolean.valueOf(true));
                capabilities.setTextDocumentSync(textDocumentSyncOptions);
                CompletionOptions completionOptions = new CompletionOptions();
                completionOptions.setResolveProvider(Boolean.valueOf(true));
                completionOptions.setTriggerCharacters(Arrays.asList(".", "#", "@", "*"));
                capabilities.setCompletionProvider(completionOptions);
                capabilities.setHoverProvider(Boolean.valueOf(true));
                CodeActionOptions codeActionOptions = new CodeActionOptions(Arrays.asList("quickfix", "source", "source.organizeImports", "refactor"));
                codeActionOptions.setResolveProvider(Boolean.valueOf(true));
                capabilities.setCodeActionProvider(codeActionOptions);
                capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
                capabilities.setDefinitionProvider(Boolean.valueOf(true));
                capabilities.setTypeDefinitionProvider(Boolean.valueOf(true));
                capabilities.setImplementationProvider(Boolean.valueOf(true));
                capabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
                capabilities.setDocumentFormattingProvider(Boolean.valueOf(true));
                capabilities.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
                capabilities.setReferencesProvider(Boolean.valueOf(true));
                CallHierarchyRegistrationOptions chOpts = new CallHierarchyRegistrationOptions();
                chOpts.setWorkDoneProgress(Boolean.valueOf(true));
                capabilities.setCallHierarchyProvider(chOpts);
                LinkedHashSet<String> commands = new LinkedHashSet<String>(Arrays.asList(Server.GRAALVM_PAUSE_SCRIPT, Server.NBLS_BUILD_WORKSPACE, Server.NBLS_CLEAN_WORKSPACE, Server.JAVA_RUN_PROJECT_ACTION, Server.JAVA_FIND_DEBUG_ATTACH_CONFIGURATIONS, Server.JAVA_FIND_DEBUG_PROCESS_TO_ATTACH, Server.JAVA_FIND_PROJECT_CONFIGURATIONS, Server.JAVA_GET_PROJECT_CLASSPATH, Server.JAVA_GET_PROJECT_PACKAGES, Server.JAVA_GET_PROJECT_SOURCE_ROOTS, Server.JAVA_LOAD_WORKSPACE_TESTS, Server.JAVA_RESOLVE_STACKTRACE_LOCATION, Server.JAVA_NEW_FROM_TEMPLATE, Server.JAVA_NEW_PROJECT, Server.JAVA_PROJECT_CONFIGURATION_COMPLETION, Server.JAVA_PROJECT_RESOLVE_PROJECT_PROBLEMS, Server.JAVA_SUPER_IMPLEMENTATION, Server.JAVA_CLEAR_PROJECT_CACHES, Server.NATIVE_IMAGE_FIND_DEBUG_PROCESS_TO_ATTACH, Server.JAVA_PROJECT_INFO, Server.JAVA_ENABLE_PREVIEW));
                for (CodeActionsProvider codeActionsProvider : Lookup.getDefault().lookupAll(CodeActionsProvider.class)) {
                    commands.addAll(codeActionsProvider.getCommands());
                }
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(new ArrayList<String>(commands)));
                WorkspaceSymbolOptions wsOpts = new WorkspaceSymbolOptions();
                wsOpts.setResolveProvider(Boolean.valueOf(true));
                capabilities.setWorkspaceSymbolProvider(wsOpts);
                capabilities.setCodeLensProvider(new CodeLensOptions(Boolean.valueOf(false)));
                RenameOptions renOpt = new RenameOptions();
                renOpt.setPrepareProvider(Boolean.valueOf(true));
                capabilities.setRenameProvider(renOpt);
                FoldingRangeProviderOptions foldingOptions = new FoldingRangeProviderOptions();
                capabilities.setFoldingRangeProvider(foldingOptions);
                this.textDocumentService.init(init.getCapabilities(), capabilities);
                WorkspaceServerCapabilities wcaps = new WorkspaceServerCapabilities();
                WorkspaceFoldersOptions wfopts = new WorkspaceFoldersOptions();
                wfopts.setSupported(Boolean.valueOf(true));
                wfopts.setChangeNotifications(Boolean.valueOf(true));
                wcaps.setWorkspaceFolders(wfopts);
                capabilities.setWorkspace(wcaps);
            }
            return new InitializeResult(capabilities);
        }

        public CompletableFuture<InitializeResult> initialize(InitializeParams init) {
            NbCodeClientCapabilities capa = NbCodeClientCapabilities.get(init);
            this.client.setClientCaps(capa);
            Server.hackConfigureGroovySupport(capa);
            Server.hackNoReuseOfOutputsForAntProjects();
            ArrayList<FileObject> projectCandidates = new ArrayList<FileObject>();
            List folders = init.getWorkspaceFolders();
            if (folders != null) {
                for (WorkspaceFolder w : folders) {
                    try {
                        projectCandidates.add(Utils.fromUri(w.getUri()));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            } else {
                String root = init.getRootUri();
                if (root != null) {
                    try {
                        projectCandidates.add(Utils.fromUri(root));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            }
            CompletableFuture<Project[]> prjs = this.workspaceProjects;
            SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(prjs, projectCandidates, true, true));
            prjs.thenApply(this::showIndexingCompleted);
            this.initializeOptions();
            return CompletableFuture.completedFuture(this.finishInitialization(this.constructInitResponse(init, this.checkJavaSupport())));
        }

        private void initializeOptions() {
            this.getWorkspaceProjects().thenAccept(projects -> {
                if (projects != null && ((Project[])projects).length > 0) {
                    ConfigurationItem item = new ConfigurationItem();
                    FileObject fo = projects[0].getProjectDirectory();
                    item.setScopeUri(Utils.toUri(fo));
                    item.setSection(NETBEANS_FORMAT);
                    this.client.configuration(new ConfigurationParams(Collections.singletonList(item))).thenAccept(c -> {
                        if (c != null && !c.isEmpty() && c.get(0) instanceof JsonObject) {
                            this.workspaceService.updateJavaFormatPreferences(fo, (JsonObject)c.get(0));
                        }
                    });
                    item.setSection(NETBEANS_JAVA_IMPORTS);
                    this.client.configuration(new ConfigurationParams(Collections.singletonList(item))).thenAccept(c -> {
                        if (c != null && !c.isEmpty() && c.get(0) instanceof JsonObject) {
                            this.workspaceService.updateJavaImportPreferences(fo, (JsonObject)c.get(0));
                        }
                    });
                }
            });
        }

        public CompletableFuture<Project[]> getWorkspaceProjects() {
            return this.workspaceProjects;
        }

        public InitializeResult finishInitialization(InitializeResult res) {
            OperationContext c = OperationContext.find(this.sessionLookup);
            c.acquireProgressToken();
            return res;
        }

        public CompletableFuture<Object> shutdown() {
            return CompletableFuture.completedFuture(null);
        }

        public void exit() {
        }

        @Override
        @JsonDelegate
        public TreeViewService getTreeViewService() {
            return this.treeService;
        }

        @Override
        @JsonDelegate
        public InputService getInputService() {
            return this.inputService;
        }

        @Override
        public TextDocumentService getTextDocumentService() {
            return this.textDocumentService;
        }

        public WorkspaceService getWorkspaceService() {
            return this.workspaceService;
        }

        public void cancelProgress(WorkDoneProgressCancelParams params) {
        }

        public void connect(LanguageClient aClient) {
            this.client = new NbCodeClientWrapper((NbCodeLanguageClient)aClient);
            this.sessionServices.add((Object)this);
            this.sessionServices.add((Object)this.client);
            this.sessionServices.add((Object)new WorkspaceIOContext(){

                @Override
                protected LanguageClient client() {
                    return client;
                }
            });
            this.sessionServices.add((Object)new WorkspaceUIContext(this.client));
            this.sessionServices.add((Object)this.treeService.getNodeRegistry());
            this.sessionServices.add((Object)this.inputService.getRegistry());
            ((LanguageClientAware)this.getTextDocumentService()).connect((LanguageClient)this.client);
            ((LanguageClientAware)this.getWorkspaceService()).connect((LanguageClient)this.client);
            this.treeService.connect(this.client);
        }

        public void setTrace(SetTraceParams params) {
        }
    }

    private static class ConsumeWithLookup {
        private final Lookup sessionLookup;
        private NbCodeLanguageClient client;
        private OperationContext initialContext;

        public ConsumeWithLookup(Lookup sessionLookup) {
            this.sessionLookup = sessionLookup;
        }

        synchronized void attachClient(NbCodeLanguageClient client) {
            this.client = client;
        }

        public MessageConsumer attachLookup(final MessageConsumer delegate) {
            if (!(delegate instanceof Endpoint)) {
                return delegate;
            }
            return new MessageConsumer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void consume(Message msg) throws MessageIssueException, JsonRpcException {
                    OperationContext ctx;
                    InstanceContent ic = new InstanceContent();
                    ProxyLookup ll = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), sessionLookup});
                    InternalHandle toCancel = null;
                    if (msg instanceof RequestMessage) {
                        RequestMessage rq = (RequestMessage)msg;
                        Object p = rq.getParams();
                        if (initialContext == null) {
                            initialContext = OperationContext.create(client);
                            ctx = initialContext;
                        } else {
                            ctx = initialContext.operationContext();
                        }
                        if (p instanceof WorkDoneProgressParams) {
                            ctx.setProgressToken((Either<String, Integer>)((WorkDoneProgressParams)p).getWorkDoneToken());
                        }
                    } else if (msg instanceof NotificationMessage) {
                        NotificationMessage not = (NotificationMessage)msg;
                        Object p = not.getParams();
                        OperationContext selected = null;
                        if (p instanceof WorkDoneProgressCancelParams && initialContext != null) {
                            WorkDoneProgressCancelParams wdc = (WorkDoneProgressCancelParams)p;
                            toCancel = initialContext.findActiveHandle((Either<String, Integer>)wdc.getToken());
                            selected = OperationContext.getHandleContext(toCancel);
                        }
                        ctx = selected;
                    } else {
                        ctx = null;
                    }
                    if (ctx != null) {
                        ic.add(ctx);
                    }
                    InternalHandle ftoCancel = toCancel;
                    try {
                        DISPATCHERS.set(client);
                        Lookups.executeWith((Lookup)ll, () -> {
                            try {
                                delegate.consume(msg);
                            }
                            catch (Error | RuntimeException e) {
                                LOG.log(Level.WARNING, "Error occurred during message dispatch", e);
                                throw e;
                            }
                            finally {
                                if (ftoCancel != null) {
                                    ftoCancel.requestCancel();
                                }
                                if (ctx != null) {
                                    ctx.stop();
                                }
                            }
                        });
                    }
                    finally {
                        DISPATCHERS.remove();
                    }
                }
            };
        }
    }
}

