/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.attach;

import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.attach.AttachConfigurations;
import org.netbeans.modules.java.lsp.server.debugging.attach.Bundle;
import org.netbeans.modules.java.lsp.server.debugging.attach.ConfigurationAttributes;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;
import org.netbeans.modules.java.lsp.server.debugging.ni.NILocationVisualizer;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.nativeimage.debugger.api.NIDebugRunner;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.modules.nativeimage.api.debug.StartDebugParameters;
import org.openide.util.RequestProcessor;

public final class NbAttachRequestHandler {
    private static final String CONNECTOR_ARG_PID = "pid";
    private static final String CONNECTOR_ARG_HOST = "hostname";
    private static final String CONNECTOR_ARG_PORT = "port";
    private static final String CONNECTOR_ARG_NAME = "name";
    private static final Map<String, String> ATTR_CONFIG_TO_CONNECTOR = Stream.of({"processId", "pid"}, {"hostName", "hostname"}, {"port", "port"}, {"sharedMemoryName", "name"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private static final RequestProcessor RP = new RequestProcessor(AttachConfigurations.class);

    public CompletableFuture<Void> attach(Map<String, Object> attachArguments, DebugAdapterContext context) {
        boolean isNative = "nativeimage".equals(attachArguments.get("type"));
        if (isNative) {
            return this.attachToNative(attachArguments, context);
        }
        return this.attachToJVM(attachArguments, context);
    }

    private CompletableFuture<Void> attachToNative(Map<String, Object> attachArguments, DebugAdapterContext context) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        String processAndExe = (String)attachArguments.get("processId");
        String nativeImagePath = (String)attachArguments.get("nativeImagePath");
        String miDebugger = (String)attachArguments.get("miDebugger");
        int index = processAndExe.indexOf(32);
        try {
            long processId;
            if (index > 0) {
                processId = Long.parseLong(processAndExe.substring(0, index));
                if (nativeImagePath == null || nativeImagePath.isEmpty()) {
                    nativeImagePath = processAndExe.substring(index + 1);
                }
            } else {
                processId = Long.parseLong(processAndExe);
                if (nativeImagePath == null) {
                    ErrorUtilities.completeExceptionally(resultFuture, Bundle.MSG_UnknownNIPath(), ResponseErrorCode.ServerNotInitialized);
                    return resultFuture;
                }
            }
            String executable = nativeImagePath;
            RP.post(() -> this.attachNativeDebug(new File(executable), processId, miDebugger, context, resultFuture));
        }
        catch (NumberFormatException nfex) {
            ErrorUtilities.completeExceptionally(resultFuture, nfex.getLocalizedMessage(), ResponseErrorCode.ServerNotInitialized);
        }
        return resultFuture;
    }

    private void attachNativeDebug(File nativeImageFile, long processId, String miDebugger, DebugAdapterContext context, CompletableFuture<Void> resultFuture) {
        NIDebugger niDebugger;
        AtomicReference debugSessionRef = new AtomicReference();
        CompletableFuture<Void> finished = new CompletableFuture<Void>();
        resultFuture.complete(null);
        try {
            StartDebugParameters startParams = StartDebugParameters.newBuilder(Collections.singletonList(nativeImageFile.getAbsolutePath())).debugger(miDebugger).debuggerDisplayObjects(false).processID(Long.valueOf(processId)).workingDirectory(new File(System.getProperty("user.dir", ""))).build();
            niDebugger = NIDebugRunner.start((File)nativeImageFile, (StartDebugParameters)startParams, null, engine -> {
                Session session = (Session)engine.lookupFirst(null, Session.class);
                NbDebugSession debugSession = new NbDebugSession(session);
                debugSessionRef.set(debugSession);
                context.setDebugSession(debugSession);
                context.getClient().initialized();
                context.getConfigurationSemaphore().waitForConfigurationDone();
                session.addPropertyChangeListener("currentLanguage", evt -> {
                    boolean didFinish;
                    if (evt.getNewValue() == null && (didFinish = finished.complete(null))) {
                        this.notifyTerminated(context);
                    }
                });
            });
        }
        catch (IllegalStateException ex) {
            this.notifyErrorMessage(context, Bundle.MSG_FailedToAttach());
            this.notifyTerminated(context);
            return;
        }
        NbDebugSession debugSession = (NbDebugSession)debugSessionRef.get();
        debugSession.setNIDebugger(niDebugger);
        NILocationVisualizer.handle(nativeImageFile, niDebugger, finished, context.getLspSession().getLspServer().getOpenedDocuments());
    }

    private CompletableFuture<Void> attachToJVM(Map<String, Object> attachArguments, DebugAdapterContext context) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        ConfigurationAttributes configurationAttributes = AttachConfigurations.get().findConfiguration(attachArguments);
        if (configurationAttributes != null) {
            AttachingConnector connector = configurationAttributes.getConnector();
            RP.post(() -> this.attachTo(connector, attachArguments, context, resultFuture));
        } else {
            context.setDebugMode(true);
            String name = (String)attachArguments.get(CONNECTOR_ARG_NAME);
            ErrorUtilities.completeExceptionally(resultFuture, Bundle.MSG_InvalidConnector(name), ResponseErrorCode.ServerNotInitialized);
        }
        return resultFuture;
    }

    private void attachTo(AttachingConnector connector, Map<String, Object> arguments, DebugAdapterContext context, CompletableFuture<Void> resultFuture) {
        Map<String, Connector.Argument> args = connector.defaultArguments();
        for (String argName : arguments.keySet()) {
            String argNameTranslated = ATTR_CONFIG_TO_CONNECTOR.getOrDefault(argName, argName);
            Connector.Argument arg = args.get(argNameTranslated);
            if (arg == null) continue;
            String value = arguments.get(argName).toString();
            if (!arg.isValid(value)) {
                ErrorUtilities.completeExceptionally(resultFuture, Bundle.MSG_ConnectorInvalidValue(argName, value), ResponseErrorCode.ServerNotInitialized);
                return;
            }
            arg.setValue(value);
        }
        AttachingDICookie attachingCookie = AttachingDICookie.create((AttachingConnector)connector, args);
        resultFuture.complete(null);
        this.startAttaching(attachingCookie, context);
    }

    private void startAttaching(AttachingDICookie attachingCookie, final DebugAdapterContext context) {
        JPDADebugger debugger;
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])new Object[]{attachingCookie}));
        if (es.length > 0 && (debugger = (JPDADebugger)es[0].lookupFirst(null, JPDADebugger.class)) != null) {
            Session session = (Session)es[0].lookupFirst(null, Session.class);
            NbDebugSession debugSession = new NbDebugSession(session);
            context.setDebugSession(debugSession);
            final AtomicBoolean finished = new AtomicBoolean(false);
            debugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int newState = (Integer)evt.getNewValue();
                    if (newState == 4 && !finished.getAndSet(true)) {
                        NbAttachRequestHandler.this.notifyTerminated(context);
                    }
                }
            });
            boolean success = false;
            try {
                debugger.waitRunning();
                success = debugger.getState() != 4;
            }
            catch (DebuggerStartException ex) {
                this.notifyErrorMessage(context, ex.getLocalizedMessage());
            }
            if (!success) {
                if (!finished.getAndSet(true)) {
                    this.notifyTerminated(context);
                }
            } else {
                context.getClient().initialized();
            }
            return;
        }
        this.notifyErrorMessage(context, Bundle.MSG_FailedToAttach());
        this.notifyTerminated(context);
    }

    private void notifyErrorMessage(DebugAdapterContext context, String message) {
        MessageParams params = new MessageParams();
        params.setMessage(message);
        params.setType(MessageType.Error);
        ((NbCodeLanguageClient)context.getLspSession().getLookup().lookup(NbCodeLanguageClient.class)).showMessage(params);
    }

    private void notifyTerminated(DebugAdapterContext context) {
        context.getClient().terminated(new TerminatedEventArguments());
    }
}

