/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.java.lsp.server.db.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class DBAddConnection
extends CodeActionsProvider {
    public static final String DB_ADD_CONNECTION = "db.add.connection";
    public static final String USER_ID = "userId";
    public static final String PASSWORD = "password";
    public static final String DRIVER = "driver";
    public static final String DB_URL = "url";
    public static final String SCHEMA = "schema";
    public static final String DISPLAY_NAME = "displayName";
    private static final Map<String, String> urlTemplates = new HashMap<String, String>();
    private final Gson gson = new Gson();

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (!DB_ADD_CONNECTION.equals(command)) {
            return null;
        }
        String userId = null;
        String dbUrl = null;
        String driverClass = null;
        if (arguments != null && arguments.size() > 0) {
            Map m = (Map)this.gson.fromJson((JsonElement)((JsonObject)arguments.get(0)), Map.class);
            if (m != null) {
                userId = (String)m.get(USER_ID);
                dbUrl = (String)m.get(DB_URL);
                driverClass = (String)m.get(DRIVER);
            }
            if (dbUrl != null && driverClass != null) {
                JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(driverClass);
                if (driver != null && driver.length > 0) {
                    CompletableFuture<String> usernameFuture = userId != null ? CompletableFuture.completedFuture(userId) : client.showInputBox(new ShowInputBoxParams(Bundle.MSG_EnterUsername(), userId));
                    usernameFuture.thenAccept(username -> {
                        if (username == null) {
                            return;
                        }
                        String password = (String)m.get(PASSWORD);
                        CompletableFuture<String> passwordFuture = password != null ? CompletableFuture.completedFuture(password) : client.showInputBox(new ShowInputBoxParams(Bundle.MSG_EnterPassword(), "", true));
                        passwordFuture.thenAccept(p -> {
                            if (p == null) {
                                return;
                            }
                            DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver[0], (String)((String)m.get(DB_URL)), (String)username, (String)((String)m.get(SCHEMA)), (String)p, (boolean)true, (String)((String)m.get(DISPLAY_NAME)));
                            try {
                                ConnectionManager.getDefault().addConnection(dbconn);
                            }
                            catch (DatabaseException ex) {
                                client.showMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                            }
                        });
                    });
                    client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                }
                return CompletableFuture.completedFuture(null);
            }
        }
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers();
        ArrayList<QuickPickItem> items = new ArrayList<QuickPickItem>();
        for (int i = 0; i < drivers.length; ++i) {
            FileObject jarFO;
            URL[] jars = drivers[i].getURLs();
            if (jars == null || jars.length <= 0 || (jarFO = URLMapper.findFileObject((URL)jars[0])) == null || !jarFO.isValid()) continue;
            items.add(new QuickPickItem(drivers[i].getName(), null, drivers[i].getDisplayName() + " (" + drivers[i].getClassName() + ")", false, i));
        }
        return client.showQuickPick(new ShowQuickPickParams(Bundle.MSG_SelectDriver(), false, items)).thenApply(selectedItems -> {
            if (selectedItems == null) {
                return null;
            }
            if (!selectedItems.isEmpty()) {
                String urlTemplate;
                int i = ((Double)((QuickPickItem)selectedItems.get(0)).getUserData()).intValue();
                JDBCDriver driver = drivers[i];
                String string = urlTemplate = driver.getClassName() != null ? urlTemplates.get(driver.getClassName()) : "";
                if (urlTemplate == null) {
                    urlTemplate = "";
                }
                client.showInputBox(new ShowInputBoxParams(Bundle.MSG_EnterDbUrl(), urlTemplate)).thenAccept(u -> {
                    if (u == null) {
                        return;
                    }
                    client.showInputBox(new ShowInputBoxParams(Bundle.MSG_EnterUsername(), "")).thenAccept(username -> {
                        if (username == null) {
                            return;
                        }
                        client.showInputBox(new ShowInputBoxParams(Bundle.MSG_EnterPassword(), "", true)).thenAccept(password -> {
                            if (password == null) {
                                return;
                            }
                            DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver, (String)u, (String)username, null, (String)password, (boolean)true);
                            try {
                                ConnectionManager.getDefault().addConnection(dbconn);
                                List<String> schemas = DBAddConnection.getSchemas(dbconn);
                                if (schemas.isEmpty()) {
                                    client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                                } else {
                                    List<QuickPickItem> schemaItems = schemas.stream().map(schema -> new QuickPickItem((String)schema)).collect(Collectors.toList());
                                    client.showQuickPick(new ShowQuickPickParams(Bundle.MSG_SelectSchema(), schemaItems)).thenAccept(s -> {
                                        if (s == null) {
                                            try {
                                                ConnectionManager.getDefault().removeConnection(dbconn);
                                            }
                                            catch (DatabaseException ex) {
                                                StatusDisplayer.getDefault().setStatusText(ex.getMessage());
                                            }
                                            return;
                                        }
                                        String schema = ((QuickPickItem)s.get(0)).getLabel();
                                        DatabaseConnection dbconn1 = DatabaseConnection.create((JDBCDriver)driver, (String)u, (String)username, (String)schema, (String)password, (boolean)true);
                                        try {
                                            ConnectionManager.getDefault().removeConnection(dbconn);
                                            ConnectionManager.getDefault().addConnection(dbconn1);
                                        }
                                        catch (DatabaseException ex) {
                                            client.showMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                                            return;
                                        }
                                        client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                                    });
                                }
                            }
                            catch (SQLException | DatabaseException ex) {
                                client.showMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                            }
                        });
                    });
                });
            } else {
                client.showMessage(new MessageParams(MessageType.Error, Bundle.MSG_DriverNotFound()));
            }
            return null;
        });
    }

    private static List<String> getSchemas(DatabaseConnection dbconn) throws SQLException, DatabaseException {
        ResultSet rs;
        DatabaseMetaData dbMetaData;
        ArrayList<String> schemas = new ArrayList<String>();
        if (ConnectionManager.getDefault().connect(dbconn) && (dbMetaData = dbconn.getJDBCConnection().getMetaData()).supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
            while (rs.next()) {
                schemas.add(rs.getString(1).trim());
            }
        }
        return schemas;
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(DB_ADD_CONNECTION);
    }

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    static {
        urlTemplates.put("org.postgresql.Driver", "jdbc:postgresql://<HOST>:5432/<DB>");
        urlTemplates.put("org.gjt.mm.mysql.Driver", "jdbc:mysql://<HOST>:3306/<DB>");
        urlTemplates.put("com.mysql.cj.jdbc.Driver", "jdbc:mysql://<HOST>:3306/<DB>");
        urlTemplates.put("org.mariadb.jdbc.Driver", "jdbc:mariadb://<HOST>:3306/<DB>");
        urlTemplates.put("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@//<HOST>[:<PORT>][/<SERVICE>]");
        urlTemplates.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://<HOST>\\<DB>[:<PORT>]");
    }
}

