/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.htmlui;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.modules.java.lsp.server.htmlui.HttpServer;

final class SimpleServer
extends HttpServer<ReqRes, ReqRes, Object, Context> {
    private final Map<String, HttpServer.Handler> maps = new TreeMap<String, HttpServer.Handler>((s1, s2) -> {
        if (s1.length() != s2.length()) {
            return s2.length() - s1.length();
        }
        return s2.compareTo((String)s1);
    });
    private int max;
    private int min;
    private ServerSocketChannel server;
    private Selector connection;
    private Thread processor;
    private final List<Runnable> pendingActions = new ArrayList<Runnable>();
    private static final Pattern PATTERN_GET = Pattern.compile("(OPTIONS|HEAD|GET|POST|PUT|DELETE) */([^ \\?]*)(\\?[^ ]*)?");
    private static final Pattern PATTERN_HOST = Pattern.compile(".*^Host: *(.*):([0-9]+)$", 8);
    private static final Pattern PATTERN_LENGTH = Pattern.compile(".*^Content-Length: ([0-9]+)$", 8);
    static final Logger LOG = Logger.getLogger(SimpleServer.class.getName());
    private final Random random;

    SimpleServer() {
        this(new Random());
    }

    SimpleServer(Random random) {
        this.random = random;
    }

    @Override
    void addHttpHandler(HttpServer.Handler h, String path) {
        if (!path.startsWith("/")) {
            throw new IllegalStateException("Shall start with /: " + path);
        }
        this.maps.put(path.substring(1), h);
    }

    @Override
    void init(int from, int to) throws IOException {
        this.connection = Selector.open();
        this.min = from;
        this.max = to;
    }

    @Override
    synchronized void start() throws IOException {
        LOG.log(Level.INFO, "Listening for HTTP connections on port {0}", this.getServer().socket().getLocalPort());
        this.processor = new Thread(this::mainLoop, "HTTP server");
        this.processor.start();
    }

    private final synchronized Thread getProcessorThread() {
        return this.processor;
    }

    final void assertThread() {
        assert (Thread.currentThread() == this.getProcessorThread());
    }

    @Override
    String getRequestURI(ReqRes r) {
        this.assertThread();
        return "/" + r.url;
    }

    @Override
    String getServerName(ReqRes r) {
        this.assertThread();
        return r.hostName;
    }

    @Override
    int getServerPort(ReqRes r) {
        this.assertThread();
        return r.hostPort;
    }

    @Override
    String getParameter(ReqRes r, String id) {
        this.assertThread();
        return r.args.get(id);
    }

    @Override
    String getMethod(ReqRes r) {
        this.assertThread();
        return r.method;
    }

    @Override
    String getBody(ReqRes r) {
        this.assertThread();
        if (r.body == null) {
            return "";
        }
        return new String(r.body.array(), StandardCharsets.UTF_8);
    }

    static int endOfHeader(String header) {
        return header.indexOf("\r\n\r\n");
    }

    @Override
    String getHeader(ReqRes r, String key) {
        this.assertThread();
        for (String l : r.header.split("\r\n")) {
            if (l.isEmpty()) break;
            if (!l.startsWith(key + ":")) continue;
            return l.substring(key.length() + 1).trim();
        }
        return null;
    }

    @Override
    Writer getWriter(ReqRes r) {
        this.assertThread();
        return r.writer;
    }

    @Override
    void setContentType(ReqRes r, String contentType) {
        this.assertThread();
        r.contentType = contentType;
    }

    @Override
    void setStatus(ReqRes r, int status) {
        this.assertThread();
        r.status = status;
    }

    @Override
    OutputStream getOutputStream(ReqRes r) {
        this.assertThread();
        return r.os;
    }

    @Override
    void suspend(ReqRes r) {
        this.assertThread();
        r.suspended = true;
        r.updateOperations();
    }

    @Override
    void resume(ReqRes r, Runnable whenReady) {
        this.connectionWakeup(() -> {
            this.assertThread();
            r.suspended = false;
            r.updateOperations();
            whenReady.run();
        });
    }

    @Override
    void setCharacterEncoding(ReqRes r, String encoding) {
        if (!encoding.equals("UTF-8")) {
            throw new IllegalStateException(encoding);
        }
    }

    @Override
    void addHeader(ReqRes r, String name, String value) {
        this.assertThread();
        r.headers.put(name, value);
    }

    @Override
    <WebSocket> void send(WebSocket socket, String s) {
    }

    @Override
    public int getPort() {
        try {
            return this.getServer().socket().getLocalPort();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    synchronized void connectionWakeup(Runnable runOnMainLoop) {
        Selector localConnection = this.connection;
        this.pendingActions.add(runOnMainLoop);
        if (localConnection != null) {
            localConnection.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void mainLoop() {
        ByteBuffer bb = ByteBuffer.allocate(2048);
        while (Thread.currentThread() == this.getProcessorThread()) {
            AbstractInterruptibleChannel toClose = null;
            try {
                Runnable[] runnableArray = this;
                // MONITORENTER : this
                ServerSocketChannel localServer = this.getServer();
                Selector localConnection = this.connection;
                Runnable[] pendings = this.pendingActions.toArray(new Runnable[0]);
                this.pendingActions.clear();
                // MONITOREXIT : runnableArray
                LOG.log(Level.FINEST, "Before select status: open server{0}, open connection {1}, pending {2}", new Object[]{localServer.isOpen(), localConnection.isOpen(), pendings.length});
                for (Runnable r : pendings) {
                    r.run();
                }
                int amount = localConnection.select();
                LOG.log(Level.FINEST, "After select: {0}", amount);
                if (amount == 0) {
                    LOG.log(Level.FINE, "No amount after select: {0}", amount);
                }
                Set<SelectionKey> readyKeys = localConnection.selectedKeys();
                Iterator<SelectionKey> it = readyKeys.iterator();
                while (it.hasNext()) {
                    SocketChannel channel;
                    SelectionKey key = it.next();
                    LOG.log(Level.FINEST, "Handling key {0}", key.attachment());
                    it.remove();
                    if (key.isAcceptable()) {
                        try {
                            channel = localServer.accept();
                            channel.configureBlocking(false);
                            SelectionKey another = channel.register(localConnection, 1);
                            another.attach((SimpleServer)this.new ReadHeader());
                        }
                        catch (ClosedByInterruptException ex) {
                            LOG.log(Level.WARNING, "Interrupted while accepting", ex);
                            this.server.close();
                            this.server = null;
                            LOG.log(Level.INFO, "Accept server reset");
                        }
                        continue;
                    }
                    if (key.isReadable()) {
                        ((Buffer)bb).clear();
                        channel = (SocketChannel)key.channel();
                        toClose = channel;
                        channel.read(bb);
                        ((Buffer)bb).flip();
                        if (key.attachment() instanceof ReadHeader) {
                            ReadHeader readHeader = (ReadHeader)key.attachment();
                            ReqRes nextKey = readHeader.process(key, bb);
                            if (nextKey == null) continue;
                            key.attach(nextKey);
                            nextKey.updateOperations();
                            continue;
                        }
                        if (!(key.attachment() instanceof ReqRes)) continue;
                        ReqRes req = (ReqRes)key.attachment();
                        req.readBody(key, bb);
                        req.updateOperations();
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    channel = (SocketChannel)key.channel();
                    toClose = channel;
                    if (key.attachment() instanceof ReqRes) {
                        ReqRes request = (ReqRes)key.attachment();
                        WriteReply write = request.handle(channel);
                        if (write == null) continue;
                        key.attach(write);
                        write.updateOperations();
                        continue;
                    }
                    if (!(key.attachment() instanceof WriteReply)) continue;
                    WriteReply write = (WriteReply)key.attachment();
                    write.output(channel);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception while handling request", t);
                if (toClose == null) continue;
                try {
                    toClose.close();
                }
                catch (IOException ioEx) {
                    LOG.log(Level.INFO, "While closing", ioEx);
                }
            }
        }
        Runnable[] runnableArray = this;
        // MONITORENTER : this
        try {
            LOG.fine("Closing connection");
            this.connection.close();
            LOG.fine("Closing server");
            this.getServer().close();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        finally {
            this.notifyAll();
        }
        // MONITOREXIT : runnableArray
        LOG.fine("All notified, exiting server");
    }

    private HttpServer.Handler findHandler(String url) {
        LOG.log(Level.FINE, "Searching for handler for page {0}", url);
        for (Map.Entry<String, HttpServer.Handler> entry : this.maps.entrySet()) {
            if (!url.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new IllegalStateException("No mapping for " + url + " among " + this.maps);
    }

    private static void parseArgs(Map<String, ? super String> context, String args) throws UnsupportedEncodingException {
        if (args != null) {
            for (String arg : args.substring(1).split("&")) {
                String[] valueAndKey = arg.split("=");
                if (valueAndKey.length != 2) continue;
                String key = URLDecoder.decode(valueAndKey[1], "US-ASCII");
                int idx = 0;
                while ((idx = key.indexOf("%", idx)) != -1) {
                    int ch = Integer.parseInt(key.substring(idx + 1, idx + 3), 16);
                    key = key.substring(0, idx) + (char)ch + key.substring(idx + 3);
                    ++idx;
                }
                context.put(valueAndKey[0], key);
            }
        }
    }

    @Override
    public synchronized void shutdownNow() {
        Thread inter = this.processor;
        if (inter != null) {
            this.processor = null;
            LOG.fine("Processor cleaned");
            inter.interrupt();
            LOG.fine("Processor interrupted");
            try {
                this.wait(5000L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            LOG.fine("After waiting");
        }
    }

    static String date(Date date) {
        return SimpleServer.date("Date: ", date != null ? date : new Date());
    }

    static String date(String prefix, Date date) {
        DateFormat f = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        return prefix + f.format(date);
    }

    public synchronized ServerSocketChannel getServer() throws IOException {
        if (this.server == null) {
            ServerSocketChannel s = ServerSocketChannel.open();
            s.configureBlocking(false);
            for (int i = this.min; i <= this.max; ++i) {
                int at = this.min + this.random.nextInt(this.max - this.min + 1);
                InetSocketAddress address = new InetSocketAddress(at);
                try {
                    s.socket().bind(address);
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "Cannot bind to " + at, ex);
                    continue;
                }
                this.server = s;
                break;
            }
            this.server.register(this.connection, 16);
        }
        return this.server;
    }

    @Override
    Context initializeRunner(String id) {
        Context c = new Context(id);
        c.RUN = Executors.newSingleThreadExecutor(c);
        return c;
    }

    @Override
    void runSafe(Context c, final Runnable r, final Fn.Presenter presenter) {
        class Wrap
        implements Runnable {
            Wrap() {
            }

            @Override
            public void run() {
                if (presenter != null) {
                    try (Closeable c = Fn.activate((Fn.Presenter)presenter);){
                        r.run();
                    }
                    catch (IOException iOException) {}
                } else {
                    r.run();
                }
            }
        }
        if (c.RUNNER == Thread.currentThread()) {
            if (presenter != null) {
                Wrap w = new Wrap();
                w.run();
            } else {
                r.run();
            }
        } else {
            Wrap w = new Wrap();
            c.RUN.execute(w);
        }
    }

    private static void putString(ByteBuffer bb, String text) throws UnsupportedEncodingException {
        bb.put(text.getBytes("US-ASCII"));
    }

    final class WriteReply {
        private final SelectionKey delegate;
        private final String url;
        private final ByteBuffer header;
        private final ByteBuffer body;

        WriteReply(SelectionKey delegate, String url, ByteBuffer header, ByteBuffer body) {
            this.delegate = delegate;
            this.url = url;
            this.header = header;
            this.body = body;
        }

        void updateOperations() {
            this.delegate.interestOps(4);
        }

        void output(SocketChannel channel) throws IOException {
            try {
                if (this.header.remaining() > 0) {
                    channel.write(this.header);
                    return;
                }
                if (this.body.remaining() > 0) {
                    channel.write(this.body);
                } else {
                    channel.close();
                }
            }
            finally {
                if (!channel.isOpen()) {
                    LOG.log(Level.FINE, "channel for {0} not open, closing", this.url);
                    this.delegate.attach(null);
                    this.delegate.cancel();
                }
            }
        }
    }

    final class ReqRes {
        private final SelectionKey delegate;
        private final HttpServer.Handler h;
        final String url;
        final String hostName;
        final int hostPort;
        final Map<String, String> args;
        final String header;
        final String method;
        final ByteBuffer body;
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();
        final Writer writer = new OutputStreamWriter((OutputStream)this.os, StandardCharsets.UTF_8);
        final Map<String, String> headers = new LinkedHashMap<String, String>();
        String contentType;
        int status = 200;
        boolean computed;
        boolean suspended;

        public ReqRes(HttpServer.Handler h, SelectionKey delegate, String url, Map<String, String> args, String host, int port, String header, String method, ByteBuffer body) {
            this.h = h;
            this.delegate = delegate;
            this.url = url;
            this.hostName = host;
            this.hostPort = port;
            this.header = header;
            this.args = args;
            this.method = method;
            this.body = body;
        }

        void updateOperations() {
            if (this.body != null && this.body.remaining() > 0) {
                this.delegate.interestOps(1);
            } else if (this.suspended) {
                this.delegate.interestOps(0);
            } else {
                this.delegate.interestOps(4);
            }
        }

        public WriteReply handle(SocketChannel channel) throws IOException {
            if (!this.computed) {
                this.computed = true;
                this.h.service(SimpleServer.this, this, this);
            }
            if (this.suspended) {
                channel.write(ByteBuffer.allocate(0));
                return null;
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
            ByteBuffer bb = ByteBuffer.allocate(8192);
            ((Buffer)bb).clear();
            LOG.log(Level.FINE, "Serving page request {0}", this.url);
            ((Buffer)bb).clear();
            SimpleServer.putString(bb, "HTTP/1.1 " + this.status + "\r\n");
            SimpleServer.putString(bb, "Connection: close\r\n");
            SimpleServer.putString(bb, "Server: Browser presenter\r\n");
            SimpleServer.putString(bb, SimpleServer.date(null));
            SimpleServer.putString(bb, "\r\n");
            SimpleServer.putString(bb, "Content-Type: " + this.contentType + "\r\n");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                SimpleServer.putString(bb, entry.getKey() + ":" + entry.getValue() + "\r\n");
            }
            SimpleServer.putString(bb, "Pragma: no-cache\r\nCache-control: no-cache\r\n");
            SimpleServer.putString(bb, "\r\n");
            ((Buffer)bb).flip();
            return new WriteReply(this.delegate, this.url, bb, ByteBuffer.wrap(this.toByteArray()));
        }

        byte[] toByteArray() throws IOException {
            this.writer.close();
            return this.os.toByteArray();
        }

        void readBody(SelectionKey key, ByteBuffer chunk) {
            this.body.put(chunk);
        }

        public String toString() {
            return "Request[" + this.method + ":" + this.url + "]";
        }
    }

    final class ReadHeader {
        private final StringBuilder buffer = new StringBuilder();

        ReadHeader() {
        }

        final ReqRes process(SelectionKey key, ByteBuffer chunk) throws UnsupportedEncodingException {
            Map<String, String> context;
            String text = new String(chunk.array(), 0, chunk.limit(), "US-ASCII");
            this.buffer.append(text);
            int fullHeader = this.buffer.indexOf("\r\n\r\n");
            if (fullHeader == -1) {
                return null;
            }
            String header = text.substring(0, fullHeader);
            Matcher m = PATTERN_GET.matcher(header);
            String url = m.find() ? m.group(2) : null;
            String args = url != null && m.groupCount() == 3 ? m.group(3) : null;
            String method = m.group(1);
            if (args != null) {
                HashMap c = new HashMap();
                SimpleServer.parseArgs(c, args);
                context = Collections.unmodifiableMap(c);
            } else {
                context = Collections.emptyMap();
            }
            Matcher length = PATTERN_LENGTH.matcher(header);
            ByteBuffer body = null;
            if (length.find()) {
                int contentLength = Integer.parseInt(length.group(1));
                body = ByteBuffer.allocate(contentLength);
                ((Buffer)chunk).position(fullHeader + 4);
                body.put(chunk);
            }
            HttpServer.Handler h = SimpleServer.this.findHandler(url);
            Matcher hostMatch = PATTERN_HOST.matcher(header);
            String host = null;
            int port = -1;
            if (hostMatch.find()) {
                host = hostMatch.group(1);
                port = Integer.parseInt(hostMatch.group(2));
            }
            if (host != null) {
                LOG.log(Level.FINER, "Host {0}:{1}", new Object[]{host, port});
            }
            return new ReqRes(h, key, url, context, host, port, header, method, body);
        }
    }

    final class Context
    implements ThreadFactory {
        private final String id;
        Executor RUN;
        Thread RUNNER;

        Context(String id) {
            this.id = id;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t;
            this.RUNNER = t = new Thread(r, "Processor for " + this.id);
            return t;
        }
    }
}

