/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.sun.source.tree.LineMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.xtext.xbase.lib.Pure;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.parsing.api.ResultIterator;

public abstract class CodeActionsProvider {
    public static final String CODE_GENERATOR_KIND = "source.generate";
    protected static final String ERROR = "<error>";

    public abstract List<CodeAction> getCodeActions(ResultIterator var1, CodeActionParams var2) throws Exception;

    public abstract Set<String> getCommands();

    public abstract CompletableFuture<Object> processCommand(NbCodeLanguageClient var1, String var2, List<Object> var3);

    protected static int getOffset(CompilationInfo info, Position pos) {
        LineMap lm = info.getCompilationUnit().getLineMap();
        return (int)lm.getPosition(pos.getLine() + 1, pos.getCharacter() + 1);
    }

    protected static CodeAction createCodeAction(String name, String kind, String command, Object ... args) {
        CodeAction action = new CodeAction(name);
        action.setKind(kind);
        action.setCommand(new Command(name, command, Arrays.asList(args)));
        return action;
    }

    protected static String createLabel(CompilationInfo info, Element e) {
        return CodeActionsProvider.createLabel(info, e, false);
    }

    protected static String createLabel(CompilationInfo info, Element e, boolean fqn) {
        switch (e.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return CodeActionsProvider.createLabel(info, (TypeElement)e, fqn);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return CodeActionsProvider.createLabel(info, (ExecutableElement)e, fqn);
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return CodeActionsProvider.createLabel(info, (VariableElement)e, fqn);
            }
        }
        return null;
    }

    protected static String createLabel(CompilationInfo info, TypeElement e) {
        return CodeActionsProvider.createLabel(info, e, false);
    }

    protected static String createLabel(CompilationInfo info, TypeElement e, boolean fqn) {
        StringBuilder sb = new StringBuilder();
        sb.append(fqn ? e.getQualifiedName() : e.getSimpleName());
        List<? extends TypeParameterElement> typeParams = e.getTypeParameters();
        if (typeParams != null && !typeParams.isEmpty()) {
            sb.append("<");
            Iterator<? extends TypeParameterElement> it = typeParams.iterator();
            while (it.hasNext()) {
                TypeParameterElement tp = it.next();
                sb.append(tp.getSimpleName());
                List<? extends TypeMirror> bounds = tp.getBounds();
                if (!(bounds.isEmpty() || bounds.size() <= 1 && "java.lang.Object".equals(bounds.get(0).toString()))) {
                    sb.append(" extends ");
                    Iterator<? extends TypeMirror> bIt = bounds.iterator();
                    while (bIt.hasNext()) {
                        sb.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)bIt.next(), (boolean)fqn));
                        if (!bIt.hasNext()) continue;
                        sb.append(" & ");
                    }
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    protected static String createLabel(CompilationInfo info, VariableElement e) {
        return CodeActionsProvider.createLabel(info, e, false);
    }

    protected static String createLabel(CompilationInfo info, VariableElement e, boolean fqn) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getSimpleName());
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            sb.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)e.asType(), (boolean)fqn));
        }
        return sb.toString();
    }

    protected static String createLabel(CompilationInfo info, ExecutableElement e) {
        return CodeActionsProvider.createLabel(info, e, false);
    }

    protected static String createLabel(CompilationInfo info, ExecutableElement e, boolean fqn) {
        TypeMirror rt;
        StringBuilder sb = new StringBuilder();
        if (e.getKind() == ElementKind.CONSTRUCTOR) {
            sb.append(e.getEnclosingElement().getSimpleName());
        } else {
            sb.append(e.getSimpleName());
        }
        sb.append("(");
        Iterator<? extends VariableElement> it = e.getParameters().iterator();
        while (it.hasNext()) {
            VariableElement param = it.next();
            if (!it.hasNext() && e.isVarArgs() && param.asType().getKind() == TypeKind.ARRAY) {
                sb.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)((ArrayType)param.asType()).getComponentType(), (boolean)fqn));
                sb.append("...");
            } else {
                sb.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)param.asType(), (boolean)fqn));
            }
            sb.append(" ");
            sb.append(param.getSimpleName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
            sb.append(" : ");
            sb.append(Utilities.getTypeName((CompilationInfo)info, (TypeMirror)e.getReturnType(), (boolean)fqn));
        }
        return sb.toString();
    }

    public static class ElementData {
        private String kind;
        private String[] signature;

        public ElementData() {
        }

        public ElementData(Element element) {
            this((ElementHandle<? extends Element>)ElementHandle.create((Element)element));
        }

        public ElementData(ElementHandle<? extends Element> handle) {
            this.kind = handle.getKind().name();
            this.signature = ElementHandleAccessor.getInstance().getJVMSignature(handle);
        }

        ElementHandle toHandle() {
            return ElementHandleAccessor.getInstance().create(ElementKind.valueOf(this.kind), this.signature);
        }

        Element resolve(CompilationInfo info) {
            return this.toHandle().resolve(info);
        }

        @Pure
        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        @Pure
        public String[] getSignature() {
            return this.signature;
        }

        public void setSignature(String[] signature) {
            this.signature = signature;
        }

        @Pure
        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.kind);
            hash = 97 * hash + Arrays.deepHashCode(this.signature);
            return hash;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementData other = (ElementData)obj;
            if (this.kind != other.kind) {
                return false;
            }
            return Arrays.deepEquals(this.signature, other.signature);
        }
    }
}

