/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbLocalRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbRefImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class EjbRefHelper {
    private static final String EJB_ANN = "javax.ejb.EJB";
    private static final String EJBS_ANN = "javax.ejb.EJBs";

    private EjbRefHelper() {
    }

    public static void setEjbRefs(final AnnotationModelHelper helper, final List<EjbRef> resultEjbRefs, final List<EjbLocalRef> resultEjbLocalRefs) {
        try {
            helper.getAnnotationScanner().findAnnotations(EJBS_ANN, EnumSet.of(ElementKind.CLASS), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotation) {
                    EjbRefHelper.parseEJBsAnnotation(helper, typeElement, resultEjbRefs, resultEjbLocalRefs);
                }
            });
            helper.getAnnotationScanner().findAnnotations(EJB_ANN, EnumSet.of(ElementKind.CLASS, ElementKind.METHOD, ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotation) {
                    EjbRefHelper.parseElement(helper, typeElement, element, resultEjbRefs, resultEjbLocalRefs);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setEjbRefsForClass(AnnotationModelHelper helper, TypeElement typeElement, List<EjbRef> resultEjbRefs, List<EjbLocalRef> resultEjbLocalRefs) {
        assert (helper != null);
        assert (resultEjbRefs != null);
        assert (resultEjbLocalRefs != null);
        EjbRefHelper.parseEJBsAnnotation(helper, typeElement, resultEjbRefs, resultEjbLocalRefs);
        if (helper.hasAnnotation(typeElement.getAnnotationMirrors(), EJB_ANN)) {
            EjbRefHelper.parseElement(helper, typeElement, typeElement, resultEjbRefs, resultEjbLocalRefs);
        }
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!helper.hasAnnotation(variableElement.getAnnotationMirrors(), EJB_ANN)) continue;
            EjbRefHelper.parseElement(helper, typeElement, variableElement, resultEjbRefs, resultEjbLocalRefs);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!helper.hasAnnotation(executableElement.getAnnotationMirrors(), EJB_ANN)) continue;
            EjbRefHelper.parseElement(helper, typeElement, executableElement, resultEjbRefs, resultEjbLocalRefs);
        }
    }

    private static void parseEJBsAnnotation(final AnnotationModelHelper helper, TypeElement typeElement, final List<EjbRef> resultEjbRefs, final List<EjbLocalRef> resultEjbLocalRefs) {
        Map annByType = helper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror ejbsAnnotation = (AnnotationMirror)annByType.get(EJBS_ANN);
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectAnnotationArray("value", helper.resolveType(EJB_ANN), new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    Object arrayMemberValue = arrayMember.getValue();
                    if (!(arrayMemberValue instanceof AnnotationMirror)) continue;
                    EjbRefHelper.parseAnnotation(helper, (AnnotationMirror)arrayMemberValue, resultEjbRefs, resultEjbLocalRefs);
                }
                return null;
            }
        }, null);
        parser.parse(ejbsAnnotation);
    }

    private static void parseElement(AnnotationModelHelper helper, TypeElement ownerClass, Element element, List<EjbRef> resultEjbRefs, List<EjbLocalRef> resultEjbLocalRefs) {
        String name = null;
        String beanInterface = null;
        String beanName = null;
        String mappedName = null;
        String description = null;
        TypeElement interfaceTypeElement = null;
        Map annByType = helper.getAnnotationsByType(element.getAnnotationMirrors());
        if (ElementKind.CLASS == element.getKind()) {
            AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
            parser.expectString("name", null);
            parser.expectClass("beanInterface", null);
            parser.expectString("beanName", null);
            parser.expectString("mappedName", null);
            parser.expectString("description", null);
            ParseResult parseResult = parser.parse((AnnotationMirror)annByType.get(EJB_ANN));
            name = (String)parseResult.get("name", String.class);
            beanInterface = (String)parseResult.get("beanInterface", String.class);
            beanName = (String)parseResult.get("beanName", String.class);
            mappedName = (String)parseResult.get("mappedName", String.class);
            description = (String)parseResult.get("description", String.class);
            if (beanInterface != null) {
                interfaceTypeElement = helper.getCompilationController().getElements().getTypeElement(beanInterface);
            }
        } else if (ElementKind.FIELD == element.getKind() || ElementKind.METHOD == element.getKind()) {
            DeclaredType fieldDeclaredType;
            Element fieldTypeElement;
            TypeMirror fieldTypeMirror = element.asType();
            AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
            if (ElementKind.METHOD == element.getKind()) {
                String fieldName = element.getSimpleName().toString();
                fieldName = Character.toLowerCase(fieldName.charAt(3)) + fieldName.substring(4);
                parser.expectString("name", AnnotationParser.defaultValue((Object)("java:comp/env/" + ownerClass.getQualifiedName() + '/' + fieldName)));
                if (!element.getSimpleName().toString().startsWith("set")) {
                    return;
                }
                ExecutableElement method = (ExecutableElement)element;
                List<? extends VariableElement> parameters = method.getParameters();
                if (parameters.size() != 1) {
                    return;
                }
                fieldTypeMirror = parameters.get(0).asType();
            } else {
                parser.expectString("name", AnnotationParser.defaultValue((Object)("java:comp/env/" + ownerClass.getQualifiedName() + '/' + element.getSimpleName())));
            }
            if (TypeKind.DECLARED == fieldTypeMirror.getKind() && ElementKind.INTERFACE == (fieldTypeElement = (fieldDeclaredType = (DeclaredType)fieldTypeMirror).asElement()).getKind()) {
                interfaceTypeElement = (TypeElement)fieldTypeElement;
                beanInterface = interfaceTypeElement.getQualifiedName().toString();
            }
            ParseResult parseResult = parser.parse((AnnotationMirror)annByType.get(EJB_ANN));
            name = (String)parseResult.get("name", String.class);
        } else {
            return;
        }
        if (interfaceTypeElement != null) {
            EjbRefHelper.createReference(helper, interfaceTypeElement, resultEjbRefs, resultEjbLocalRefs, name, beanInterface, beanName, mappedName, description);
        }
    }

    private static void parseAnnotation(AnnotationModelHelper helper, AnnotationMirror annotationMirror, List<EjbRef> resultEjbRefs, List<EjbLocalRef> resultEjbLocalRefs) {
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectString("name", null);
        parser.expectClass("beanInterface", null);
        parser.expectString("beanName", null);
        parser.expectString("mappedName", null);
        parser.expectString("description", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        String name = (String)parseResult.get("name", String.class);
        String beanInterface = (String)parseResult.get("beanInterface", String.class);
        String beanName = (String)parseResult.get("beanName", String.class);
        String mappedName = (String)parseResult.get("mappedName", String.class);
        String description = (String)parseResult.get("description", String.class);
        TypeElement interfaceTypeElement = helper.getCompilationController().getElements().getTypeElement(beanInterface);
        EjbRefHelper.createReference(helper, interfaceTypeElement, resultEjbRefs, resultEjbLocalRefs, name, beanInterface, beanName, mappedName, description);
    }

    private static void createReference(AnnotationModelHelper helper, TypeElement interfaceTypeElement, List<EjbRef> resultEjbRefs, List<EjbLocalRef> resultEjbLocalRefs, String name, String beanInterface, String beanName, String mappedName, String description) {
        boolean isLocal = true;
        Map memberAnnByType = helper.getAnnotationsByType(interfaceTypeElement.getAnnotationMirrors());
        if (memberAnnByType.get("javax.ejb.Remote") != null) {
            isLocal = false;
        }
        if (resultEjbLocalRefs != null && isLocal) {
            resultEjbLocalRefs.add(new EjbLocalRefImpl(name, beanInterface, beanName, mappedName, description));
        } else if (resultEjbRefs != null && !isLocal) {
            resultEjbRefs.add(new EjbRefImpl(name, beanInterface, beanName, mappedName, description));
        }
    }
}

