/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class Util
extends org.netbeans.modules.i18n.Util {
    public static final String HELP_ID_ADDITIONAL = "internation.Additional";
    public static final String HELP_ID_SELECTSOURCES = "internation.SelectSources";
    public static final String HELP_ID_FOUNDSTRINGS = "internation.FoundStrings";
    public static final String HELP_ID_FOUNDMISSINGRESOURCES = "internation.FoundMissingResources";
    public static final String HELP_ID_SELECTRESOURCE = "internation.SelectResource";
    public static final String HELP_ID_SELECTTESTSOURCES = "internation.SelectTestSources";
    public static final String HELP_ID_SELECTTESTRESOURCE = "internation.SelectTestResource";

    Util() {
    }

    public static String getString(String key) {
        return NbBundle.getMessage(Util.class, (String)key);
    }

    public static char getChar(String key) {
        return Util.getString(key).charAt(0);
    }

    public static Map<DataObject, SourceData> createWizardSourceMap() {
        return new TreeMap<DataObject, SourceData>(new DataObjectComparator());
    }

    public static Map<DataObject, SourceData> createWizardSourceMap(Node[] activatedNodes) {
        Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
        if (activatedNodes != null && activatedNodes.length > 0) {
            VisibilityQuery visQuery = VisibilityQuery.getDefault();
            for (Node node : activatedNodes) {
                DataObject dobj = (DataObject)node.getCookie(DataObject.class);
                if (dobj != null && !visQuery.isVisible(dobj.getPrimaryFile())) continue;
                DataObject.Container container = (DataObject.Container)node.getCookie(DataObject.Container.class);
                if (container != null) {
                    for (DataObject dataObj : I18nUtil.getAcceptedDataObjects(container)) {
                        Util.addSource(sourceMap, dataObj);
                    }
                }
                if (dobj == null || !FactoryRegistry.hasFactory(dobj.getClass())) continue;
                Util.addSource(sourceMap, dobj);
            }
        }
        return sourceMap;
    }

    public static void addSource(Map<DataObject, SourceData> sourceMap, DataObject source) {
        if (sourceMap.containsKey(source)) {
            return;
        }
        DataFolder folder = source.getFolder();
        if (folder == null) {
            sourceMap.put(source, null);
            return;
        }
        for (DataObject child : folder.getChildren()) {
            if (!(child instanceof PropertiesDataObject)) continue;
            sourceMap.put(source, new SourceData(child));
            return;
        }
        sourceMap.put(source, null);
    }

    static boolean wizardEnabled(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (Node node : activatedNodes) {
            Node.Cookie container;
            DataObject dobj = (DataObject)node.getCookie(DataObject.class);
            if (dobj != null) {
                boolean isLocal;
                FileObject primaryFile = dobj.getPrimaryFile();
                boolean bl = isLocal = !primaryFile.isVirtual() && primaryFile.isValid() && primaryFile.toURL().getProtocol().equals("file");
                if (!isLocal) {
                    return false;
                }
            }
            if ((container = node.getCookie(DataObject.Container.class)) != null) continue;
            if (dobj == null) {
                return false;
            }
            Future openProjects = OpenProjects.getDefault().openProjects();
            if (!openProjects.isDone()) {
                return false;
            }
            if (FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile()) != null) continue;
            return false;
        }
        return true;
    }

    static void layoutSelectResourcePanel(Container thePanel, String instructionsText, String selectionLabelText, Component selectionComp, JButton button1, JButton button2) {
        JTextArea instructions = new JTextArea();
        JLabel lblSelection = new JLabel();
        instructions.setColumns(20);
        instructions.setEditable(false);
        instructions.setLineWrap(true);
        instructions.setText(instructionsText);
        instructions.setWrapStyleWord(true);
        instructions.setDisabledTextColor(new JLabel().getForeground());
        instructions.setEnabled(false);
        instructions.setOpaque(false);
        lblSelection.setLabelFor(selectionComp);
        Mnemonics.setLocalizedText((JLabel)lblSelection, (String)selectionLabelText);
        JScrollPane scrollPane = new JScrollPane(selectionComp);
        JPanel filesSelection = new JPanel();
        GroupLayout layout = new GroupLayout(filesSelection);
        filesSelection.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblSelection).addGroup(layout.createSequentialGroup().addComponent(scrollPane, 0, -1, Integer.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(button1).addComponent(button2))));
        layout.linkSize(0, button1, button2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(lblSelection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(scrollPane, 0, -1, Integer.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(button1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(button2)))));
        LayoutStyle layoutStyle = layout.getLayoutStyle();
        if (layoutStyle == null) {
            layoutStyle = LayoutStyle.getInstance();
        }
        BorderLayout mainLayout = new BorderLayout();
        thePanel.setLayout(mainLayout);
        thePanel.add((Component)instructions, "First");
        thePanel.add((Component)filesSelection, "Center");
        mainLayout.setVgap(layoutStyle.getPreferredGap(instructions, lblSelection, LayoutStyle.ComponentPlacement.UNRELATED, 1, thePanel));
    }

    private static class DataObjectComparator
    implements Comparator<DataObject> {
        private DataObjectComparator() {
        }

        @Override
        public int compare(DataObject d1, DataObject d2) {
            if (d1 == d2) {
                return 0;
            }
            if (d1 == null) {
                return -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d1.getPrimaryFile().getPath().compareTo(d2.getPrimaryFile().getPath());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

