/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.html.lexer;

import java.util.Arrays;

final class HtmlElements {
    private static final String[] TAGS = new String[]{"a", "abbr", "acronym", "address", "area", "b", "base", "bdo", "big", "blockquote", "body", "br", "button", "caption", "cite", "code", "col", "colgroup", "dd", "del", "dfn", "div", "dl", "dt", "em", "fieldset", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "link", "map", "meta", "noscript", "object", "ol", "optgroup", "option", "p", "param", "pre", "q", "samp", "script", "select", "small", "span", "strong", "style", "sub", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt", "ul", "var"};
    private static final String[] ATTRS = new String[]{"abbr", "accept", "accept-charset", "accesskey", "action", "align", "alt", "archive", "axis", "border", "cellpadding", "cellspacing", "char", "charoff", "charset", "checked", "cite", "class", "classid", "codebase", "codetype", "cols", "colspan", "content", "coords", "data", "datapagesize", "datetime", "declare", "defer", "dir", "disabled", "enctype", "event", "for", "frame", "headers", "height", "href", "hreflang", "http-equiv", "id", "ismap", "label", "lang", "longdesc", "maxlength", "media", "method", "multiple", "name", "nohref", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "profile", "readonly", "rel", "rev", "rows", "rowspan", "rules", "scheme", "scope", "selected", "shape", "size", "span", "src", "standby", "style", "summary", "tabindex", "title", "type", "usemap", "valign", "value", "valuetype", "width"};
    private static final int INDEX_LEN = 25;
    private static final int INDEX_BASE = 97;
    private static final int[][] TAGS_INDEX = new int[25][2];
    private static final int[][] ATTRS_INDEX = new int[25][2];

    HtmlElements() {
    }

    private static void index(String[] source, int[][] index) {
        int i;
        for (i = 0; i < index.length; ++i) {
            Arrays.fill(index[i], -1);
        }
        for (i = 0; i < source.length; ++i) {
            char first = source[i].charAt(0);
            char cAscii = first;
            int cIndex = cAscii - 97;
            if (index[cIndex][0] == -1) {
                index[cIndex][0] = i;
                index[cIndex][1] = 1;
                continue;
            }
            int[] nArray = index[cIndex];
            nArray[1] = nArray[1] + 1;
        }
    }

    public static String getCachedTagName(CharSequence tagName) {
        return HtmlElements.getCachedString(TAGS, TAGS_INDEX, tagName);
    }

    public static String getCachedAttrName(CharSequence attrName) {
        return HtmlElements.getCachedString(ATTRS, ATTRS_INDEX, attrName);
    }

    private static String getCachedString(String[] source, int[][] index, CharSequence text) {
        int j;
        int key = text.charAt(0) - 97;
        if (key < 0 || key >= index.length) {
            return null;
        }
        int low = index[key][0];
        int high = low + index[key][1] - 1;
        if (low == -1) {
            return null;
        }
        if (text.length() == 1 && source[low].length() == 1) {
            return source[low];
        }
        int match = -1;
        for (j = 1; j < text.length(); ++j) {
            char c = text.charAt(j);
            match = -1;
            boolean counting = false;
            for (int i = low; i <= high; ++i) {
                String tag = source[i];
                int len = tag.length();
                if (len <= j) {
                    if (!counting) {
                        low = i;
                        continue;
                    }
                    high = i;
                    continue;
                }
                if (tag.charAt(j) == c) {
                    if (!counting) {
                        match = low = i;
                        counting = true;
                        continue;
                    }
                    match = -1;
                    continue;
                }
                if (!counting) continue;
                high = i - 1;
                break;
            }
            if (counting) continue;
            return null;
        }
        return match != -1 ? (j == source[match].length() ? source[match] : null) : null;
    }

    static {
        HtmlElements.index(TAGS, TAGS_INDEX);
        HtmlElements.index(ATTRS, ATTRS_INDEX);
    }
}

