/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.html.lexer;

import java.util.Collection;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.html.lexer.HtmlLexerPlugin;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class HtmlPlugins {
    private static HtmlPlugins DEFAULT;
    private Lookup.Result<HtmlLexerPlugin> lookupResult;
    private Collection<? extends HtmlLexerPlugin> plugins;
    private String[][] data;

    public static synchronized HtmlPlugins getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new HtmlPlugins();
        }
        return DEFAULT;
    }

    private HtmlPlugins() {
        Lookup lookup = MimeLookup.getLookup((String)"text/html");
        this.lookupResult = lookup.lookupResult(HtmlLexerPlugin.class);
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                HtmlPlugins.this.refresh();
            }
        });
        this.refresh();
    }

    private void refresh() {
        Collection allInstances;
        this.plugins = allInstances = this.lookupResult.allInstances();
        this.data = new String[3][allInstances.size()];
        int idx = 0;
        for (HtmlLexerPlugin fact : allInstances) {
            this.data[0][idx] = fact.getOpenDelimiter();
            this.data[1][idx] = fact.getCloseDelimiter();
            this.data[2][idx] = fact.getContentMimeType();
            ++idx;
        }
    }

    public String[] getOpenDelimiters() {
        return this.data[0];
    }

    public String[] getCloseDelimiters() {
        return this.data[1];
    }

    public String[] getMimeTypes() {
        return this.data[2];
    }

    public String createAttributeEmbedding(String elementName, String attributeName) {
        for (HtmlLexerPlugin htmlLexerPlugin : this.plugins) {
            String embeddingMimeType = htmlLexerPlugin.createAttributeEmbedding(elementName, attributeName);
            if (embeddingMimeType == null) continue;
            return embeddingMimeType;
        }
        return null;
    }
}

