/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class GradleProjectNode
extends AbstractNode {
    private final NbGradleProjectImpl project;
    private final ProjectInformation info;

    public GradleProjectNode(Lookup lookup, NbGradleProjectImpl proj) {
        super(NodeFactorySupport.createCompositeChildren((Project)proj, (String)"Projects/org-netbeans-modules-gradle/Nodes"), lookup);
        this.project = proj;
        this.info = ProjectUtils.getInformation((Project)this.project);
        this.info.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String prop = event.getPropertyName();
                if (null != prop) {
                    switch (prop) {
                        case "name": {
                            GradleProjectNode.this.fireNameChange(null, null);
                            break;
                        }
                        case "displayName": {
                            GradleProjectNode.this.fireDisplayNameChange(null, GradleProjectNode.this.getDisplayName());
                            break;
                        }
                        case "icon": {
                            GradleProjectNode.this.fireIconChange();
                            GradleProjectNode.this.fireOpenedIconChange();
                        }
                    }
                }
            }
        });
        ProjectProblemsProvider problems = (ProjectProblemsProvider)proj.getLookup().lookup(ProjectProblemsProvider.class);
        if (problems != null) {
            problems.addPropertyChangeListener(evt -> {
                if ("problems".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(() -> {
                        this.fireNameChange(null, this.getName());
                        this.fireDisplayNameChange(null, this.getDisplayName());
                        this.fireShortDescriptionChange(null, this.getShortDescription());
                    });
                }
            });
        }
    }

    public String getName() {
        return this.info.getName();
    }

    public String getDisplayName() {
        return this.info.getDisplayName();
    }

    public Image getIcon(int param) {
        return ImageUtilities.icon2Image((Icon)this.info.getIcon());
    }

    public Image getOpenedIcon(int param) {
        return ImageUtilities.icon2Image((Icon)this.info.getIcon());
    }

    public Action[] getActions(boolean param) {
        return CommonProjectActions.forType((String)"org-netbeans-modules-gradle");
    }

    public String getShortDescription() {
        StringBuilder buf = new StringBuilder();
        GradleBaseProject gp = this.project.getGradleProject().getBaseProject();
        String desc = gp.getDescription();
        if (desc == null) {
            desc = Bundle.LBL_DefaultDescription();
        }
        buf.append("<html><i>").append(Bundle.DESC_Project1()).append("</i><b> ").append(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())).append("</b><br><i>");
        buf.append(Bundle.DESC_Project2()).append("</i><b> ").append(gp.getGroup()).append("</b><br><i>");
        buf.append(Bundle.DESC_Project3()).append("</i><b> ").append(gp.getName()).append("</b><br><i>");
        buf.append(Bundle.DESC_Project4()).append("</i><b> ").append(gp.getVersion()).append("</b><br><i>");
        Collection problems = ((ProjectProblemsProvider)this.project.getLookup().lookup(ProjectProblemsProvider.class)).getProblems();
        if (!problems.isEmpty()) {
            buf.append("<br><b>").append(Bundle.DESC_Project7()).append("</b><br><ul>");
            for (ProjectProblemsProvider.ProjectProblem elem : problems) {
                buf.append("<li>").append(elem.getDisplayName()).append("</li>");
            }
            buf.append("</ul>");
        }
        return buf.toString();
    }
}

