/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.GradleModuleFileCache21;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.ModuleSearchSupport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.cache.SubProjectDiskCache;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class GradleBaseProject
implements Serializable,
ModuleSearchSupport {
    public static final String PRIVATE_TASK_GROUP = "<private>";
    String name;
    String group = "";
    String description;
    String version;
    String path;
    String status;
    String parentName;
    String displayName;
    File buildDir;
    File projectDir;
    File rootDir;
    String license;
    Set<String> plugins = Collections.emptySet();
    Set<File> gradleClassPath = Collections.emptySet();
    Set<File> buildClassPath = Collections.emptySet();
    Map<String, File> subProjects = Collections.emptyMap();
    Map<String, File> includedBuilds = Collections.emptyMap();
    Map<String, List<GradleTask>> tasksByGroup = new HashMap<String, List<GradleTask>>();
    Map<String, GradleTask> tasksByName = new HashMap<String, GradleTask>();
    Map<String, String> netBeansProperties = Collections.emptyMap();
    Map<File, GradleDependency.ModuleDependency> componentsByFile = new HashMap<File, GradleDependency.ModuleDependency>();
    Map<String, GradleConfiguration> configurations = new HashMap<String, GradleConfiguration>();
    Set<File> outputPaths = Collections.emptySet();
    Map<String, String> projectIds = Collections.emptyMap();
    GradleDependency projectDependencyNode;
    Set<GradleReport> problems = Collections.emptySet();
    Map<String, List<String>> taskDependencies = new HashMap<String, List<String>>();
    Map<String, Set<String>> taskTypes = new HashMap<String, Set<String>>();
    private transient Map<String, List<GradleTask>> taskDeepDependencies = new HashMap<String, List<GradleTask>>();
    transient Boolean resolved = null;

    GradleBaseProject() {
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getStatus() {
        return this.status;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isVersionSpecified() {
        return this.version != null && !"".equals(this.version) && !"unspecified".equals(this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public Set<File> getOutputPaths() {
        return this.outputPaths;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public Set<String> getPlugins() {
        return this.plugins;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public Set<File> getGradleClassPath() {
        return this.gradleClassPath;
    }

    public Set<File> getBuildClassPath() {
        return this.buildClassPath;
    }

    public Map<String, File> getIncludedBuilds() {
        return this.includedBuilds;
    }

    public Set<GradleReport> getProblems() {
        return this.problems;
    }

    public boolean isRoot() {
        return this.projectDir.equals(this.rootDir);
    }

    public String getNetBeansProperty(String key) {
        return this.netBeansProperties.get(key);
    }

    public String getLicense() {
        return this.license != null ? this.license : "default";
    }

    public Map<String, File> getSubProjects() {
        return this.subProjects;
    }

    public String findProjectGav(@NonNull String projectPath) {
        if ("".equals(projectPath) || this.getPath().equals(projectPath)) {
            String n = this.getName();
            String g = this.getGroup();
            String v = this.getVersion();
            if (n == null || n.isEmpty() || g == null || g.isEmpty() || v == null || v.isEmpty() || "unspecified".equals(v)) {
                return null;
            }
            return String.format("%s:%s:%s", g, n, v);
        }
        return this.projectIds.get(projectPath);
    }

    public Set<String> getTaskGroups() {
        return Collections.unmodifiableSet(this.tasksByGroup.keySet());
    }

    public List<GradleTask> getTasks(String group) {
        List<GradleTask> ret = this.tasksByGroup.get(group);
        return ret != null ? Collections.unmodifiableList(ret) : Collections.emptyList();
    }

    public List<GradleTask> getTasks() {
        return Collections.unmodifiableList(new ArrayList<GradleTask>(this.tasksByName.values()));
    }

    public Set<String> getTaskNames() {
        return Collections.unmodifiableSet(this.tasksByName.keySet());
    }

    public GradleTask getTaskByName(String name) {
        return this.tasksByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GradleTask> getTaskPredecessors(GradleTask gt, boolean directs) {
        ArrayList orderedTasks;
        String taskPath;
        if (gt.getName() == null || this.getTaskByName(gt.getName()) != gt) {
            return Collections.emptyList();
        }
        if (!directs) {
            GradleBaseProject gradleBaseProject = this;
            synchronized (gradleBaseProject) {
                List<GradleTask> cached = this.taskDeepDependencies.get(gt.getName());
                if (cached != null) {
                    return cached;
                }
            }
        }
        HashSet<String> paths = new HashSet<String>();
        ArrayDeque<String> toProcess = new ArrayDeque<String>();
        toProcess.add(gt.getPath());
        HashMap<String, String> taskNamesAndPaths = new HashMap<String, String>();
        boolean first = true;
        HashSet<String> ownTasks = new HashSet<String>();
        while ((taskPath = (String)toProcess.poll()) != null) {
            if (taskPath.equals("") || !paths.add(taskPath)) continue;
            int lastColon = taskPath.lastIndexOf(58);
            String p = taskPath.substring(0, Math.max(1, lastColon));
            String n = taskPath.substring(lastColon + 1);
            taskNamesAndPaths.put(taskPath, n);
            if (this.path.equals(p)) {
                ownTasks.add(taskPath);
                if (!directs || first) {
                    toProcess.addAll(this.taskDependencies.getOrDefault(n, Collections.emptyList()));
                }
            }
            first = false;
        }
        paths.remove(gt.getPath());
        HashMap<String, List> edges = new HashMap<String, List>();
        for (String tn : ownTasks) {
            String sn = (String)taskNamesAndPaths.get(tn);
            for (String pred : this.taskDependencies.getOrDefault(sn, Collections.emptyList())) {
                if (pred.isEmpty()) continue;
                edges.computeIfAbsent(pred, k -> new ArrayList()).add(tn);
            }
        }
        try {
            orderedTasks = Utilities.topologicalSort(paths, edges);
        }
        catch (TopologicalSortException ex) {
            orderedTasks = new ArrayList(taskNamesAndPaths.keySet());
        }
        ArrayList<GradleTask> result = new ArrayList<GradleTask>();
        for (String p : orderedTasks) {
            String n = (String)taskNamesAndPaths.get(p);
            GradleTask toAdd = null;
            if (ownTasks.contains(p)) {
                toAdd = this.getTaskByName(n);
            }
            if (toAdd == null) {
                toAdd = new GradleTask(p, n);
            }
            result.add(toAdd);
        }
        if (!directs) {
            GradleBaseProject gradleBaseProject = this;
            synchronized (gradleBaseProject) {
                this.taskDeepDependencies.putIfAbsent(gt.getName(), result);
            }
        }
        return result;
    }

    public boolean isTaskInstanceOf(String name, String gradleFQN) {
        Set<String> s = this.taskTypes.get(name);
        return s == null ? false : s.contains(gradleFQN);
    }

    public Map<String, GradleConfiguration> getConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    public Set<GradleDependency.ProjectDependency> getProjectDependencies() {
        HashSet<GradleDependency.ProjectDependency> ret = new HashSet<GradleDependency.ProjectDependency>();
        for (GradleConfiguration conf : this.configurations.values()) {
            ret.addAll(conf.getProjects());
        }
        return Collections.unmodifiableSet(ret);
    }

    public boolean hasPlugins(String ... plugins) {
        for (String plugin : plugins) {
            if (this.plugins.contains(plugin)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<GradleDependency.ModuleDependency> findModules(String group, String artifact, String version) {
        HashSet<GradleDependency.ModuleDependency> ret = new HashSet<GradleDependency.ModuleDependency>();
        for (GradleConfiguration conf : this.configurations.values()) {
            ret.addAll(conf.findModules(group, artifact, version));
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<GradleDependency.ModuleDependency> findModules(String gav) throws IllegalArgumentException {
        String[] parts = GradleModuleFileCache21.gavSplit(gav);
        String groupId = parts[0].isEmpty() ? null : parts[0];
        String artifactId = parts[1].isEmpty() ? null : parts[1];
        String ver = parts[2].isEmpty() ? null : parts[2];
        return this.findModules(groupId, artifactId, ver);
    }

    public boolean isResolved() {
        if (this.resolved == null) {
            boolean b = true;
            for (GradleConfiguration value : this.configurations.values()) {
                if (value.isCanBeResolved() && !(b &= value.isResolved())) break;
            }
            this.resolved = b;
        }
        return this.resolved;
    }

    public boolean isRootOf(GradleBaseProject other) {
        if (other == null) {
            return false;
        }
        return this.isRoot() && !other.isRoot() && this.subProjects.containsKey(other.name) && this.projectDir.equals(other.rootDir);
    }

    public boolean isSibling(GradleBaseProject other) {
        if (other == null) {
            return false;
        }
        return !this.isRoot() && !other.isRoot() && this.rootDir.equals(other.rootDir) && !this.projectDir.equals(other.projectDir);
    }

    GradleConfiguration createConfiguration(String name) {
        GradleConfiguration conf = new GradleConfiguration(name);
        this.configurations.put(name, conf);
        return conf;
    }

    public static GradleBaseProject get(Project project) {
        NbGradleProject gp = NbGradleProject.get(project);
        return gp != null ? gp.projectLookup(GradleBaseProject.class) : null;
    }

    static GradleBaseProject getFallback(GradleFiles files) {
        Set<File> subProjects;
        GradleBaseProject ret = new GradleBaseProject();
        ret.name = files.getProjectDir().getName();
        ret.projectDir = files.getProjectDir();
        ret.buildDir = new File(files.getProjectDir(), "build");
        ret.rootDir = files.getRootDir();
        ret.version = "unspecified";
        SubProjectDiskCache.SubProjectInfo structure = (SubProjectDiskCache.SubProjectInfo)SubProjectDiskCache.get(files.getRootDir()).loadData();
        if (structure != null) {
            ret.path = structure.getProjectPath(files.getProjectDir());
            ret.description = structure.getProjectDescription(files.getProjectDir());
            ret.name = structure.getProjectName(files.getProjectDir());
        }
        if (ret.path == null) {
            StringBuilder path = new StringBuilder(":");
            if (!files.isRootProject()) {
                Path prjPath = files.getProjectDir().toPath();
                Path rootPath = files.getRootDir().toPath();
                Object separator = "";
                Path relPath = rootPath.relativize(prjPath);
                for (int i = 0; i < relPath.getNameCount(); ++i) {
                    path.append((String)separator);
                    path.append(relPath.getName(i));
                    separator = ":";
                }
            }
            ret.path = path.toString();
        }
        ret.status = "release";
        ret.parentName = files.isRootProject() ? null : files.getRootDir().getName();
        HashMap<String, String> nbprops = new HashMap<String, String>();
        nbprops.put("augmented.build", "false");
        nbprops.put("compile.on.save", "false");
        ret.netBeansProperties = Collections.unmodifiableMap(nbprops);
        Map<String, File> subPrj = Collections.emptyMap();
        if (files.isRootProject() && files.getSettingsScript() != null && !(subProjects = GradleFiles.SettingsFile.getSubProjects(files.getSettingsScript())).isEmpty()) {
            subPrj = new HashMap();
            for (File sp : subProjects) {
                subPrj.put(sp.getName(), sp);
            }
        }
        ret.subProjects = Collections.unmodifiableMap(subPrj);
        HashSet<String> plugins = new HashSet<String>();
        File srcDir = new File(files.getProjectDir(), "src");
        if (srcDir.isDirectory()) {
            File[] sourceSets;
            HashSet setNames = new HashSet();
            for (File dir : sourceSets = srcDir.listFiles()) {
                if (!dir.isDirectory()) continue;
                if ("dist".equals(dir.getName())) {
                    plugins.add("distribution");
                }
                if (new File(dir, "java").isDirectory()) {
                    plugins.add("java");
                }
                if (new File(dir, "resources").isDirectory()) {
                    plugins.add("java");
                }
                if (new File(dir, "groovy").isDirectory()) {
                    plugins.add("java");
                    plugins.add("groovy");
                    plugins.add("groovy-base");
                }
                if (new File(dir, "scala").isDirectory()) {
                    plugins.add("java");
                    plugins.add("scala");
                    plugins.add("scala-base");
                }
                if (!new File(dir, "webapp").isDirectory()) continue;
                plugins.add("java");
                plugins.add("war");
            }
            if (plugins.contains("java")) {
                plugins.add("java-base");
                plugins.add("base");
            }
            ret.plugins = Collections.unmodifiableSet(plugins);
        }
        return ret;
    }

    public String toString() {
        return "GradleBaseProject{name=" + this.name + ", projectDir=" + this.projectDir + ", plugins=" + this.plugins + "}";
    }
}

