/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.GradleProjectLoader;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.api.GradleProjects;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.execute.EscapeProcessingOutputStream;
import org.netbeans.modules.gradle.execute.GradlePlainEscapeProcessor;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.newproject.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class TemplateOperation
implements Runnable {
    private static final Logger LOG = Logger.getLogger(TemplateOperation.class.getName());
    final List<OperationStep> steps = new LinkedList<OperationStep>();
    final ProgressHandle handle;
    final Set<FileObject> importantFiles = new LinkedHashSet<FileObject>();

    public TemplateOperation(ProgressHandle handle) {
        this.handle = handle;
    }

    public TemplateOperation() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.handle != null) {
            this.handle.start(this.steps.size());
        }
        try {
            int work = 0;
            for (OperationStep step : this.steps) {
                if (this.handle != null) {
                    this.handle.progress(step.getMessage(), work++);
                }
                LOG.log(Level.FINE, "Executing Gradle Project Template Operation {0}", step);
                Set<FileObject> filesToOpen = step.execute();
                if (filesToOpen == null) continue;
                this.importantFiles.addAll(filesToOpen);
            }
        }
        finally {
            if (this.handle != null) {
                this.handle.finish();
            }
        }
    }

    public Set<FileObject> getImportantFiles() {
        return Collections.unmodifiableSet(this.importantFiles);
    }

    public void createFolder(File target) {
        this.steps.add(new CreateDirStep(target, Bundle.MSG_CREATE_FOLDER(target.getName())));
    }

    public void createPackage(File base, String pkg) {
        String relativePath = pkg.replace('.', '/');
        this.steps.add(new CreateDirStep(new File(base, relativePath), Bundle.MSG_CREATE_PACKAGE(pkg)));
    }

    public void addConfigureProject(File projectDir, ProjectConfigurator configurator) {
        this.steps.add(new ConfigureProjectStep(projectDir, configurator));
    }

    public void addWrapperInit(File target) {
        this.steps.add(new InitGradleWrapper(target, null));
    }

    public void addWrapperInit(File target, String version) {
        this.steps.add(new InitGradleWrapper(target, version));
    }

    public InitOperation createGradleInit(File target, String type) {
        return new InitStep(target, type);
    }

    public void copyFromFile(String templateName, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromFileTemplate(templateName, target, tokens, false));
    }

    public void openFromFile(String templateName, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromFileTemplate(templateName, target, tokens, true));
    }

    public void copyFromTemplate(String template, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromTemplate(template, target, tokens, false));
    }

    public void openFromTemplate(String template, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromTemplate(template, target, tokens, true));
    }

    public void addProjectPreload(File projectDir) {
        this.steps.add(new PreloadProject(projectDir));
    }

    public void addProjectPreload(File projectDir, List<String> important) {
        this.steps.add(new PreloadProject(projectDir, important));
    }

    static interface OperationStep {
        public String getMessage();

        public Set<FileObject> execute();
    }

    private static final class CreateDirStep
    extends BaseOperationStep {
        final String message;
        final File dir;

        public CreateDirStep(File dir, String message) {
            this.dir = dir;
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Set<FileObject> execute() {
            try {
                FileUtil.createFolder((File)this.dir);
                Thread.sleep(200L);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class ConfigureProjectStep
    extends BaseOperationStep {
        final File dir;
        final ProjectConfigurator configurator;

        public ConfigureProjectStep(File dir, ProjectConfigurator configurator) {
            this.dir = dir;
            this.configurator = configurator;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_CONFIGURING_PROJECT();
        }

        @Override
        public final Set<FileObject> execute() {
            if (GradleProjects.testForProject(this.dir)) {
                try {
                    NbGradleProjectImpl impl;
                    FileObject projectDir = FileUtil.toFileObject((File)this.dir);
                    Project project = ProjectManager.getDefault().findProject(projectDir);
                    ProjectTrust.getDefault().trustProject(project);
                    NbGradleProjectImpl nbGradleProjectImpl = impl = project != null ? (NbGradleProjectImpl)project.getLookup().lookup(NbGradleProjectImpl.class) : null;
                    if (impl != null) {
                        impl.projectWithQuality(null, NbGradleProject.Quality.FULL, false, false);
                        this.configurator.configure(project);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Set.of();
        }
    }

    public static interface ProjectConfigurator {
        public void configure(Project var1);
    }

    private static final class InitGradleWrapper
    extends BaseOperationStep {
        final File projectDir;
        final String version;

        public InitGradleWrapper(File projectDir, String version) {
            this.projectDir = projectDir;
            this.version = version;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_INIT_WRAPPER();
        }

        @Override
        public Set<FileObject> execute() {
            GradleConnector gconn = GradleConnector.newConnector();
            try (ProjectConnection pconn = gconn.forProjectDirectory(this.projectDir).connect();){
                ArrayList<String> args = new ArrayList<String>();
                args.add("wrapper");
                if (this.version != null) {
                    args.add("--gradle-version");
                    args.add(this.version);
                }
                if (GradleSettings.getDefault().isOffline()) {
                    ((BuildLauncher)pconn.newBuild().withArguments(new String[]{"--offline"})).forTasks(args.toArray(new String[0])).run();
                } else {
                    pconn.newBuild().forTasks(args.toArray(new String[0])).run();
                }
            }
            catch (IllegalStateException | GradleConnectionException throwable) {
                // empty catch block
            }
            gconn.disconnect();
            return null;
        }
    }

    private final class InitStep
    extends InitOperation
    implements OperationStep {
        private final File target;
        private final String type;
        private String dsl;
        private String testFramework;
        private String basePackage;
        private String projectName;
        private String javaVersion;
        private Boolean comments;

        InitStep(File target, String type) {
            this.target = target;
            this.type = type;
        }

        @Override
        public InitStep dsl(String dsl) {
            this.dsl = dsl;
            return this;
        }

        @Override
        public InitStep testFramework(String testFramework) {
            this.testFramework = testFramework;
            return this;
        }

        @Override
        public InitStep basePackage(String pkg) {
            this.basePackage = pkg;
            return this;
        }

        @Override
        public InitStep projectName(String name) {
            this.projectName = name;
            return this;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_INIT_GRADLE(this.type, this.target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<FileObject> execute() {
            GradleConnector gconn = GradleConnector.newConnector();
            this.target.mkdirs();
            InputOutput io = IOProvider.getDefault().getIO(this.projectName + " (init)", true);
            try (ProjectConnection pconn = gconn.forProjectDirectory(this.target).connect();){
                ArrayList<String> args = new ArrayList<String>();
                args.add("init");
                args.add("--type");
                args.add(this.type);
                if (this.testFramework != null) {
                    args.add("--test-framework");
                    args.add(this.testFramework);
                }
                if (this.dsl != null) {
                    args.add("--dsl");
                    args.add(this.dsl);
                }
                if (this.basePackage != null) {
                    args.add("--package");
                    args.add(this.basePackage);
                }
                if (this.projectName != null) {
                    args.add("--project-name");
                    args.add(this.projectName);
                }
                if (this.javaVersion != null) {
                    args.add("--java-version");
                    args.add(this.javaVersion);
                }
                if (this.comments != null) {
                    args.add(this.comments != false ? "--comments" : "--no-comments");
                }
                args.add("--use-defaults");
                try (EscapeProcessingOutputStream out = new EscapeProcessingOutputStream(new GradlePlainEscapeProcessor(io, false));
                     EscapeProcessingOutputStream err = new EscapeProcessingOutputStream(new GradlePlainEscapeProcessor(io, false));){
                    BuildLauncher gradleInit = pconn.newBuild().forTasks(args.toArray(new String[0]));
                    if (GradleSettings.getDefault().isOffline()) {
                        gradleInit = (BuildLauncher)gradleInit.withArguments(new String[]{"--offline"});
                    }
                    gradleInit.setStandardOutput((OutputStream)out);
                    gradleInit.setStandardError((OutputStream)err);
                    gradleInit.run();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (IllegalStateException | GradleConnectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (io.getOut() != null) {
                    io.getOut().close();
                }
                if (io.getErr() != null) {
                    io.getErr().close();
                }
            }
            gconn.disconnect();
            return Collections.singleton(FileUtil.toFileObject((File)this.target));
        }

        @Override
        public InitOperation javaVersion(String version) {
            this.javaVersion = version;
            return this;
        }

        @Override
        public InitOperation comments(Boolean comments) {
            this.comments = comments;
            return this;
        }
    }

    private static final class CopyFromFileTemplate
    extends BaseOperationStep {
        final File target;
        final Map<String, ? extends Object> tokens;
        final boolean important;
        final String templateName;

        public CopyFromFileTemplate(String templateName, File target, Map<String, ? extends Object> tokens, boolean important) {
            this.templateName = templateName;
            this.target = target;
            this.tokens = tokens;
            this.important = important;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_COPY_TEMPLATE(this.target.getName());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<FileObject> execute() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager(l);
            ScriptEngine engine = scriptEngineManager.getEngineByName("freemarker");
            assert (engine != null);
            Bindings bindings = engine.getContext().getBindings(100);
            String basename = this.target.getName();
            bindings.put("name", basename.replaceFirst("\\.[^./]+$", ""));
            bindings.put("user", System.getProperty("user.name"));
            Date d = new Date();
            bindings.put("date", DateFormat.getDateInstance().format(d));
            bindings.put("time", DateFormat.getTimeInstance().format(d));
            bindings.put("nameAndExt", this.target.getName());
            bindings.putAll(this.tokens);
            try {
                FileObject fo = FileUtil.createData((File)this.target);
                Charset targetEnc = Charset.defaultCharset();
                bindings.put("encoding", targetEnc.name());
                try (OutputStreamWriter w = new OutputStreamWriter(fo.getOutputStream(), targetEnc);){
                    engine.getContext().setWriter(w);
                    try (InputStreamReader is = new InputStreamReader(TemplateOperation.class.getResourceAsStream("/" + this.templateName));){
                        engine.eval(is);
                    }
                    catch (IOException | ScriptException ex) {
                        throw new IOException(ex.getMessage(), ex);
                    }
                    Set<FileObject> set = this.important ? Set.of(fo) : null;
                    return set;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class CopyFromTemplate
    extends BaseOperationStep {
        final File target;
        final Map<String, ? extends Object> tokens;
        final boolean important;
        final String templateName;

        public CopyFromTemplate(String templateName, File target, Map<String, ? extends Object> tokens, boolean important) {
            this.templateName = templateName;
            this.target = target;
            this.tokens = tokens;
            this.important = important;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_COPY_TEMPLATE(this.target.getName());
        }

        @Override
        public Set<FileObject> execute() {
            FileObject template = FileUtil.getConfigFile((String)this.templateName);
            if (template != null) {
                String targetName = this.target.getName();
                try {
                    FileObject targetParent = FileUtil.createFolder((File)this.target.getParentFile());
                    DataFolder targetFolder = DataFolder.findFolder((FileObject)targetParent);
                    DataObject o = DataObject.find((FileObject)template);
                    DataObject newData = o.createFromTemplate(targetFolder, targetName, this.tokens);
                    return this.important ? Set.of(newData.getPrimaryFile()) : null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static final class PreloadProject
    extends BaseOperationStep {
        final File dir;
        final List<String> importantFiles;

        public PreloadProject(File dir) {
            this(dir, List.of());
        }

        public PreloadProject(File dir, List<String> importantFiles) {
            this.dir = dir;
            this.importantFiles = importantFiles;
        }

        @Override
        public String getMessage() {
            return GradleProjects.testForProject(this.dir) ? Bundle.MSG_PRELOAD_PROJECT(this.dir.getName()) : Bundle.MSM_CHECKING_FOLDER(this.dir.getName());
        }

        @Override
        public Set<FileObject> execute() {
            if (GradleProjects.testForProject(this.dir)) {
                try {
                    FileObject projectDir = FileUtil.toFileObject((File)this.dir);
                    Project project = ProjectManager.getDefault().findProject(projectDir);
                    if (project == null) {
                        ProjectManager.getDefault().clearNonProjectCache();
                    }
                    if ((project = ProjectManager.getDefault().findProject(projectDir)) != null) {
                        GradleProjectLoader loader;
                        ProjectTrust.getDefault().trustProject(project);
                        NbGradleProjectImpl nbProject = (NbGradleProjectImpl)project.getLookup().lookup(NbGradleProjectImpl.class);
                        if (nbProject != null && (loader = (GradleProjectLoader)nbProject.getLookup().lookup(GradleProjectLoader.class)) != null) {
                            loader.loadProject(NbGradleProject.loadOptions(NbGradleProject.Quality.FULL_ONLINE).setIgnoreCache(true), new String[0]);
                        }
                        LinkedHashSet<FileObject> ret = new LinkedHashSet<FileObject>();
                        ret.add(projectDir);
                        for (String f : this.importantFiles) {
                            FileObject fo = projectDir.getFileObject(f);
                            if (fo == null) continue;
                            ret.add(fo);
                        }
                        return ret;
                    }
                }
                catch (IOException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static abstract class BaseOperationStep
    implements OperationStep {
        private BaseOperationStep() {
        }

        public final String toString() {
            return "Step: " + this.getMessage();
        }
    }

    public abstract class InitOperation {
        InitOperation() {
        }

        public final void add() {
            TemplateOperation.this.steps.add((OperationStep)((Object)this));
        }

        public abstract InitOperation dsl(String var1);

        public abstract InitOperation testFramework(String var1);

        public abstract InitOperation basePackage(String var1);

        public abstract InitOperation projectName(String var1);

        public abstract InitOperation javaVersion(String var1);

        public abstract InitOperation comments(Boolean var1);
    }
}

