/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeListener;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.WatchedResourceProvider;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class GradleDistributionProviderImpl
implements GradleDistributionProvider,
WatchedResourceProvider {
    private static final Logger LOGGER = Logger.getLogger(GradleDistributionProviderImpl.class.getName());
    private static final List<String> AFFECTING_PROPS = Arrays.asList("gradleUserHome", "useCustomGradle", "gradleHome", "preferWrapper", "gradleVersion");
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private final PreferenceChangeListener listener = evt -> {
        if (AFFECTING_PROPS.contains(evt.getKey())) {
            this.distributionChanged();
        }
    };
    final NbGradleProjectImpl project;
    private GradleDistributionManager.GradleDistribution dist;
    private PropertyChangeListener pcl;
    private URI distributionURI;

    public GradleDistributionProviderImpl(Project project) {
        this.project = (NbGradleProjectImpl)project;
        this.pcl = evt -> {
            URI uri;
            if ("resources".equals(evt.getPropertyName()) && (uri = (URI)evt.getNewValue()) != null && uri.getPath() != null && uri.getPath().endsWith("gradle/wrapper/gradle-wrapper.properties")) {
                URI newDistURI = this.getWrapperDistributionURI();
                if (GradleSettings.getDefault().isWrapperPreferred() && this.distributionURI != null && !Objects.equal((Object)this.distributionURI, (Object)newDistURI)) {
                    this.distributionURI = newDistURI;
                    this.distributionChanged();
                }
            }
        };
        NbGradleProject.addPropertyChangeListener(project, WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)project));
    }

    @Override
    public GradleDistributionManager.GradleDistribution getGradleDistribution() {
        if (this.dist == null) {
            GradleSettings settings = GradleSettings.getDefault();
            GradleDistributionManager mgr = GradleDistributionManager.get();
            if (settings.isWrapperPreferred()) {
                try {
                    this.dist = mgr.distributionFromWrapper(this.project.getGradleFiles().getRootDir());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Cannot evaulate Gradle Wrapper", ex);
                }
            }
            if (this.dist == null && settings.useCustomGradle() && !settings.getDistributionHome().isEmpty()) {
                try {
                    this.dist = mgr.distributionFromDir(new File(settings.getDistributionHome()));
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "Cannot evaulate Gradle Distribution", ex);
                }
            }
            if (this.dist == null) {
                this.dist = mgr.distributionFromVersion(settings.getGradleVersion());
            }
            LOGGER.log(Level.INFO, "Gradle Distribution for {0} is {1}", new Object[]{this.project, this.dist});
        }
        return this.dist;
    }

    private void distributionChanged() {
        this.dist = null;
        this.support.fireChange();
        NbGradleProject.fireGradleProjectReload(this.project);
    }

    private URI getWrapperDistributionURI() {
        URI ret = null;
        try {
            ret = GradleDistributionManager.getWrapperDistributionURI(this.project.getGradleFiles().getRootDir());
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (!this.support.hasListeners()) {
            GradleSettings.getDefault().getPreferences().addPreferenceChangeListener(this.listener);
        }
        this.support.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.support.removeChangeListener(l);
        if (!this.support.hasListeners()) {
            GradleSettings.getDefault().getPreferences().removePreferenceChangeListener(this.listener);
        }
    }

    @Override
    public Set<File> getWatchedResources() {
        return Collections.singleton(new File(this.project.getGradleFiles().getRootDir(), "gradle/wrapper/gradle-wrapper.properties"));
    }
}

