/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.NbProjectInfo;
import org.netbeans.modules.gradle.cache.AbstractDiskCache;
import org.netbeans.modules.gradle.spi.GradleFiles;

public final class ProjectInfoDiskCache
extends AbstractDiskCache<GradleFiles, QualifiedProjectInfo> {
    private static final int COMPATIBLE_CACHE_VERSION = 21;
    private static final String INFO_CACHE_FILE_NAME = "project-info.ser";
    private static final Map<GradleFiles, ProjectInfoDiskCache> DISK_CACHES = Collections.synchronizedMap(new WeakHashMap());

    public static ProjectInfoDiskCache get(GradleFiles gf) {
        ProjectInfoDiskCache ret = DISK_CACHES.computeIfAbsent(gf, k -> new ProjectInfoDiskCache((GradleFiles)k));
        return ret;
    }

    private ProjectInfoDiskCache(GradleFiles gf) {
        super(gf);
    }

    public static void testFlushCaches() {
        DISK_CACHES.clear();
    }

    public static boolean testDestroyCache(GradleFiles gf) {
        ProjectInfoDiskCache cache = ProjectInfoDiskCache.get(gf);
        if (cache == null) {
            return false;
        }
        File f = cache.cacheFile();
        return f.exists() && f.delete();
    }

    @Override
    protected int cacheVersion() {
        return 21;
    }

    @Override
    protected File cacheFile() {
        return new File(NbGradleProjectImpl.getCacheDir((GradleFiles)this.key), INFO_CACHE_FILE_NAME);
    }

    @Override
    protected Set<File> cacheInvalidators() {
        HashSet<File> ret = new HashSet<File>(((GradleFiles)this.key).getProjectFiles());
        if (((GradleFiles)this.key).hasWrapper()) {
            ret.add(((GradleFiles)this.key).getWrapperProperties());
        }
        return ret;
    }

    private static CacheReport makeReport(NbProjectInfo.Report r) {
        CacheReport nested = r.getCause() != null ? ProjectInfoDiskCache.makeReport(r.getCause()) : null;
        return new CacheReport(r.getErrorClass(), r.getScriptLocation(), r.getLineNumber(), r.getMessage(), nested);
    }

    private static Set<NbProjectInfo.Report> makeReports(Collection<NbProjectInfo.Report> reps) {
        LinkedHashSet<NbProjectInfo.Report> res = new LinkedHashSet<NbProjectInfo.Report>();
        for (NbProjectInfo.Report r : reps) {
            res.add(ProjectInfoDiskCache.makeReport(r));
        }
        return res;
    }

    public static final class QualifiedProjectInfo
    implements NbProjectInfo {
        private final NbGradleProject.Quality quality;
        private final Map<String, Object> info;
        private final transient Map<String, Object> ext;
        private final Set<String> problems;
        private final Set<NbProjectInfo.Report> reports;
        private final String gradleException;

        public QualifiedProjectInfo(NbGradleProject.Quality quality, NbProjectInfo pinfo) {
            this.quality = quality;
            this.info = new TreeMap<String, Object>(pinfo.getInfo());
            this.ext = new TreeMap<String, Object>(pinfo.getExt());
            this.problems = new LinkedHashSet<String>(pinfo.getProblems());
            this.gradleException = pinfo.getGradleException();
            this.reports = ProjectInfoDiskCache.makeReports(pinfo.getReports());
        }

        public Map<String, Object> getInfo() {
            return this.info;
        }

        public Map<String, Object> getExt() {
            return this.ext != null ? this.ext : Collections.emptyMap();
        }

        public Set<String> getProblems() {
            return this.problems;
        }

        public Set<NbProjectInfo.Report> getReports() {
            return this.reports;
        }

        public String getGradleException() {
            return this.gradleException;
        }

        public boolean hasException() {
            return this.gradleException != null;
        }

        public boolean getMiscOnly() {
            return false;
        }

        public NbGradleProject.Quality getQuality() {
            return this.quality;
        }

        public String toString() {
            return "QualifiedProjectInfo{quality=" + (Object)((Object)this.quality) + '}';
        }
    }

    static final class CacheReport
    implements NbProjectInfo.Report,
    Serializable {
        private final String errorClass;
        private final String location;
        private final int line;
        private final String message;
        private final NbProjectInfo.Report causedBy;

        public CacheReport(String errorClass, String location, int line, String message, NbProjectInfo.Report causedBy) {
            this.errorClass = errorClass;
            this.location = location;
            this.line = line;
            this.message = message;
            this.causedBy = causedBy;
        }

        public String getErrorClass() {
            return this.errorClass;
        }

        public String getScriptLocation() {
            return this.location;
        }

        public int getLineNumber() {
            return this.line;
        }

        @NonNull
        public String getMessage() {
            return this.message;
        }

        @CheckForNull
        public NbProjectInfo.Report getCause() {
            return this.causedBy;
        }

        public int hashCode() {
            int hash = 3;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheReport other = (CacheReport)obj;
            if (this.line != other.line) {
                return false;
            }
            if (!Objects.equals(this.errorClass, other.errorClass)) {
                return false;
            }
            if (!Objects.equals(this.location, other.location)) {
                return false;
            }
            return Objects.equals(this.message, other.message);
        }
    }
}

