/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectErrorNotifications;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.NbProjectInfo;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.cache.ProjectInfoDiskCache;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.loaders.Bundle;
import org.netbeans.modules.gradle.loaders.GradleArtifactStore;
import org.netbeans.modules.gradle.loaders.GradleDaemon;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.util.Cancellable;

public class LegacyProjectLoader
extends AbstractProjectLoader {
    private static final Logger LOG = Logger.getLogger(LegacyProjectLoader.class.getName());
    private static AtomicLong timeInLoad = new AtomicLong();
    private static AtomicInteger loadedProjects = new AtomicInteger();
    private static final boolean DEBUG_GRADLE_INFO_ACTION = Boolean.getBoolean("netbeans.debug.gradle.info.action");

    public LegacyProjectLoader(AbstractProjectLoader.ReloadContext ctx) {
        super(ctx);
    }

    @Override
    public GradleProject load() {
        GradleProject ret;
        try {
            ret = (GradleProject)GradleDaemon.GRADLE_LOADER_RP.submit((Callable)new ProjectLoaderTask(this.ctx)).get();
            LegacyProjectLoader.updateSubDirectoryCache(ret);
        }
        catch (InterruptedException | ExecutionException ex) {
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean isEnabled() {
        return this.ctx.aim.betterThan(NbGradleProject.Quality.FALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GradleProject loadGradleProject(AbstractProjectLoader.ReloadContext ctx, CancellationToken token, ProgressListener pl) {
        GradleBaseProject base;
        NbGradleProject.Quality quality;
        NbProjectInfo info;
        long start;
        block20: {
            GoOnline goOnline;
            start = System.currentTimeMillis();
            info = null;
            quality = ctx.aim;
            base = ctx.previous.getBaseProject();
            ProjectConnection pconn = (ProjectConnection)ctx.project.getLookup().lookup(ProjectConnection.class);
            GradleProjectErrorNotifications errors = (GradleProjectErrorNotifications)ctx.project.getLookup().lookup(GradleProjectErrorNotifications.class);
            GradleCommandLine cmd = new GradleCommandLine(ctx.cmd);
            cmd.setFlag(GradleCommandLine.Flag.CONFIGURE_ON_DEMAND, GradleSettings.getDefault().isConfigureOnDemand());
            cmd.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.INIT_SCRIPT);
            cmd.setStackTrace(GradleCommandLine.StackTrace.SHORT);
            cmd.addSystemProperty("NETBEANS_TOOLING_JAR", GradleDaemon.TOOLING_JAR);
            cmd.addProjectProperty("nbSerializeCheck", "true");
            if (GradleSettings.getDefault().isOffline()) {
                goOnline = GoOnline.NEVER;
            } else if (ctx.aim == NbGradleProject.Quality.FULL_ONLINE) {
                goOnline = GoOnline.ALWAYS;
            } else {
                switch (GradleSettings.getDefault().getDownloadLibs()) {
                    case NEVER: {
                        goOnline = GoOnline.NEVER;
                        break;
                    }
                    case ALWAYS: {
                        goOnline = GoOnline.ALWAYS;
                        break;
                    }
                    default: {
                        goOnline = GoOnline.ON_DEMAND;
                    }
                }
            }
            try {
                errors.clear();
                info = LegacyProjectLoader.retrieveProjectInfo(goOnline, pconn, cmd, token, pl);
                if (!info.hasException()) {
                    if (!info.getProblems().isEmpty()) {
                        quality = NbGradleProject.Quality.SIMPLE;
                        errors.openNotification(Bundle.TIT_LOAD_ISSUES(base.getProjectDir().getName()), Bundle.TIT_LOAD_ISSUES(base.getProjectDir().getName()), GradleProjectErrorNotifications.bulletedList(info.getProblems()));
                    } else {
                        quality = ctx.aim;
                    }
                    break block20;
                }
                String problem = info.getGradleException();
                String[] lines = problem.split("\n");
                LOG.log(Level.INFO, "Failed to retrieve project information for: {0}\nReason: {1}", new Object[]{base.getProjectDir(), problem});
                errors.openNotification(Bundle.TIT_LOAD_FAILED(base.getProjectDir().getName()), lines[0], problem);
                GradleProject gradleProject = ctx.previous.invalidate(problem);
                return gradleProject;
            }
            catch (IllegalStateException | GradleConnectionException ex) {
                LOG.log(Level.FINE, "Failed to retrieve project information for: " + base.getProjectDir(), ex);
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (Throwable th = ex; th != null; th = th.getCause()) {
                    sb.insert(0, separator);
                    sb.insert(0, th.getMessage());
                    separator = "<br/>";
                }
                errors.openNotification(Bundle.TIT_LOAD_FAILED(base.getProjectDir()), ex.getMessage(), sb.toString());
                GradleProject gradleProject = ctx.previous.invalidate(sb.toString());
                return gradleProject;
            }
            finally {
                loadedProjects.incrementAndGet();
            }
        }
        long finish = System.currentTimeMillis();
        timeInLoad.getAndAdd(finish - start);
        LOG.log(Level.FINE, "Loaded project {0} in {1} msec", new Object[]{base.getProjectDir(), finish - start});
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Load happened on AWT event dispatcher", new RuntimeException());
        }
        ProjectInfoDiskCache.QualifiedProjectInfo qinfo = new ProjectInfoDiskCache.QualifiedProjectInfo(quality, info);
        GradleProject ret = LegacyProjectLoader.createGradleProject(qinfo);
        GradleArtifactStore.getDefault().processProject(ret);
        if (info.getMiscOnly()) {
            ret = ctx.previous;
        } else {
            LegacyProjectLoader.saveCachedProjectInfo(qinfo, ret);
        }
        return ret;
    }

    private static BuildActionExecuter<NbProjectInfo> createInfoAction(ProjectConnection pconn, GradleCommandLine cmd, CancellationToken token, ProgressListener pl) {
        BuildActionExecuter ret = pconn.action((BuildAction)new NbProjectInfoAction());
        cmd.configure((ConfigurableLauncher<?>)ret);
        if (DEBUG_GRADLE_INFO_ACTION) {
            ret.addJvmArguments(new String[]{"-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5006"});
        }
        if (token != null) {
            ret.withCancellationToken(token);
        }
        if (pl != null) {
            ret.addProgressListener(pl);
        }
        return ret;
    }

    private static NbProjectInfo retrieveProjectInfo(GoOnline goOnline, ProjectConnection pconn, GradleCommandLine cmd, CancellationToken token, ProgressListener pl) throws GradleConnectionException, IllegalStateException {
        NbProjectInfo ret;
        BuildActionExecuter<NbProjectInfo> action;
        GradleCommandLine online;
        block7: {
            GradleSettings settings = GradleSettings.getDefault();
            online = new GradleCommandLine(cmd);
            GradleCommandLine offline = new GradleCommandLine(cmd);
            if (goOnline != GoOnline.ALWAYS) {
                if (settings.getDownloadSources() == GradleSettings.DownloadMiscRule.ALWAYS) {
                    // empty if block
                }
                if (settings.getDownloadJavadoc() == GradleSettings.DownloadMiscRule.ALWAYS) {
                    // empty if block
                }
                offline.addFlag(GradleCommandLine.Flag.OFFLINE);
            }
            if (goOnline == GoOnline.NEVER || goOnline == GoOnline.ON_DEMAND) {
                action = LegacyProjectLoader.createInfoAction(pconn, offline, token, pl);
                try {
                    ret = (NbProjectInfo)action.run();
                    if (goOnline == GoOnline.NEVER || !ret.hasException()) {
                        return ret;
                    }
                }
                catch (IllegalStateException | GradleConnectionException ex) {
                    if (goOnline != GoOnline.NEVER) break block7;
                    throw ex;
                }
            }
        }
        action = LegacyProjectLoader.createInfoAction(pconn, online, token, pl);
        ret = (NbProjectInfo)action.run();
        return ret;
    }

    private static class ProjectLoaderTask
    implements Callable<GradleProject>,
    Cancellable {
        private final AbstractProjectLoader.ReloadContext ctx;
        private CancellationTokenSource tokenSource;

        public ProjectLoaderTask(AbstractProjectLoader.ReloadContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public GradleProject call() throws Exception {
            this.tokenSource = GradleConnector.newCancellationTokenSource();
            String msg = this.ctx.description != null ? Bundle.FMT_ProjectLoadReason(this.ctx.description, this.ctx.previous.getBaseProject().getName()) : Bundle.LBL_Loading(this.ctx.previous.getBaseProject().getName());
            ProgressHandle handle = ProgressHandle.createHandle((String)msg, (Cancellable)this);
            ProgressListener pl = pe -> handle.progress(pe.getDescription());
            handle.start();
            try {
                GradleProject gradleProject = LegacyProjectLoader.loadGradleProject(this.ctx, this.tokenSource.token(), pl);
                return gradleProject;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
                throw ex;
            }
            finally {
                handle.finish();
            }
        }

        public boolean cancel() {
            if (this.tokenSource != null) {
                this.tokenSource.cancel();
            }
            return true;
        }
    }

    private static class NbProjectInfoAction
    implements Serializable,
    BuildAction<NbProjectInfo> {
        private NbProjectInfoAction() {
        }

        public NbProjectInfo execute(BuildController bc) {
            return (NbProjectInfo)bc.getModel(NbProjectInfo.class);
        }
    }

    private static enum GoOnline {
        NEVER,
        ON_DEMAND,
        ALWAYS;

    }
}

