/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.customizer.CustomActionMapping;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class CustomActionRegistrationSupport {
    public static final String ACTION_PROP_PREFIX = "action.";
    final Map<String, CustomActionMapping> customActions = new TreeMap<String, CustomActionMapping>();
    final Project project;

    public CustomActionRegistrationSupport(Project project) {
        this.project = project;
        ProjectActionMappingProvider mappingProvider = (ProjectActionMappingProvider)project.getLookup().lookup(ProjectActionMappingProvider.class);
        Set<String> customizedActions = mappingProvider.customizedActions();
        customizedActions.forEach(action -> {
            CustomActionMapping mapping = new CustomActionMapping(mappingProvider.findMapping((String)action));
            this.customActions.put((String)action, mapping);
        });
    }

    public String findNewCustonActionId() {
        String ret;
        int i = 1;
        while (this.customActions.containsKey(ret = "custom-" + i++)) {
        }
        return ret;
    }

    public CustomActionMapping registerCustomAction(String name, String displayName, String args, ActionMapping.ReloadRule rule, boolean repeatable) {
        CustomActionMapping mapping = new CustomActionMapping(name);
        mapping.setDisplayName(displayName);
        mapping.setArgs(args);
        mapping.setReloadRule(rule);
        mapping.setRepeatable(repeatable);
        return this.registerCustomAction(mapping);
    }

    public CustomActionMapping registerCustomAction(CustomActionMapping mapping) {
        this.customActions.put(mapping.getName(), mapping);
        return mapping;
    }

    public CustomActionMapping registerCustomAction(String displayName, String args) {
        String name = this.getByDisplayName(displayName);
        if (name == null) {
            name = this.findNewCustonActionId();
        }
        return this.registerCustomAction(name, displayName, args, ActionMapping.ReloadRule.DEFAULT, true);
    }

    public CustomActionMapping unregisterCustomAction(String name) {
        return this.customActions.remove(name);
    }

    public CustomActionMapping getCustomAction(String name) {
        return this.customActions.get(name);
    }

    public Collection<CustomActionMapping> getCustomActions() {
        return Collections.unmodifiableCollection(this.customActions.values());
    }

    private String getByDisplayName(String displayName) {
        String ret = null;
        for (CustomActionMapping value : this.customActions.values()) {
            if (!value.getDisplayName().equals(displayName)) continue;
            ret = value.getName();
            break;
        }
        return ret;
    }

    public void save() {
        EditableProperties props = new EditableProperties(false);
        ProjectManager.mutex().writeAccess(() -> {
            block36: {
                try {
                    FileObject fo = this.project.getProjectDirectory().getFileObject("gradle.properties");
                    if (fo != null) {
                        InputStream is = fo.getInputStream();
                        Object object = null;
                        try {
                            props.load(is);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is != null) {
                                if (object != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    Iterator it = props.keySet().iterator();
                    while (it.hasNext()) {
                        if (!((String)it.next()).startsWith(ACTION_PROP_PREFIX)) continue;
                        it.remove();
                    }
                    for (CustomActionMapping mapping : this.customActions.values()) {
                        String prefix = ACTION_PROP_PREFIX + mapping.getName() + '.';
                        if (mapping.getName().startsWith("custom-")) {
                            props.setProperty(ACTION_PROP_PREFIX + mapping.getName(), mapping.getDisplayName());
                        }
                        if (!mapping.getArgs().isEmpty()) {
                            props.setProperty(prefix + "args", mapping.getArgs());
                        }
                        if (!mapping.getReloadArgs().isEmpty()) {
                            props.setProperty(prefix + "reload.args", mapping.getReloadArgs());
                        }
                        if (mapping.getReloadRule() != ActionMapping.ReloadRule.DEFAULT) {
                            props.setProperty(prefix + "reload.rule", mapping.getReloadRule().name());
                        }
                        if (mapping.isRepeatable()) continue;
                        props.setProperty(prefix + "repeatable", "false");
                    }
                    if (fo != null && props.isEmpty()) {
                        fo.delete();
                    }
                    if (fo == null && !props.isEmpty()) {
                        fo = this.project.getProjectDirectory().createData("gradle.properties");
                    }
                    if (fo == null || props.isEmpty()) break block36;
                    try (OutputStream os = fo.getOutputStream();){
                        props.store(os);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }
}

