/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.GradleProjectCache;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.api.GradleProjects;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.spi.newproject.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class TemplateOperation
implements Runnable {
    final List<OperationStep> steps = new LinkedList<OperationStep>();
    final ProgressHandle handle;
    final Set<FileObject> importantFiles = new LinkedHashSet<FileObject>();

    public TemplateOperation(ProgressHandle handle) {
        this.handle = handle;
    }

    public TemplateOperation() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.handle != null) {
            this.handle.start(this.steps.size());
        }
        try {
            int work = 0;
            for (OperationStep step : this.steps) {
                Set<FileObject> filesToOpen;
                if (this.handle != null) {
                    this.handle.progress(step.getMessage(), work++);
                }
                if ((filesToOpen = step.execute()) == null) continue;
                this.importantFiles.addAll(filesToOpen);
            }
        }
        finally {
            if (this.handle != null) {
                this.handle.finish();
            }
        }
    }

    public Set<FileObject> getImportantFiles() {
        return Collections.unmodifiableSet(this.importantFiles);
    }

    public void createFolder(File target) {
        this.steps.add(new CreateDirStep(target, Bundle.MSG_CREATE_FOLDER(target.getName())));
    }

    public void createPackage(File base, String pkg) {
        String relativePath = pkg.replace('.', '/');
        this.steps.add(new CreateDirStep(new File(base, relativePath), Bundle.MSG_CREATE_PACKAGE(pkg)));
    }

    public void addConfigureProject(File projectDir, ProjectConfigurator configurator) {
        this.steps.add(new ConfigureProjectStep(projectDir, configurator));
    }

    public void addWrapperInit(File target) {
        this.steps.add(new InitGradleWrapper(target));
    }

    public void copyFromFile(String templateName, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromFileTemplate(templateName, target, tokens, false));
    }

    public void openFromFile(String templateName, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromFileTemplate(templateName, target, tokens, true));
    }

    public void copyFromTemplate(String template, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromTemplate(template, target, tokens, false));
    }

    public void openFromTemplate(String template, File target, Map<String, ? extends Object> tokens) {
        this.steps.add(new CopyFromTemplate(template, target, tokens, true));
    }

    public void addProjectPreload(File projectDir) {
        this.steps.add(new PreloadProject(projectDir));
    }

    private static class CopyFromTemplate
    implements OperationStep {
        final File target;
        final Map<String, ? extends Object> tokens;
        final boolean important;
        final String templateName;

        public CopyFromTemplate(String templateName, File target, Map<String, ? extends Object> tokens, boolean important) {
            this.templateName = templateName;
            this.target = target;
            this.tokens = tokens;
            this.important = important;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_COPY_TEMPLATE(this.target.getName());
        }

        @Override
        public Set<FileObject> execute() {
            FileObject template = FileUtil.getConfigFile((String)this.templateName);
            if (template != null) {
                String targetName = this.target.getName();
                try {
                    FileObject targetParent = FileUtil.createFolder((File)this.target.getParentFile());
                    DataFolder targetFolder = DataFolder.findFolder((FileObject)targetParent);
                    DataObject o = DataObject.find((FileObject)template);
                    DataObject newData = o.createFromTemplate(targetFolder, targetName, this.tokens);
                    return this.important ? Collections.singleton(newData.getPrimaryFile()) : null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class CopyFromFileTemplate
    implements OperationStep {
        final File target;
        final Map<String, ? extends Object> tokens;
        final boolean important;
        final String templateName;

        public CopyFromFileTemplate(String templateName, File target, Map<String, ? extends Object> tokens, boolean important) {
            this.templateName = templateName;
            this.target = target;
            this.tokens = tokens;
            this.important = important;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_COPY_TEMPLATE(this.target.getName());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Set<FileObject> execute() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager(l);
            ScriptEngine engine = scriptEngineManager.getEngineByName("freemarker");
            assert (engine != null);
            Bindings bindings = engine.getContext().getBindings(100);
            String basename = this.target.getName();
            bindings.put("name", basename.replaceFirst("\\.[^./]+$", ""));
            bindings.put("user", System.getProperty("user.name"));
            Date d = new Date();
            bindings.put("date", DateFormat.getDateInstance().format(d));
            bindings.put("time", DateFormat.getTimeInstance().format(d));
            bindings.put("nameAndExt", this.target.getName());
            bindings.putAll(this.tokens);
            try {
                FileObject fo = FileUtil.createData((File)this.target);
                Charset targetEnc = Charset.defaultCharset();
                bindings.put("encoding", targetEnc.name());
                try (OutputStreamWriter w = new OutputStreamWriter(fo.getOutputStream(), targetEnc);){
                    engine.getContext().setWriter(w);
                    try (InputStreamReader is = new InputStreamReader(TemplateOperation.class.getResourceAsStream("/" + this.templateName));){
                        engine.eval(is);
                    }
                    catch (IOException | ScriptException ex) {
                        throw new IOException(ex.getMessage(), ex);
                    }
                    Set<FileObject> set = this.important ? Collections.singleton(fo) : null;
                    return set;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class InitGradleWrapper
    implements OperationStep {
        final File projectDir;

        public InitGradleWrapper(File projectDir) {
            this.projectDir = projectDir;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_INIT_WRAPPER();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<FileObject> execute() {
            GradleConnector gconn = GradleConnector.newConnector();
            try (ProjectConnection pconn = gconn.forProjectDirectory(this.projectDir).connect();){
                ((BuildLauncher)pconn.newBuild().withArguments(new String[]{"--offline"})).forTasks(new String[]{"wrapper"}).run();
            }
            return null;
        }
    }

    private static class PreloadProject
    implements OperationStep {
        final File dir;

        public PreloadProject(File dir) {
            this.dir = dir;
        }

        @Override
        public String getMessage() {
            return GradleProjects.testForProject(this.dir) ? Bundle.MSG_PRELOAD_PROJECT(this.dir.getName()) : Bundle.MSM_CHECKING_FOLDER(this.dir.getName());
        }

        @Override
        public Set<FileObject> execute() {
            if (GradleProjects.testForProject(this.dir)) {
                try {
                    FileObject projectDir = FileUtil.toFileObject((File)this.dir);
                    Project project = ProjectManager.getDefault().findProject(projectDir);
                    if (project == null) {
                        ProjectManager.getDefault().clearNonProjectCache();
                    }
                    if ((project = ProjectManager.getDefault().findProject(projectDir)) != null) {
                        ProjectTrust.getDefault().trustProject(project);
                        NbGradleProjectImpl nbProject = (NbGradleProjectImpl)project.getLookup().lookup(NbGradleProjectImpl.class);
                        if (nbProject != null) {
                            GradleProjectCache.loadProject(nbProject, NbGradleProject.Quality.FULL_ONLINE, true, false, new String[0]);
                        }
                        return Collections.singleton(projectDir);
                    }
                }
                catch (IOException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class ConfigureProjectStep
    implements OperationStep {
        final File dir;
        final ProjectConfigurator configurator;

        public ConfigureProjectStep(File dir, ProjectConfigurator configurator) {
            this.dir = dir;
            this.configurator = configurator;
        }

        @Override
        public String getMessage() {
            return Bundle.MSG_CONFIGURING_PROJECT();
        }

        @Override
        public final Set<FileObject> execute() {
            if (GradleProjects.testForProject(this.dir)) {
                try {
                    NbGradleProjectImpl impl;
                    FileObject projectDir = FileUtil.toFileObject((File)this.dir);
                    Project project = ProjectManager.getDefault().findProject(projectDir);
                    NbGradleProjectImpl nbGradleProjectImpl = impl = project != null ? (NbGradleProjectImpl)project.getLookup().lookup(NbGradleProjectImpl.class) : null;
                    if (impl != null) {
                        impl.fireProjectReload(true);
                        this.configurator.configure(project);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.emptySet();
        }
    }

    private static class CreateDirStep
    implements OperationStep {
        final String message;
        final File dir;

        public CreateDirStep(File dir, String message) {
            this.dir = dir;
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Set<FileObject> execute() {
            try {
                FileUtil.createFolder((File)this.dir);
                Thread.sleep(200L);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return null;
        }
    }

    static interface OperationStep {
        public String getMessage();

        public Set<FileObject> execute();
    }

    public static interface ProjectConfigurator {
        public void configure(Project var1);
    }
}

