/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.ConfigurableLauncher;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.util.NbBundle;

public final class GradleCommandLine
implements Serializable {
    public static final String TEST_TASK = "test";
    public static final String CHECK_TASK = "check";
    static final List<ArgumentParser<? extends Argument>> PARSERS = new LinkedList<ArgumentParser<? extends Argument>>();
    final Set<Argument> arguments = new LinkedHashSet<Argument>();
    final Set<String> tasks = new LinkedHashSet<String>();

    public GradleCommandLine(GradleCommandLine cmd) {
        this.arguments.addAll(cmd.arguments);
        this.tasks.addAll(cmd.tasks);
    }

    public GradleCommandLine(String ... args) {
        Iterator<String> it = Arrays.asList(args).iterator();
        while (it.hasNext()) {
            String arg = it.next();
            Argument parg = null;
            for (ArgumentParser<? extends Argument> parser : PARSERS) {
                parg = parser.parse(arg, it);
                if (parg == null) continue;
                this.arguments.add(parg);
                break;
            }
            if (parg != null) continue;
            this.tasks.add(arg);
        }
    }

    public GradleCommandLine(CharSequence argLine) {
        this(GradleCommandLine.parseArgLine(argLine));
    }

    static String[] parseArgLine(CharSequence cli) {
        char quote = '\u0000';
        StringBuilder buf = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < cli.length(); ++i) {
            char ch = cli.charAt(i);
            if (quote == '\u0000') {
                if (Character.isWhitespace(ch)) {
                    if (buf.length() <= 0) continue;
                    args.add(buf.toString());
                    buf.setLength(0);
                    continue;
                }
                if (ch == '\"' || ch == '\'') {
                    quote = ch;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (quote == ch) {
                quote = '\u0000';
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            args.add(buf.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    private List<String> getArgs(Set<Argument.Kind> kinds) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Argument arg : this.arguments) {
            if (!kinds.contains((Object)arg.getKind())) continue;
            ret.addAll(arg.getArgs());
        }
        return ret;
    }

    public List<String> getSupportedCommandLine() {
        List<String> ret = this.getArgs(EnumSet.of(Argument.Kind.PARAM, Argument.Kind.SYSTEM));
        ret.addAll(this.tasks);
        return ret;
    }

    public List<String> getFullCommandLine() {
        List<String> ret = this.getArgs(EnumSet.allOf(Argument.Kind.class));
        ret.addAll(this.tasks);
        return ret;
    }

    public Set<String> getTasks() {
        return new LinkedHashSet<String>(this.tasks);
    }

    public void setTasks(Collection<String> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
    }

    public void removeTask(String task) {
        this.tasks.remove(task);
    }

    public void addTask(String task) {
        this.tasks.add(task);
    }

    public boolean hasTask(String task) {
        return this.tasks.contains(task);
    }

    public boolean hasFlag(Flag flag) {
        return this.arguments.contains(FlagArgument.of(flag));
    }

    public void addFlag(Flag flag) {
        this.arguments.add(FlagArgument.of(flag));
    }

    public boolean canAdd(Flag f) {
        EnumSet<Flag> reserved = EnumSet.noneOf(Flag.class);
        for (Argument arg : this.arguments) {
            if (!(arg instanceof FlagArgument)) continue;
            FlagArgument farg = (FlagArgument)arg;
            reserved.add(farg.flag);
            reserved.addAll(farg.flag.incompatible);
        }
        return !reserved.contains((Object)f);
    }

    public void removeFlag(Flag flag) {
        Iterator<Argument> it = this.arguments.iterator();
        while (it.hasNext()) {
            Argument arg = it.next();
            if (!(arg instanceof FlagArgument)) continue;
            FlagArgument farg = (FlagArgument)arg;
            if (farg.flag != flag) continue;
            it.remove();
        }
    }

    public void setFlag(Flag flag, boolean b) {
        if (b) {
            this.addFlag(flag);
        } else {
            this.removeFlag(flag);
        }
    }

    public void addParameter(Parameter param, String value) {
        this.arguments.add(new ParametricArgument(param, value));
    }

    public String getFirstParameter(Parameter param) {
        for (Argument arg : this.arguments) {
            if (!(arg instanceof ParametricArgument)) continue;
            ParametricArgument parg = (ParametricArgument)arg;
            if (parg.param != param) continue;
            return parg.value;
        }
        return null;
    }

    public boolean hasParameter(Parameter param) {
        return this.getFirstParameter(param) != null;
    }

    public Collection<String> getParameters(Parameter param) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Argument arg : this.arguments) {
            if (!(arg instanceof ParametricArgument)) continue;
            ParametricArgument parg = (ParametricArgument)arg;
            if (parg.param != param) continue;
            ret.add(parg.value);
        }
        return ret;
    }

    public Set<String> getExcludedTasks() {
        return new LinkedHashSet<String>(this.getParameters(Parameter.EXCLUDE_TASK));
    }

    public void setExcludedTasks(Collection<String> excluded) {
        Iterator<Argument> it = this.arguments.iterator();
        while (it.hasNext()) {
            Argument arg = it.next();
            if (!(arg instanceof ParametricArgument)) continue;
            ParametricArgument parg = (ParametricArgument)arg;
            if (parg.param != Parameter.EXCLUDE_TASK) continue;
            it.remove();
        }
        for (String task : excluded) {
            this.arguments.add(new ParametricArgument(Parameter.EXCLUDE_TASK, task));
        }
    }

    public void removeParameters(Parameter param) {
        Iterator<Argument> it = this.arguments.iterator();
        while (it.hasNext()) {
            Argument arg = it.next();
            if (!(arg instanceof ParametricArgument)) continue;
            ParametricArgument parg = (ParametricArgument)arg;
            if (parg.param != param) continue;
            it.remove();
        }
    }

    public void removeParameter(Parameter param, String value) {
        Iterator<Argument> it = this.arguments.iterator();
        while (it.hasNext()) {
            Argument arg = it.next();
            if (!(arg instanceof ParametricArgument)) continue;
            ParametricArgument parg = (ParametricArgument)arg;
            if (parg.param != param || !parg.value.equals(value)) continue;
            it.remove();
        }
    }

    public void removeProperty(Property prop, String key) {
        Iterator<Argument> it = this.arguments.iterator();
        while (it.hasNext()) {
            Argument arg = it.next();
            if (!(arg instanceof PropertyArgument)) continue;
            PropertyArgument parg = (PropertyArgument)arg;
            if (parg.prop != prop || !parg.key.equals(key)) continue;
            it.remove();
        }
    }

    public GradleCommandLine remove(GradleCommandLine mask) {
        GradleCommandLine ret = new GradleCommandLine(new String[0]);
        for (Argument argument : mask.arguments) {
            Argument parg;
            if (argument instanceof FlagArgument) {
                FlagArgument farg = (FlagArgument)argument;
                if (this.hasFlag(farg.flag)) {
                    ret.setFlag(farg.flag, true);
                    this.setFlag(farg.flag, false);
                }
            }
            if (argument instanceof ParametricArgument) {
                parg = (ParametricArgument)argument;
                if (this.hasParameter(parg.param) && this.getParameters(parg.param).contains(parg.value)) {
                    this.removeParameter(parg.param, parg.value);
                    ret.addParameter(parg.param, parg.value);
                }
            }
            if (!(argument instanceof PropertyArgument)) continue;
            parg = (PropertyArgument)argument;
            String propValue = this.getProperty(((PropertyArgument)parg).prop, ((PropertyArgument)parg).key);
            if (propValue == null || ((PropertyArgument)parg).prop != Property.PROJECT) continue;
            this.removeProperty(((PropertyArgument)parg).prop, ((PropertyArgument)parg).key);
            switch (((PropertyArgument)parg).prop) {
                case PROJECT: {
                    ret.addProjectProperty(((PropertyArgument)parg).key, propValue);
                    break;
                }
                case SYSTEM: {
                    ret.addSystemProperty(((PropertyArgument)parg).key, propValue);
                }
            }
        }
        return ret;
    }

    public String getProperty(Property type, String key) {
        for (Argument arg : this.arguments) {
            if (!(arg instanceof PropertyArgument)) continue;
            PropertyArgument parg = (PropertyArgument)arg;
            if (parg.prop != type || !parg.key.equals(key)) continue;
            return parg.value;
        }
        return null;
    }

    public LogLevel getLoglevel() {
        LogLevel ret = LogLevel.WARN;
        for (Argument arg : this.arguments) {
            if (!(arg instanceof FlagArgument)) continue;
            FlagArgument farg = (FlagArgument)arg;
            switch (farg.flag) {
                case LOG_DEBUG: {
                    ret = LogLevel.DEBUG;
                    break;
                }
                case LOG_INFO: {
                    ret = LogLevel.INFO;
                    break;
                }
                case LOG_QUIET: {
                    ret = LogLevel.QUIET;
                }
            }
        }
        return ret;
    }

    public void setLogLevel(LogLevel level) {
        this.arguments.removeAll(Arrays.asList(Flag.LOG_DEBUG, Flag.LOG_INFO, Flag.LOG_QUIET, Flag.LOG_WARN));
        switch (level) {
            case DEBUG: {
                this.addFlag(Flag.LOG_DEBUG);
                break;
            }
            case INFO: {
                this.addFlag(Flag.LOG_INFO);
                break;
            }
            case WARN: {
                this.addFlag(Flag.LOG_WARN);
                break;
            }
            case QUIET: {
                this.addFlag(Flag.LOG_QUIET);
            }
        }
    }

    public void addProjectProperty(String key, String value) {
        PropertyArgument arg = new PropertyArgument(Property.PROJECT, key, value);
        this.arguments.remove(arg);
        this.arguments.add(arg);
    }

    public void addSystemProperty(String key, String value) {
        PropertyArgument arg = new PropertyArgument(Property.SYSTEM, key, value);
        this.arguments.remove(arg);
        this.arguments.add(arg);
    }

    public StackTrace getStackTrace() {
        StackTrace ret = StackTrace.NONE;
        for (Argument arg : this.arguments) {
            if (!(arg instanceof FlagArgument)) continue;
            FlagArgument farg = (FlagArgument)arg;
            switch (farg.flag) {
                case STACKTRACE: {
                    ret = StackTrace.SHORT;
                    break;
                }
                case STACKTRACE_FULL: {
                    ret = StackTrace.FULL;
                }
            }
        }
        return ret;
    }

    public void setStackTrace(StackTrace st) {
        this.removeFlag(Flag.STACKTRACE);
        this.removeFlag(Flag.STACKTRACE_FULL);
        switch (st) {
            case FULL: {
                this.addFlag(Flag.STACKTRACE_FULL);
                break;
            }
            case SHORT: {
                this.addFlag(Flag.STACKTRACE);
            }
        }
    }

    public void configure(ConfigurableLauncher launcher) {
        launcher.setJvmArguments(this.getArgs(EnumSet.of(Argument.Kind.SYSTEM)));
        LinkedList<String> args = new LinkedList<String>(this.getArgs(EnumSet.of(Argument.Kind.PARAM)));
        args.addAll(this.tasks);
        launcher.withArguments(args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        List<String> cli = this.getFullCommandLine();
        sb.append("Gradle CommandLine:");
        for (String s : cli) {
            sb.append(' ').append(s);
        }
        return sb.toString();
    }

    public static GradleCommandLine combine(GradleCommandLine first, GradleCommandLine ... layers) {
        GradleCommandLine ret = new GradleCommandLine(first);
        for (GradleCommandLine layer : layers) {
            Set<String> newExcludes = ret.getExcludedTasks();
            newExcludes.removeAll(layer.tasks);
            newExcludes.addAll(layer.getExcludedTasks());
            Set<String> newTasks = ret.getTasks();
            newTasks.removeAll(layer.getExcludedTasks());
            newTasks.addAll(layer.getTasks());
            layer.arguments.forEach(argument -> {
                if (argument instanceof PropertyArgument) {
                    PropertyArgument parg = (PropertyArgument)argument;
                    if (parg.prop == Property.PROJECT) {
                        ret.addProjectProperty(parg.key, parg.value);
                    }
                    if (parg.prop == Property.SYSTEM) {
                        ret.addSystemProperty(parg.key, parg.value);
                    }
                } else if (argument instanceof FlagArgument) {
                    FlagArgument farg = (FlagArgument)argument;
                    for (Flag flag : farg.flag.incompatible) {
                        ret.removeFlag(flag);
                    }
                    ret.arguments.add((Argument)argument);
                } else {
                    ret.arguments.add((Argument)argument);
                }
            });
            ret.setExcludedTasks(newExcludes);
            ret.setTasks(newTasks);
        }
        return ret;
    }

    public static GradleCommandLine getDefaultCommandLine() {
        GradleSettings settings = GradleSettings.getDefault();
        GradleCommandLine ret = new GradleCommandLine(new String[0]);
        ret.setFlag(Flag.OFFLINE, settings.isOffline());
        ret.setFlag(Flag.CONFIGURE_ON_DEMAND, settings.isConfigureOnDemand());
        ret.setFlag(Flag.NO_REBUILD, settings.getNoRebuild());
        ret.setLogLevel(settings.getDefaultLogLevel());
        ret.setStackTrace(settings.getDefaultStackTrace());
        if (settings.skipCheck()) {
            ret.addParameter(Parameter.EXCLUDE_TASK, CHECK_TASK);
        }
        if (settings.skipTest()) {
            ret.addParameter(Parameter.EXCLUDE_TASK, TEST_TASK);
        }
        return ret;
    }

    static {
        for (Flag flag : Flag.values()) {
            PARSERS.add(FlagArgument.of(flag));
        }
        for (Enum enum_ : Property.values()) {
            PARSERS.add(new PropertyParser((Property)enum_));
        }
        for (Enum enum_ : Parameter.values()) {
            PARSERS.add(new ParameterParser((Parameter)enum_));
        }
    }

    static class ParameterParser
    implements ArgumentParser<ParametricArgument> {
        final Parameter param;

        public ParameterParser(Parameter param) {
            this.param = param;
        }

        @Override
        public ParametricArgument parse(String arg, Iterator<String> args) {
            return this.param.flags.contains(arg) && args.hasNext() ? new ParametricArgument(this.param, args.next()) : null;
        }
    }

    static class ParametricArgument
    implements Argument {
        final Parameter param;
        final String value;

        public ParametricArgument(Parameter param, String value) {
            this.param = param;
            this.value = value;
        }

        @Override
        public Argument.Kind getKind() {
            return this.param.kind;
        }

        @Override
        public List<String> getArgs() {
            return Arrays.asList(this.param.flags.get(0), this.value);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode((Object)this.param);
            hash = 79 * hash + Objects.hashCode(this.value);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParametricArgument other = (ParametricArgument)obj;
            if (!Objects.equals(this.value, other.value)) {
                return false;
            }
            return this.param == other.param;
        }
    }

    static class PropertyParser
    implements ArgumentParser<PropertyArgument> {
        final Property prop;

        PropertyParser(Property prop) {
            this.prop = prop;
        }

        @Override
        public PropertyArgument parse(String arg, Iterator<String> args) {
            String keyValue = null;
            if (this.prop.flag.equals(arg) && args.hasNext()) {
                keyValue = args.next();
            }
            if (keyValue == null && arg.startsWith(this.prop.prefix)) {
                keyValue = arg.substring(2);
            }
            if (keyValue != null) {
                int sep;
                int eq = keyValue.indexOf(61);
                int colon = keyValue.indexOf(58);
                int n = sep = eq > 0 && colon > 0 ? Math.min(eq, colon) : Math.max(eq, colon);
                if (sep > 0) {
                    String key = keyValue.substring(0, sep);
                    String value = keyValue.substring(sep + 1);
                    return new PropertyArgument(this.prop, key, value);
                }
            }
            return null;
        }
    }

    static class PropertyArgument
    implements Argument {
        final Property prop;
        final String key;
        final String value;

        public PropertyArgument(Property prop, String key, String value) {
            this.prop = prop;
            this.key = key;
            this.value = value;
        }

        @Override
        public List<String> getArgs() {
            return Collections.singletonList(this.prop.prefix + this.key + "=" + this.value);
        }

        @Override
        public Argument.Kind getKind() {
            return this.prop.kind;
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + Objects.hashCode((Object)this.prop);
            hash = 47 * hash + Objects.hashCode(this.key);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyArgument other = (PropertyArgument)obj;
            if (!Objects.equals(this.key, other.key)) {
                return false;
            }
            return this.prop == other.prop;
        }
    }

    static class FlagArgument
    implements Argument,
    ArgumentParser<FlagArgument> {
        final Flag flag;
        private static final EnumMap<Flag, FlagArgument> FLAG_ARGS = new EnumMap(Flag.class);

        public static FlagArgument of(Flag f) {
            return FLAG_ARGS.get((Object)f);
        }

        private FlagArgument(Flag flag) {
            this.flag = flag;
        }

        @Override
        public List<String> getArgs() {
            return Collections.singletonList(this.flag.flags.get(0));
        }

        @Override
        public FlagArgument parse(String arg, Iterator<String> args) {
            return this.flag.flags.contains(arg) ? this : null;
        }

        public int hashCode() {
            return this.flag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlagArgument other = (FlagArgument)obj;
            return this.flag == other.flag;
        }

        @Override
        public Argument.Kind getKind() {
            return this.flag.kind;
        }

        static {
            for (Flag flag : Flag.values()) {
                FLAG_ARGS.put(flag, new FlagArgument(flag));
            }
        }
    }

    static interface ArgumentParser<T extends Argument> {
        public T parse(String var1, Iterator<String> var2);
    }

    static interface Argument {
        public Kind getKind();

        public List<String> getArgs();

        public static enum Kind {
            PARAM,
            SYSTEM,
            UNSUPPORTED;

        }
    }

    public static enum Parameter {
        SETTINGS_FILE(Argument.Kind.UNSUPPORTED, "-c", "--settings-file"),
        CONSOLE(Argument.Kind.UNSUPPORTED, "--console"),
        GRADLE_USER_HOME(Argument.Kind.UNSUPPORTED, "-g", "--gradle-user-home"),
        INIT_SCRIPT(Argument.Kind.PARAM, "-I", "--init-script"),
        MAX_WORKER(Argument.Kind.PARAM, "--max-worker"),
        PROJECT_DIR(Argument.Kind.PARAM, "-p", "--project-dir"),
        PROJECT_CACHE_DIR(Argument.Kind.UNSUPPORTED, "--project-cache-dir"),
        EXCLUDE_TASK(Argument.Kind.PARAM, "-x", "--exclude-task"),
        IMPORT_BUILD(Argument.Kind.PARAM, "--import-build");

        final Argument.Kind kind;
        final List<String> flags;

        private Parameter(Argument.Kind kind, String ... flags) {
            this.kind = kind;
            this.flags = Arrays.asList(flags);
        }
    }

    public static enum Property {
        PROJECT(Argument.Kind.PARAM, "-P", "--project-prop"),
        SYSTEM(Argument.Kind.SYSTEM, "-D", "--system-prop");

        private final Argument.Kind kind;
        private final String prefix;
        private final String flag;

        private Property(Argument.Kind kind, String prefix, String flag) {
            this.kind = kind;
            this.prefix = prefix;
            this.flag = flag;
        }
    }

    public static enum Flag {
        NO_REBUILD(Argument.Kind.PARAM, "-a", "--no-rebuild"),
        BUILD_CACHE(Argument.Kind.PARAM, "--build-cache"),
        CONFIGURE_ON_DEMAND(Argument.Kind.PARAM, "--configure-on-demand"),
        CONTINUE(Argument.Kind.PARAM, "--continue"),
        DRY_RUN(Argument.Kind.PARAM, "-m", "--dry-run"),
        OFFLINE(Argument.Kind.PARAM, "--offline"),
        PARALLEL(Argument.Kind.PARAM, "--parallel"),
        REFRESH_DEPENDENCIES(Argument.Kind.PARAM, "--refresh-dependencies"),
        RERUN_TASKS(Argument.Kind.PARAM, "--rerun-tasks"),
        LOG_DEBUG(Argument.Kind.PARAM, "-d", "--debug"),
        LOG_INFO(Argument.Kind.PARAM, "-i", "--info"),
        LOG_WARN(Argument.Kind.PARAM, "-w", "--warn"),
        LOG_QUIET(Argument.Kind.PARAM, "-q", "--quiet"),
        STACKTRACE(Argument.Kind.PARAM, "-s", "--stacktrace"),
        STACKTRACE_FULL(Argument.Kind.PARAM, "-S", "--full-stacktrace"),
        PROFILE(Argument.Kind.PARAM, "--profile"),
        NO_BUILD_CACHE(Argument.Kind.PARAM, "--no-build-cache"),
        NO_CONFIGURE_ON_DEMAND(Argument.Kind.PARAM, "--no-configure-on-demand"),
        NO_PARALLEL(Argument.Kind.PARAM, "--no-parallel"),
        SCAN(Argument.Kind.PARAM, "--scan"),
        NO_SCAN(Argument.Kind.PARAM, "--no-scan"),
        DAEMON(Argument.Kind.UNSUPPORTED, "--no-daemon"),
        NO_DAEMON(Argument.Kind.UNSUPPORTED, "--daemon"),
        HELP(Argument.Kind.UNSUPPORTED, "--help", "-h", "-?"),
        FOREGROUND(Argument.Kind.UNSUPPORTED, "--foreground"),
        GUI(Argument.Kind.UNSUPPORTED, "--gui"),
        STATUS(Argument.Kind.UNSUPPORTED, "--status"),
        STOP(Argument.Kind.UNSUPPORTED, "--stop"),
        CONTINUOUS(Argument.Kind.UNSUPPORTED, "--continuous", "-t"),
        NO_SEARCH_UPWARD(Argument.Kind.UNSUPPORTED, "--no-search-upward", "-u"),
        RECOMPILE_SCRIPTS(Argument.Kind.UNSUPPORTED, "--recompile-scripts"),
        VERSION(Argument.Kind.UNSUPPORTED, "--version", "-v");

        private Set<Flag> incompatible = Collections.emptySet();
        private final Argument.Kind kind;
        private final List<String> flags;

        private Flag(Argument.Kind kind, String ... flags) {
            this.kind = kind;
            this.flags = Arrays.asList(flags);
        }

        private void incompatibleWith(Flag first, Flag ... rest) {
            this.incompatible = Collections.unmodifiableSet(EnumSet.of(first, rest));
        }

        public boolean isSupported() {
            return this.kind != Argument.Kind.UNSUPPORTED;
        }

        public List<String> getFlags() {
            return this.flags;
        }

        public final String getDescription() {
            return NbBundle.getMessage(GradleCommandLine.class, (String)(this.name() + "_DSC"));
        }

        static {
            DAEMON.incompatibleWith(NO_DAEMON, new Flag[0]);
            NO_DAEMON.incompatibleWith(DAEMON, new Flag[0]);
            LOG_DEBUG.incompatibleWith(LOG_INFO, LOG_QUIET, LOG_WARN);
            LOG_INFO.incompatibleWith(LOG_DEBUG, LOG_QUIET, LOG_WARN);
            LOG_WARN.incompatibleWith(LOG_DEBUG, LOG_INFO, LOG_QUIET);
            LOG_QUIET.incompatibleWith(LOG_DEBUG, LOG_INFO, LOG_WARN);
            STACKTRACE.incompatibleWith(STACKTRACE_FULL, new Flag[0]);
            STACKTRACE_FULL.incompatibleWith(STACKTRACE, new Flag[0]);
            SCAN.incompatibleWith(NO_SCAN, new Flag[0]);
            NO_SCAN.incompatibleWith(SCAN, new Flag[0]);
            CONFIGURE_ON_DEMAND.incompatibleWith(NO_CONFIGURE_ON_DEMAND, new Flag[0]);
            NO_CONFIGURE_ON_DEMAND.incompatibleWith(CONFIGURE_ON_DEMAND, new Flag[0]);
            BUILD_CACHE.incompatibleWith(NO_BUILD_CACHE, new Flag[0]);
            NO_BUILD_CACHE.incompatibleWith(BUILD_CACHE, new Flag[0]);
            PARALLEL.incompatibleWith(NO_PARALLEL, new Flag[0]);
            NO_PARALLEL.incompatibleWith(PARALLEL, new Flag[0]);
        }
    }

    public static enum StackTrace {
        NONE,
        SHORT,
        FULL;

    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        LIFECYCLE,
        WARN,
        QUIET;

    }
}

