/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.GradleInstallPanel;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class GradleDistributionManager {
    private static final Pattern WRAPPER_DIR_PATTERN = Pattern.compile("gradle-(\\d+\\.\\d+.*)-(bin|all)");
    private static final Pattern DIST_VERSION_PATTERN = Pattern.compile(".*gradle-(\\d+\\.\\d+.*)-(bin|all)\\.zip");
    private static final String DOWNLOAD_URI = "https://services.gradle.org/distributions/gradle-%s-bin.zip";
    private static final RequestProcessor RP = new RequestProcessor("Gradle Installer", 1);
    private static final Set<String> VERSION_BLACKLIST = new HashSet<String>(Arrays.asList("2.3", "2.13"));
    private static final GradleVersion MINIMUM_SUPPORTED_VERSION = GradleVersion.version((String)"2.0");
    private static final Map<File, GradleDistributionManager> CACHE = new WeakHashMap<File, GradleDistributionManager>();
    private static final int JAVA_VERSION;
    final File gradleUserHome;
    private final Map<URI, NbGradleVersion> versions = new HashMap<URI, NbGradleVersion>();

    private GradleDistributionManager(File gradleUserHome) {
        this.gradleUserHome = gradleUserHome;
    }

    public static GradleDistributionManager get(File gradleUserHome) {
        GradleDistributionManager ret = CACHE.get(gradleUserHome);
        if (ret == null) {
            ret = new GradleDistributionManager(gradleUserHome);
            CACHE.put(gradleUserHome, ret);
        }
        return ret;
    }

    public NbGradleVersion defaultToolingVersion() {
        return this.createVersion(GradleVersion.current().getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File install(NbGradleVersion version) {
        File ret = null;
        if (version.install()) {
            ReentrantLock lock = new ReentrantLock();
            PropertyChangeListener pcl = evt -> {
                if ("available".equals(evt.getPropertyName())) {
                    Lock lock2 = lock;
                    synchronized (lock2) {
                        lock.notifyAll();
                    }
                }
            };
            try {
                ReentrantLock reentrantLock = lock;
                synchronized (reentrantLock) {
                    version.addPropertyChangeListener(pcl);
                    lock.wait();
                }
            }
            catch (InterruptedException ex) {
                File file = ret;
                return file;
            }
            finally {
                version.removePropertyChangeListener(pcl);
            }
            ret = version.distributionDir();
        } else {
            ret = version.distributionDir();
        }
        return ret;
    }

    public NbGradleVersion evaluateGradleWrapperDistribution(File rootDir) {
        NbGradleVersion ret = null;
        File wrapperProps = new File(rootDir, "gradle/wrapper/gradle-wrapper.properties");
        if (wrapperProps.isFile() && wrapperProps.canRead()) {
            Properties wrapper = new Properties();
            try (FileInputStream is2 = new FileInputStream(wrapperProps);){
                wrapper.load(is2);
            }
            catch (IOException is2) {
                // empty catch block
            }
            String distUrlProp = wrapper.getProperty("distributionUrl");
            if (distUrlProp != null) {
                try {
                    URI distURL = new URI(distUrlProp);
                    ret = this.createVersion(distURL);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public List<NbGradleVersion> availableVersions(boolean releaseOnly) {
        ArrayList<NbGradleVersion> ret = new ArrayList<NbGradleVersion>();
        JSONParser parser = new JSONParser();
        try {
            URL allVersions = new URL("http://services.gradle.org/versions/all");
            try (InputStreamReader is = new InputStreamReader(allVersions.openStream());){
                JSONArray versions = (JSONArray)parser.parse((Reader)is);
                for (Object o : versions) {
                    JSONObject v = (JSONObject)o;
                    URI downloadURL = new URI((String)v.get((Object)"downloadUrl"));
                    boolean snapshot = (Boolean)v.get((Object)"snapshot");
                    boolean nightly = (Boolean)v.get((Object)"nightly");
                    boolean broken = (Boolean)v.get((Object)"broken");
                    String version = (String)v.get((Object)"version");
                    String rcFor = (String)v.get((Object)"rcFor");
                    if (nightly || broken || snapshot || !rcFor.isEmpty() && releaseOnly || GradleVersion.version((String)version).compareTo(MINIMUM_SUPPORTED_VERSION) < 0) continue;
                    ret.add(this.createVersion(version, downloadURL, rcFor.isEmpty()));
                }
            }
            catch (IOException | URISyntaxException | ParseException throwable) {}
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ret;
    }

    public List<String> installedVersions(File gradleUserHome) {
        ArrayList<String> ret = new ArrayList<String>();
        File wrapperDir = new File(gradleUserHome, "wrapper/dists");
        if (wrapperDir.isDirectory()) {
            File[] dirs;
            for (File dir : dirs = wrapperDir.listFiles()) {
                Matcher m;
                if (!dir.isDirectory() || !(m = WRAPPER_DIR_PATTERN.matcher(dir.getName())).matches()) continue;
                ret.add(m.group(1));
            }
        }
        return ret;
    }

    public NbGradleVersion createVersion(URI distributionUrl) {
        NbGradleVersion ret = null;
        Matcher m = DIST_VERSION_PATTERN.matcher(distributionUrl.getPath());
        if (m.matches()) {
            String version;
            ret = this.createVersion(version, distributionUrl, !(version = m.group(1)).contains("-"));
        }
        return ret;
    }

    public NbGradleVersion createVersion(String version) {
        try {
            URI url = new URI(String.format(DOWNLOAD_URI, version));
            return this.createVersion(version, url, !version.contains("-"));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private NbGradleVersion createVersion(String version, URI url, boolean b) {
        NbGradleVersion ret = this.versions.get(url);
        if (ret == null) {
            ret = new NbGradleVersion(version, url, b);
            this.versions.put(url, ret);
        }
        return ret;
    }

    private static List<File> listDirs(File d) {
        ArrayList<File> ret = new ArrayList<File>();
        if (d.isDirectory()) {
            for (File f : d.listFiles()) {
                if (!f.isDirectory()) continue;
                ret.add(f);
            }
        }
        return ret;
    }

    static {
        int ver = 8;
        String version = System.getProperty("java.specification.version", System.getProperty("java.version"));
        try {
            int dot = version.indexOf(46);
            int n = ver = dot > 0 ? Integer.parseInt(version.substring(0, dot)) : Integer.parseInt(version);
            if (ver == 1) {
                ver = (dot = (version = version.substring(dot + 1)).indexOf(46)) > 0 ? Integer.parseInt(version.substring(0, dot)) : Integer.parseInt(version);
            }
        }
        catch (NumberFormatException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        JAVA_VERSION = ver;
    }

    private class DownloadTask
    implements Runnable,
    IDownload {
        private final NbGradleVersion version;
        private final ProgressHandle handle;
        private final Notification notification;

        public DownloadTask(NbGradleVersion version) {
            this.version = version;
            this.handle = ProgressHandleFactory.createSystemHandle((String)Bundle.TIT_Download_Gradle(version.getVersion()));
            this.notification = NotificationDisplayer.getDefault().notify(Bundle.TIT_Download_Gradle(version.getVersion()), (Icon)NbGradleProject.getIcon(), Bundle.MSG_Download_Gradle(version.getVersion()), null, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WrapperConfiguration conf = new WrapperConfiguration();
                conf.setDistribution(this.version.getDownloadLocation());
                PathAssembler pa = new PathAssembler(GradleDistributionManager.this.gradleUserHome);
                Install install = new Install(new Logger(true), (IDownload)this, pa);
                install.createDist(conf);
                this.version.fireVersionAvailable();
            }
            catch (Exception ex) {
                NotificationDisplayer.getDefault().notify(Bundle.TIT_Install_Gradle_Failed(this.version.getVersion()), NbGradleProject.getWarningIcon(), ex.getLocalizedMessage(), null, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
            }
            finally {
                this.handle.finish();
                this.notification.clear();
            }
        }

        public void download(URI uri, File file) throws Exception {
            URL url = uri.toURL();
            URLConnection conn = url.openConnection();
            byte[] buf = new byte[8192];
            try (FileOutputStream os = new FileOutputStream(file);){
                int read;
                conn.connect();
                int size = conn.getContentLength();
                if (size > 0) {
                    this.handle.start(size);
                } else {
                    this.handle.start();
                }
                int allRead = 0;
                InputStream is = url.openStream();
                while ((read = is.read(buf)) > 0) {
                    os.write(buf, 0, read);
                    allRead += read;
                    if (size <= 0) continue;
                    this.handle.progress(allRead);
                }
            }
        }
    }

    public final class NbGradleVersion
    implements Comparable<NbGradleVersion> {
        public static final String PROP_AVAILABLE = "available";
        final GradleVersion version;
        final URI downloadLocation;
        final boolean release;
        private PropertyChangeSupport pcs;

        private NbGradleVersion(String version, URI downloadLocation, boolean release) {
            this.version = GradleVersion.version((String)version);
            this.downloadLocation = downloadLocation;
            this.release = release;
        }

        public GradleVersion getVersion() {
            return this.version;
        }

        public URI getDownloadLocation() {
            return this.downloadLocation;
        }

        public boolean isRelease() {
            return this.release;
        }

        public boolean isCompatibleWithSystemJava() {
            return JAVA_VERSION < 11 ? true : this.version.compareTo(GradleVersion.version((String)"4.10.2")) >= 0;
        }

        public boolean isAvailable() {
            File distDir = this.distributionDir();
            return distDir != null && distDir.isDirectory();
        }

        public boolean isBlackListed() {
            return VERSION_BLACKLIST.contains(this.version.getVersion());
        }

        public boolean install() {
            if (!this.isAvailable()) {
                if (GradleSettings.getDefault().isSilentInstall()) {
                    RP.post((Runnable)new DownloadTask(this), 500);
                    return true;
                }
                GradleInstallPanel panel = new GradleInstallPanel(this.version.getVersion());
                DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.TIT_GradleInstall(), true, 2, DialogDescriptor.OK_OPTION, null);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                    GradleSettings.getDefault().setSilentInstall(panel.isSilentInstall());
                    RP.post((Runnable)new DownloadTask(this), 500);
                    return true;
                }
            }
            return false;
        }

        public File distributionDir() {
            File distDir = this.distributionBaseDir();
            if (distDir.isDirectory()) {
                List dirs = GradleDistributionManager.listDirs(distDir);
                assert (dirs.size() <= 1) : "Only one directory allowed in distribution dir";
                if (!dirs.isEmpty()) {
                    return (File)dirs.get(0);
                }
            }
            return new File(distDir, "gradle-" + this.version.getVersion());
        }

        private File distributionBaseDir() {
            WrapperConfiguration conf = new WrapperConfiguration();
            conf.setDistribution(this.downloadLocation);
            PathAssembler pa = new PathAssembler(GradleDistributionManager.this.gradleUserHome);
            PathAssembler.LocalDistribution dist = pa.getDistribution(conf);
            return dist.getDistributionDir();
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(l);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(l);
            }
        }

        void fireVersionAvailable() {
            if (this.pcs != null) {
                this.pcs.firePropertyChange(PROP_AVAILABLE, null, null);
            }
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof NbGradleVersion) {
                return this.version.equals((Object)((NbGradleVersion)obj).version);
            }
            return false;
        }

        public String toString() {
            return this.version.getVersion();
        }

        @Override
        public int compareTo(NbGradleVersion o) {
            return this.version.compareTo(o.getVersion());
        }
    }
}

