/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public abstract class GradleDependency
implements Serializable,
Comparable<GradleDependency> {
    final String id;

    GradleDependency(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    @Override
    public int compareTo(GradleDependency o) {
        int ret = this.getType().ordinal() - o.getType().ordinal();
        return ret != 0 ? ret : this.id.compareToIgnoreCase(o.id);
    }

    public abstract Type getType();

    public static final class UnresolvedDependency
    extends GradleDependency {
        String problem;

        UnresolvedDependency(String id) {
            super(id);
        }

        public String getProblem() {
            return this.problem;
        }

        @Override
        public Type getType() {
            return Type.UNRESOLVED;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnresolvedDependency other = (UnresolvedDependency)obj;
            return Objects.equals(this.id, other.id);
        }

        public String toString() {
            return "UnresolvedDependency{problem=" + this.problem + '}';
        }
    }

    public static final class FileCollectionDependency
    extends GradleDependency {
        final Set<File> files;

        FileCollectionDependency(Set<File> files) {
            super("Files");
            this.files = files;
        }

        @Override
        public Type getType() {
            return Type.FILE;
        }

        public Set<File> getFiles() {
            return this.files;
        }
    }

    public static final class ProjectDependency
    extends GradleDependency {
        final File path;
        String description;

        ProjectDependency(String id, File path) {
            super(id);
            this.path = path;
        }

        public File getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description != null ? this.description : this.id;
        }

        @Override
        public Type getType() {
            return Type.PROJECT;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.id);
            hash = 37 * hash + Objects.hashCode(this.path);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectDependency other = (ProjectDependency)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return Objects.equals(this.path, other.path);
        }

        public String toString() {
            return "ProjectDependency{path=" + this.path + ", description=" + this.description + '}';
        }
    }

    public static final class ModuleDependency
    extends GradleDependency {
        final Set<File> artifacts;
        Set<File> sources;
        Set<File> javadoc;
        String group;
        String name;
        String version;

        ModuleDependency(String id, Set<File> artifacts) {
            super(id);
            this.artifacts = artifacts;
            String[] parts = id.split(":");
            this.group = parts[0];
            this.name = parts[1];
            this.version = parts[2];
        }

        public Set<File> getArtifacts() {
            return this.artifacts != null ? this.artifacts : Collections.emptySet();
        }

        public Set<File> getSources() {
            return this.sources != null ? this.sources : Collections.emptySet();
        }

        public Set<File> getJavadoc() {
            return this.javadoc != null ? this.javadoc : Collections.emptySet();
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean hasSources() {
            return !this.getSources().isEmpty();
        }

        public boolean hasJavadocs() {
            return !this.getJavadoc().isEmpty();
        }

        @Override
        public int compareTo(GradleDependency o) {
            int ret = this.getType().ordinal() - o.getType().ordinal();
            if (ret == 0) {
                ModuleDependency dep = (ModuleDependency)o;
                ret = this.name.compareToIgnoreCase(dep.name);
                ret = ret != 0 ? ret : this.version.compareTo(dep.version);
                ret = ret != 0 ? ret : this.group.compareToIgnoreCase(dep.group);
            }
            return ret;
        }

        @Override
        public Type getType() {
            return Type.MODULE;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleDependency other = (ModuleDependency)obj;
            return Objects.equals(this.id, other.id);
        }

        public String toString() {
            return "ComponentDependency{artifacts=" + this.artifacts + ", sources=" + this.sources + ", javadoc=" + this.javadoc + '}';
        }
    }

    public static enum Type {
        UNRESOLVED,
        PROJECT,
        MODULE,
        FILE;

    }
}

