/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class TemplateAttrProvider
implements CreateFromTemplateAttributes {
    private static final Logger LOG = Logger.getLogger(TemplateAttrProvider.class.getName());
    private static final String DEFAULT_LICENSE_PREFIX = "/Templates/Licenses/license-";
    final Project project;

    public TemplateAttrProvider(Project project) {
        this.project = project;
    }

    public Map<String, ?> attributesFor(CreateDescriptor desc) {
        TreeMap<String, String> values = new TreeMap<String, String>();
        GradleBaseProject prj = GradleBaseProject.get(this.project);
        if (prj != null) {
            String license;
            String licensePath;
            values.put("name", prj.getName());
            if (prj.getDescription() != null) {
                values.put("displayName", prj.getDescription());
            }
            if (prj.getGroup() != null) {
                values.put("group", prj.getGroup());
            }
            if ((licensePath = TemplateAttrProvider.findLicensePathInTemplates(license = prj.getLicense())) == null) {
                File local = new File(prj.getProjectDir(), license);
                if (!local.isFile()) {
                    local = new File(license);
                }
                if (local.isFile()) {
                    licensePath = FileUtil.normalizeFile((File)local).toURI().toString();
                }
            }
            if (licensePath == null) {
                String string = licensePath = (license = TemplateAttrProvider.findLicenseByMavenProjectContent(license)) != null ? TemplateAttrProvider.findLicensePathInTemplates(license) : null;
            }
            if (licensePath == null) {
                LOG.log(Level.INFO, "Unable to resolve project license: {0} to project.licensePath", prj.getLicense());
            } else {
                values.put("license", prj.getLicense());
                values.put("licensePath", licensePath);
            }
        }
        return !values.isEmpty() ? Collections.singletonMap("project", values) : null;
    }

    public static String findLicensePathInTemplates(String lic) {
        FileObject fo = FileUtil.getConfigFile((String)("Templates/Licenses/license-" + lic + ".txt"));
        return fo != null ? DEFAULT_LICENSE_PREFIX + lic + ".txt" : null;
    }

    public static String findLicenseByMavenProjectContent(String url) {
        FileObject licensesFO = FileUtil.getConfigFile((String)"Templates/Licenses");
        if (licensesFO == null) {
            return null;
        }
        FileObject[] licenseFiles = licensesFO.getChildren();
        if (url != null) {
            for (FileObject fo : licenseFiles) {
                String str = (String)fo.getAttribute("mavenLicenseURL");
                if (str == null || !Arrays.asList(str.split(" ")).contains(url)) continue;
                if (fo.getName().startsWith("license-")) {
                    return fo.getName().substring("license-".length());
                }
                Logger.getLogger(TemplateAttrProvider.class.getName()).log(Level.WARNING, "Bad license file name {0} (expected to start with ''license-'' prefix)", fo.getName());
                break;
            }
        }
        return null;
    }
}

