/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.gradle.api.BuildPropertiesSupport;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.ProjectArtifactsQuery;
import org.netbeans.modules.project.dependency.spi.ProjectArtifactsImplementation;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class GradleJarArtifacts
implements ProjectArtifactsImplementation<Result> {
    private static final RequestProcessor GRADLE_ARTIFACTS_RP = new RequestProcessor(GradleJarArtifacts.class);
    private final Project project;
    private static final String TASKCLASS_SHADOW_JAR = "com.github.jengelman.gradle.plugins.shadow.tasks.ShadowJar";
    private static final String TASKCLASS_JAR = "org.gradle.jvm.tasks.Jar";
    private static final String TASK_JAR = "jar";
    private static final String TASK_SHADOW_JAR = "shadowJar";

    public GradleJarArtifacts(Project project) {
        this.project = project;
    }

    public Result evaluate(ProjectArtifactsQuery.Filter query) {
        GradleBaseProject gbp = GradleBaseProject.get((Project)this.project);
        NbGradleProject proj = NbGradleProject.get((Project)this.project);
        if (gbp == null) {
            return null;
        }
        if (proj == null) {
            return null;
        }
        if (query.getArtifactType() != null && !query.getArtifactType().equals("<all>") && !TASK_JAR.equals(query.getArtifactType())) {
            return null;
        }
        return new Result(this.project, query, proj);
    }

    public Project findProject(Result r) {
        return r.project;
    }

    public List<ArtifactSpec> findArtifacts(Result r) {
        return r.getArtifacts();
    }

    public Collection<ArtifactSpec> findExcludedArtifacts(Result r) {
        return Collections.emptySet();
    }

    public void handleChangeListener(Result r, ChangeListener l, boolean add) {
        r.addListener(l, add);
    }

    public boolean computeSupportsChanges(Result r) {
        return true;
    }

    static class Result
    implements PropertyChangeListener {
        private static final List<ArtifactSpec> PENDING = new ArrayList<ArtifactSpec>();
        private final Project project;
        private final ProjectArtifactsQuery.Filter filter;
        private final NbGradleProject gradleProject;
        private final List<String> buildTasks;
        private List<ChangeListener> listeners;
        private List<ArtifactSpec> artifacts;
        private RequestProcessor.Task refreshTask;

        public Result(Project project, ProjectArtifactsQuery.Filter filter, NbGradleProject gradleProject) {
            ActionMapping mapping;
            this.project = project;
            this.filter = filter;
            this.gradleProject = gradleProject;
            String action = "build";
            GradleExecConfiguration cfg = null;
            Lookup lkp = Lookup.EMPTY;
            if (filter.getBuildContext() != null) {
                ProjectActionContext pac = filter.getBuildContext();
                if (pac.getProjectAction() != null) {
                    action = pac.getProjectAction();
                }
                if (pac.getConfiguration() != null) {
                    cfg = (GradleExecConfiguration)pac.getConfiguration();
                }
            }
            if ((mapping = RunUtils.findActionMapping((Project)project, (String)action, cfg)) == null) {
                mapping = new TaskActionMapping(action);
            }
            String[] args = RunUtils.evaluateActionArgs((Project)project, (String)action, (String)mapping.getArgs(), (Lookup)lkp);
            RunConfig rc = RunUtils.createRunConfig((Project)project, (String)action, (String)"Searching for artifacts", (Lookup)Lookup.EMPTY, (GradleExecConfiguration)cfg, Collections.emptySet(), (String[])args);
            this.buildTasks = new ArrayList<String>(rc.getCommandLine().getTasks());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(ChangeListener l, boolean add) {
            Result result = this;
            synchronized (result) {
                if (add) {
                    if (this.listeners == null) {
                        this.listeners = new ArrayList<ChangeListener>();
                        this.gradleProject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.project));
                    }
                    this.listeners.add(l);
                } else {
                    if (this.listeners == null) {
                        return;
                    }
                    this.listeners.remove(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ArtifactSpec> getArtifacts() {
            List<ArtifactSpec> as = this.artifacts;
            if (as != null && as != PENDING) {
                return as;
            }
            as = this.createArtifactList();
            Result result = this;
            synchronized (result) {
                if (this.artifacts == null || this.artifacts == PENDING) {
                    this.artifacts = as;
                }
            }
            return as;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(List<ArtifactSpec> oldCopy) {
            ChangeListener[] ll;
            List<ArtifactSpec> specs = this.createArtifactList();
            Result result = this;
            synchronized (result) {
                if (this.artifacts == null) {
                    this.artifacts = specs;
                    return;
                }
                if (this.artifacts == PENDING) {
                    this.artifacts = specs;
                }
                if (specs.equals(oldCopy)) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[0]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }

        private List<ArtifactSpec> createArtifactList() {
            GradleBaseProject gbp = GradleBaseProject.get((Project)this.project);
            LinkedHashSet<ArtifactSpec> result = new LinkedHashSet<ArtifactSpec>();
            for (String taskName : this.buildTasks) {
                GradleTask gt = gbp.getTaskByName(taskName);
                if (gt == null) continue;
                boolean shadowApplied = false;
                ArrayList<GradleTask> jarTasks = new ArrayList<GradleTask>();
                ArrayList<GradleTask> tasks = new ArrayList<GradleTask>(gbp.getTaskPredecessors(gt, false));
                tasks.add(gt);
                for (GradleTask dep : tasks) {
                    if (gbp.isTaskInstanceOf(dep.getName(), GradleJarArtifacts.TASKCLASS_SHADOW_JAR)) {
                        this.addShadowJarArtifacts(dep.getName(), gbp, result);
                        shadowApplied = true;
                        continue;
                    }
                    if (!gbp.isTaskInstanceOf(dep.getName(), GradleJarArtifacts.TASKCLASS_JAR)) continue;
                    jarTasks.add(dep);
                }
                for (GradleTask dep : jarTasks) {
                    if (shadowApplied && GradleJarArtifacts.TASK_JAR.equals(dep.getName())) continue;
                    this.addJarArtifacts(dep.getName(), gbp, result);
                }
            }
            return new ArrayList<ArtifactSpec>(result);
        }

        private void addShadowJarArtifacts(String taskName, GradleBaseProject gbp, Collection<ArtifactSpec> results) {
            ArtifactSpec.Builder b;
            boolean addShadow = false;
            boolean addJar = true;
            if ("<any>".equals(this.filter.getClassifier()) || "all".equals(this.filter.getClassifier())) {
                addShadow = true;
            } else if (this.filter.getClassifier() == null) {
                addShadow = false;
                if (this.filter.hasTag("<shaded>")) {
                    addShadow = true;
                    addJar = false;
                }
                if (this.filter.hasTag("<basic>")) {
                    addJar = true;
                }
            }
            if (addShadow && (b = this.artifactBuilder(taskName, gbp)) != null) {
                results.add(b.tag("<shaded>").build());
            }
            if (addJar && (b = this.artifactBuilder(GradleJarArtifacts.TASK_JAR, gbp)) != null) {
                results.add(b.tag("<basic>").build());
            }
        }

        private ArtifactSpec.Builder artifactBuilder(String task, GradleBaseProject gbp) {
            String name = gbp.getName();
            String group = gbp.getGroup();
            String version = gbp.isVersionSpecified() ? gbp.getVersion() : null;
            String baseName = name;
            Path path = null;
            String dir = null;
            String classifier = null;
            String appendix = null;
            BuildPropertiesSupport props = BuildPropertiesSupport.get((Project)this.project);
            BuildPropertiesSupport.Property p = props.findTaskProperty(task, "archiveFile");
            if (p != null && p.getStringValue() != null) {
                path = Paths.get(p.getStringValue(), new String[0]);
            } else {
                p = props.findTaskProperty(task, "archiveFileName");
                Object filename = p != null && p.getStringValue() != null ? p.getStringValue() : (gbp.isVersionSpecified() ? String.format("%s-%s.jar", baseName, version) : baseName + ".jar");
                p = props.findTaskProperty(task, "destinationDirectory");
                if (p != null && p.getStringValue() != null) {
                    dir = p.getStringValue();
                }
                if (dir == null) {
                    dir = gbp.getBuildDir().toPath().toString();
                }
                if (dir != null && filename != null) {
                    path = Paths.get(dir, new String[0]).resolve((String)filename);
                }
            }
            p = props.findTaskProperty(task, "archiveAppendix");
            if (p != null && p.getStringValue() != null) {
                appendix = p.getStringValue();
            }
            if ((p = props.findTaskProperty(task, "archiveClassifier")) != null && p.getStringValue() != null && (classifier = p.getStringValue()).isEmpty()) {
                classifier = null;
            }
            String artName = appendix == null ? name : name + "-" + appendix;
            ArtifactSpec.Builder b = ArtifactSpec.builder((String)group, (String)artName, (String)version, (Object)this.project).classifier(classifier).type(GradleJarArtifacts.TASK_JAR);
            if (path != null) {
                b.location(path.toUri());
            }
            return b;
        }

        private void addJarArtifacts(String name, GradleBaseProject gbp, Collection<ArtifactSpec> results) {
            ArtifactSpec.Builder b = this.artifactBuilder(name, gbp);
            if (b == null) {
                return;
            }
            ArtifactSpec a = b.build();
            if ("<any>".equals(this.filter.getClassifier()) || Objects.equals(this.filter.getClassifier(), a.getClassifier())) {
                results.add(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ChangeListener[] ll;
            if (!"ProjectInfo".equals(evt.getPropertyName())) {
                return;
            }
            Result result = this;
            synchronized (result) {
                boolean wasInitialized = this.artifacts != null;
                List<ArtifactSpec> copy = this.artifacts;
                this.artifacts = PENDING;
                if (this.listeners == null || this.listeners.isEmpty()) {
                    return;
                }
                if (this.refreshTask != null) {
                    this.refreshTask.cancel();
                }
                if (wasInitialized) {
                    this.refreshTask = GRADLE_ARTIFACTS_RP.post(() -> this.update(copy));
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[0]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }
    }

    private static final class TaskActionMapping
    implements ActionMapping {
        private final String task;

        public TaskActionMapping(String task) {
            this.task = task;
        }

        public String getName() {
            return this.task;
        }

        public String getDisplayName() {
            return this.task;
        }

        public String getArgs() {
            return this.task;
        }

        public ActionMapping.ReloadRule getReloadRule() {
            return ActionMapping.ReloadRule.DEFAULT;
        }

        public String getReloadArgs() {
            return "";
        }

        public boolean isApplicable(Set<String> plugins) {
            return true;
        }

        public boolean isRepeatable() {
            return false;
        }

        public int compareTo(ActionMapping o) {
            return -1;
        }
    }
}

